
        opt     l-
        icl     'atarihw.ah'
        icl     'atarios.ah'
        icl     'vbxefx.asm'
        opt     l+

        .zpvar  ptr1    .word
        .zpvar  lines   .byte
        .zpvar  ysav    .byte
        .zpvar  phase   .byte
        .zpvar  bank    .byte



;-----------------------------------------------------------
        org     $2400

Init    putli   'VBXE BMPview v1.20'
        DetectCore
        jeq     i1
        putli   'Core FX v1.20 not found'
        jmp     (DOSVEC)
i1      ResetCore
        rts

        ini     Init

;-----------------------------------------------------------
        org     $2400

Start   cld
        mva     #0xff PORTB
        jsr     ClearScreen

        WinSetup #winbuf

err
ferr
loop
        WinDestroy
        FileClose
        FileBoxExecute #fmask #dirbuf #dirbuf_len
        jpl     try
        ResetCore
        rts

try     FileOpen #fm.fname #CIO_Read
        jmi     err

        SetupTransfer #bitmap_header #CIO_getdata
        jmi     err

        lda     #0
        sta     bfType

        NextTransfer #54
        jmi     err

        lda     bfType
        cmp     #'B'
        jne     ferr
        lda     bfType+1
        cmp     #'M'
        jne     ferr

        lda     biSize
        cmp     #40
        jne     ferr

        lda     biWidth
        cmp     <320
        jne     ferr
        lda     biWidth+1
        cmp     >320
        jne     ferr
        lda     biWidth+2
        ora     biWidth+3
        jne     ferr

        lda     biHeight+1
        ora     biHeight+2
        ora     biHeight+3
        jne     ferr

        lda     biBitCount
        cmp     #8
        jne     ferr
        lda     biBitCount+1
        jne     ferr

        lda     biCompression
        ora     biCompression+1
        ora     biCompression+2
        ora     biCompression+3
        jne     ferr

        WinCreate #11 #8 #15 #5
        SetCursor #0 #2 #2
        PutText #tbot #0 #0 #1 #SRC_INTERNAL+DST_INTERNAL

        jmp     loa

tbot    .byte   "Loading ...",1

loa
        SetupTransfer #palette #CIO_getdata
        jmi     err
        NextTransfer #256*4
        jmi     err

        mwa     #palette ptr1
        fxs     #0 FX_CSEL
        fxs     #1 FX_PSEL
        ldx     #0
pl1     ldy     #2
        lda     (ptr1),y
        fxsa    FX_CR
        ldy     #1
        lda     (ptr1),y
        fxsa    FX_CG
        ldy     #0
        lda     (ptr1),y
        fxsa    FX_CB
        adw     ptr1 #4
        inx
        jne     pl1

        mva     biHeight lines
        mwa     #$4000 ptr1
        ldy     #0
        mva     #0 bank
        fxsap   FX_MEMS
        fxsp    #$40+MCE+M16K FX_MEMC
        jmp     lp4

lp1     lda     bank
        asl     @
        asl     @
        ora     #$80
        fxsap   FX_MEMS

lp0     lda     phase
        jne     ph2
        lda     linebuf,x
        inx
        jne     lp2
        inc     phase
        jmp     lp2
ph2     cpx     #64
        bcc     ph21

        dec     lines
        jeq     cxdl

lp4     sty     ysav
        fxs     #0 FX_MEMS
        SetupTransfer #linebuf #CIO_getdata
        jmi     err
        NextTransfer #320
        jmi     err
        ldx     #0
        stx     phase
        ldy     ysav
        jmp     lp1

ph21    lda     linebuf+0x100,x
        inx
lp2     sta     (ptr1),y
        iny
        bne     lp0
        inc     ptr1+1
        jpl     lp0
        mwa     #$4000 ptr1
        inc     bank
        jmp     lp1

cxdl    lda     #0
        sta     adrez
        sta     adrez+1
        sta     adrez+2
        mva     biHeight lines

cx1     dec     lines
        jeq     cx2
        lda     adrez
        add     <320
        sta     adrez
        lda     adrez+1
        adc     >320
        sta     adrez+1
        lda     adrez+2
        adc     #0
        sta     adrez+2
        jmp     cx1

cx2
        inc     bank
        lda     bank
        asl     @
        asl     @
        ora     #$80
        fxsa    FX_MEMS
        mwa     #$4000 ptr1

        mva     biHeight lines
        cmp     #241
        bcc     cx21
        mva     #240 lines

cx21    lda     #240
        sub     lines
        lsr
        jeq     cx4
        sub     #1
        sta     lines

cx3     ldy     #0
        lda     <XDLC_RPTL
        sta     (ptr1),y
        iny
        lda     >XDLC_RPTL
        sta     (ptr1),y
        iny
        lda     lines
        sta     (ptr1),y
        adw     ptr1 #3

cx4     mva     biHeight lines

cx5     ldy     #0
        lda     lines
        cmp     #1
        jne     cx51
        lda     <XDLC_GMON+XDLC_OVADR+XDLC_END
        sta     (ptr1),y
        iny
        lda     >XDLC_GMON+XDLC_OVADR+XDLC_END
        jmp     cx52
cx51    lda     <XDLC_GMON+XDLC_OVADR
        sta     (ptr1),y
        iny
        lda     >XDLC_GMON+XDLC_OVADR
cx52    sta     (ptr1),y
        iny
        lda     adrez
        sta     (ptr1),y
        iny
        lda     adrez+1
        sta     (ptr1),y
        iny
        lda     adrez+2
        sta     (ptr1),y
        iny
        lda     #0
        sta     (ptr1),y
        iny
        sta     (ptr1),y
        adw     ptr1 #7

        lda     adrez
        sub     <320
        sta     adrez
        lda     adrez+1
        sbc     >320
        sta     adrez+1
        lda     adrez+2
        sbc     #0
        sta     adrez+2

        dec     lines
        jne     cx5

        lda     #0
        fxsa    FX_XDL_ADR0
        lda     bank
        asl
        asl
        asl
        asl
        asl
        asl
        fxsa    FX_XDL_ADR1
        lda     bank
        lsr
        lsr
        fxsa    FX_XDL_ADR2

        mva     #0 DMACTLS
        fxsa    FX_MEMS
        fxsa    FX_MEMC
        fxs     #VC_XDL_ENABLED+VC_NTR FX_VIDEO_CONTROL

        GetKey

        mva     #0x22 DMACTLS
        fxs     #0 FX_VIDEO_CONTROL

        jmp     loop


adrez   .long   0

ClearScreen .local

        ;skasuj zawarto ekranu
        mwa     SAVMSC ptr1
        ldx     #24
l1      ldy     #39
        lda     #0
l2      sta     (ptr1),y
        dey
        bpl     l2
        adw     ptr1 #40
        dex
        bne     l1
        rts

        .endl

;-----------------------------------------------------------

        ;opt     l-
        icl     'filebox.asm'
        ;opt     l+

;-----------------------------------------------------------
fmask   .byte   '*.BMP',$9b

bitmap_header
bfType          .word   0
bfSize          .dword  0
bfR1            .word   0
bfR2            .word   0
bfOffBits       .dword  0
biSize          .dword  0
biWidth         .dword  0
biHeight        .dword  0
biPlanes        .word   0
biBitCount      .word   0
biCompression   .dword  0
biSizeImage     .dword  0
biXPelsPerMeter .dword  0
biYPelsPerMeter .dword  0
biClrUsed       .dword  0
biClrImportant  .byte   0
biClrRotation   .byte   0
biReserved      .word   0

dirbuf_len      equ     0x1000

dirbuf  equ     *
palette equ     *
linebuf equ    *
winbuf  equ     0x8000

init2   jmp     FileBoxInit

        ini     init2
        run     Start