// TIP ANIMATOR v1.4 (17.08.2008) by Tebe/Madteam

program anm_tip;

{$APPTYPE CONSOLE}

uses
  SysUtils;

var
 a0, a1, a2, b0, b1, b2: array [0..8191] of byte;

 dic: array [0..20000] of byte;

 i, dicLen, dicCnt, first, last, used_bank, active_bank, old_active_bank: integer;

 cell: integer = 0;

 all_banks: Boolean = false;

 plik: file;


function fname(i, b: integer): string;
begin
 Result:=IntToStr(i);

 while length(Result)<b do Result:='0'+Result;
end;


procedure load_a(i: integer);
var f: file;
    a: string;
    s: integer;
begin

 a:=fname(i, 4);

 if not(FileExists(a+'.tip')) then begin
  writeln('File ',a,' not found.');
  halt;
 end;

 assignfile(f, a+'.tip'); reset(f,1);
 S:=FileSize(f)-9;

 blockread(f, a0, 9);
 blockread(f, a0, s div 3);
 blockread(f, a1, s div 3);
 blockread(f, a2, s div 3);
 closefile(f);

end;


procedure load_b(i: integer);
var f: file;
    a: string;
    s: integer;
begin

 a:=fname(i, 4);

 if not(FileExists(a+'.tip')) then begin
  writeln('File ',a,' not found.');
  halt;
 end; 

 assignfile(f, a+'.tip'); reset(f,1);
 S:=FileSize(f)-9;

 blockread(f, b0, 9);
 blockread(f, b0, s div 3);
 blockread(f, b1, s div 3);
 blockread(f, b2, s div 3);
 closefile(f);

end;


function tsearch(bnk, k, min_y, max_y: integer; var b:array of byte): integer;
(*----------------------------------------------------------------------------*)
(* testowe przeszukanie slownikow zapisanych na dysku                         *)
(* jesli w danym slowniku beda wszystkie 3 ciagi wowczas przelaczy na ten bank*)
(*----------------------------------------------------------------------------*)
var i, j, x, dl: integer;
    ok: Boolean;
    tmpDic: array [0..20000] of byte;
    f: file;
    a: string;
begin

  Result:=0;

  used_bank:=-1;


  fillchar(tmpDic, sizeof(tmpDic), 0);

  a:=fname(bnk, 2);

  assignfile(f, 'dic'+a+'.dat'); reset(f,1);
  blockread(f, tmpDic, sizeof(tmpDic), dl);
  closefile(f);

  i:=0;

  while i<=dl-(max_y-min_y) do begin

   ok:=true;
   j:=0;

   for x:=min_y to max_y-1 do begin

    if tmpDic[i+j]<>b[k+x*40] then begin ok:=false; Break end;

    inc(j);
   end;

   if ok then begin Result:=i; used_bank:=bnk; exit end;

   inc(i);
  end;


end;


function search(k, min_y, max_y: integer; var b:array of byte): integer;
var i, j, x: integer;
    ok: Boolean;
begin

 Result:=dicLen;


 i:=0;

 while i<=dicLen-(max_y-min_y) do begin

  ok:=true;
  j:=0;

  for x:=min_y to max_y-1 do begin

   if dic[i+j]<>b[k+x*40] then begin ok:=false; Break end;

   inc(j);
  end;

  if ok then begin Result:=i; exit end;

  inc(i);
 end;


// nie znalazl, dopisz do slownika
 for x:=min_y to max_y-1 do begin
  dic[dicLen]   := b[k+x*40];

  inc(dicLen);
 end;

end;




function TESTsearch(k, min_y, max_y: integer; var b:array of byte): Boolean;
var i, j, x: integer;
    ok: Boolean;
begin

 Result:=false;


 i:=0;

 while i<=dicLen-(max_y-min_y) do begin

  ok:=true;
  j:=0;

  for x:=min_y to max_y-1 do begin

   if dic[i+j]<>b[k+x*40] then begin ok:=false; Break end;

   inc(j);
  end;

  if ok then begin Result:=true; exit end;

  inc(i);
 end;


end;



procedure save_dic;
var a: string;
    d: file;
begin

 a:=fname(dicCnt, 2);

 assignfile(d, 'dic'+a+'.dat'); rewrite(d,1);
 blockwrite(d, dic, dicLen);
 closefile(d);

end;


procedure compare;
var i,j, a,b, min_y, max_y, idx, h, tbnk: integer;
    idx0, idx1, idx2: integer;
    bf: array [0..15] of byte;
    hpos, ubank, rle: Boolean;
    v0, v1, v2: byte;
begin

 for i:=0 to 39 do begin

 hpos:=false;

 j:=0;

 while j<=99 do begin

  a:=0;
  b:=0;

  min_y:=255; max_y:=0;

  while j<=99 do begin

   while ((a0[i+j*40]=b0[i+j*40]) and (a1[i+j*40]=b1[i+j*40]) and (a2[i+j*40]=b2[i+j*40])) and (j<=99) do inc(j);

   if j<>a then b:=j;

   h:=j;
   while ((a0[i+j*40]<>b0[i+j*40]) or (a1[i+j*40]<>b1[i+j*40]) or (a2[i+j*40]<>b2[i+j*40])) and (j<=99) do inc(j);
   if j<>h then a:=j;

   if b<min_y then min_y:=b;
   if a>max_y then max_y:=a;

   if max_y-min_y > CELL then Break;

  end;


//  writeln(i,' - ',min_y,',',max_y);


  if min_y>=max_y then begin

//   writeln(i,' - ',min_y,',',max_y);

  end else begin

   h:=max_y-min_y;


   rle:=true;

   v0:=b0[i+min_y*40];
   v1:=b1[i+min_y*40];
   v2:=b2[i+min_y*40];

   for idx0:=min_y to max_y-1 do
    if (b0[i+idx0*40]<>v0) or (b1[i+idx0*40]<>v1) or (b2[i+idx0*40]<>v2) then begin rle:=false; Break end;


   if not(hpos) then begin
    bf[0]:=$fe;                       // pozycja pozioma
    bf[1]:=i;
    blockwrite(plik, bf, 2);

    hpos:=true;
   end;


   active_bank:=dicCnt;

   ubank:=false;


   if not(rle) then
   if all_banks then
   if not(TESTsearch(i, min_y, max_y, b0)) or not(TESTsearch(i, min_y, max_y, b1)) or not(TESTsearch(i, min_y, max_y, b2)) then
   for tbnk:=0 to dicCnt-1 do begin

    ubank:=true;

    idx0:=tsearch(tbnk, i, min_y, max_y, b0)+$4000; if used_bank<>tbnk then ubank:=false;
    idx1:=tsearch(tbnk, i, min_y, max_y, b1)+$4000; if used_bank<>tbnk then ubank:=false;
    idx2:=tsearch(tbnk, i, min_y, max_y, b2)+$4000; if used_bank<>tbnk then ubank:=false;

    if ubank then begin active_bank:=tbnk; Break end;
   end;


   if not(rle) then
   if not(ubank) then
   if not(TESTsearch(i, min_y, max_y, b0)) or not(TESTsearch(i, min_y, max_y, b1)) or not(TESTsearch(i, min_y, max_y, b2)) then
   if dicLen+h*3>16383 then begin

    save_dic;

    inc(dicCnt);

    active_bank:=dicCnt;

    fillchar(dic, sizeof(dic), 0);

    dicLen:=0;
   end;


   if active_bank<>old_active_bank then begin
    bf[0]:=$ff;
    bf[1]:=active_bank;

    blockwrite(plik, bf, 2);

    old_active_bank := active_bank;
   end;



   bf[0]:=(min_y+1) or $80;       // pionowa pozycja poczatkowa

   if not(rle) then
    bf[1]:=h-1                    // wysokosc kolumny, jednakowa dla wszystkich 3 buforow
   else
    bf[1]:=0;
   
   blockwrite(plik, bf, 2);


   if rle then begin

    bf[0]:=h-1;                   // RLE

    bf[1]:=v0;
    bf[2]:=v1;
    bf[3]:=v2;

    blockwrite(plik, bf, 4);

   end else
   if ubank then begin

    bf[1]:=byte(idx0 shr 8);            // indeks do kolumny B0
    bf[0]:=byte(idx0);
    blockwrite(plik, bf, 2);

    bf[1]:=byte(idx1 shr 8);            // indeks do kolumny B1
    bf[0]:=byte(idx1);
    blockwrite(plik, bf, 2);

    bf[1]:=byte(idx2 shr 8);            // indeks do kolumny B2
    bf[0]:=byte(idx2);
    blockwrite(plik, bf, 2);

   end else begin

    idx:=search(i, min_y, max_y, b0) + $4000;

    bf[1]:=byte(idx shr 8);            // indeks do kolumny B0
    bf[0]:=byte(idx);
    blockwrite(plik, bf, 2);


    idx:=search(i, min_y, max_y, b1) + $4000;

    bf[1]:=byte(idx shr 8);            // indeks do kolumny B1
    bf[0]:=byte(idx);
    blockwrite(plik, bf, 2);


    idx:=search(i, min_y, max_y, b2) + $4000;

    bf[1]:=byte(idx shr 8);            // indeks do kolumny B2
    bf[0]:=byte(idx);
    blockwrite(plik, bf, 2);

   end; 

  end;


  end;


 end;

 bf[0]:=$80;
 blockwrite(plik, bf, 1);

end;


procedure save_asm;
var t: textfile;
    i: integer;
    a: string;
begin

 a:='tipanm.asx';

 AssignFile(t,a);
 {$I-}
 FileMode:=1;
 Rewrite(t);
 CloseFile(t);
 {$I+}

 if (IOResult <> 0) or (a='') then begin
  writeln('ERROR: File TIPANM.ASX access denied.');
  halt;
 end;


assignfile(t, a); rewrite(t);

writeln(t, '//-------------------------------------------------------------------');
writeln(t, '//                                                                   ');
writeln(t, '//	TIP ANIMATION v1.4 (17.08.2008) by Tebe/Madteam & Lewis/Aids     ');
writeln(t, '//                                                                   ');
writeln(t, '//	!!! TIP-y o rozmiarze 160x100 !!!                                ');
writeln(t, '//                                                                   ');
writeln(t, '//-------------------------------------------------------------------'#13#10);

writeln(t, 'delay'#9'= 1',#9#9'; jeli dziaa za szybko mona spowolni :)');
writeln(t, 'banks'#9'= ',IntToStr(dicCnt+1),#9#9'; liczba bankw = liczbie plikw DIC?.DAT wygenerowanych przez TIPANM.EXE');
writeln(t, 'tipanm'#9'= $2000'#9#9'; adres glownego bloku z animacja'#13#10);


writeln(t, '//-------------------------------------------------------------------'#13#10);

writeln(t, '@TAB_MEM_BANKS = $0100'#13#10);

writeln(t, #9'org $2000');

writeln(t, 'init'#9'jsr @mem_detect');
writeln(t, #9'cmp #banks');
writeln(t, #9'bcs ok');

writeln(t, #9'jsr printf');
writeln(t, #9'.by "I need extended RAM" $9b 0');

writeln(t, #9'pla');
writeln(t, #9'pla');

writeln(t, 'ok'#9'rts'#13#10);

writeln(t, #9'.link "proc\@mem_detect_reloc.obx"');
writeln(t, #9'.link "stdio\printf.obx"'#13#10);

writeln(t, #9'ini init'#13#10);

writeln(t, '//-------------------------------------------------------------------'#13#10);

writeln(t, '@PROC_ADD_BANK	= $2000'#13#10);

writeln(t, '	opt b+');

writeln(t, '	lmb #1');

 for i:=0 to dicCnt do begin
  a:=fname(i, 2);
  writeln(t, #9'ins "dic',a,'.dat"');
  if i<>dicCnt then writeln(t, #9'nmb');
 end;

writeln(t, #9'lmb #0');
writeln(t, #9'opt b-'#13#10);

writeln(t, '//-------------------------------------------------------------------'#13#10);


a:=fname(first, 4);

writeln(t, #9'.get "',a,'.tip"			; inicjacja przy pomocy pierwszej klatki animacji'#13#10);

writeln(t, 'tipLen	= .get[7]+.get[8]<<8'#13#10);


writeln(t, #9'org $2000'#13#10);

writeln(t, #9'.link "tipanm_init_reloc.obx"'#13#10);

writeln(t, 'tip9	.sav [9] tipLen*3');
writeln(t, 'tipA	= tip9+tipLen');
writeln(t, 'tipB	= tip9+tipLen*2'#13#10);

writeln(t, #9'ini tipanm_init'#13#10);


writeln(t, '//-------------------------------------------------------------------');
writeln(t, '//-------------------------------------------------------------------'#13#10);

writeln(t, #9'org tipanm'#13#10);

writeln(t, #9'.link "tipanm_engine_reloc.obx"'#13#10);

writeln(t, 'anm	ins "anm.dat"'#9#9#9'; plik ANM.DAT wygenerowany przez TIPANM.EXE'#13#10);


writeln(t, #9'ert *>$bfff,*-$c000'#13#10);

//writeln(t, #9'.print "end: ",*'#13#10);

writeln(t, #9'run start'#13#10);

writeln(t, '//-------------------------------------------------------------------'#13#10);

writeln(t, #9'icl "@bank_add.mac"');

closefile(t);
end;



procedure Syntax;
begin
  writeln('Usage: TIPANM FIRST LAST [hX] [max]');
  writeln('hX',#9,'minimal height value, H=<0..64> (default = 0)');
  writeln('max'#9,'maximum compress (default off = fast)');
  writeln('Example: TIPANM 1 24 h0 max'#13#10'File: 0001.tip, 0002.tip ... 0024.tip');
  halt;
end;

begin
 writeln('TIPANM v1.4 by Tebe/Madteam (17.08.2008)');

 if ParamCount>0 then begin
  first:=StrToInt(ParamStr(1));
  last:=StrToInt(ParamStr(2));

  if ParamCount>2 then
   for i:=3 to ParamCount do
    if (ParamStr(i)='max') or (ParamStr(i)='MAX') then all_banks:=true else
     if (ParamStr(i)[1]='H') or (ParamStr(i)[1]='h') then begin
      cell:=StrToInt(copy(ParamStr(i),2,length(ParamStr(i))));

      if not(cell in [0..64]) then begin
       writeln('Height = [0..64]');
       halt;
      end;

     end else
      Syntax; 

 end else
  Syntax;


 assignfile(plik, 'anm.dat'); rewrite(plik,1);


 old_active_bank:=active_bank;

 for i:=first to last-1 do begin

  load_a(i);
  load_b(i+1);

  compare;

 end;

 load_a(last);
 load_b(first);

 compare;


 a0[0]:=$ff;
 a0[1]:=$ff;
 blockwrite(plik, a0, 2);          // koniec animacji $ffff


 closefile(plik);


 if dicLen>0 then save_dic;


 save_asm;

end.
