
//-------------------------------------------------------------------
//
//	TIPANM ENGINE v1.4 by Tebe/Madteam (17.08.2008)
//
//-------------------------------------------------------------------

	org $c000

grb	.ds $1000


	org $d800

dl1	.ds $300
lcol	.ds $80
hcol	.ds $80

dl2	.ds $300
lrle	.ds $80
hrle	.ds $80

gr9	.ds $1000
gra	;	.ds $1000

//-------------------------------------------------------------------

	.zpvar ad, b0, b1, b2, tmp .word bank, height, px, regA, regX, regY .byte = $80

	.extrn anm, @TAB_MEM_BANKS	.word
	.extrn delay	.byte

	.public	gr9, gra, grb, nmi, dl1, dl2, start
	.public TIPANM.column, TIPANM.colRle
	.public lcol, hcol, lrle, hrle


//-------------------------------------------------------------------

	.reloc


start	lda:cmp:req 20

	sei
	mva #0 $d40e
	sta $d400

	sta 20

	mva #$fe $d301

	mwa #nmi $fffa

	mwa #dl1 $230

	mva #$c0 $d40e


	mwa adres ad

	jmp TIPANM.MAIN


adres	dta a(anm)


//-------------------------------------------------------------------


.local	TIPANM


* ---	HPOS

hpos	iny
	mva (ad),y px

	adw ad #2

	jmp MAIN


* ---	NBANK

nbank	iny
	lda (ad),y

	cmp #$ff
	bne skp

	mwa adres ad
	mva #0 bank

	jmp wait

skp	sta bank

	adw ad #2

	jmp MAIN


* ---	NEXT

next	inw ad			;  nastepna klatka animacji (next animation frames)

wait	lda 20
	cmp #delay
	bcc wait

	mva #0 20


* ---	MAIN

MAIN	ldy #0

loop	mva #$fe $d301

	lda (ad),y

	cmp #$fe
	beq hpos

	cmp #$ff
	beq nbank

	and #$7f
	beq next

	tax			; pozycja pionowa +1

	iny
	mva (ad),y height	; wysokosc kolumny <0..99>

	beq RLE


* ---	STORE N BYTES

	mva lcol,x _jsr+1
	mva hcol,x _jsr+2

	txa
	add height		; wysokosc kolumny
	tax
	mva lcol+1,x tmp
	mva hcol+1,x tmp+1

	iny
	mwa (ad),y b0

	iny
	mwa (ad),y b1

	iny
	mwa (ad),y b2

	bne skp2


* ---	Run Length Encode

RLE
	mva lrle,x _jsr+1
	mva hrle,x _jsr+2

	txa
	iny
	add (ad),y		; liczba powtorzen RLE
	tax
	mva lrle+1,x tmp
	mva hrle+1,x tmp+1

	iny
	mva (ad),y b0
	iny
	mva (ad),y b1
	iny
	mva (ad),y b2

skp2
;	iny
	tya
	sec			; +1
	adc ad
	sta ad
	scc
	inc ad+1
;	lda #0
;	adc ad+1
;	sta ad+1

	ldx bank
	lda @TAB_MEM_BANKS+1,x
	sta $d301


	ldy #0			; !!! regY = 0
	mva (tmp),y backup+1
	lda #{rts}
	sta (tmp),y

	ldx px			; regX = PX

_jsr	jsr $ffff		; regY = 0

	ldy #0
backup	lda #0
	sta (tmp),y

	jmp loop		; !!! regY = 0


column	.rept 101
	mva	(b0),y	gr9+#*40,x
	mva	(b1),y	gra+#*40,x
	mva	(b2),y	grb+#*40,x
	iny
	.endr


colRle	.rept 101
	mva	b0	gr9+#*40,x
	mva	b1	gra+#*40,x
	mva	b2	grb+#*40,x
	.endr

.end


//-------------------------------------------------------------------

nmi	bit $d40f
	bpl vbl

dli	sta regA
	stx regX
	sty regY

	ldx #$c0

	ldy #100+2

dli1	lda #$80
dli2	sta $d40a
	stx $d01b
	sta $d40a
	sta $d01b
	eor #$c0
	dey
	bne dli2

	eor #$c0
	sta dli1+1

dli3	lda #>dl2
	eor #(>dl1)^(>dl2)
	sta dli3+1
	sta $231

	lda regA
	ldx regX
	ldy regY
	rti


vbl	phr
	sta $d40f

	inc 20

	mwa $230 $d402

	mva #$22 $d400

	.put = 0, 2, 4, 6, 8, $a, $c, $e, 0

	:9 mva #.get[#] $d012+#

	plr
	rti
