// TIP ANIMATOR v1.3 (15.08.2008) by Tebe/Madteam

program anm_tip;

{$APPTYPE CONSOLE}

uses
  SysUtils;

var
 a0, a1, a2, b0, b1, b2: array [0..8191] of byte;

 dic: array [0..20000] of byte;

 i, dicLen, dicCnt, first, last, used_bank, active_bank, old_active_bank: integer;

 cell: integer = 4;

 all_banks: Boolean = false;

 plik: file;

 
procedure load_a(i: integer);
var f: file;
    a: string;
    s: integer;
begin

 a:=IntToStr(i);

 while length(a)<4 do a:='0'+a;

 assignfile(f, a+'.tip'); reset(f,1);
 S:=FileSize(f)-9;

 blockread(f, a0, 9);
 blockread(f, a0, s div 3);
 blockread(f, a1, s div 3);
 blockread(f, a2, s div 3);
 closefile(f);

end;


procedure load_b(i: integer);
var f: file;
    a: string;
    s: integer;
begin

 a:=IntToStr(i);

 while length(a)<4 do a:='0'+a;

 assignfile(f, a+'.tip'); reset(f,1);
 S:=FileSize(f)-9;

 blockread(f, b0, 9);
 blockread(f, b0, s div 3);
 blockread(f, b1, s div 3);
 blockread(f, b2, s div 3);
 closefile(f);

end;


function tsearch(bnk, k, min_y, max_y: integer; var b:array of byte): integer;
var i, j, x, dl: integer;
    ok: Boolean;
    tmpDic: array [0..20000] of byte;
    f: file;
begin

  Result:=0;

  used_bank:=-1;


  fillchar(tmpDic, sizeof(tmpDic), 0);

  assignfile(f, 'dic'+IntToStr(bnk)+'.dat'); reset(f,1);
  blockread(f, tmpDic, sizeof(tmpDic), dl);
  closefile(f);

  i:=0;

  while i<dl-(max_y-min_y) do begin

   ok:=true;
   j:=0;

   for x:=min_y to max_y-1 do begin

    if (tmpDic[i+j]<>b[k+x*40]) or (i+j>=dl) then begin ok:=false; Break end;

    inc(j);
   end;

   if ok then begin Result:=i; used_bank:=bnk; exit end;

   inc(i);
  end;


end;


function search(k, min_y, max_y: integer; var b:array of byte): integer;
var i, j, x: integer;
    ok: Boolean;
begin

 Result:=dicLen;


 i:=0;

 while i<dicLen-(max_y-min_y) do begin

  ok:=true;
  j:=0;

  for x:=min_y to max_y-1 do begin

   if (dic[i+j]<>b[k+x*40]) or (i+j>=dicLen) then begin ok:=false; Break end;

   inc(j);
  end;

  if ok then begin Result:=i; exit end;

  inc(i);
 end;


// nie znalazl, dopisz do slownika
 for x:=min_y to max_y-1 do begin
  dic[dicLen]   := b[k+x*40];

  inc(dicLen);
 end;

end;




function TESTsearch(k, min_y, max_y: integer; var b:array of byte): Boolean;
var i, j, x: integer;
    ok: Boolean;
begin

 Result:=false;


 i:=0;

 while i<dicLen-(max_y-min_y) do begin

  ok:=true;
  j:=0;

  for x:=min_y to max_y-1 do begin

   if (dic[i+j]<>b[k+x*40]) or (i+j>=dicLen) then begin ok:=false; Break end;

   inc(j);
  end;

  if ok then begin Result:=true; exit end;

  inc(i);
 end;


end;



procedure compare;
var i,j, a,b, min_y, max_y, idx, h, ub, tbnk: integer;
    idx0, idx1, idx2: integer;
    bf: array [0..15] of byte;
    d: file;
    hpos, ubank: Boolean;
begin

 for i:=0 to 39 do begin

 hpos:=false;

 j:=0;

 while j<=99 do begin

  a:=0;
  b:=0;

  min_y:=255; max_y:=0;

  while j<=99 do begin

   while ((a0[i+j*40]=b0[i+j*40]) and (a1[i+j*40]=b1[i+j*40]) and (a2[i+j*40]=b2[i+j*40])) and (j<=99) do inc(j);

   if j<>a then b:=j;

   h:=j;
   while ((a0[i+j*40]<>b0[i+j*40]) or (a1[i+j*40]<>b1[i+j*40]) or (a2[i+j*40]<>b2[i+j*40])) and (j<=99) do inc(j);
   if j<>h then a:=j;

   if b<min_y then min_y:=b;
   if a>max_y then max_y:=a;

   if max_y-min_y > CELL then Break;

  end;


//  writeln(i,' - ',min_y,',',max_y);


  if min_y>=max_y then begin

//   writeln(i,' - ',min_y,',',max_y);

  end else begin

   h:=max_y-min_y;


   if not(hpos) then begin
    bf[0]:=$fe;                       // pozycja pozioma
    bf[1]:=i;
    blockwrite(plik, bf, 2);

    hpos:=true;
   end;


   active_bank:=dicCnt;

   ubank:=false;


   if all_banks then
   if not(TESTsearch(i, min_y, max_y, b0)) or not(TESTsearch(i, min_y, max_y, b1)) or not(TESTsearch(i, min_y, max_y, b2)) then
   for tbnk:=0 to dicCnt-1 do begin

    ubank:=true;

    idx0:=tsearch(tbnk, i, min_y, max_y, b0)+$4000; if used_bank<>tbnk then ubank:=false;
    idx1:=tsearch(tbnk, i, min_y, max_y, b1)+$4000; if used_bank<>tbnk then ubank:=false;
    idx2:=tsearch(tbnk, i, min_y, max_y, b2)+$4000; if used_bank<>tbnk then ubank:=false;

    if ubank then begin active_bank:=tbnk; Break end;
   end;



   if not(ubank) then
   if not(TESTsearch(i, min_y, max_y, b0)) or not(TESTsearch(i, min_y, max_y, b1)) or not(TESTsearch(i, min_y, max_y, b2)) then
   if dicLen+h*3>16383 then begin

    assignfile(d, 'dic'+IntToStr(dicCnt)+'.dat'); rewrite(d,1);
    blockwrite(d, dic, dicLen);
    closefile(d);

    inc(dicCnt);

    active_bank:=dicCnt;

    fillchar(dic, sizeof(dic), 0);

    dicLen:=0;
   end;


   if active_bank<>old_active_bank then begin
    bf[0]:=$ff;
    bf[1]:=active_bank;

    blockwrite(plik, bf, 2);

    old_active_bank := active_bank;
   end;


   bf[0]:=h or $80;                   // wysokosc kolumny, jednakowa dla wszystkich 3 buforow
   bf[1]:=min_y;                      // pionowa pozycja poczatkowa
   blockwrite(plik, bf, 2);


   if ubank then begin

    bf[1]:=byte(idx0 shr 8);            // indeks do kolumny B0
    bf[0]:=byte(idx0);
    blockwrite(plik, bf, 2);

    bf[1]:=byte(idx1 shr 8);            // indeks do kolumny B1
    bf[0]:=byte(idx1);
    blockwrite(plik, bf, 2);

    bf[1]:=byte(idx2 shr 8);            // indeks do kolumny B2
    bf[0]:=byte(idx2);
    blockwrite(plik, bf, 2);

   end else begin

    idx:=search(i, min_y, max_y, b0) + $4000;

    bf[1]:=byte(idx shr 8);            // indeks do kolumny B0
    bf[0]:=byte(idx);
    blockwrite(plik, bf, 2);

    
    idx:=search(i, min_y, max_y, b1) + $4000;

    bf[1]:=byte(idx shr 8);            // indeks do kolumny B1
    bf[0]:=byte(idx);
    blockwrite(plik, bf, 2);


    idx:=search(i, min_y, max_y, b2) + $4000;

    bf[1]:=byte(idx shr 8);            // indeks do kolumny B2
    bf[0]:=byte(idx);
    blockwrite(plik, bf, 2);

   end; 

  end;


  end;


 end;

 bf[0]:=$80;
 blockwrite(plik, bf, 1);

end;


procedure Syntax;
begin
  writeln('Usage: TIPANM FIRST LAST');
  writeln('Example: TIPANM 1 24'#13#10'File: 0001.tip, 0002.tip ... 0024.tip');
  halt;
end;

begin
 writeln('TIPANM v1.3 by Tebe/Madteam');

 if ParamCount>0 then begin
  first:=StrToInt(ParamStr(1));
  last:=StrToInt(ParamStr(2));

  if ParamCount>2 then
   for i:=3 to ParamCount do
    if (ParamStr(i)='max') or (ParamStr(i)='MAX') then all_banks:=true else
     if (ParamStr(i)[1]='c') or (ParamStr(i)[1]='C') then begin
      cell:=StrToInt(copy(ParamStr(i),2,length(ParamStr(i))));

      if not(cell in [0..64]) then begin
       writeln('Cell = [0..64]');
       halt;
      end;

     end else
      Syntax; 

 end else
  Syntax;


 assignfile(plik, 'anm.dat'); rewrite(plik,1);


 old_active_bank:=active_bank;

 for i:=first to last-1 do begin

  load_a(i);
  load_b(i+1);

  compare;

 end;

 load_a(last);
 load_b(first);

 compare;


 i:=$ff;
 blockwrite(plik, byte(i), 1);
 blockwrite(plik, byte(i), 1);          // koniec animacji $ffff


 closefile(plik);


 if dicLen>0 then begin

  assignfile(plik, 'dic'+IntToStr(dicCnt)+'.dat'); rewrite(plik,1);
  blockwrite(plik, dic, dicLen);
  closefile(plik);
 end;

end.
