
start
	jsr prepareDispList

	;empty collisions store area
	lda #$00
	tay
emptCollsns
	sta collisions,Y
	dey
	bne emptCollsns

	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	lda #1
	sta critic      ;delayed part of system VBLK handler will be off

	sei ;turn off all IRQ

	;save original dmactl
	lda dmactls
	sta tmpDmactls

;	lda #$00
;	sta dmactls
;	sta dmactl      ;disable screen dma

	;save original dlist vector
	lda	dlptrs
	sta tmpDlptrs
	lda	dlptrs+1
	sta tmpDlptrs+1
	;set new dlist vector
	lda #.lo(dList)  ;setup Display List vector
	sta dlptrs
	sta dlptr
	lda #.hi(dList)
	sta dlptrs+1
	sta dlptr+1

	;save original gtiactl
	lda gtiactls
	sta tmpGtiactls
	;set new gtiactl
	lda #$00
	sta gtiactl
	sta gtiactls

	;save original colors
	ldy #$08
savCol1
	lda colpm0s,Y
	sta tmpColpm0s,Y
	dey
	bpl savCol1

	;fill screen memory 40b
	lda #$11          ;if all pixels are 0001 (colpm1 in GTIA10) then when DGM is active all these pixels are interpreted as 0100 (colpf0 in GTIA10)
	ldy #39
filScMem1
	sta screenData,Y
	dey
	bpl filScMem1

	lda #$02
	sta grafm

	lda #$00
	sta grafp0
	sta grafp1
	sta grafp2
	sta grafp3
	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	sta sizem
	sta hposp0
	sta hposp1
	sta hposp2
	sta hposp3
	sta hposm1
	sta hposm2
	sta hposm3

	sta colpf0
	sta colpf0s
	sta colpf1
	sta colpf1s
	sta colpf2
	sta colpf2s
	sta colbak
	sta colbaks
	sta colpm0
	sta colpm0s
	sta colpm1
	sta colpm1s

	sta hscrol

	sta chkCnt

	lda #LEFT_BORDER+8
	sta hposm0

	lda #$22        ;normal width screen
	sta dmactls
	sta dmactl      ;enable screen dma

	jmp main


restoreSystemSettings

	lda #0
	sta critic

	;lda #$00
	sta hposm0
	sta grafm

	;lda #$00
	sta pmctl       ;disable PMG DMA in GTIA

	;restore original colors
	ldy #$08
resCol1
	lda tmpColpm0s,Y
	sta colpm0s,Y
	sta colpm0,Y
	dey
	bpl resCol1

	;restore original gtiactl
	lda tmpGtiactls
	sta gtiactls
	sta gtiactl

	;restore original dlist vector
	lda tmpDlptrs
	sta dlptrs
	sta dlptr
	lda tmpDlptrs+1
	sta dlptrs+1
	sta dlptr+1

	;restore original dmactl
	lda tmpDmactls
	sta dmactls
	sta dmactl

	cli ;turn on all IRQ

	lda #$FF
	sta kbcodes

	lda #$00
	tax
	tay

	rts


outputText
	pha
	lda #$00
	sta ICBLH ;$0349
	pla
outputLongText
	sty ICBAL ;$0344
	stx ICBAH ;$0345
	sta ICBLL ;$0348
	ldx #$00
	lda #$0B
	sta ICCOM,x ;$0342,X
	jmp ciov ;$E456


;close all IOCBs except 0
closeIOChns
	ldx	#0
	beq	closeIOChns2
closeIOChns1
	lda #$0C
	sta ICCOM,x ;$0342,X
	jsr CIOV ;$E456
closeIOChns2
	txa 
	clc 
	adc #$10
	tax 
	bpl closeIOChns1
	rts


waitAfterMsg
	ldx #100 ;2 sec
waitAftMsg1
	lda rtclock+2
waitAftMsg2
	cmp rtclock+2
	beq waitAftMsg2
	dex
	bne waitAftMsg1
	rts


chkCnt	.ds 1 ;init to 0
tmpDlptrs	.ds 2
tmpDmactls	.ds 1
tmpGtiactls	.ds 1
tmpColpm0s	.ds 9


main
	ldy #12
	jsr waitY
	jsr check_16_107
	jsr sumStableLines
	cmp #200 ;all lines stable?
	bne main2
	inc chkCnt
	lda chkCnt
	cmp #10 ; number of checks (frames) to perform
	bcc main1
	bcs main3
main1
	jmp main
main2
	jsr restoreSystemSettings
	;show message "DGM G9 not available"
	ldy #.lo(dgmNotAvail)
	ldx #.hi(dgmNotAvail)
	lda #dgmNotAvailLen
	jsr outputText
	jsr waitAfterMsg
	jsr closeIOChns
	jmp (dosvec) ;quit - DGM not available
main3
	jmp restoreSystemSettings ;quit - OK


dgmNotAvail
	dta c "DGM G9 not available", $9B
dgmNotAvailEnd

dgmNotAvailLen = dgmNotAvailEnd - dgmNotAvail


waitY
	cpy vcount
	bne waitY
	rts


;sum up stable lines - max 200
sumStableLines
	ldx #0
	ldy #200
sumLin1
	lda collisions,Y
	beq sumLin2
	inx
sumLin2
	dey
	bne sumLin1
	txa
	rts


prepareDispList
	lda #$70
	sta dList
	sta dList+1
	ldy #210
prpDList1
	lda #$4F
	sta dListRegLines-3,Y
	sta dListRegLines-3+210,Y
	sta dListRegLines-3+420,Y
	lda #.lo(screenData)
	sta dListRegLines-2,Y
	sta dListRegLines-2+210,Y
	sta dListRegLines-2+420,Y
	lda #.hi(screenData)	
	sta dListRegLines-1,Y
	sta dListRegLines-1+210,Y
	sta dListRegLines-1+420,Y
	dey
	dey
	dey
	bne prpDList1
	rts


;16,107; no wsync; normal; dList instr. 3 bytes
;DGM-DG10; no DPS
check_16_107
	lda #$22
	sta dmactl
	nop
	nop
	nop
	sta wsync ;must be two consecutive wsyncs
	sta wsync
	nop
	nop
	nop
	nop
	nop
	ldy #$FF
check_16_107_1
	nop
	nop
	ldx #$80
	lda #$40
	sta gtiactl
	stx gtiactl
	lda 0
	nop
	nop
	nop
	nop
	nop
	iny
	cpy #201
	bcs check_16_107_2
	lda m0pf ;collisions of Missile 0
	sta collisions,Y
	sta hitclr
	lda #$00
	sta gtiactl
	nop
	lda 0
	jmp check_16_107_1
check_16_107_2
	rts


collisions
	.ds 256
