
start
	ldy #.lo(welcomeText)
	ldx #.hi(welcomeText)
	lda #welcomeTextLen
	jsr outputText
	jsr wait4SecOrKey

	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	;save original vblki vector
	lda	vvblki
	sta tmpVvblki
	lda	vvblki+1
	sta tmpVvblki+1
	;set new vblki vector
	lda #6
	ldx #.hi(vBlkInt)
	ldy #.lo(vBlkInt)
	jsr setvbv

	lda #1
	sta critic      ;delayed part of system VBLK handler will be off

	lda #$00
	sta nmien       ;disable all NMI
	sta nmires

	sei ;turn off all IRQ

	;save original dmactl
	lda dmactls
	sta tmpDmactls

	lda #$00
	sta dmactls
	sta dmactl      ;disable screen dma

	;save original dli vector
	lda	dliv
	sta tmpDliv
	lda	dliv+1
	sta tmpDliv+1
	;set new dli vector
	lda #.lo(dliHnd)   ;setup DLI vector
	sta dliv
	lda #.hi(dliHnd)
	sta dliv+1

	;save original dlist vector
	lda	dlptrs
	sta tmpDlptrs
	lda	dlptrs+1
	sta tmpDlptrs+1
	;set new dlist vector
	lda #.lo(dList)  ;setup Display List vector
	sta dlptrs
	sta dlptr
	lda #.hi(dList)
	sta dlptrs+1
	sta dlptr+1

	;save original gtiactl
	lda gtiactls
	sta tmpGtiactls
	;set new gtiactl
	lda #$00
	sta gtiactl
	sta gtiactls

	;save original colors
	ldy #$08
savCol1
	lda colpm0s,Y
	sta tmpColpm0s,Y
	dey
	bpl savCol1

	;fill screen memory 4k
	lda #$39 ;0321
	ldy #$00
filScMem1
	sta picAdr,Y
	sta picAdr+(256*1),Y
	sta picAdr+(256*2),Y
	sta picAdr+(256*3),Y
	sta picAdr+(256*4),Y
	sta picAdr+(256*5),Y
	sta picAdr+(256*6),Y
	sta picAdr+(256*7),Y
	sta picAdr+(256*8),Y
	sta picAdr+(256*9),Y
	sta picAdr+(256*10),Y
	sta picAdr+(256*11),Y
	sta picAdr+(256*12),Y
	sta picAdr+(256*13),Y
	sta picAdr+(256*14),Y
	sta picAdr+(256*15),Y
	dey
	bne filScMem1

	;empty collisions store area
	;lda #$00
	;tay ;Y already set to 0
	tya
emptCollsns
	sta collisions,Y
	dey
	bne emptCollsns

	;lda #$80
	;sta grafp0

	;lda #$00
	sta grafp1
	sta grafp2
	sta grafp3
	sta grafm
	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	sta sizem
	sta hposp1
	sta hposp2
	sta hposp3
	sta hposm0
	sta hposm1
	sta hposm2
	sta hposm3

	sta hscrol

	sta showBkgScreen
	sta quit
	sta stabilityPercentBCD
	sta stabilityPercentBCD+1
	sta framesCnt
	sta secondsCnt
	sta minutesCnt
	sta hoursCnt
	sta alOn
	sta alarmPlayed
	sta timeLatched
	sta blinkFrameIdx
	sta progressTxtShown

	lda #$01
	sta clkOn

	lda #$FF
	sta lastKey

	;init DGF stability measurement procedure
	jsr initStabilityMeasure

	jsr handleShowBkgScreen
	
	lda #LEFT_BORDER+0
	sta hposp0

	lda #$C0        ;enable VBLKI and DLI
	sta nmien

	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	lda #$22        ;normal width screen
	sta dmactls
	sta dmactl      ;enable screen dma

	jmp main


quitProg

	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	;restore original vblki vector
	lda #6
	ldx tmpVvblki+1
	ldy tmpVvblki
	jsr setvbv

	lda #0
	sta critic

	;restore original colors
	ldy #$08
resCol1
	lda tmpColpm0s,Y
	sta colpm0s,Y
	sta colpm0,Y
	dey
	bpl resCol1

	;restore original gtiactl
	lda tmpGtiactls
	sta gtiactls
	sta gtiactl

	;restore original dlist vector
	lda tmpDlptrs
	sta dlptrs
	sta dlptr
	lda tmpDlptrs+1
	sta dlptrs+1
	sta dlptr+1

	;restore original dli vector
	lda tmpDliv
	sta dliv
	lda tmpDliv+1
	sta dliv+1

	;restore original dmactl
	lda tmpDmactls
	sta dmactls
	sta dmactl

	lda #$00
	sta pmctl       ;disable PMG DMA in GTIA

	lda #$40
	sta nmien       ;enable VBLKI only

	cli ;turn on all IRQ

	lda #$FF
	sta kbcodes

	;jsr reopenSysScreen

	lda #$00
	tax
	tay

	rts ;quit to OS/DOS
	;jmp (dosvec)


;reopenSysScreen
;	ldx #$00
;	lda #$0C
;	jsr ropnSyScr1
;	ldx #$00
;	lda #.lo(screenDev)
;	sta ICBAL,x ;$0344,X
;	lda #.hi(screenDev)
;	sta ICBAH,x ;$0345,X
;	lda #$0C
;	sta ICAX1,x ;$034A,X
;	lda #$00
;	sta ICAX2,x ;$034B,X
;	lda #$03
;ropnSyScr1
;	sta ICCOM,x ;$0342,X
;	jmp ciov ;$E456
;
;screenDev
;	dta c "E:", $9B


wait4SecOrKey
	ldx #200
wait4Sec1
	lda kbcodes
	cmp #$FF
	bne wait4Sec3
	lda rtclock+2
wait4Sec2
	cmp rtclock+2
	beq wait4Sec2
	dex
	bne wait4Sec1
wait4Sec3
	rts

outputText
	pha
	lda #$00
	sta ICBLH ;$0349
	pla
outputLongText
	sty ICBAL ;$0344
	stx ICBAH ;$0345
	sta ICBLL ;$0348
	ldx #$00
	lda #$0B
	sta ICCOM,x ;$0342,X
	jmp ciov ;$E456


stop	.ds 1
showBkgScreen .ds 1 ;init to 0
colDetectColMask .ds 1
checkProcPtr .ds 2
quit	.ds 1 ;1 - signal to quit the program, init to 0
tmpVvblki	.ds 2
tmpDliv		.ds 2
tmpDlptrs	.ds 2
tmpDmactls	.ds 1
tmpGtiactls	.ds 1
tmpColpm0s	.ds 9


UPPER_SCREEN_COLLISION_BUFFER_OFFSET = 0
LOWER_SCREEN_COLLISION_BUFFER_OFFSET = 110


runCheckProcX
	txa
	and #$07
	tax
	lda checkProcPtrLSBs,X
	sta checkProcPtr
	lda checkProcPtrMSBs,X
	sta checkProcPtr+1
	jmp (checkProcPtr)


main
	ldy #$03
	jsr waitY

	lda #$80
	sta grafp0
	lda dmactls ;normal width screen
	sta dmactl
	lda #$00
	sta gtiactl
	sta wsync

	ldy #UPPER_SCREEN_COLLISION_BUFFER_OFFSET
	ldx upperProcIdx
	jsr runCheckProcX

	ldy #$3D
	jsr waitY
	sta wsync
	lda dmactls ;normal width screen for info line
	sta dmactl
	lda #$00
	sta gtiactl
	lda #$1A ;color 1 for info line
	sta colpf1
	lda #$82 ;color 2 for info line
	sta colpf2

	ldy #$42
	jsr waitY
	lda colpf1s ;color 1 for upper and lower screen
	sta colpf1
	lda colpf2s ;color 2 for upper and lower screen
	sta colpf2

	lda #$80
	sta grafp0

	ldy #LOWER_SCREEN_COLLISION_BUFFER_OFFSET
	ldx lowerProcIdx
	jsr runCheckProcX

	lda quit
	beq main
	jmp quitProg


waitY
	cpy vcount
	bne waitY
	rts


measureMode .ds 1 ;1 - check 1 on upper screen, switched checks 1, 2, 3, 4 and 5 on lower screen
                  ;2 - check 5 on upper screen, switched checks 1 and 6 on lower screen
measureFrameIdx .ds 1 ;current number of frame in measurement cycle (0-31)
maxMeasureCnt .ds 1 ;number of consequent max measures in mode 2
notMaxMeasureCnt .ds 1 ;number of consequent not max measures in mode 2, only after reaching dgf stability
dgfStabilityReached .ds 1 ;1 = dgf stability has been reached in current run of measurement procedure
stableLinesSumMode .ds 1 ;1 = sum upper screen lines, 2 = sum lower screen lines, 3 = sum both screen lines
stableLinesSum .ds 2 ;sum of stable lines in measurement cycle, max 200*32=6400
stabilityPercentBCD .ds 2 ;BCD percentage of stable lines in measurement cycle
upperLinesSum .ds 1
lowerLinesSum .ds 1
upperProcIdx .ds 1
lowerProcIdx .ds 1


;Sums number of DGF-stable lines.
;Maximum number which may be added to the sum per single call is 200, no matter if half (100 lines) or whole (200 lines) screen is considered.
;It is called 32 times per measurement cycle.
sumStableLines
	lda pal
	and #$0E
	bne sumNTSCStableLines ;branch if NTSC
	ldx stableLinesSumMode ;1 = sum upper screen lines, 2 = sum lower screen lines, 3 = sum both screen lines
	ldy #100
	cpx #3
	bne sumLin4
sumLin1
	lda collisions+UPPER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumLin2
	inc stableLinesSum
	bne sumLin2
	inc stableLinesSum+1
sumLin2
	lda collisions+LOWER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumLin3
	inc stableLinesSum
	bne sumLin3
	inc stableLinesSum+1
sumLin3
	dey
	bne sumLin1
	rts
sumLin4
	cpx #2
	bne sumLin7
sumLin5
	lda collisions+LOWER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumLin6
	clc
	lda #2
	adc stableLinesSum
	sta stableLinesSum
	lda #0
	adc stableLinesSum+1
	sta stableLinesSum+1
sumLin6
	dey
	bne sumLin5
	rts
sumLin7
	lda collisions+UPPER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumLin8
	clc
	lda #2
	adc stableLinesSum
	sta stableLinesSum
	lda #0
	adc stableLinesSum+1
	sta stableLinesSum+1
sumLin8
	dey
	bne sumLin7
	rts

;Sums number of DGF-stable lines in NTSC machine.
;Maximum number which may be added to the sum per single call is 200, no matter if half (100 lines) or whole (200 lines) screen is considered.
;It is called 32 times per measurement cycle.
;Real number of lines checked is limited from 200 to 50 to reduce execution time (to fit VBLK).
sumNTSCStableLines
	ldx stableLinesSumMode ;1 = sum upper screen lines, 2 = sum lower screen lines, 3 = sum both screen lines
	ldy #25
	cpx #3
	bne sumNLin4
sumNLin1
	lda collisions+UPPER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumNLin2
	clc
	lda #4
	adc stableLinesSum
	sta stableLinesSum
	bne sumNLin2
	inc stableLinesSum+1
sumNLin2
	lda collisions+LOWER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumNLin3
	clc
	lda #4
	adc stableLinesSum
	sta stableLinesSum
	bne sumNLin3
	inc stableLinesSum+1
sumNLin3
	dey
	bne sumNLin1
	rts
sumNLin4
	cpx #2
	bne sumNLin7
sumNLin5
	lda collisions+LOWER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumNLin6
	clc
	lda #8
	adc stableLinesSum
	sta stableLinesSum
	bne sumNLin6
	inc stableLinesSum+1
sumNLin6
	dey
	bne sumNLin5
	rts
sumNLin7
	lda collisions+UPPER_SCREEN_COLLISION_BUFFER_OFFSET-1,Y
	beq sumNLin8
	clc
	lda #8
	adc stableLinesSum
	sta stableLinesSum
	bne sumNLin8
	inc stableLinesSum+1
sumNLin8
	dey
	bne sumNLin7
	rts


;Measures DGF stability.
;There are 2 modes of measurement, applied consecutively.
measureStability
	jsr sumStableLines
	inc measureFrameIdx
	lda measureMode
	bne msrStb21 ;branch to mode 1 or higher
	rts
msrStb21
	cmp #1
	bne msrStb31 ;branch to mode 2
;mode 1 - check 1 on upper screen, switched checks 1, 2, 3, 4 and 5 on lower screen
	lda measureFrameIdx
	and #$1F
	tax
	lda mode1FrameToCheck,X
	sta lowerProcIdx
	lda measureFrameIdx
	cmp #32
	bcs msrStb22
	rts
msrStb22
	lda #0
	sta measureFrameIdx
	sta stabilityPercentBCD
	sta stabilityPercentBCD+1
	;check if all lines stable for all tries - if so then 100% stability
	;max sum after 32 turns is 200*32=6400
	lda #.lo(200*32)
	cmp stableLinesSum
	bne msrStb23
	lda #.hi(200*32)
	cmp stableLinesSum+1
	bne msrStb23
	;inc stabilityPercentBCD+1
	lda #$99
	sta stabilityPercentBCD
	jmp msrStb43 ;switch to mode 2
msrStb23
	;6400*4=25600, 25600/256=100
	lda stableLinesSum+1
	asl stableLinesSum
	rol
	asl stableLinesSum
	rol
	jsr binToBCD
	bcc msrStb24
	;if C=1 then the result is 100 but we still treat it as 99% stability
	lda #$99
msrStb24
	sta stabilityPercentBCD
	jmp msrStb45
msrStb31
;mode 2 - check 5 on upper screen, switched checks 1 and 6 on lower screen
	lda measureFrameIdx
	and #$1F
	tax
	lda mode2FrameToCheck,X
	sta lowerProcIdx
	lda measureFrameIdx
	cmp #32
	bcs msrStb32
	rts
msrStb32
	lda #0
	sta measureFrameIdx
	sta stabilityPercentBCD
	sta stabilityPercentBCD+1
	;check if all lines stable for all tries - if so then 100% stability
	;max sum after 32 turns is 200*32=6400
	lda #.lo(200*32)
	cmp stableLinesSum
	bne msrStb34
	lda #.hi(200*32)
	cmp stableLinesSum+1
	bne msrStb34
	inc maxMeasureCnt
	lda maxMeasureCnt
	cmp #7 ;number of consequent max measures required to consider dgf stability reached; 4.5 sec; (32/50Hz)*7
	bcc msrStb33
	lda #1
	sta dgfStabilityReached
msrStb33
	lda #0
	sta notMaxMeasureCnt
	inc stabilityPercentBCD+1 ;stability = 100%
	bne msrStb45 ;branch always
msrStb34
	;6400*4=25600, 25600/256=100
	lda stableLinesSum+1
	asl stableLinesSum
	rol
	asl stableLinesSum
	rol
	jsr binToBCD
	bcc msrStb35
	;if C=1 then the result is 100 but we still treat it as 99% stability
	lda #$99
msrStb35
	sta stabilityPercentBCD
	lda #0
	sta maxMeasureCnt
	lda dgfStabilityReached
	beq msrStb36
	inc notMaxMeasureCnt
	lda notMaxMeasureCnt
	cmp #16 ;10 sec; (32/50Hz)*16
	bcs initStabilityMeasure ;reinitialize measurement procedure - hardware seems to cool down
msrStb36
	jmp msrStb45
;init/switch to mode 1 - check 1 on upper screen, switched checks 1, 2, 3, 4 and 5 on lower screen
initStabilityMeasure
	lda #0
	sta dgfStabilityReached
	lda #1
	sta measureMode
	;lda #1 ;check 1
	sta upperProcIdx
	lda mode1FrameToCheck ;check 1
	sta lowerProcIdx
	;lda #2 ;2 = sum lower screen lines
	lda #3 ;3 = sum both screen lines
	sta stableLinesSumMode ;1 = sum upper screen lines, 2 = sum lower screen lines, 3 = sum both screen lines
	bne msrStb44 ;branch always
msrStb43
;switch to mode 2 - check 5 on upper screen, switched checks 1 and 6 on lower screen
	lda #2
	sta measureMode
	lda #5 ;check 5
	sta upperProcIdx
	;lda #1 ;check 1
	lda mode2FrameToCheck ;check 1
	sta lowerProcIdx
	lda #3 ;3 = sum both screen lines
	sta stableLinesSumMode ;1 = sum upper screen lines, 2 = sum lower screen lines, 3 = sum both screen lines
	lda #0
	sta maxMeasureCnt
	sta notMaxMeasureCnt
msrStb44
	lda #0
	sta measureFrameIdx
msrStb45
	lda #0
	sta stableLinesSum
	sta stableLinesSum+1
	rts

;mapping of frame index (0-31) to check method in mode 1
;check 5 share is about 10% (6 out of 64 frames); if check 5 has stability 0% while other have 100% we get 90% overall stability; DGI demo works fine with this 90% stability
mode1FrameToCheck
	.db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
	.db 2,2,2,3,3,3,4,4,4,4,5,5,5,5,5,5

;mapping of frame index (0-31) to check method in mode 2
mode2FrameToCheck
	.db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
	.db 6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6

showStability
;overall
	lda stabilityPercentBCD+1
	jsr loNibbleToDec
	sta stabDisp+0
	lda stabilityPercentBCD
	jsr hiNibbleToDec
	sta stabDisp+1
	lda stabilityPercentBCD
	jsr loNibbleToDec
	sta stabDisp+2
	;remove leading zeros
	ldx #$00
	lda stabDisp+0
	cmp #$10 ;0 digit
	bne shwStb1
	stx stabDisp+0
	lda stabDisp+1
	cmp #$10 ;0 digit
	bne shwStb1
	stx stabDisp+1
shwStb1
	rts


framesCnt .ds 1
secondsCnt .ds 1
minutesCnt .ds 1
hoursCnt .ds 1
clkOn .ds 1

calcTimeElapsed
	lda clkOn
	beq clcTim2
	inc framesCnt
	ldy #0
	ldx #50
	lda pal
	and #$0E
	beq clcTim1 ;branch if PAL
	ldx #60
clcTim1
	cpx framesCnt
	beq clcTim1a
	bcs clcTim2
clcTim1a
	sty framesCnt ;store 0
	sed ;turn on BCD
	lda secondsCnt
	adc #0 ;c=1
	sta secondsCnt
	cmp #$60
	bcc clcTim2
	sty secondsCnt ;store 0
	lda minutesCnt
	adc #0 ;c=1
	sta minutesCnt
	cmp #$60
	bcc clcTim2
	sty minutesCnt ;store 0
	lda hoursCnt
	adc #0 ;c=1
	sta hoursCnt
clcTim2
	cld ;turn off BCD
	rts

showTimeElapsed
	lda minutesCnt
	bne shwTim1
	lda hoursCnt
	jsr hiNibbleToDec
	sta timeDisp+0
	lda hoursCnt
	jsr loNibbleToDec
	sta timeDisp+1
shwTim1
	lda secondsCnt
	bne shwTim2
	lda minutesCnt
	jsr hiNibbleToDec
	sta timeDisp+3
	lda minutesCnt
	jsr loNibbleToDec
	sta timeDisp+4
shwTim2
	lda framesCnt
	bne shwTim3
	lda secondsCnt
	jsr hiNibbleToDec
	sta timeDisp+6
	lda secondsCnt
	jsr loNibbleToDec
	sta timeDisp+7
shwTim3
	rts


binToBCD
	tax
	lsr
	lsr
	lsr
	lsr
	tay
	txa
	and #$0F
	tax
	lda binToBCD_mn,Y
	sed
	clc
	adc binToBCD_ln,X
	cld
	rts

binToBCD_mn
	.db $00,$16,$32,$48,$64,$80,$96 ;,$00,$00,$00,$00,$00,$00,$00,$00,$00
binToBCD_ln
	.db $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$10,$11,$12,$13,$14,$15


alFreq
	.db $30,$30,$30,$30
alVol
	.db $AA,$00,$AA,$00
alTime
	.db 5,2,5,20

alTimer	.ds 1
alIdx .ds 1
alOn  .ds 1
alDur .ds 2

playAlarm
	lda alOn
	beq plAl3
	lda alTimer
	bne plAl2
	ldx alIdx
	lda alFreq,X
	sta audf1
	lda alVol,X
	sta audc1
	lda alTime,X
	sta alTimer
	inx
	cpx #4
	bcc plAl1
	ldx #0
plAl1
	stx alIdx
plAl2
	dec alTimer
	inc alDur
	bne plAl4
	inc alDur+1
	lda alDur+1
	cmp #12 ;play alarm about 1 minute max, 12*256/50=61 sec
	bcc plAl4
	lda #$00
	sta alOn
plAl3
	sta audf1
	sta audc1
	sta alTimer
	sta alIdx
	sta alDur
	sta alDur+1
plAl4
	rts

alarmPlayed .ds 1 ;1 = alarm played for current run of measurement procedure, 0 = alarm not played

handleAlarm
	lda alarmPlayed
	beq hndAlrm1
	lda dgfStabilityReached
	bne hndAlrm2
	sta alOn
	sta alarmPlayed
	beq hndAlrm2 ;branch always
hndAlrm1
	lda dgfStabilityReached
	sta alOn
	sta alarmPlayed
hndAlrm2
	jmp playAlarm


timeLatched .ds 1 ;1 = time of reaching stability latched for current run of measurement procedure, 0 = time not latched
blinkFrameIdx .ds 1
progressTxtShown .ds 1
progressTxt dta d'PROGRESS'

;Shows 'Progress' text if DGF stability not reached, blinking latched time of reaching stability otherwise.
handleDgfStabilityReached
	lda dgfStabilityReached
	bne hndStbRch3
	lda progressTxtShown
	bne hndStbRch2
	ldx #8-1
hndStbRch1
	lda progressTxt,X
	sta progrDisp,X
	dex
	bpl hndStbRch1
	stx progressTxtShown
	lda #0
	sta timeLatched
	sta blinkFrameIdx
hndStbRch2
	rts
hndStbRch3
	lda timeLatched
	bne hndStbRch5
	ldx #8-1
hndStbRch4
	lda timeDisp,X
	sta latchedTime,X
	dex
	bpl hndStbRch4
	stx timeLatched
	lda #0
	sta progressTxtShown
hndStbRch5
	lda blinkFrameIdx
	and #$1F
	cmp #$00
	bne hndStbRch7
	ldx #8-1
hndStbRch6
	lda latchedTime,X
	sta progrDisp,X
	dex
	bpl hndStbRch6
	bmi hndStbRch9
hndStbRch7
	cmp #$10
	bne hndStbRch9
	ldx #8-1
	lda #$00
hndStbRch8
	sta progrDisp,X
	dex
	bpl hndStbRch8
hndStbRch9
	inc blinkFrameIdx
	rts


vBlkInt
	;pha
	;txa
	;pha
	;tya
	;pha

	lda #$01
	sta stop
	sta atract

	jsr measureStability
	jsr showStability

	jsr calcTimeElapsed
	jsr showTimeElapsed

	jsr handleDgfStabilityReached
	jsr handleAlarm

	jsr handleKeyboard
	;pla
	;tay
	;pla
	;tax
	;pla
	;rti
	jmp sysvbv


dliHnd
	pha
	lda #$01
	sta stop

	lda #$00
	sta grafp0
	sta hitclr

	pla
	rti


repetitionDelay	.ds 1
lastKey	.ds 1


handleKeyboard
	jsr getKey
	cmp #$FF
	bne handleKeyboard1
	rts
handleKeyboard1
	ldx #0
	stx alOn ;any key turns off alarm
;	cmp #KEY_Q
;	bne handleKeyboard14
;	lda #1
;	sta dgfStabilityReached
;	jmp msrStb43
;handleKeyboard14
	cmp #KEY_ESCAPE
	bne handleKeyboard15
	lda #$01
	sta quit
	rts
handleKeyboard15
	cmp #KEY_B
	bne handleKeyboard16
	lda showBkgScreen
	eor #$01
	sta showBkgScreen
	jmp handleShowBkgScreen
handleKeyboard16
	rts


getKey
	;test regular keys
	lda skstat    ;test if any key pressed
	and #$04
	beq kbdHnd10
	lda #$FF
	sta lastKey
kbdHnd9:
	lda #$FF
	rts
kbdHnd10:
	;handle regular keys
	lda kbcode
	tax
	cmp lastKey
	bne kbdHnd11
	lda repetitionDelay
	beq kbdHnd10a ;no repetition
	;beq kbdHnd10b
	dec repetitionDelay
kbdHnd10a:
	jmp kbdHnd9
kbdHnd10b:
	lda #$04
	bne kbdHnd11b
	;lda #$00
	;beq kbdHnd11b
kbdHnd11:
	lda #$14
kbdHnd11b:
	sta repetitionDelay
	txa
	sta lastKey
	rts


handleShowBkgScreen
	lda showBkgScreen
	beq hndShBkgSc1
	lda #$FE
	sta colpf0
	sta colpf0s
	lda #$1A
	sta colpf1
	sta colpf1s
	lda #$82
	sta colpf2
	sta colpf2s
	lda #$CC
	sta colpf3
	sta colpf3s
	lda #$00
	sta colbak
	sta colbaks
	lda #$08
	sta colpm0
	sta colpm0s
	lda #$68
	sta colpm1
	sta colpm1s
	lda #$86
	sta colpm2
	sta colpm2s
	lda #$A4
	sta colpm3
	sta colpm3s
	lda #$FF
	sta colDetectColMask
	rts
hndShBkgSc1
	lda #$00
	sta colpf0
	sta colpf0s
	sta colpf1
	sta colpf1s
	sta colpf2
	sta colpf2s
	sta colpf3
	sta colpf3s
	sta colbak
	sta colbaks
	sta colpm0
	sta colpm0s
	sta colpm1
	sta colpm1s
	sta colpm2
	sta colpm2s
	sta colpm3
	sta colpm3s
	sta colDetectColMask
	rts


loNibbleToDec
	and #$0F
	ora #$10
	rts


hiNibbleToDec
	lsr
	lsr
	lsr
	lsr
	ora #$10
	rts

latchedTime
	.ds 8

collisions
	.ds 256
