
start
	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	;save original vblki vector
	lda	vvblki
	sta tmpVvblki
	lda	vvblki+1
	sta tmpVvblki+1
	;set new vblki vector
	lda #6
	ldx #.hi(vBlkInt)
	ldy #.lo(vBlkInt)
	jsr setvbv

	lda #1
	sta critic      ;delayed part of system VBLK handler will be off

	lda #$00
	sta nmien       ;disable all NMI
	sta nmires

	sei ;turn off all IRQ

	;save original dmactl
	lda dmactls
	sta tmpDmactls

	lda #$00
	sta dmactls
	sta dmactl      ;disable screen dma

	;save original dlist vector
	lda	dlptrs
	sta tmpDlptrs
	lda	dlptrs+1
	sta tmpDlptrs+1
	;set new dlist vector
	lda #.lo(dList)  ;setup Display List vector
	sta dlptrs
	sta dlptr
	lda #.hi(dList)
	sta dlptrs+1
	sta dlptr+1

	;save original gtiactl
	lda gtiactls
	sta tmpGtiactls
	;set new gtiactl
	lda #$40
	sta gtiactl
	sta gtiactls

	;save original colors
	ldy #$08
savCol1
	lda colpm0s,Y
	sta tmpColpm0s,Y
	dey
	bpl savCol1

	;fill screen memory
	jsr fillScrArea

	lda #$00
	sta grafp0
	sta grafp1
	sta grafp2
	sta grafp3
	sta grafm
	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	sta sizem
	sta hposp0
	sta hposp1
	sta hposp2
	sta hposp3
	sta hposm1
	sta hposm2
	sta hposm3

	sta hscrol

	sta quit

	sta colbak
	sta colbaks
	sta colpm0
	sta colpm0s
	sta colpf1
	sta colpf1s
	sta colpf2
	sta colpf2s

	lda #$22
	sta colpm1
	sta colpm1s
	lda #$34
	sta colpm2
	sta colpm2s
	lda #$76
	sta colpm3
	sta colpm3s
	lda #$88
	sta colpf0
	sta colpf0s
	lda #$9A
	sta colpf3
	sta colpf3s

	lda #$01
	sta grafm
	
	lda #LEFT_BORDER+72
	sta hposm0

	lda #$FF
	sta lastKey

	lda #$40        ;enable VBLKI
	sta nmien

	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	lda #$22        ;normal width screen
	sta dmactls
	sta dmactl      ;enable screen dma

	jmp main


quitProg

	;wait for new screen frame
	lda rtclock + 2
	cmp rtclock + 2
	beq *-2

	;restore original vblki vector
	lda #6
	ldx tmpVvblki+1
	ldy tmpVvblki
	jsr setvbv

	lda #0
	sta critic

	;lda #$00
	sta hposm0
	sta grafm

	;restore original colors
	ldy #$08
resCol1
	lda tmpColpm0s,Y
	sta colpm0s,Y
	sta colpm0,Y
	dey
	bpl resCol1

	;restore original gtiactl
	lda tmpGtiactls
	sta gtiactls
	sta gtiactl

	;restore original dlist vector
	lda tmpDlptrs
	sta dlptrs
	sta dlptr
	lda tmpDlptrs+1
	sta dlptrs+1
	sta dlptr+1

	;restore original dmactl
	lda tmpDmactls
	sta dmactls
	sta dmactl

	lda #$00
	sta pmctl       ;disable PMG DMA in GTIA

	lda #$40
	sta nmien       ;enable VBLKI

	cli ;turn on all IRQ

	lda #$FF
	sta kbcodes

	lda #$00
	tax
	tay

	rts ;quit to OS/DOS
	;jmp (dosvec)


quit	.ds 1 ;1 - signal to quit the program, init to 0
tmpVvblki	.ds 2
tmpDlptrs	.ds 2
tmpDmactls	.ds 1
tmpGtiactls	.ds 1
tmpColpm0s	.ds 9


main
	jsr displayModes
	lda quit
	beq main
	jmp quitProg


waitY
	cpy vcount
	bne waitY
	rts


displayModes
	ldy #14
	jsr waitY
	jsr g9mode
	lda 0
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	jsr dg9mode_e1
	jsr dpsmode_e1
	jsr g9dpsmode_e1
	jsr dg9dpsmode_e1
	ldy #66
	jsr waitY
	jsr g10mode
	lda 0
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	jsr dg10mode_e1
	jsr dpsmode_e1
	jsr g10dpsmode_e1
	jsr dg10dpsmode_e1
	rts


vBlkInt
	;pha
	;txa
	;pha
	;tya
	;pha

	lda #$00
	sta atract

	jsr handleKeyboard
	;pla
	;tay
	;pla
	;tax
	;pla
	;rti
	jmp sysvbv


repetitionDelay	.ds 1
lastKey	.ds 1


handleKeyboard
	jsr getKey
	cmp #$FF
	bne handleKeyboard1
	rts
handleKeyboard1
	cmp #KEY_ESCAPE
	bne handleKeyboard15
	lda #$01
	sta quit
	rts
handleKeyboard15
	cmp #KEY_SPACE
	bne handleKeyboard16
	lda colpf2s
	eor #$C4
	sta colpf2s
	sta colpf2
handleKeyboard16
	rts


getKey
	;test regular keys
	lda skstat    ;test if any key pressed
	and #$04
	beq kbdHnd10
	lda #$FF
	sta lastKey
kbdHnd9:
	lda #$FF
	rts
kbdHnd10:
	;handle regular keys
	lda kbcode
	tax
	cmp lastKey
	bne kbdHnd11
	lda repetitionDelay
	beq kbdHnd10a ;no repetition
	;beq kbdHnd10b
	dec repetitionDelay
kbdHnd10a:
	jmp kbdHnd9
kbdHnd10b:
	lda #$04
	bne kbdHnd11b
	;lda #$00
	;beq kbdHnd11b
kbdHnd11:
	lda #$14
kbdHnd11b:
	sta repetitionDelay
	txa
	sta lastKey
	rts


picWidth = 40

fill20LinesScrArea .macro
	ldy #picWidth-1
;filScArea11
	lda screenSrcData,Y
	sta :1,Y
	sta :1+(picWidth*1),Y
	sta :1+(picWidth*2),Y
	sta :1+(picWidth*3),Y
	sta :1+(picWidth*4),Y
	sta :1+(picWidth*5),Y
	sta :1+(picWidth*6),Y
	sta :1+(picWidth*7),Y
	sta :1+(picWidth*8),Y
	sta :1+(picWidth*9),Y
	sta :1+(picWidth*10),Y
	sta :1+(picWidth*11),Y
	sta :1+(picWidth*12),Y
	sta :1+(picWidth*13),Y
	sta :1+(picWidth*14),Y
	sta :1+(picWidth*15),Y
	sta :1+(picWidth*16),Y
	sta :1+(picWidth*17),Y
	sta :1+(picWidth*18),Y
	sta :1+(picWidth*19),Y
	dey
	bpl *-64 ;filScArea11
.endm

fillScrArea
	fill20LinesScrArea picAdr+picWidth*0
	fill20LinesScrArea picAdr+picWidth*20
	fill20LinesScrArea picAdr+picWidth*40
	fill20LinesScrArea picAdr+picWidth*60
	fill20LinesScrArea picAdr+picWidth*80
	fill20LinesScrArea picAdr+picWidth*100
	fill20LinesScrArea picAdr+picWidth*120
	fill20LinesScrArea picAdr+picWidth*140
	fill20LinesScrArea picAdr+picWidth*160
	fill20LinesScrArea picAdr+picWidth*180
	rts

