 icl "system.inc"
 icl "dgfdemo.inc"

 org chkAdr

 ;The initial checks start here.
 ;This code is executed before loading main part of XEX into memory and stops loading in case any test fails.
 
	jsr checkMem
	beq chk1
	jsr wait3Sec
	jmp quitDos
chk1
	rts

wait3Sec
	ldx #150
wait3Sec1
	lda rtclock+2
wait3Sec2
	cmp rtclock+2
	beq wait3Sec2
	dex
	bne wait3Sec1
	rts

outputText
	pha
	lda #$00
	sta ICBLH ;$0349
	pla
outputLongText
	sty ICBAL ;$0344
	stx ICBAH ;$0345
	sta ICBLL ;$0348
	ldx #$00
	lda #$0B
	sta ICCOM,x ;$0342,X
	jmp ciov ;$E456

quitDos
	jsr closeIOChns
	jmp (dosvec)

;close all IOCBs except 0
closeIOChns
	ldx	#0
	beq	closeIOChns2
closeIOChns1
	lda #$0C
	sta ICCOM,x ;$0342,X
	jsr CIOV ;$E456
closeIOChns2
	txa 
	clc 
	adc #$10
	tax 
	bpl closeIOChns1
	rts

insufMem
	dta c "Insufficient memory! Required 24K RAM", $9B
insufMemEnd

insufMemLen = insufMemEnd - insufMem

checkMem
	lda ramtop
	cmp #$60
	bcs chkm1
	;show message "INSUFFICIENT MEMORY! REQUIRED 24K OF RAM"
	ldy #.lo(insufMem)
	ldx #.hi(insufMem)
	lda #insufMemLen
	jsr outputText
	lda #$FF	;memory tests not passed
	rts
chkm1
	lda #$00	;memory tests passed
	rts

 ini chkAdr

