/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

scr48	= %00111111	;screen 48b
scr40	= %00111110	;screen 40b
scr32	= %00111101	;screen 32b

hposp0	= $D000
hposp1	= $D001
hposp2	= $D002
hposp3	= $D003
hposm0	= $D004
hposm1	= $D005
hposm2	= $D006
hposm3	= $D007
sizep0	= $D008
sizep1	= $D009
sizep2	= $D00A
sizep3	= $D00B
sizem	= $D00C

colpm0	= $D012
colpm1	= $D013
colpm2	= $D014
colpm3	= $D015
color0	= $D016
color1	= $D017
color2	= $D018
color3	= $D019
colbak	= $D01A
gtictl	= $D01B

pmcntl	= $D01D
hitclr	= $D01E

skctl	= $D20F

portb	= $D301

dmactl	= $D400

dlptr	= $D402

pmbase	= $D407

chbase	= $D409
wsync	= $D40A
vcount	= $D40B

nmien	= $D40E
nmist	= $D40F


	org $80

fcnt	.ds 2
fadr	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1


* ---	MAIN PROGRAM
	org $2000

ant	ANTIC_PROGRAM scr,ant

scr	SCREEN_DATA

	.ALIGN $0400
fnt	FONTS

	.ifdef USESPRITES
	.ALIGN $0800
	.ds $0300
pmg	SPRITES
	eif

 .def :show_loading_jack
* ---	init PMG
	.ifdef USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif


	.ifdef CHANGES		;if label CHANGES defined
	jsr save_color		;then save all colors and set value 0 for all colors
	eif

	lda:cmp:req $14		;wait 1 frame

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

	mva #$c0 nmien		;switch on NMI+DLI again


	.ifdef CHANGES		;if label CHANGES defined

	jsr fade_in		;fade in colors

_lp	lda skctl		;wait to press any key; here you can put any own routine
	and #$04
	bne _lp

        jsr fade_out		;fade out colors
	mva #$00 pmcntl		;PMG disabled
	ldx #$0c\ sta:rpl hposp0,x-
	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled
	rts
       ; jmp ($000a)		;jump to DOS

	els

null	jmp dli1		;CPU is busy here, so no more routines allowed

	eif


* ---	DLI PROGRAM

	?old_dli = *

dli_start
dli11
	sta wsync		;line=16
	sta wsync		;line=17
	sta wsync		;line=18
	sta wsync		;line=19
	sta wsync		;line=20
c8	lda #$74
	sta wsync		;line=21
	sta color0
c9	lda #$F8
	sta wsync		;line=22
	sta color0
c10	lda #$FA
	sta wsync		;line=23
	sta color0
c11	lda #$F8
	sta wsync		;line=24
	sta color0
c12	lda #$24
	sta wsync		;line=25
	sta color3
c13	lda #$74
	sta wsync		;line=26
	sta color3
	DLINEW dli12

dli12

c14	lda #$46
	sta wsync		;line=32
	sta colpm3
c15	lda #$46
	ldx #$D0
	ldy #$6C
	sta wsync		;line=33
	sta color2
	stx sizem
	sty hposp3
	lda #$32
	sta hposm2
	lda #$71
	sta hposm3
	sta wsync		;line=34
	lda #$A2
	sta wsync		;line=35
	sta hposp2
	lda #$03
	ldx #$85
	ldy #$9B
	sta wsync		;line=36
	sta sizep3
	stx hposp2
	sty hposp3
	lda #$64
	sta hposm0
	lda #$03
	ldx #$96
	ldy #$C0
	sta wsync		;line=37
	sta sizep0
	stx hposp0
	sty hposm3
c16	lda #$04
	sta colpm3
	lda #$52
	sta wsync		;line=38
	sta hposm1
	lda #$D4
	sta wsync		;line=39
	sta sizem
	lda #$D3
	ldx #$C0
c17	ldy #$06
	sta wsync		;line=40
	sta sizem
	stx hposm0
	sty colpm0
	sta wsync		;line=41
	lda #$56
	sta wsync		;line=42
	sta hposm1
	DLINEW dli2


dli2	lda >fnt+$400*$01
	sta wsync		;line=56
	sta chbase
	sta wsync		;line=57
	sta wsync		;line=58
	sta wsync		;line=59
	lda #$D0
	ldx #$34
c18	ldy #$06
	sta wsync		;line=60
	sta sizem
	stx hposm0
	sty colpm3
	sta wsync		;line=61
	lda #$A2
	sta wsync		;line=62
	sta hposp2
	sta wsync		;line=63
c19	lda #$74
	sta wsync		;line=64
	sta colpm0
	sta wsync		;line=65
	lda #$01
	ldx #$C6
	ldy #$30
	sta wsync		;line=66
	sta sizep0
	stx hposp0
	sty hposm0
c20	lda #$08
	ldx #$01
	ldy #$10
	sta wsync		;line=67
	sta color3
	stx sizep3
	sty sizem
	lda #$C6
	sta hposp3
	lda #$2F
	sta hposm3
	sta wsync		;line=68
	lda #$C4
	sta wsync		;line=69
	sta hposp3
	sta wsync		;line=70
	lda #$00
	sta wsync		;line=71
	sta sizem
	sta wsync		;line=72
	lda #$01
	ldx #$C0
c21	ldy #$74
	sta wsync		;line=73
	sta sizep1
	stx hposp1
	sty colpm1
c22	lda #$24
	sta colpm3
	lda #$00
	ldx #$6F
	ldy #$7E
	sta wsync		;line=74
	sta sizep3
	stx hposp0
	sty hposp2
	lda #$76
	sta hposp3
	lda #$2F
	sta hposm0
	DLINEW dli3

dli3	lda >fnt+$400*$02
	sta wsync		;line=80
	sta chbase
	sta wsync		;line=81
	sta wsync		;line=82
	sta wsync		;line=83
	sta wsync		;line=84
	lda #$30
c23	ldx #$24
	sta wsync		;line=85
	sta hposm1
	stx colpm0
	lda #$00
	ldx #$58
	ldy #$6A
	sta wsync		;line=86
	sta sizep0
	stx hposp0
	sty hposm0
c24	lda #$74
	sta colpm3
	lda #$00
	ldx #$01
	ldy #$60
	sta wsync		;line=87
	sta sizep1
	stx sizep3
	sty hposp1
	lda #$C4
	sta hposp3
c25	lda #$24
	sta colpm1
	sta wsync		;line=88
	lda #$68
	sta wsync		;line=89
	sta hposm1
	sta wsync		;line=90
	sta wsync		;line=91
c26	lda #$06
	sta wsync		;line=92
	sta color3
	DLINEW dli13

dli13	sta wsync		;line=96
	sta wsync		;line=97
	sta wsync		;line=98
	sta wsync		;line=99
c27	lda #$74
	ldx #$03
	ldy #$A6
	sta wsync		;line=100
	sta color3
	stx sizep3
	sty hposp3
c28	lda #$06
	sta colpm3
	lda #$03
	ldx #$97
c29	ldy #$04
	sta wsync		;line=101
	sta sizep2
	stx hposp2
	sty colpm2
	lda #$30
	ldx #$B7
	sta wsync		;line=102
	sta sizem
	sta hposp0
	stx hposm2
	lda #$73
	ldx #$61
	ldy #$58
	sta wsync		;line=103
	sta sizem
	stx hposp1
	sty hposm0
	lda #$69
	sta hposm1
	lda #$98
	sta hposm3
	lda >fnt+$400*$03
	ldx #$00
	ldy #$F3
	sta wsync		;line=104
	sta chbase
	stx sizep2
	sty sizem
	lda #$9D
	sta hposp2
	lda #$97
	sta hposm3
c30	lda #$00
	sta colpm2
	sta wsync		;line=105
	lda #$03
	ldx #$97
	ldy #$A7
	sta wsync		;line=106
	sta sizep2
	stx hposp2
	sty hposp3
c31	lda #$04
	sta colpm2
c32	lda #$24
	sta wsync		;line=107
	sta color2
	sta wsync		;line=108
	lda #$A9
	sta wsync		;line=109
	sta hposm3
	lda #$B1
	sta wsync		;line=110
	sta hposm3
	sta wsync		;line=111
	sta wsync		;line=112
c33	lda #$F6
	ldx #$00
	ldy #$BB
	sta wsync		;line=113
	sta color0
	stx sizep3
	sty hposp3
c34	lda #$F8
	ldx #$30
	ldy #$CD
	sta wsync		;line=114
	sta color0
	stx sizem
	sty hposm3
c35	lda #$F6
	ldx #$42
c36	ldy #$70
	sta wsync		;line=115
	sta color0
	stx hposp0
	sty colpm0
	sta wsync		;line=116
c37	lda #$F8
	sta wsync		;line=117
	sta color0
c38	lda #$F6
	ldx #$5E
c39	ldy #$20
	sta wsync		;line=118
	sta color0
	stx hposp1
	sty colpm1
	sta wsync		;line=119
	sta wsync		;line=120
	sta wsync		;line=121
	lda #$5C
	sta wsync		;line=122
	sta hposm1
	sta wsync		;line=123
	sta wsync		;line=124
	lda #$00
	ldx #$BC
	ldy #$CD
	sta wsync		;line=125
	sta sizep2
	sta sizem
	stx hposp2
	sty hposm2
c40	lda #$F8
	sta colpm2
	lda #$C5
c41	ldx #$24
;	sta wsync		;line=126
	sta hposp3
	stx colpm3
	DLINEW dli4


dli4	lda >fnt+$400*$04
	sta wsync		;line=128
	sta chbase
	sta wsync		;line=129
	lda #$3B
c42	ldx #$22
	sta wsync		;line=130
	sta hposp0
	stx colpm0
	sta wsync		;line=131
	lda #$32
	sta wsync		;line=132
	sta hposm3
	lda #$47
c43	ldx #$06
	sta wsync		;line=133
	sta hposp1
	stx colpm1
	DLINEW dli14

dli14

c44	lda #$F8
	ldx #$4F
	ldy #$57
	sta wsync		;line=136
	sta color0
	stx hposp2
	sty hposm2
c45	lda #$2C
	sta colpm2
	sta wsync		;line=137
	lda #$03
	ldx #$70
	sta wsync		;line=138
	sta sizep0
	stx hposp0
	stx colpm0
	sta wsync		;line=139
c46	lda #$2C
	sta wsync		;line=140
	sta colpm1
	DLINEW dli5

dli5
	lda >fnt+$400*$05
	sta wsync		;line=152
	sta chbase
	sta wsync		;line=153
c47	lda #$22
	sta wsync		;line=154
	sta colpm3
c48	lda #$24
	sta wsync		;line=155
	sta colpm3
c49	lda #$22
	sta wsync		;line=156
	sta colpm3
	sta wsync		;line=157
	sta wsync		;line=158
	lda #$01
	ldx #$BD
	sta wsync		;line=159
	sta sizep3
	stx hposp3
	sta wsync		;line=160
	sta wsync		;line=161
	sta wsync		;line=162
	lda #$00
	ldx #$01
	ldy #$4A
	sta wsync		;line=163
	sta sizep0
	stx sizem
	sty hposp0
	lda #$56
	sta hposm0
c50	lda #$72
	sta colpm0
	DLINEW dli6

dli6
	lda >fnt+$400*$06
	sta wsync		;line=176
	sta chbase
	sta wsync		;line=177
	sta wsync		;line=178
	sta wsync		;line=179
	sta wsync		;line=180
	lda #$B2
c51	ldx #$22
	sta wsync		;line=181
	sta hposp2
	stx colpm2
	DLINEW dli15

dli15
	lda #$4F
c52	ldx #$22
	sta wsync		;line=184
	sta hposp1
	stx colpm1
	lda #$A8
c53	ldx #$FA
	sta wsync		;line=185
	sta hposp0
	stx colpm0
	sta wsync		;line=186
	sta wsync		;line=187
	sta wsync		;line=188
	sta wsync		;line=189
	sta wsync		;line=190
c54	lda #$24
	sta wsync		;line=191
	sta colpm3
	sta wsync		;line=192
	lda #$3A
	sta wsync		;line=193
	sta hposp0
	DLINEW dli7

dli7
	lda >fnt+$400*$07
	sta wsync		;line=200
	sta chbase
	sta wsync		;line=201
	lda #$30
	ldx #$37
	ldy #$AD
	sta wsync		;line=202
	sta sizem
	stx hposm0
	sty hposm2
	DLINEW dli16

dli16

	sta wsync		;line=208
	sta wsync		;line=209
	sta wsync		;line=210
	sta wsync		;line=211
	lda #$34
	ldx #$31
	sta wsync		;line=212
	sta sizem
	stx hposm1
	DLINEW dli17

dli17

c55	lda #$FA
	sta wsync		;line=216
	sta color0
c56	lda #$F8
	sta wsync		;line=217
	sta color0
c57	lda #$74
	sta wsync		;line=218
	sta color0
c58	lda #$70
	sta wsync		;line=219
	sta color0
c59	lda #$F8
	sta wsync		;line=220
	sta color0
	DLINEW dli8

dli8
	lda >fnt+$400*$00
	sta wsync		;line=224
	sta chbase
	jmp NMI.quit

;---

CHANGES

;---

.proc	NMI
	sta regA
	stx regX
	sty regY

	bit nmist
	bpl VBL

	jmp dli_start
dliv	equ *-2

VBL
	sta nmist		;reset NMI flag

	inc cloc		;little timer

	mwa #ant dlptr		;ANTIC address program

	mva #scr40 dmactl	;set new screen's width

;--- first line of screen initialization

	lda >fnt+$400*$00
	sta chbase
c0	lda #$00
	sta colbak
c1	lda #$70
	sta color0
c2	lda #$0C
	sta color1
c3	lda #$24
	sta color2
c4	lda #$74
	sta color3

	lda #$04
	sta gtictl

	lda #$00
	sta sizep0
	sta sizep3
	sta sizem
	sta sizep1
	sta sizep2

	lda #$4C
	sta hposp0
	lda #$53
	sta hposp3
	lda #$30
	sta hposm0
c5	lda #$74
	sta colpm0
	sta colpm3

	lda #$CE
	sta hposm3
	lda #$33
	sta hposp1
c6	lda #$06
	sta colpm1

	lda #$54
	sta hposp2
	sta hposm1

c7	lda #$24
	sta colpm2
	lda #$34
	sta hposm2

	mwa #dli_start dliv	;set the first address of DLI interrupt

;this area is for yours routines

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

;---
	icl 'init\tlo\loading_jack.fad'

;	run main
;---

	opt l-

.MACRO	SPRITES
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$03,$03,$03
	dta $03,$C3,$02,$03,$33,$32,$33,$33,$02,$73,$F3,$F2,$33,$F9,$FD,$7D
	dta $73,$F3,$FF,$FF,$F3,$F3,$F2,$F3,$F2,$F2,$F2,$F2,$F2,$F2,$F2,$F2
	dta $F3,$F2,$F3,$F3,$F0,$F0,$F2,$F0,$71,$32,$32,$33,$22,$33,$33,$33
	dta $33,$33,$21,$21,$21,$21,$31,$31,$21,$21,$21,$21,$31,$3C,$3F,$40
	dta $40,$48,$4C,$44,$42,$42,$43,$41,$41,$41,$41,$41,$06,$4D,$5A,$EF
	dta $CF,$DF,$CF,$C0,$C0,$C0,$E0,$E0,$C0,$F0,$E0,$E0,$E0,$F0,$E0,$E0
	dta $E0,$E0,$EC,$EC,$DC,$FC,$34,$34,$3C,$3C,$3C,$3C,$FC,$70,$B0,$B0
	dta $A0,$B0,$B0,$B0,$B0,$A0,$A0,$A0,$A0,$80,$80,$80,$80,$A0,$A0,$A0
	dta $80,$C0,$80,$80,$C0,$80,$80,$80,$80,$80,$80,$83,$81,$83,$83,$81
	dta $83,$81,$81,$83,$83,$83,$83,$83,$83,$81,$80,$80,$C0,$80,$80,$C0
	dta $C0,$C0,$80,$80,$80,$80,$80,$40,$40,$C0,$C0,$C0,$00,$00,$00,$00
	dta $00,$00,$33,$33,$33,$30,$30,$30,$20,$20,$30,$30,$3C,$3C,$3C,$0C
	dta $0C,$0C,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$FE,$9D
	dta $67,$7F,$3F,$DF,$DF,$BF,$BF,$DF,$FF,$EF,$DF,$D4,$86,$AF,$AF,$AF
	dta $BF,$2F,$3F,$2F,$E5,$B7,$A1,$E5,$A1,$E3,$A3,$C1,$D0,$B0,$70,$73
	dta $F3,$F7,$D7,$C7,$43,$49,$49,$59,$00,$00,$78,$78,$78,$F8,$F8,$F8
	dta $F8,$F8,$80,$80,$F8,$F4,$F0,$FC,$F4,$70,$00,$10,$00,$00,$00,$00
	dta $00,$00,$00,$01,$00,$02,$0A,$27,$41,$81,$00,$00,$00,$00,$00,$38
	dta $6C,$44,$C2,$00,$00,$00,$00,$00,$00,$00,$00,$44,$40,$48,$20,$20
	dta $90,$A0,$A0,$A0,$C0,$40,$40,$40,$20,$20,$00,$02,$02,$03,$07,$0F
	dta $1B,$35,$FF,$FF,$FF,$FF,$FE,$FE,$FE,$FE,$FC,$FC,$FC,$FC,$FE,$FE
	dta $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$7C,$78,$F8,$80,$80,$C0,$C0,$C8
	dta $E6,$E2,$F0,$F0,$FC,$F8,$FC,$F0,$60,$40,$40,$00,$00,$00,$00,$00
	dta $00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dta $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$FF,$FB,$BD,$FF,$5B,$BD,$FF,$5B,$BD,$FF,$5B,$BD,$FF,$5B
	dta $BD,$FF,$5B,$BD,$FF,$5B,$BD,$FF,$5B,$BD,$BF,$5B,$BD,$FF,$5B,$BD
	dta $FF,$5B,$BD,$FF,$5B,$BD,$FF,$5B,$BD,$FF,$5B,$BD,$FF,$5B,$FD,$FF
	dta $00,$3F,$7F,$3F,$7F,$3F,$FF,$BF,$3F,$7F,$3F,$7F,$3F,$7F,$3F,$07
	dta $0D,$08,$D0,$30,$10,$08,$04,$04,$02,$82,$81,$41,$41,$21,$26,$F8
	dta $A6,$DE,$FE,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01
	dta $0F,$3F,$1F,$0F,$0F,$0F,$0E,$0E,$0C,$0C,$08,$18,$08,$20,$A8,$28
	dta $09,$09,$09,$01,$00,$01,$0F,$FF,$7F,$7F,$3F,$3F,$3F,$DF,$6F,$37
	dta $3B,$1C,$0F,$0F,$07,$03,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$80,$80,$C0,$C0,$E0,$E0,$F0,$F0,$F8,$F8,$F8,$FC,$FC,$FC,$FC
	dta $FE,$FE,$FE,$FE,$FE,$FE,$FE,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dta $FF,$FF,$FF,$FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$F0,$E0,$80,$80,$90,$C0,$00,$FF,$80,$03,$02,$1D
	dta $22,$20,$80,$C2,$20,$6A,$1E,$84,$34,$82,$18,$11,$01,$31,$C3,$57
	dta $92,$07,$8C,$0E,$10,$AA,$7F,$FF,$FF,$FF,$FF,$FF,$FF,$FC,$F8,$00
	dta $00,$00,$00,$00,$00,$80,$58,$84,$50,$00,$48,$C0,$B0,$D0,$60,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$28,$22,$00
	dta $C0,$C8,$34,$3A,$B4,$FB,$FD,$FE,$FF,$FF,$7B,$7B,$BB,$DB,$DB,$EB
	dta $A3,$B3,$B3,$3A,$FE,$DE,$BF,$7F,$7F,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dta $01,$07,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE,$FE,$FD
	dta $FB,$F7,$0F,$F6,$8A,$B8,$F8,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$80,$C0,$E0
	dta $F2,$F8,$F8,$FC,$FC,$FC,$FE,$FE,$FE,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dta $FF,$FF,$FF,$FF,$FE,$FE,$FE,$FE,$FE,$FC,$FD,$FD,$FA,$F9,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1F,$5F,$DF
	dta $DF,$CF,$DF,$C7,$C3,$C7,$CF,$DF,$C7,$00,$00,$00,$00,$A0,$A0,$A0
	dta $80,$AC,$8C,$AC,$AC,$BC,$BC,$BC,$BC,$BC,$FE,$9E,$19,$39,$7F,$7B
	dta $7B,$F3,$B3,$B3,$83,$03,$03,$03,$01,$01,$81,$70,$70,$F8,$F8,$78
	dta $F8,$7C,$0F,$05,$8F,$22,$48,$01,$45,$0C,$45,$06,$05,$0A,$00,$FC
	dta $FC,$FC,$FC,$FC,$7C,$7C,$7C,$FC,$FC,$FC,$FC,$FC,$CA,$8A,$08,$08
	dta $08,$08,$F9,$79,$F9,$FD,$FD,$FF,$FF,$FB,$FE,$FF,$FE,$FF,$FE,$FF
	dta $FE,$FF,$FF,$F8,$F7,$00,$7F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dta $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	dta $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$7F,$FF,$FF
	dta $FF,$7F,$7E,$3C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	dta $00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
.ENDM

USESPRITES

.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	jmp NMI.quit

	.def ?old_dli = *
.ENDM

.MACRO	ANTIC_PROGRAM
	dta $44,a(:1),$84,$04,$84,$04,$04,$84,$04,$04,$84,$04,$84,$04,$04
	dta $04,$84,$84,$04,$84,$04,$04,$84,$84,$04,$84,$84,$84,$84,$04,$04
	dta $41,a(:2)
.ENDM

.MACRO	SCREEN_DATA
	ins 'init\tlo\loading_jack.scr'
.ENDM

.MACRO	FONTS
	ins 'init\tlo\loading_jack.fnt'
.ENDM
