; inicjalizacja danych, przepisanie pod odpowiednie adresy

charsBAK	= 96	; liczba znakw przeznaczonych na to pola gry <0..charsBAK-1>
			; <charsBAK..127> znaki przeznaczone na duchy

init_scr .proc
        mva portb port+1

	ldx #0
	stx B2ClrIdx			; koniecznie zerujemy !!! B2ClrIdx !!!
	stx B3ClrIdx			; koniecznie zerujemy !!! B3ClrIdx !!!

        ldx Number_Board
        ldy tab_scr_bank-1,x
        mva @TAB_MEM_BANKS,y portb	; ustaw bank, w ktrej jest plansza

        txa
        asl @
        tax

        mwa tab_scr_addr-2,x inputPointer
        mwa #B3fnt0        outputPointer
        jsr inflate
        cop_mem #B2scr+32*30, #free_mem,#5*30   ; zachowaj kolory na pniej
        cop_mem #B3fnt0,#B2fnt0,#1024*4
        cop_mem #B2scr, #B1scr #@sw*@sh
        cop_mem #B2scr, #B3scr, #@sw*@sh

port    mva #$ff portb
	rts
.endp

; ------------------------------------------------
init    jsr init_scr

init_col .proc
hlp	= zp[0].src

@bak	= free_mem ;+4*1024+32*30
@col0	= @bak+30
@col1	= @col0+30
@col2	= @col1+30
@col3	= @col2+30

	mva	@bak	oldCol		; inicjalizujemy kolory pola gry
	sta	bak+1

	mva	@col0	oldCol+1
	sta	dli0[0].ldx+1

	mva	@col1	oldCol+2
	sta	dli0[0].ldy+1

	mva	@col2	oldCol+3
	sta	dli0[0].lda2+1

	mva	@col3	oldCol+4
	sta	dli0[0].ldx2+1

	mwa #color0 dli0[0].stx+1
	mwa #color1 dli0[0].sty+1
	mwa #color2 dli0[0].sta2+1
	mwa #color3 dli0[0].stx2+1

	ldx #1

loop	mva	ldli,x	hlp
	mva	hdli,x	hlp+1

	lda <$d01e		; domyslna warto rejestrw $d01e

	ldy #@DLI.stx+1
	sta (hlp),y
	ldy #@DLI.sty+1
	sta (hlp),y
	ldy #@DLI.sta2+1
	sta (hlp),y
	ldy #@DLI.stx2+1
	sta (hlp),y

;	lda >$d01e		; starszy bajt adresu zawsze = $D0, nie musimy si powtarza

;	ldy #@DLI.stx+2
;	sta (hlp),y
;	ldy #@DLI.sty+2
;	sta (hlp),y
;	ldy #@DLI.sta2+2
;	sta (hlp),y
;	ldy #@DLI.stx2+2
;	sta (hlp),y
; ---
	lda @col0,x
	cmp oldCol+1
	beq nxt1

	sta oldCol+1
	ldy <color0
	jsr addChangeDLI

nxt1	lda @col1,x
	cmp oldCol+2
	beq nxt2

	sta oldCol+2
	ldy <color1
	jsr addChangeDLI

nxt2	lda @col2,x
	cmp oldCol+3
	beq nxt3

	sta oldCol+3
	ldy <color2
	jsr addChangeDLI

nxt3	lda @col3,x
	cmp oldCol+4
	beq nxt

	sta oldCol+4
	ldy <color3
	jsr addChangeDLI

nxt	inx
	cpx #@sh
	bne loop

        rts

; ------------------------------------------------
.macro	UPDATE
	ldy #:1+1
	mva val (hlp),y
	ldy #:2+1
	mva cReg (hlp),y

	rts
.endm


.local	addChangeDLI		; tutaj rejestr X nie moe ulec zmianie

	.var val cReg .byte

	sta val
	sty cReg

	ldy #@DLI.stx+1
	lda (hlp),y
	cmp <$d01e
	bne nxt1

	UPDATE @DLI.ldx @DLI.stx

nxt1	ldy #@DLI.sty+1
	lda (hlp),y
	cmp <$d01e
	bne nxt2

	UPDATE @DLI.ldy @DLI.sty

nxt2	ldy #@DLI.sta2+1
	lda (hlp),y
	cmp <$d01e
	bne nxt3

	UPDATE @DLI.lda2 @DLI.sta2

nxt3	ldy #@DLI.stx2+1
	lda (hlp),y
	cmp <$d01e
	bne nxt

	UPDATE @DLI.ldx2 @DLI.stx2

nxt	lda $d20a		; ta sytuacja nie powinna si zdarzy
	sta $d01a
	jmp nxt

	.endl

* ------------------------------------------------


oldCol	:5 brk

_len	dta a(B1scr)

ldli	.rept @sh, #
	dta l(dli:1)
	.endr

hdli	.rept @sh, #
	dta h(dli:1)
	.endr

.endp

