;--------------------------------------------------------------------------------------------------------------------------------------------------------
; CONSTATNS
;--------------------------------------------------------------------------------------------------------------------------------------------------------
JVB                  = 65   ; stae do tworzenia Display Listy
Mode4                = 4
Mode2                = 2
ModeE                = 14
ModeF                = 15
DLI                  = 128
LMS                  = 64
Blank8               = $70
Blank6               = $50
Blank4               = $30
Blank2               = $10

bomb_sprite     = 7                 ; number of sprite what we will use for 'blink bomb'
letter_sprite   = 6                 ; number of sprite what we will use for 'letter B,E,P'
scr32	        = %00111101	    ; $3d
fnt_1           = $D800             ; address of first charset for TITLE & HI-SCORE SCREEN
pmg_1           = $E000
fnt_2           = $E800             ; address of first charset for TITLE & HI-SCORE SCREEN
pmg_2           = $F000
scr_1           = $F800             ; address of Text Screen for TITLE & HI-SCORE SCREEN
scr_2           = $FC00             ; address of Text Screen for TITLE & HI-SCORE SCREEN
TRUE            = 1
FALSE           = 0
MIN_POSX_SPRITE = 0
MAX_POSX_SPRITE = 255-13            ; max. value 255+12!
MIN_POSY_SPRITE = 4*8-4
MAX_POSY_SPRITE = 25*8+9
WIDTH_SPRITE    = 12
SPEED_SPRITE    = 2                 ; less value -> slower
x_pmg           = 4*16              ; trzeba doda, aby zmienn sprite'a na ekranie X zamieni na zmienn X PMG
y_pmg           = 4*5+5
SIZE_PMG        = 49                ; ilo bajtw przypadajcych na 1 klatk animacji PMG
CORR_Y          = 3*8-1
MAX_LINES_SCR   = 240               ; maksymalna liczba linii na ekranie (30 wierszy)

num_shd         = $04               ; delay during shadow rotation
num_col         = $06               ; delay during color rotation
pmg_prior       = $01               ; the PMG priority

col_jack   = $0c               ; 3-rd color (PMG)
col_drill  = $46
col_dotbal = $84
col_squbal = $46
col_feebal = $36
col_UFO    = $96
col_bird   = $F8
col_astro  = $08
col_newopp = $26
col_smifac = $FA                    ; UWAGA! bit3 musi byc rwny 1 bo inaczej bdnie mog miga na pomaraczowo buki jeeli ich czas si koczy...
col_P      = $3A
col_E      = $1A
col_B      = $C8
col_points = $38

trig0           = $d010  ; GTIA
prior           = $d01b
kbcode          = $d209  ; POKEY
random          = $d20a
skctl           = $d20f
porta           = $d300  ; PIA
portb           = $d301
dmactl          = $d400  ; ANTIC
dlistl          = $d402  ; (2)
dlisth          = $d403
vscrol          = $d405
pmbase          = $d407
chbase	        = $d409
wsync           = $d40a
vcount	        = $d40b
nmien           = $d40e
iocb0           = $340
ciov            = $e465

ScreenBuff40x25   = B1SCR ; prawdziwy ekran to 32x30
Font_Bonus        = $0800 ; wykorzystujemy obszar 2-gi PMG na font dla "BONUS SCREEN"

def_ledgeV        = 86                 ; pierwszy znak definicji kadki w poziomie
def_ledgeH        = def_ledgeV+1       ; pierwszy znak definicji kadki w pionie
def_bomb_ver1     = def_ledgeV+2       ; pierwszy znak definicji bomby w wersji 1 (w sumie 4-ry znaki)
def_bomb_ver2     = def_bomb_ver1+4    ; pierwszy znak definicji bomby w wersji 2 (w sumie 4-ry znaki)
; def_bomb_ver3   = def_bomb_ver2+4  ; pierwszy znak definicji bomby w wersji 3 (w sumie 4-ry znaki)
def_chars         = 8                  ; definicja 8 znakw, ktre mona zmieni jeeli koniec levelu ju (B2fnt0, B2fnt1, B2fnt2...)

BombJack_Stand          = $A7  ;- C64
BombJack_HandsUp_CapeDn = $A8  ;- C64
BombJack_HandsUp_CapeUp = $A9  ;- C64
BombJack_Right_Dn       = $AA  ;- C64
BombJack_Left_Dn        = $AB  ;- C64
BombJack_Right_Stand    = $AC  ;- C64
BombJack_Left_Stand     = $AD  ;- C64
BombJack_Dead           = $AE  ;- C64
BombJack_Dance          = $AF  ;- C64
BombJack_Right          = $B2  ;- C64
BombJack_Left           = $B6  ;- C64
Bomb_Blink              = $C0  ;- C64

Drill_Left              = 0  ; 4 clips
Drill_Right             = 4  ; 4 clips
Dot_Ball                = 8  ; 3 clips
Square_Ball             = 11 ; 6 clips
Feeler_Ball             = 17 ; 4 clips
UFO                     = 21 ; 3 clips
Bird_Right              = 24 ; 3 clips
Bird_Left               = 27 ; 3 clips
Bird_Down               = 30 ; 3 clips
Astronaut_Right         = 33 ; 4 clips
Astronaut_Left          = 37 ; 4 clips
Astronaut_Up_Down       = 41 ; 1 clip
New_Opponent_Apear      = 42 ; 3 clips
Jack_Stand              = 45 ; 1 clip
Jack_HandsUp_CapeDn     = 46 ; 1 clip
Jack_HandsUp_CapeUp     = 47 ; 1 clip
Jack_Right_Dn           = 48 ; 1 clip
Jack_Left_Dn            = 49 ; 1 clip
Jack_Right_Stand        = 50 ; 1 clip
Jack_Left_Stand         = 51 ; 1 clip
Jack_Dead               = 52 ; 1 clip
Jack_Dance              = 53 ; 3 clips
Jack_Left               = 56 ; 4 clips
Jack_Right              = 60 ; 4 clips
Jack_Dead_Bird          = 64 ; 3 clips
Letter_P                = 67 ; 3 clips
Letter_B                = 70 ; 3 clips
Letter_E                = 73 ; 2 clips
Smilling_Face           = 75 ; 5 clips
Points_200x1            = 80 ; 1 clip
Points_200x2            = 81 ; 1 clip
Points_200x3            = 82 ; 1 clip
Points_2000             = 83 ; 1 clip
Points_100              = 84 ; 1 clip
Points_200              = 85 ; 1 clip
Points_300              = 86 ; 1 clip
Points_400              = 87 ; 1 clip
Points_500              = 88 ; 1 clip
Points_600              = 89 ; 1 clip
StartU                  = 90 ; 4 clips
StartD                  = 94 ; 4 clips
GameOver                = 98 ; 5 clips
BlinkBomb               = 103 ; 1 clip

C64_None                = $00
C64_Astronaut           = $01
C64_Drill               = $02
C64_Feeler_Ball         = $03
C64_Square_Ball         = $04
C64_Dot_Ball            = $05
C64_UFO                 = $06
C64_Smiling_Face        = $07
C64_Letter_P            = $08
C64_Letter_E            = $09
C64_Letter_B            = $0A
C64_Bird                = $0B
C64_New_Opponent        = $0C
C64_Free                = $0E ; wskazuje, e jest to miejsce nie wykorzystywane
C64_Points              = $0F
C64_Blink_Bomb          = $10
;C64_Clear_PMG           = $11

C64_GameOver            = $D0

sfx_get_opponent        = $30 ; zebranie potworka zamienionego w monet
;sfx_move_jack           = $31 ; zrobienie kroku (kiedy chodzi)
sfx_get_letter_B        = $32 ; zebranie literki (B), bo przy P bedzie od razu zmiana muzy
sfx_get_bomb            = $33 ; wzicie bomby
sfx_jump_jack           = $34 ; wykonanie skoku (moe jeszcze bd poprawia)
sfx_dead_jack           = $35 ; mier
sfx_get_letter_E        = $3b ; zebranie litery E

mus_title               = $00 ; tytu
mus_board1              = $0f ; ingame #1
mus_board2              = $25 ; ingame #2
mus_board3              = $42 ; ingame #3
mus_board4              = $4a ; ingame #4
mus_board5              = $5b ; ingame #5
mus_game_over           = $73 ; game over
mus_hall_fame           = $7e ; wpis na hall of fame
mus_level_complited     = $76 ; level completed
mus_bonus               = $7a ; po zebraniu "P" i trwa pki potworki s monetami (prawie do koca)
mus_bonus2              = $7c ; na 1,5-2 sekundy przed zamian potworkw z powrotem w monety, potem powrt do muzy z levela.
mus_perfect             = $8f ; muza grana po zebraniu 20-24 migajcych bomb
mus_no                  = $94 ; muza wyciszona!

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; zero page (ju tylko jeden bajt jest wolny na stronie zerowej!!!!!!!)
ZeroPage     = inflate_zp      ; reserve -18! bytes for player RMT
inflate_zp   = byte-10         ; reserve 10 bytes for depacker
byte         = $F3             ; bajt oglnego wykorzystania
counter      = $F4             ; licznik oglnego wykorzystania
counter2     = $F5
rA	     = $F6             ; wykorzystywane tylko przez przerwanie DLI i VBL
rX	     = $F7             ; j.w.
rY	     = $F8             ; j.w.
address1     = $F9
fadr         = $FB
address2     = $FB
fcnt         = $FD             ; wykorzystywane przez procedury FADE IN & FADE OUT
address3     = $FD
cloc	     = $FF             ; zegar zwikszany o +1 co 1/50s

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; FRAMES #0-#14 from SHAPE 0 (BJ0.OBX)
* ---	klatki dla krccej si "bomby"
SquaBall dta 1,0*8		; maksymalna warto licznika klatek animacji dla ksztatu SHAPE #0
         dta 1,1*8              ; kolejne numery klatek animacji *8
         dta 1,2*8
         dta 1,3*8
         dta 1,4*8
         dta 1,5*8

* ---	klatki dla ptaka skierowanego w prawo
BirdRight dta 1,6*8
          dta 1,7*8
          dta 1,8*8

* ---	klatki dla ptaka skierowanego w lewo
BirdLeft dta 1,9*8
         dta 1,10*8
         dta 1,11*8

* ---	klatki dla ptaka poruszajcego si w pionie
BirdDown dta 1,12*8
         dta 1,13*8
         dta 1,14*8

; FRAMES #0-#14 from SHAPE 1 (BJ1.OBX)
* ---	klatki dla stojcego w miejscu "bomb jack'a"
JackS	dta 1		; maksymalna warto licznika klatek animacji dla ksztatu SHAPE #1
	dta 0*8	        ; kolejne numery klatek animacji *8

* ---	klatki dla unoszcego si w gr "bomb jack'a"
JackU	dta 1,1*8

* ---	klatki dla spadajcego w d "bomb jack'a"
JackD	dta 1,2*8

* ---	klatki dla spadajcego w prawo-d "bomb jack'a"
JackRD  dta 1,3*8

* ---	klatki dla spadajcego w lewo-d "bomb jack'a"
JackLD  dta 1,4*8

* ---	klatki dla obrconego w prawo "bomb jack'a"
JackR   dta 1,5*8

* ---	klatki dla obrconego w lewo "bomb jack'a"
JackL   dta 1,6*8

* ---	klatki dla idcego w prawo "bomb jack'a"
JackMR  dta 1,7*8
        dta 1,8*8
        dta 1,9*8
        dta 1,10*8

* ---	klatki dla idcego w lewo "bomb jack'a"
JackML  dta 1,11*8
        dta 1,12*8
        dta 1,13*8
        dta 1,14*8

; FRAMES #0-#14 from SHAPE 2 (BJ2.OBX)
* ---	klatki dla gincego "bomb jack'a"
JackDe	dta 1		        ; maksymalna warto licznika klatek animacji dla ksztatu SHAPE #2
	dta 0*8                 ; kolejne numery klatek animacji *8

* ---	klatki dla taczcego "bomb jack'a"
JackDa  dta 1,1*8
        dta 1,2*8
        dta 1,3*8

* ---	klatki dla ptaszka pojawiajcego si nad gow martwego "bomb jack'a"
BirdDe  dta 1,4*8
        dta 1,5*8
        dta 1,6*8

* ---	klatki dla pocztkowego napisu "START" (grne linie)
StartU1 dta 1,7*8
        dta 1,8*8
        dta 1,9*8
        dta 1,10*8

* ---	klatki dla pocztkowego napisu "START" (dolne linie)
StartD1 dta 1,11*8
        dta 1,12*8
        dta 1,13*8
        dta 1,14*8
;---

; FRAMES #0-#14 from SHAPE 3 (BJ3.OBX)
* ---	klatki dla ruchu w prawo przeciwnika "astronauty"
OppAstR	dta 1,0*8
        dta 1,1*8
        dta 1,2*8
        dta 1,3*8

* ---	klatki dla ruchu w lewo przeciwnika "astronauty"
OppAstL dta 1,4*8
        dta 1,5*8
        dta 1,6*8
        dta 1,7*8

* ---	klatki dla spadajcego w d przeciwnika "astronauty"
OppAstD dta 1,8*8

GameOvr1 dta 1,9*8
         dta 1,10*8

* ---	klatki dla ruchu przeciwnika "z czukami"
OppFeel dta 1,11*8
        dta 1,12*8
        dta 1,13*8
        dta 1,14*8

; FRAMES #0-#14 from SHAPE 4 (BJ4.OBX)
* ---	klatki dla ruchu przeciwnika "kuli z kropkami"
OppBalD dta 1,0*8
        dta 1,1*8
        dta 1,2*8

* ---	klatki dla ruchu przeciwnika "UFO"
OppUFO  dta 1,3*8
        dta 1,4*8
        dta 1,5*8

* ---	klatki dla ruchu w lewo przeciwnika "widerka"
OppDriL dta 1,6*8
        dta 1,7*8
        dta 1,8*8
        dta 1,9*8

* ---	klatki dla ruchu w prawo przeciwnika "widerka"
OppDriR dta 1,10*8
        dta 1,11*8
        dta 1,12*8
        dta 1,13*8

* ---	klatka z wyborem np: litery wewntrz
Select  dta 1,14*8

; FRAMES #0-#14 from SHAPE 5 (BJ5.OBX)
* ---	klatki dla ruchu "litery B"
LetterB	dta 1,0*8
        dta 1,1*8
        dta 1,2*8

* ---	klatki dla ruchu "litery E"
LetterE	dta 1,3*8
        dta 1,4*8
        dta 1,2*8

* ---	klatki dla ruchu "litery P"
LetterP	dta 1,5*8
        dta 1,6*8
        dta 1,7*8

* ---	klatki dla pojawiajcego si nowego przeciwnika
OppApea	dta 1,8*8
        dta 1,9*8
        dta 1,10*8

* ---	klatka dla 'game over'
GameOvr2 dta 1,11*8
         dta 1,12*8
         dta 1,13*8

* ---	klatka dla 'migajcej bomby'
BlinkBom dta 1,14*8

; FRAMES #0-#14 from SHAPE 6 (BJ6.OBX)
* ---	klatki dla animacji "umiechnitych buziek"
SmiFace	dta 1,0*8
        dta 1,1*8
        dta 1,2*8
        dta 1,3*8
        dta 1,4*8

* ---	klatka z punktami "200x1"
P200x1	dta 1,5*8

* ---	klatka z punktami "200x2"
P200x2	dta 1,6*8

* ---	klatka z punktami "200x3"
P200x3	dta 1,7*8

* ---	klatka z punktami "2000"
P2000	dta 1,8*8

* ---	klatka z punktami "100"
P100	dta 1,9*8

* ---	klatka z punktami "200"
P200	dta 1,10*8

* ---	klatka z punktami "300"
P300	dta 1,11*8

* ---	klatka z punktami "400"
P400	dta 1,12*8

* ---	klatka z punktami "500"
P500	dta 1,13*8

* ---	klatka z punktami "600"
P600	dta 1,14*8

sts_screen                        dta $00                            ; this value is copied to DMACTL ($d400) every VBL interrupt
Key                               dta $00                            ; kod wcinitego klawisza
CH1                               dta $00                            ; pomoc przy przechowywaniu kodu wcinitego klawisza
sfx_effect                        dta $00                            ; which SFX(instrument) we can play on VBL
pos_tab_addr_live                 dta $00 ; wskazuje na pozycje w tablicy, gdzie jest adres, pod ktrym mona narysowa ycie BOMB JACK-a
Can_Show_LetterEB_on_Board        dta $00 ; 0 - nie mona wywietli "LITERY E lub B", $01-$FF - mona wywietli
Score_Player                      dta $00,$00,$00                     ; punkty gracza (BOMB JACK-a)
Number_Round_BCD                  dta $00                             ; numer rundy w kodzie BCD
Number_Round_BIN                  dta $00                             ; numer rundy w kodzie BINARNYM (normalnym)
Number_Board                      dta $00                             ; numer planszy od #1 do #5!
is_color_title                    dta $00  ; czy by zapis kolorw dla ekranu "TITLE"? =1 TAK!
is_color_score                    dta $00  ; czy by zapis kolorw dla ekranu "SCORE"? =1 TAK!
cnt_shd                           dta $00  ; counter for rotating shadows                                            UWAGA! musi by w tej pamici!
cnt_col                           dta $00  ; counter for rotating colors                                             UWAGA! musi by w tej pamici!
cnt_rot                           dta $00  ; index to rotating color table                                           UWAGA! musi by w tej pamici!
number_song                       dta $00  ; choose a starting song line 0-255 (for init the RMT player)             UWAGA! musi by w tej pamici!
store_number_song                 dta $00  ; zapamituje aktualnie gran muzyk (np: jeeli wcisnelimy klawisz M)
is_play_music                     dta $00 ; Is play Music on VBL? =0 NO!, =1 YES!                                    UWAGA! musi by w tej pamici!
is_rotating_colors                dta $00 ; =1 rotating colors is allowed                                            UWAGA! musi by w tej pamici!
pos_tab8_score                    dta $00 ; wskanik na pozycj wypisywanych punktw+nicka na ekran                  UWAGA! musi by w tej pamici!
count1                            dta $00 ; wykorzystywane przez przerwanie DLI (tylko dla TITLE & HI-SCORE SCREEN)  UWAGA! musi by w tej pamici!
count2                            dta $00 ; j.w.                                                                     UWAGA! musi by w tej pamici!

; zmienne i tablice
tab_SHP_C64_to_ATARI   dta 4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE),  0*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),4*(.len @SHAPE),  0*(.len @SHAPE),  0*(.len @SHAPE),  0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE), 0*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),3*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),1*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),5*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),6*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),2*(.len @SHAPE),  3*(.len @SHAPE), 3*(.len @SHAPE),  5*(.len @SHAPE), 5*(.len @SHAPE), 5*(.len @SHAPE), 5*(.len @SHAPE)
tab_FRM_C64_to_ATARI_L dta    <[OppDriL+0],   <[OppDriL+2],   <[OppDriL+4],   <[OppDriL+6],   <[OppDriR+0],   <[OppDriR+2],   <[OppDriR+4],   <[OppDriR+6],   <[OppBalD+0],   <[OppBalD+2],   <[OppBalD+4],   <[SquaBall+0],   <[SquaBall+2],   <[SquaBall+4],   <[SquaBall+6],   <[SquaBall+8],   <[SquaBall+10],   <[OppFeel+0],   <[OppFeel+2],   <[OppFeel+4],   <[OppFeel+6],    <[OppUFO+0],    <[OppUFO+2],    <[OppUFO+4],   <[BirdRight+0],   <[BirdRight+2],   <[BirdRight+4],   <[BirdLeft+0],   <[BirdLeft+2],   <[BirdLeft+4],   <[BirdDown+0],   <[BirdDown+2],   <[BirdDown+4],   <[OppAstR+0],   <[OppAstR+2],   <[OppAstR+4],   <[OppAstR+6],   <[OppAstL+0],   <[OppAstL+2],   <[OppAstL+4],   <[OppAstL+6],   <[OppAstD+0],   <[OppApea+0],   <[OppApea+2],   <[OppApea+4],         <JackS,         <JackU,         <JackD,        <JackRD,        <JackLD,         <JackR,         <JackL,        <JackDe,    <[JackDa+0],    <[JackDa+2],    <[JackDa+4],    <[JackML+0],    <[JackML+2],    <[JackML+4],    <[JackML+6],    <[JackMR+0],    <[JackMR+2],    <[JackMR+4],    <[JackMR+6],    <[BirdDe+0],    <[BirdDe+2],    <[BirdDe+4],   <[LetterP+0],   <[LetterP+2],   <[LetterP+4],   <[LetterB+0],   <[LetterB+2],   <[LetterB+4],   <[LetterE+0],   <[LetterE+2],   <[SmiFace+0],   <[SmiFace+2],   <[SmiFace+4],   <[SmiFace+6],   <[SmiFace+8],      <[P200x1],      <[P200x2],      <[P200x3],       <[P2000],        <[P100],        <[P200],        <[P300],        <[P400],        <[P500],        <[P600],   <[StartU1+0],   <[StartU1+2],   <[StartU1+4],   <[StartU1+6],   <[StartD1+0],   <[StartD1+2],   <[StartD1+4],   <[StartD1+6],    <[GameOvr1+0],   <[GameOvr1+2],    <[GameOvr2+0],   <[GameOvr2+2],   <[GameOvr2+4],   <[BlinkBom+0]
tab_FRM_C64_to_ATARI_H dta    >[OppDriL+0],   >[OppDriL+2],   >[OppDriL+4],   >[OppDriL+6],   >[OppDriR+0],   >[OppDriR+2],   >[OppDriR+4],   >[OppDriR+6],   >[OppBalD+0],   >[OppBalD+2],   >[OppBalD+4],   >[SquaBall+0],   >[SquaBall+2],   >[SquaBall+4],   >[SquaBall+6],   >[SquaBall+8],   >[SquaBall+10],   >[OppFeel+0],   >[OppFeel+2],   >[OppFeel+4],   >[OppFeel+6],    >[OppUFO+0],    >[OppUFO+2],    >[OppUFO+4],   >[BirdRight+0],   >[BirdRight+2],   >[BirdRight+4],   >[BirdLeft+0],   >[BirdLeft+2],   >[BirdLeft+4],   >[BirdDown+0],   >[BirdDown+2],   >[BirdDown+4],   >[OppAstR+0],   >[OppAstR+2],   >[OppAstR+4],   >[OppAstR+6],   >[OppAstL+0],   >[OppAstL+2],   >[OppAstL+4],   >[OppAstL+6],   >[OppAstD+0],   >[OppApea+0],   >[OppApea+2],   >[OppApea+4],         >JackS,         >JackU,         >JackD,        >JackRD,        >JackLD,         >JackR,         >JackL,        >JackDe,    >[JackDa+0],    >[JackDa+2],    >[JackDa+4],    >[JackML+0],    >[JackML+2],    >[JackML+4],    >[JackML+6],    >[JackMR+0],    >[JackMR+2],    >[JackMR+4],    >[JackMR+6],    >[BirdDe+0],    >[BirdDe+2],    >[BirdDe+4],   >[LetterP+0],   >[LetterP+2],   >[LetterP+4],   >[LetterB+0],   >[LetterB+2],   >[LetterB+4],   >[LetterE+0],   >[LetterE+2],   >[SmiFace+0],   >[SmiFace+2],   >[SmiFace+4],   >[SmiFace+6],   >[SmiFace+8],      >[P200x1],      >[P200x2],      >[P200x3],       >[P2000],        >[P100],        >[P200],        >[P300],        >[P400],        >[P500],        >[P600],   >[StartU1+0],   >[StartU1+2],   >[StartU1+4],   >[StartU1+6],   >[StartD1+0],   >[StartD1+2],   >[StartD1+4],   >[StartD1+6],    >[GameOvr1+0],   >[GameOvr1+2],    >[GameOvr2+0],   >[GameOvr2+2],   >[GameOvr2+4],   >[BlinkBom+0]
tab_PMG_C64_to_ATARI_L dta <pmg1_drill_l01,<pmg1_drill_l02,<pmg1_drill_l03,<pmg1_drill_l04,<pmg1_drill_r01,<pmg1_drill_r02,<pmg1_drill_r03,<pmg1_drill_r04,  <pmg1_dot_b01,  <pmg1_dot_b02,  <pmg1_dot_b03, <pmg1_squar_b01, <pmg1_squar_b02, <pmg1_squar_b03, <pmg1_squar_b04, <pmg1_squar_b05,  <pmg1_squar_b06,<pmg1_feele_b01,<pmg1_feele_b02,<pmg1_feele_b03,<pmg1_feele_b04,    <pmg1_UFO01,    <pmg1_UFO02,    <pmg1_UFO03,   <pmg1_bird_r01,   <pmg1_bird_r02,   <pmg1_bird_r03,  <pmg1_bird_l01,  <pmg1_bird_l02,  <pmg1_bird_l03,  <pmg1_bird_d01,  <pmg1_bird_d02,  <pmg1_bird_d03,<pmg1_astro_r01,<pmg1_astro_r02,<pmg1_astro_r03,<pmg1_astro_r04,<pmg1_astro_l01,<pmg1_astro_l02,<pmg1_astro_l03,<pmg1_astro_l04,<pmg1_astro_d01,<pmg1_opp_ape01,<pmg1_opp_ape02,<pmg1_opp_ape03,  <pmg0_jack_st,  <pmg0_jack_up,  <pmg0_jack_dn,  <pmg0_jack_rd,  <pmg0_jack_ld,  <pmg0_jack_ri,  <pmg0_jack_le,  <pmg0_jack_de,<pmg0_jack_da01,<pmg0_jack_da02,<pmg0_jack_da03,<pmg0_jack_ml01,<pmg0_jack_ml02,<pmg0_jack_ml03,<pmg0_jack_ml04,<pmg0_jack_mr01,<pmg0_jack_mr02,<pmg0_jack_mr03,<pmg0_jack_mr04,<pmg0_bird_de01,<pmg0_bird_de02,<pmg0_bird_de03,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,<pmg1_smil_fa01,<pmg1_smil_fa02,<pmg1_smil_fa03,<pmg1_smil_fa04,<pmg1_smil_fa05,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,         <$ffff,           <$ffff,          <$ffff,           <$ffff,          <$ffff,          <$ffff,          <$ffff
tab_PMG_C64_to_ATARI_H dta >pmg1_drill_l01,>pmg1_drill_l02,>pmg1_drill_l03,>pmg1_drill_l04,>pmg1_drill_r01,>pmg1_drill_r02,>pmg1_drill_r03,>pmg1_drill_r04,  >pmg1_dot_b01,  >pmg1_dot_b02,  >pmg1_dot_b03, >pmg1_squar_b01, >pmg1_squar_b02, >pmg1_squar_b03, >pmg1_squar_b04, >pmg1_squar_b05,  >pmg1_squar_b06,>pmg1_feele_b01,>pmg1_feele_b02,>pmg1_feele_b03,>pmg1_feele_b04,    >pmg1_UFO01,    >pmg1_UFO02,    >pmg1_UFO03,   >pmg1_bird_r01,   >pmg1_bird_r02,   >pmg1_bird_r03,  >pmg1_bird_l01,  >pmg1_bird_l02,  >pmg1_bird_l03,  >pmg1_bird_d01,  >pmg1_bird_d02,  >pmg1_bird_d03,>pmg1_astro_r01,>pmg1_astro_r02,>pmg1_astro_r03,>pmg1_astro_r04,>pmg1_astro_l01,>pmg1_astro_l02,>pmg1_astro_l03,>pmg1_astro_l04,>pmg1_astro_d01,>pmg1_opp_ape01,>pmg1_opp_ape02,>pmg1_opp_ape03,  >pmg0_jack_st,  >pmg0_jack_up,  >pmg0_jack_dn,  >pmg0_jack_rd,  >pmg0_jack_ld,  >pmg0_jack_ri,  >pmg0_jack_le,  >pmg0_jack_de,>pmg0_jack_da01,>pmg0_jack_da02,>pmg0_jack_da03,>pmg0_jack_ml01,>pmg0_jack_ml02,>pmg0_jack_ml03,>pmg0_jack_ml04,>pmg0_jack_mr01,>pmg0_jack_mr02,>pmg0_jack_mr03,>pmg0_jack_mr04,>pmg0_bird_de01,>pmg0_bird_de02,>pmg0_bird_de03,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,>pmg1_smil_fa01,>pmg1_smil_fa02,>pmg1_smil_fa03,>pmg1_smil_fa04,>pmg1_smil_fa05,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,         >$ffff,           >$ffff,          >$ffff,           >$ffff,          >$ffff,          >$ffff,          >$ffff

tab_col_opponent_PMG   .db col_jack,col_astro,col_drill,col_feebal,col_squbal,col_dotbal,col_UFO,col_smifac,col_P,col_E,col_B,col_bird,col_newopp,$16,col_points ; tablica 3-ciego koloru (PMG) w zalenoci od typu sprite'a
tab_choose_col_PMG     .db $00,$00,$00,$00,$00,$00,$00,$00         ; tablica wyboru koloru dla PMG #0-#3 (sprite'y #0-#7)
tab_choose_sprite      .db $00,$02,$06,$05,$ff,$03,$01,$ff         ; tablica konwersji numeru sprite #0-#7 na numer jaki ma by wykorzystany PMG #0-#3 (dla tego sprite)
tab_old_choose_sprite  .db $00,$00,$00,$00,$00,$00,$00,$00         ; tablica przechowujca stare wartoci tablicy 'tab_choose_sprite'
                       .db $00,$00,$00,$00,$00,$00,$00,$00
clr_second_time_pmg    .db $00                                     ; =1 ustaw znacznik kasowania PMG w nastpnej ramce

; UWAGA! pojaw. si przeciw. x   1   4   3       2   x   x           przeciwnicy pojawiaj si w tej tablicy w kolejnoci 1-4
tab_AND1_missile       .db %11111100,%11110011,%11001111,%00111111 ; maska AND dla pociskw #0-#3
tab_AND2_missile       .db %00000011,%00001100,%00110000,%11000000 ; maska AND dla pociskw #0-#3
tab_multiplex_count    :26 .db $00                                 ; tablica suca do zliczania ilu przeciwnikw jest wywietlanych w wierszach 0-25 (min.0 - max.5)- dziki niej przeciwnik moe sprawdzi czy ma drog woln w d lub w gr (bo max. liczba przeciwnikw w wierszu to 3-ch)
                           .db $00,$00                             ; tutaj musi by dodatkowe bajty bo czasem moe zapisa te t warto
tab_multiplex_sprites  :26 .db $00                                 ; tablica suca odwzorowaniu, w ktrym wierszu jest jaki sprite #1-#3 i #5-#6
                           .db $00,$00
tab_multiplex_pmg      :26 .db $00                                 ; tablica suca zapisaniu, jaki pmg #2-3 wykorzystamy w danym wierszu dla przeciwnika
                           .db $00,$00
is_fast_move_on        .db $00                                     ; 1 - wcz szybki przesw przeciwnikw w pionie
is_init_multiplex_VBL  .db $00                                     ; 1 - aktywacja multiplexer'a PMG podczas przerwania VBL
is_mute_music          .db $00                                     ; 1 - wycz muzyk podczas gry, 0 - wcz

; tablice z adresami procedur kasujcych i rysujcych wzr dla danego PMG #0-#3 (w obszarze pmg0 lub pmg1)
tab_pmg01_clrl         dta    <pmg1_clr_pla0,    <pmg0_clr_pla0,    <pmg1_clr_pla1,    <pmg0_clr_pla1,    <pmg1_clr_pla2,    <pmg0_clr_pla2,    <pmg1_clr_pla3,    <pmg0_clr_pla3,    <pmg1_clr_pla0,    <pmg0_clr_pla0,    <pmg1_clr_pla1,    <pmg0_clr_pla1,    <pmg1_clr_pla2,    <pmg0_clr_pla2,    <pmg1_clr_pla3,    <pmg0_clr_pla3
tab_pmg01_clrh         dta    >pmg1_clr_pla0,    >pmg0_clr_pla0,    >pmg1_clr_pla1,    >pmg0_clr_pla1,    >pmg1_clr_pla2,    >pmg0_clr_pla2,    >pmg1_clr_pla3,    >pmg0_clr_pla3,    >pmg1_clr_pla0,    >pmg0_clr_pla0,    >pmg1_clr_pla1,    >pmg0_clr_pla1,    >pmg1_clr_pla2,    >pmg0_clr_pla2,    >pmg1_clr_pla3,    >pmg0_clr_pla3

tab_choose_M0_H        dta >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1], >[pmg1+$300+y_pmg-1],>[pmg0+$300+y_pmg-1]
tab_choose_PMBASE      dta >[pmg0],>[pmg1]

text_score_scr         dta $20,$0B,$14,$0F,$11,$0E,$20,$20 ; " SCORE  " - ten tekst jest wypisywany na ekranie gry
r1500                  dta $0B,$0C,$0D,$0E,$20,$02,$20,$20 ; "SIDE 2  "???
text_round_scr         dta $11,$0F,$12,$10,$0D,$20         ; "ROUND 00" - tekst wypis. na ekranie gry UWAGA: $00 (+6 pozycja) - numer rundy w kodzie BCD | $00 (+7 pozycja) - numer rundy w normalnym formacie
text_hiscore_scr       dta $13,$0C,$20,$0B,$14,$0F,$11,$0E ; "HI SCORE"
text_line_scr          dta $20,$FE,$FE,$FE,$FE,$FE,$FE,$20 ; " XXXXXX "   - tekst wywietlany w trzech wierszach dla narysowania prostoktu

;choose board - q,w,e,r,t keys
tab_key_board          dta 47,46,42,40,45

; music #1-#5 for every board
tab_mus                dta mus_board1,mus_board2,mus_board3,mus_board4,mus_board5

;tab_choose_music dta $00,$0F,$25,$42,$4A,$5B,$5E,$6C,$6F,$73 ; tablica wyboru muzyki dla wcinitego klawisza 0-9 (dla MIKER-a)
tab_keyb      dta  31, 30, 26, 24, 29, 27
tab_sfx       dta $33,$34,$35,$36,$37,$38

tab_rot_col   dta $80,$30,$F0,$C0,$50 ; for rotating colors on "TITLE SCREEN"
num_rot = * - tab_rot_col

tab_scr_bank  dta [=board1],[=board2],[=board3],[=board4],[=board5] ;,[=board6],[=board7],[=board8],[=board9],[=board10]  ; bank number
tab_scr_addr  .dw    board1,   board2,   board3,   board4,   board5 ;,   board6,   board7,   board8,   board9,   board10  ; address of every board

tab_jump_down_sprite1_7                           dta $00,$00,$00,$00,$00,$00,$00 ; =1 oznacza, e ten sprite, akurat spada na d
Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7  dta $08,$08,$08,$08,$08,$08,$08 ; =0 testowa z dolnej strony, =8 z grnej
Add_BYTE_to_SCORE_PLAYER                          dta $00,$00,$00                 ; punkty zapisywane tutaj na chwile a potem dodawane do wyniku gracza
tab_Every_Second_Frame_Atronaut_Sprite            dta $00,$00,$00,$00,$00,$00,$00 ; 0-rysuj "ASTRONAUTE", 1-nie rysuj "ASTRONAUTE" (dziki temu rysujemy co 2-g ramke)
tab_Show_Type_Sprite1_7_After_Animation_Appearing dta $00,$00,$00,$00,$00,$00,$00 ; jaki typ SPRITE'a ma si pojawi po zakoczeniu animacji "POJAWIANIA SI"
tab_First_PosX_SPRITES_1_7                        dta $00,$19,$32,$4B,$64,$7D,$96 ; tablica zawiera pocztkow wsp.X dla SPRITE'w #1-#7 (wykorzystywana np: zaraz jak rozpoczyna si gra)
tab_Is_Astronaut_Move_Left_or_Right_or_Stand      dta $00,$00,$00,$00,$00,$00,$00 ; Czy "ASTRONAUTA" przesuwa si aktualnie w lewo(=2), prawo(=1) czy stoi(=0) w miejscu?
bits0_1_Right_Down                                dta $03,$02,$03,$02,$03,$02,$03 ; bit0=1 spr. z prawej strony SPRITE'a, bit1=1 spr. z dolnej strony SPRITE'a
tab_Is_Change_PosX_or_PosY_Bird                   dta $00,$00,$00,$00,$00,$00,$00 ; =1 zmieniaj wsp.X "PTASZKA", =0 zmieniaj wsp.Y "PTASZKA"
tab_7x_Add_Speed_Jump_Down_to_PosY                dta $07,$07,$07,$07,$07,$07,$07 ; licznik ile razy trzeba jeszcze doda warto z "tab_Anim_Speed_Jump_Down" do wsp.Y "ASTRONAUTY"
tab_Anim_Speed_Jump_Down                          dta $00,$00,$00,$00,$00,$00,$00 ; warto od 1-8 dodawana do wsp.X SPRITE'a #1-#7 - wskazuje jak szybko ma spada w d "ASTRONAUTA"
index_tab4clips_Move_BOMB_JACK                    dta $00                         ; wskazuje na kolejn klatk, ktr naley pobra, aby uzyska ruch BOMB JACK-a w prawo lub w lewo (na 4-rech klatkach)
Delay_Move_BOMB_JACK_Left_or_Right                dta $00                         ; (wartoci $00-$03) opnienie pomidzy kolejnymi klatkach wywietlanymi dla uzyskania ruchu w prawo lub w lewo

; tablica zawiera adresy dla SPRITE'w #1-#7 (aby obliczy adres naley: warto*64+$4000)
tab_Every_Fourth_Frame_Astronaut_Sprite           dta $00,$00,$00,$00,$00,$00,$00     ; $00-$04 - zlicza do 4-rech (SPRITES #1-#7) - dziki temu rysujemy "ASTRONAUTE" co 4-t ramk
tab_Every_Third_Frame_Move_Sprite                 dta $00,$00,$00,$00,$00,$00,$00     ; $00-$03 - zlicza do 3-ch (SPRITES #1-#7) - dziki temu rysujemy "WIDEREKA lub KUL lub LITERE PEB lub UFO lub BUKE" co 3-ci ramk
tab_Every_Third_Frame_Move_Bird_Sprite            dta $00,$00,$00,$00,$00,$00,$00     ; $00-$03 - zlicza do 3-ch (SPRITES #1-#7) - dziki temu rysujemy "PTASZKA" co 3-ci ramk
tab_Every_Second_Frame_New_Appear_Sprite          dta $00,$00,$00,$00,$00,$00,$00 ; $00-$02 - zlicza do 2-ch (SPRITES #1-#7) - dziki temu rysujemy "POJAWIANIE SI NOWEGO PRZECIWNIKA" co 2-g ramk

index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right dta $00,$00,$00,$00,$00,$00,$00 ; tablica dla SPRITE'w #1-#7 - zawiera wskanik na klatk z dwch powyszych tablic!
index_tab_clips_Move_Opponent                             dta $00,$00,$00,$00,$00,$00,$00 ; wskanik na kolejn klatk, aby przesun SPRITE #1-#7
index_tab_clips_Move_Bird                                 dta $00,$00,$00,$00,$00,$00,$00 ; wskanik na kolejn klatk, aby przesun "PTAKA" (SPRITE #1-#7)
index_tab_7th_clips_New_Opponent_Appear                   dta $00,$00,$00,$00,$00,$00,$00         ; tablica dla SPRITE'w #1-#7 - zawiera wskanik na klatk z tablicy "tab_7th_clips_New_Opponent_Appear"

tab_7th_clips_New_Opponent_Appear           dta $99,$98,$99,$98,$98,$97,$98,$00,$00,$00 ; kolejne klatki pojawiajce si przed pokazaniem si nowego przeciwnika($97-"kko",$98-"trafienie",$99-"dymek")
tab_4th_clips_Move_Opponent_Astronaut_Left  dta $8D,$8E,$8F,$90,$00,$00,$00,$00,$00,$00 ; 4-ry klatki z animacj przeciwnika "KOSMONAUTY" - ruch w lewo (*64+$4000) (na kocu $00, eby wiedzie, e to koniec tablicy)
tab_4th_clips_Move_Opponent_Astronaut_Right dta $89,$8A,$8B,$8C,$00,$00,$00,$00,$00,$00 ; 4-ry klatki z animacj przeciwnika "KOSMONAUTY" - ruch w prawo (*64+$4000) (na kocu $00, eby wiedzie, e to koniec tablicy)
tab_6th_clips_Move_Opponent_Square_Ball     dta $60,$61,$62,$63,$64,$65,$00,$00,$00,$00 ; 6 klatek animacyjnych przesuwajcej si w lewo lub prawo "KULI Z KWADRATOWYMI OKNAMI"
tab_3th_clips_Move_Opponent_Dot_Ball        dta $66,$67,$68,$00,$00,$00,$00,$00,$00,$00 ; 3 klatki animacyjne przesuwajcej si w lewo lub prawo "KULI Z KROPKAMI"
tab_5th_clips_Move_Opponent_Smiling_Face    dta $81,$82,$83,$84,$85,$00,$00,$00,$00,$00 ; 5 klatek animacyjnych "UMIECHNITEJ BUZI" - pojawiaj si one w miejscu przeciwnikw jeeli BOMB JACK zbierze litere P!
tab_6th_clips_Move_Opponent_Bird_Up_Down    dta $86,$87,$88,$88,$87,$86,$00,$00,$00,$00 ; 6 klatek animacyjnych "PTAKA przemieszczajcego si w gr lub d" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_6th_clips_Move_Opponent_Bird_Left       dta $75,$76,$77,$77,$76,$75,$00,$00,$00,$00 ; 6 klatek animacyjnych "PTAKA przemieszczajcego si w lewo" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_6th_clips_Move_Opponent_Bird_Right      dta $6A,$6B,$6C,$6C,$6B,$6A,$00,$00,$00,$00 ; 6 klatek animacyjnych "PTAKA przemieszczajcego si w prawo" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_6th_clips_Move_Letter_P                 dta $94,$94,$95,$95,$96,$96,$00,$00,$00,$00 ; 6 klatek animacyjnych "LITERY P" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_8th_clips_Move_Opponent_Feeler_Ball     dta $78,$79,$7A,$7B,$78,$79,$7A,$7B,$00,$00 ; 8 klatek animacyjnych "KULI Z CZUKAMI"
tab_4th_clips_Move_Opponent_Drill_Left      dta $6D,$6E,$6F,$70,$00,$00,$00,$00,$00,$00 ; 4-ry klatki animacyjne "WIDERKA" przesuwajcego si w lewo
tab_8th_clips_Move_Opponent_Drill_Right     dta $71,$72,$73,$74,$71,$72,$73,$74,$00,$00 ; 8 klatek animacyjnych "WIDERKA" przesuwajcego si w prawo
tab_6th_clips_Move_Opponent_UFO             dta $A4,$A5,$A6,$A4,$A5,$A6,$00,$00,$00,$00 ; 6 klatek animacyjnych "SPODKA"
tab_8th_clips_Letter_B                      dta $7C,$7C,$7D,$7D,$7E,$7E,$7D,$7D,$00,$00 ; 8 klatek obracajcej si litery "B", ktr moe zebra BOMB JACK!
tab_8th_clips_Letter_E                      dta $7F,$7F,$80,$80,$7E,$7E,$80,$80,$00,$00 ; 8 klatek obracajcej si litery "E", ktr moe zebra BOMB JACK!
tab_Bird_Over_BOMB_JACK                     dta $BA,$BB,$BC,$BB,$BA,$BB,$BC,$00,$00,$00 ; tablica z animacj ptaszka nad BOMB JACKIEM, jeeli ten zgin ($BA*$40 = $6E80)

tab_Is_Sprite1_7_on_Screen               dta $00,$00,$00,$00,$00,$00,$00         ; =0 SPRITE #1-#7 nie jest jeszcze narysowany na ekranie, =1 jest ju
tab_Type_SPRITES_0_7                     dta $00
tab_Type_SPRITES_1_7                     dta $00,$00,$00,$00,$00,$00,$00         ; tablica zawiera jaki typ duszka(np: "WIDEREK") jest wywietlany na SPRITE'ach #1-#7 (UWAGA: jeeli na pozycji jest $00 to oznacza, e ten SPRITE nie jest wywietlany aktualnie)
save_tab_Type_SPRITES_0_7                dta $00
save_tab_Type_SPRITES_1_7                dta $00,$00,$00,$00,$00,$00,$00         ; do zapamitania powyszej tablicy

;tab_sfx_move dta sfx_move_jack,0,sfx_move_jack,0   ; co ktr klatk podczas ruchu 'bomb jacka' w lewo lub prawo odtwarza SFX

tab_Dead_BOMB_JACK                dta BombJack_HandsUp_CapeUp,BombJack_HandsUp_CapeUp,BombJack_Dead,BombJack_Dead   ; tablica z 2 klatkami animujcymi mier BOMB JACK-a po dotkniciu przez wroga (raz do gry nogami, a raz normalnie ustawiony BOMB JACK)-$6A40 i $6B80

; tablica zawiera adresy dla SPRITE'w #1-#7 (aby obliczy adres naley: warto*64+$4000)
BombJack_SHP_C64
tab_Addr_Sprite0_7_Pattern        dta $00
tab_Addr_Sprite1_7_Pattern        dta BombJack_HandsUp_CapeUp,$00,BombJack_HandsUp_CapeUp,$00,BombJack_HandsUp_CapeUp,$00,$00 ; $A9 - klatka ze spadajcym BOMB JACK-iem
save_tab_Addr_Sprite0_7_Pattern   dta $00
save_tab_Addr_Sprite1_7_Pattern   :7 dta $00

; tablica z gotowymi (bezwzgldnymi) adresami, kolejnych wierszy ScreenBuff40x25 w zalenoci od wsp.Y SPRITE'a ...
; ...oraz pozycj Y dla SPRITE'a, eby znalaz si pod tym adresem na ekranie (+wsp. X)
; czyli adres nastpny jest co 3bajty!!! ($5000,$1C,$5028,$24,$5050,$2C,$5078 itd.)
tab_Addr_SPRITE_ScreenBuff40x25
 dta a(B1SCR+32* 0),$1C-$1C,a(B1SCR+32* 1),$24-$1C,a(B1SCR+32* 2),$2C-$1C,a(B1SCR+32* 3),$34-$1C,a(B1SCR+32* 4),$3C-$1C,a(B1SCR+32* 5),$44-$1C
 dta a(B1SCR+32* 6),$4C-$1C,a(B1SCR+32* 7),$54-$1C,a(B1SCR+32* 8),$5C-$1C,a(B1SCR+32* 9),$64-$1C,a(B1SCR+32*10),$6C-$1C,a(B1SCR+32*11),$74-$1C
 dta a(B1SCR+32*12),$7C-$1C,a(B1SCR+32*13),$84-$1C,a(B1SCR+32*14),$8C-$1C,a(B1SCR+32*15),$94-$1C,a(B1SCR+32*16),$9C-$1C,a(B1SCR+32*17),$A4-$1C
 dta a(B1SCR+32*18),$AC-$1C,a(B1SCR+32*19),$B4-$1C,a(B1SCR+32*20),$BC-$1C,a(B1SCR+32*21),$C4-$1C,a(B1SCR+32*22),$CC-$1C,a(B1SCR+32*23),$D4-$1C
 dta a(B1SCR+32*24),$DC-$1C,a(B1SCR+32*25),$E4-$1C,a(B1SCR+32*26),$EC-$1C,a(B1SCR+32*27),$F4-$1C,a(B1SCR+32*28),$FC-$1C

; tablica zawiera "kod akcji" dla wszystkich 256 znakw uywanych w zestawie (dla ekranu z polem gry)
; $01 - oznacza, e ten znak na ekranie to zielona ramka(otaczajca pole gry) lub kadka, po ktrej skacze BOMB JACK
; $02 -  lewy grny rg BOMB-y do zebrania
; $03 - prawy grny rg BOMB-y do zebrania
; $04 -  lewy dolny rg BOMB-y do zebrania
; $05 - prawy dolny rg BOMB-y do zebrania
tab_Action_for_256Chars
                .rept 2
                  :def_ledgeV     dta $00
                                  dta $01,$01,$02,$03,$04,$05,$02,$03,$04,$05
                  :[128-charsBAK] dta $00
                .endr

; tablica z kolejnymi klatkami powodujcymi taczenie BOMB JACK-a (po zebraniu wszystkich BOMB)
tab_Dance_BOMB_JACK             dta BombJack_Dance,BombJack_Dance+1,BombJack_Dance+2,BombJack_Dance,BombJack_Dance+1,BombJack_Dance+2,BombJack_Dance+1,BombJack_Dance,BombJack_Dance+2,$00
tab_4clips_Move_BOMB_JACK_Left  dta BombJack_Left,BombJack_Left+1,BombJack_Left+2,BombJack_Left+3,$00     ; 4-ry klatki animacji ruchu BOMB JACKA w lewo (pierwsza pod $6D80)
tab_4clips_Move_BOMB_JACK_Right dta BombJack_Right,BombJack_Right+1,BombJack_Right+2,BombJack_Right+3,$00 ; 4-ry klatki animacji ruchu BOMB JACKA w prawo (pierwsza pod $6C80)

; ponisze tablice s po to, eby dostosowa wersje z C64 do wywietlania na ATARI
tab_bomb .dw tab_scr1, tab_scr2, tab_scr2, tab_scr2, tab_scr2  ; dziki tym tablicom nastpuje dopasowanie wywietlania BOMB do ekranu ATARI (a nie C64)
         .dw tab_scr1, tab_scr2, tab_scr2, tab_scr2, tab_scr2  ; chodzi tu gwnie o invers oraz jakie to ma mie BOMB-a
         .dw tab_scr1, tab_scr1, tab_scr2, tab_scr2, tab_scr2
         .dw tab_scr2, tab_scr2, tab_scr2, tab_scr2, tab_scr2
tab_scr1 dta $00,$00,$00
tab_scr2 dta $00,$01,$02                                       ; UWAGA! =2 oznacza wymuszenie rysowania bomb bez inwersu

; tablica ze znakami definiujcymi BOMBY
tab_bombs           dta def_bomb_ver2+0, def_bomb_ver2+1   ; grne bajty BOMBY - pojawiaj si na planszy
                    dta def_bomb_ver2+2, def_bomb_ver2+3   ; dolne bajty BOMBY

                    dta def_bomb_ver1+0, def_bomb_ver1+1   ; grne bajty BOMBY - pojawiaj si na niebie
                    dta def_bomb_ver1+2, def_bomb_ver1+3   ; dolne bajty BOMBY

                    dta def_bomb_ver2+0, def_bomb_ver2+1   ; grne bajty BOMBY - pojawiaj si na niebie
                    dta def_bomb_ver2+2, def_bomb_ver2+3   ; dolne bajty BOMBY

BOMB                dta 0,0                                ; cztery znaki BOMBY - pobrane z tablicy "tab_bombs"
                    dta 0,0

; tablica z adresami danych ze zdefiniowanymi ukadami BOMB dla kolejnych ekranw
tab_pos_bombs_on_screens
 .dw Bombs_screen1,Bombs_screen2,Bombs_screen3,Bombs_screen4,Bombs_screen5
 .dw Bombs_screen6,Bombs_screen7,Bombs_screen8,Bombs_screen9,Bombs_screenA
 .dw Bombs_screenB,Bombs_screenC,Bombs_screenD,Bombs_screenE,Bombs_screenG
 .dw Bombs_screenF,Bombs_screen2,Bombs_screen3,Bombs_screen1,Bombs_screenH

; dane do rozrysowania ukadu BOMB na 1-szym ekranie
; pierwszy bajt - $00-$02 wskazuje pozycje w tablicy tab_bombs (4-ry znaki rozrysowujce BOMB)
; drugi bajt    - ile naley doda do pozycji X (lub Y) aby narysowa kolejn BOMB w danym wierszu (kolumnie)
; trzeci bajt   - ile BOMB naley narysowa w wierszu
; 4,5 bajt      - przesunicie wzgldem ScreenBuff40x25 lub ColorRAM gdzie zaczynamy rysowa BOMBY
Bombs_screen1 dta $00,$03,$03,a($002C),$00,$03,$03,a($003E),$00,$03,$04,a($00D5),$00,$60,$04,a($0141),$00,$60,$04,a($015C),$01,$03,$03,a($0373),$00,$03,$03,a($02E2),$FF
Bombs_screen2 dta $00,$03,$03,a($0033),$00,$03,$03,a($0079),$00,$03,$03,a($008D),$00,$03,$03,a($00FB),$00,$03,$02,a($0194),$01,$03,$01,a($019A),$00,$03,$03,a($01A2),$00,$03,$03,a($0285),$00,$03,$03,a($0291),$FF
Bombs_screen3 dta $00,$03,$02,a($0029),$00,$03,$02,a($0041),$00,$03,$02,a($007F),$00,$03,$02,a($008A),$00,$60,$03,a($0122),$00,$60,$03,a($012A),$01,$03,$03,a($02A9),$01,$03,$03,a($02BE),$00,$04,$02,a($0376),$00,$04,$02,a($0382),$FF
Bombs_screen4 dta $00,$03,$03,a($00A2),$00,$03,$01,a($0192),$01,$03,$02,a($0195),$00,$03,$01,a($0282),$01,$03,$02,a($0285),$01,$03,$03,a($0372),$00,$03,$03,a($00B5),$00,$03,$03,a($01A5),$00,$03,$03,a($0295),$01,$03,$03,a($0385),$FF
Bombs_screen5 dta $02,$60,$06,a($007C),$02,$60,$06,a($0083),$02,$60,$06,a($008A),$02,$60,$06,a($0091),$FF
Bombs_screen6 dta $00,$03,$02,a($0029),$00,$03,$02,a($0087),$00,$03,$02,a($0041),$01,$03,$02,a($0169),$01,$60,$04,a($01E1),$01,$03,$02,a($02D6),$01,$03,$03,a($02DE),$00,$03,$03,a($017E),$00,$60,$04,a($01FC),$FF
Bombs_screen7 dta $00,$03,$03,a($007D),$00,$03,$03,a($008C),$00,$03,$01,a($01E5),$01,$03,$02,a($01E8),$01,$03,$02,a($01F3),$00,$03,$01,a($01F9),$00,$60,$03,a($0281),$00,$60,$03,a($028B),$00,$60,$03,a($0293),$00,$60,$03,a($029C),$FF
Bombs_screen8 dta $00,$60,$03,a($0054),$00,$60,$03,a($005B),$00,$60,$03,a($0062),$00,$60,$03,a($0069),$00,$03,$03,a($01E2),$00,$03,$03,a($01F5),$00,$60,$01,a($0260),$00,$60,$02,a($02D8),$00,$60,$01,a($026D),$00,$60,$02,a($02E5),$FF
Bombs_screen9 dta $00,$03,$03,a($003D),$00,$60,$01,a($00CC),$01,$60,$02,a($0144),$00,$60,$01,a($00D0),$01,$60,$02,a($0148),$00,$03,$03,a($0156),$00,$03,$03,a($0244),$01,$03,$03,a($02D4),$00,$40,$02,a($02E7),$01,$40,$01,a($0387),$00,$40,$02,a($02EC),$01,$40,$01,a($038C),$FF
Bombs_screenA dta $02,$03,$03,a($002B),$02,$03,$03,a($003C),$02,$03,$04,a($00FE),$02,$60,$04,a($015C),$02,$60,$04,a($0141),$02,$03,$03,a($0307),$02,$03,$03,a($0371),$FF
Bombs_screenB dta $00,$60,$03,a($002C),$00,$60,$03,a($0041),$01,$60,$03,a($00F7),$00,$60,$03,a($0089),$01,$60,$03,a($01A6),$01,$60,$03,a($023B),$01,$60,$03,a($0281),$00,$60,$03,a($029C),$FF
Bombs_screenC dta $00,$40,$03,a($0029),$00,$03,$03,a($003E),$01,$03,$03,a($00D5),$00,$60,$03,a($0144),$00,$60,$02,a($010C),$01,$60,$04,a($0181),$01,$40,$03,a($02EC),$01,$03,$03,a($0371),$FF
Bombs_screenD dta $00,$03,$03,a($002D),$00,$03,$03,a($003B),$00,$60,$02,a($0141),$01,$60,$01,a($0231),$00,$60,$02,a($015C),$01,$60,$01,a($024C),$00,$60,$03,a($00CF),$00,$60,$03,a($00DE),$00,$40,$03,a($023B),$00,$40,$03,a($0242),$FF
Bombs_screenE dta $00,$03,$03,a($00A4),$00,$03,$03,a($00B3),$00,$60,$03,a($0141),$00,$60,$03,a($015C),$00,$60,$03,a($019B),$00,$60,$03,a($01A1),$00,$60,$02,a($0284),$01,$60,$01,a($0374),$00,$60,$02,a($0299),$01,$60,$01,a($0389),$FF
Bombs_screenF dta $00,$03,$06,a($0029),$00,$03,$03,a($00CE),$00,$03,$02,a($016E),$02,$60,$04,a($00BC),$00,$03,$03,a($00FF),$00,$03,$06,a($0378),$FF
Bombs_screenG dta $02,$03,$03,a($002C),$02,$03,$03,a($003E),$02,$03,$04,a($00D5),$02,$60,$04,a($0141),$02,$60,$04,a($015C),$02,$03,$03,a($0373),$02,$03,$03,a($02E2),$FF
Bombs_screenH dta $02,$03,$03,a($0033),$02,$03,$03,a($0079),$02,$03,$03,a($008D),$02,$03,$03,a($00FB),$02,$03,$02,a($0194),$02,$03,$01,a($019A),$02,$03,$03,a($01A2),$02,$03,$03,a($0285),$02,$03,$03,a($0291),$FF

; 19*2=38 bajtw - kolejne adresy dla kolejnych plansz gry (jak wida w sumie, aby przejcia BOMB JACK-a naley ukoczy 19 plansz)
; zawiera adresy do tablic(dla kadej planszy osobna) gdzie s przechowywane wskaniki na podstawie, ktrych mona wyliczy lewy grny rg kolejnej BOMBY, ktra ma miga
tab_Address_Next_Blink_Bomb_BOARD
 .dw Pointer_Address_Next_Blink_Bomb_BOARD_01,Pointer_Address_Next_Blink_Bomb_BOARD_02,Pointer_Address_Next_Blink_Bomb_BOARD_03,Pointer_Address_Next_Blink_Bomb_BOARD_04,Pointer_Address_Next_Blink_Bomb_BOARD_05
 .dw Pointer_Address_Next_Blink_Bomb_BOARD_06,Pointer_Address_Next_Blink_Bomb_BOARD_07,Pointer_Address_Next_Blink_Bomb_BOARD_08,Pointer_Address_Next_Blink_Bomb_BOARD_09,Pointer_Address_Next_Blink_Bomb_BOARD_0A
 .dw Pointer_Address_Next_Blink_Bomb_BOARD_0B,Pointer_Address_Next_Blink_Bomb_BOARD_0C,Pointer_Address_Next_Blink_Bomb_BOARD_0D,Pointer_Address_Next_Blink_Bomb_BOARD_0E,Pointer_Address_Next_Blink_Bomb_BOARD_02
 .dw Pointer_Address_Next_Blink_Bomb_BOARD_0F,Pointer_Address_Next_Blink_Bomb_BOARD_02,Pointer_Address_Next_Blink_Bomb_BOARD_03,Pointer_Address_Next_Blink_Bomb_BOARD_01,Pointer_Address_Next_Blink_Bomb_BOARD_01

; tablica 24 bajtowa (bo do zebrania na kadej planszy s 24 BOMB-y)
; te wartoci s zapisywane w odpowiedniej pozycji tablicy tab_Screen_BOMB+1
; warto_z_poniszej_tablicy * 2 + ScreenText40x25 - w ten sposb obliczamy offset(powikszony o $0400) lewego grnego rogu kolejnej BOMB-y, ktra bdzie miga
Pointer_Address_Next_Blink_Bomb_BOARD_01 dta $01,$02,$17,$06,$03,$04,$07,$08,$09,$0E,$0B,$0C,$0D,$00,$0F,$10,$11,$0A,$05,$12,$13,$14,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_02 dta $03,$00,$01,$04,$05,$0C,$07,$08,$0B,$02,$09,$0A,$0D,$0E,$12,$10,$11,$06,$13,$14,$15,$16,$17,$0F
Pointer_Address_Next_Blink_Bomb_BOARD_03 dta $14,$00,$03,$05,$01,$04,$07,$02,$0B,$08,$09,$0C,$0D,$11,$0F,$10,$0A,$12,$13,$06,$15,$16,$17,$0E
Pointer_Address_Next_Blink_Bomb_BOARD_04 dta $0B,$00,$01,$0C,$03,$04,$0F,$06,$07,$15,$09,$0A,$0D,$0E,$02,$10,$11,$05,$13,$14,$08,$16,$17,$12
Pointer_Address_Next_Blink_Bomb_BOARD_05 dta $01,$02,$03,$04,$05,$0F,$07,$08,$12,$0A,$0B,$00,$0D,$0E,$09,$10,$11,$06,$13,$14,$15,$16,$17,$0C
Pointer_Address_Next_Blink_Bomb_BOARD_06 dta $04,$00,$01,$02,$05,$07,$08,$06,$09,$0A,$0B,$17,$03,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_07 dta $01,$02,$03,$04,$05,$15,$0C,$06,$07,$0A,$0B,$0F,$0D,$0E,$00,$10,$11,$08,$13,$14,$09,$16,$17,$12
Pointer_Address_Next_Blink_Bomb_BOARD_08 dta $01,$02,$09,$04,$05,$00,$07,$08,$17,$0A,$0B,$06,$14,$0C,$0D,$0E,$0F,$10,$03,$12,$13,$11,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_09 dta $08,$00,$01,$04,$05,$0F,$03,$06,$07,$15,$09,$0A,$0D,$0E,$12,$10,$11,$0C,$13,$14,$0B,$16,$17,$02
Pointer_Address_Next_Blink_Bomb_BOARD_0A dta $01,$02,$14,$06,$03,$04,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$00,$17,$12,$13,$05,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_0B dta $01,$02,$12,$04,$05,$09,$07,$08,$0F,$0A,$0B,$00,$0D,$0E,$06,$10,$11,$03,$13,$14,$17,$0C,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_0C dta $01,$02,$09,$04,$05,$0E,$00,$06,$07,$0A,$0B,$0F,$08,$0C,$0D,$10,$11,$12,$13,$14,$17,$03,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_0D dta $06,$00,$01,$15,$03,$04,$07,$08,$0F,$0A,$0B,$02,$09,$0C,$0D,$10,$11,$12,$13,$14,$05,$16,$17,$0E
Pointer_Address_Next_Blink_Bomb_BOARD_0E dta $09,$00,$01,$04,$05,$06,$07,$08,$12,$0A,$0B,$15,$0D,$0E,$03,$0C,$0F,$10,$13,$14,$02,$16,$17,$11
Pointer_Address_Next_Blink_Bomb_BOARD_0F dta $01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$00

; tablica zawiera adresy danych dla rysowania paskw dla poszczeglnych ekranw gry
tab_addr_char_bars
 ;          1           2           3           4           5           6           7           8           9           10
 .dw adr_ledge01,adr_ledge02,adr_ledge03,adr_ledge04,adr_ledge05,adr_ledge06,adr_ledge07,adr_ledge08,adr_ledge09,adr_ledge10
 .dw adr_ledge11,adr_ledge12,adr_ledge13,adr_ledge14,adr_ledge10,adr_ledge15,adr_ledge04,adr_ledge03,adr_ledge01,adr_ledge16

; tablica z adresami danych, ktre ustawiaj wszystkie sprite'y na pocztku kadej planszy
tab_parameters_for_sprites
 .dw adr_sprit01,adr_sprit02,adr_sprit03,adr_sprit04,adr_sprit05,adr_sprit06,adr_sprit07,adr_sprit08,adr_sprit09,adr_sprit10
 .dw adr_sprit11,adr_sprit12,adr_sprit13,adr_sprit14,adr_sprit05,adr_sprit15,adr_sprit03,adr_sprit01,adr_sprit04,adr_sprit16

; dane po 6-bajtw
; bajt    0 - dugo rysowanego paska (ten po ktrym skaczemy)
; bajt    1 - atrybut(kolor) paska
; bajt    2 - znak paska (zwykle $FF)
; bajt    3 - o ile przesun aby rysowa pasek na nowej pozycji (zwykle +1)
; bajty 4,5 - offset, od ktrego rysujemy pasek
; UWAGA! jeeli pokazuj si przeciwnicy to musz by w tym samym wierszu raczej bo inaczej procka "test_max_sprites_in_row" moe przyblokowa jednego z nich!
adr_ledge01 dta $1E,$B0,$FF,$01,a($0410),$08,$0B,$FF,$01,a($00AF),$04,$0B,$FF,$01,a($00F7),$07,$0B,$FF,$01,a($023C),$04,$0B,$FF,$01,a($02D4),$09,$0B,$FF,$01,a($0332),$00,$00,$00,$00,a($0000) ; UWAGA! tutaj same $00 - kod wykrywa to miejsce i od pierwszej wartoci <>$00 zmienia sposb interpretowania danych z tej tablicy
adr_sprit01 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00 ; typy SPRITE'w, ktre pojawi si na planszy (SPRITES #1-#7) ($01-ASTRONAUT, $0B-BIRD, $0E-??)
            dta $50,$40,$00,$00,$00,$00,$00,$00,$32,$40,$00,$00,$00,$00 ; pocztkowe wsp.X i Y dla SPRITES #1-#7
            dta     $00,    $06,    $02,    $02,    $02                 ; (typy SPRITE'w - na jakiego gorszego przeciwnika moemy si przeksztaci) przepisuje te dane w odwrotnej kolejnoci do tablicy

adr_ledge02 dta $1E,$B0,$FF,$01,a($0410),$06,$0B,$FF,$01,a($00F1),$06,$0B,$FF,$01,a($0108),$05,$0B,$FF,$01,a($01E5),$06,$0B,$FF,$01,a($01F4),$05,$0B,$FF,$01,a($02D8),$05,$0B,$FF,$01,a($02E2),$00,$00,$00,$00,a($0000)
adr_sprit02 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00
            dta $31,$32,$2D,$32,$2A,$C8,$E6,$32,$C8,$D2,$00,$00,$00,$00
            dta     $05,    $06,    $05,    $05,   $05

adr_ledge03 dta $1E,$B0,$FF,$01,a($0410),$05,$0B,$FF,$01,$CF,$00,$05,$0B,$FF,$01,$DA,$00,$05,$0B,$FF,$01,$65,$02,$05,$0B,$FF,$01,$FD,$02,$05,$0B,$FF,$01,$0D,$03,$00,$00,$00,$00,$00,$00
adr_sprit03 dta     $0E,    $01,    $0E,    $0E,    $0B,    $00,    $00
            dta $B4,$C8,$51,$32,$2A,$C8,$B5,$32,$C8,$DC,$00,$00,$00,$00
            dta $04,$04,$06,$04,$04

adr_ledge04 dta $1E,$B0,$FF,$01,a($0410),$06,$0B,$FF,$01,$F5,$00,$06,$0B,$FF,$01,$04,$01,$06,$0B,$FF,$01,$D5,$02,$06,$0B,$FF,$01,$E4,$02,$00,$00,$00,$00,$00,$00
adr_sprit04 dta     $0E,    $01,    $0E,    $0E,    $0B,    $00,    $00
            dta $12,$C8,$51,$32,$2A,$C8,$DC,$AA,$C8,$C8,$00,$00,$00,$00
            dta $03,$06,$03,$03,$03

adr_ledge05 dta $1E,$B0,$FF,$01,a($0410),$00,$00,$00,$00,$00,$00
adr_sprit05 dta     $01,    $01,    $01,    $04,    $0B,    $00,    $00
            dta $B4,$80,$B4,$70,$B4,$60,$46,$46,$B4,$46,$00,$00,$00,$00
            dta     $06,    $06,    $04,    $04,    $04

adr_ledge06 dta $1E,$B0,$FF,$01,a($0410),$08,$0B,$FF,$01,$19,$01,$06,$0B,$FF,$01,$D7,$00,$07,$0B,$FF,$01,$CC,$01,$06,$0B,$F9,$20,$F4,$01,$0E,$0B,$FF,$01,$AF,$02,$00,$00,$00,$00,$00,$00
adr_sprit06 dta     $0E,    $0E,    $0E,    $01,    $0B,    $00,    $00
            dta $01,$01,$01,$01,$01,$01,$96,$32,$D2,$32,$00,$00,$00,$00
            dta $02,$04,$04,$06,$06

adr_ledge07 dta $1E,$B0,$FF,$01,a($0410),$06,$0B,$FF,$01,$D5,$00,$07,$0B,$FF,$01,$96,$01,$07,$0B,$FF,$01,$A3,$01,$07,$0B,$FF,$01,$36,$02,$07,$0B,$FF,$01,$43,$02,$06,$0B,$FF,$01,$05,$03,$00,$00,$00,$00,$00,$00
adr_sprit07 dta     $0E,    $0E,    $0E,    $01,    $0B,    $00,    $00
            dta $01,$01,$01,$01,$01,$01,$96,$32,$46,$32,$00,$00,$00,$00
            dta $06,$02,$04,$05,$03

adr_ledge08 dta $1E,$B0,$FF,$01,a($0410),$07,$0B,$F9,$20,$AA,$00,$07,$0B,$F9,$20,$B4,$00,$07,$0B,$F9,$20,$3A,$02,$07,$0B,$F9,$20,$44,$02,$07,$0B,$FF,$01,$94,$01,$07,$0B,$FF,$01,$A4,$01,$07,$0B,$FF,$01,$34,$02,$07,$0B,$FF,$01,$44,$02,$00,$00,$00,$00,$00,$00
adr_sprit08 dta     $01,    $0E,    $0E,    $01,    $0B,    $00,    $00
            dta $46,$32,$01,$01,$01,$01,$DC,$32,$BE,$C8,$00,$00,$00,$00
            dta $03,$03,$05,$05,$03

adr_ledge09 dta $1E,$B0,$FF,$01,a($0410),$04,$0B,$FF,$01,$AF,$00,$03,$0B,$F9,$20,$D7,$00,$05,$0B,$FF,$01,$4F,$01,$07,$0B,$FF,$01,$ED,$01,$03,$0B,$F9,$20,$18,$02,$04,$0B,$FF,$01,$90,$02,$0E,$0B,$FF,$01,$26,$03,$00,$00,$00,$00,$00,$00
adr_sprit09 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00
            dta $96,$32,$01,$01,$01,$01,$01,$01,$DC,$32,$00,$00,$00,$00
            dta $06,$06,$02,$04,$03

adr_ledge10 dta $1E,$B0,$FF,$01,a($0410),$00,$00,$00,$00,$00,$00
adr_sprit10 dta     $05,    $01,    $01,    $01,    $0B,    $00,    $00
            dta $32,$32,$50,$56,$6E,$56,$AA,$56,$C8,$32,$00,$00,$00,$00
            dta $06,$06,$05,$04,$04

adr_ledge11 dta $1E,$B0,$FF,$01,a($0410),$08,$0B,$FF,$01,$CE,$00,$06,$0B,$FF,$01,$DB,$00,$0C,$0B,$F9,$20,$F6,$00,$0C,$0B,$F9,$20,$08,$01,$05,$0B,$FF,$01,$D6,$02,$0A,$0B,$FF,$01,$DF,$02,$00,$00,$00,$00,$00,$00
adr_sprit11 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00
            dta $50,$32,$01,$01,$01,$01,$01,$01,$C8,$C8,$00,$00,$00,$00
            dta $06,$06,$05,$05,$02

adr_ledge12 dta $1E,$B0,$FF,$01,a($0410),$05,$0B,$FF,$01,$19,$01,$05,$0B,$FF,$01,$09,$02,$05,$0B,$FF,$01,$F9,$02,$05,$0B,$FF,$01,$E1,$00,$05,$0B,$FF,$01,$D1,$01,$05,$0B,$FF,$01,$C1,$02,$00,$00,$00,$00,$00,$00
adr_sprit12 dta     $01,    $01,    $0E,    $0E,    $0B,    $00,    $00
            dta $50,$32,$DC,$32,$01,$01,$01,$01,$C8,$C8,$00,$00,$00,$00
            dta $06,$03,$04,$04,$03

adr_ledge13 dta $1E,$B0,$FF,$01,a($0410),$03,$0B,$FF,$01,$AA,$00,$03,$0B,$FF,$01,$B2,$00,$05,$0B,$F9,$20,$F5,$00,$05,$0B,$F9,$20,$35,$02,$05,$0B,$F9,$20,$09,$01,$05,$0B,$F9,$20,$49,$02,$05,$0B,$FF,$01,$75,$01,$05,$0B,$FF,$01,$8D,$02,$04,$0B,$FF,$01,$29,$03,$04,$0B,$FF,$01,$32,$03,$03,$0B,$F9,$20,$C1,$01,$03,$0B,$F9,$20,$CD,$01,$00,$00,$00,$00,$00,$00
adr_sprit13 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00
            dta $96,$50,$01,$01,$01,$01,$01,$01,$C8,$C8,$00,$00,$00,$00
            dta $06,$06,$06,$04,$04

adr_ledge14 dta $1E,$B0,$FF,$01,a($0410),$13,$0B,$FF,$01,$F6,$00,$0B,$0B,$F9,$20,$1E,$01,$0B,$0B,$F9,$20,$30,$01,$05,$0B,$FF,$01,$04,$03,$00,$00,$00,$00,$00,$00
adr_sprit14 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00
            dta $50,$32,$01,$01,$01,$01,$01,$01,$C8,$32,$00,$00,$00,$00
            dta $06,$04,$04,$05,$02

adr_ledge15 dta $1E,$B0,$FF,$01,a($0410),$09,$0B,$FF,$01,$A5,$00,$06,$0B,$F9,$20,$CD,$00,$09,$0B,$FF,$01,$BD,$01,$07,$0B,$F9,$20,$42,$02,$07,$0B,$F9,$20,$47,$02,$04,$0B,$FF,$01,$BB,$02,$00,$00,$00,$00,$00,$00
adr_sprit15 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00
            dta $50,$32,$01,$01,$01,$01,$01,$01,$C8,$D2,$00,$00,$00,$00
            dta $06,$06,$06,$04,$04

adr_ledge16 dta $1E,$B0,$FF,$01,a($0410),$06,$0B,$FF,$01,a($00AF),$04,$0B,$FF,$01,a($00F7),$07,$0B,$FF,$01,a($023C),$04,$0B,$FF,$01,a($02D4),$09,$0B,$FF,$01,a($0332),$00,$00,$00,$00,a($0000) ; UWAGA! tutaj same $00 - kod wykrywa to miejsce i od pierwszej wartoci <>$00 zmienia sposb interpretowania danych z tej tablicy
adr_sprit16 dta     $01,    $0E,    $0E,    $0E,    $0B,    $00,    $00 ; typy SPRITE'w, ktre pojawi si na planszy (SPRITES #1-#7) ($01-ASTRONAUT, $0B-BIRD, $0E-??)
            dta $50,$46,$00,$00,$00,$00,$00,$00,$32,$46,$00,$00,$00,$00 ; pocztkowe wsp.X i Y dla SPRITES #1-#7
            dta     $00,    $06,    $02,    $02,    $02                 ; (typy SPRITE'w - na jakiego gorszego przeciwnika moemy si przeksztaci) przepisuje te dane w odwrotnej kolejnoci do tablicy

tab_ledgeHV dta def_ledgeH,def_ledgeH,def_ledgeH,def_ledgeH,def_ledgeV,$FF,def_ledgeV ; tablica konwertujca rodzaje kadek z C64 na te, ktre s na ATARI

Count_Char_Bar                           dta $00                         ; zlicza o jakiej dugoci ma by pasek
Attrib_Char_Bar                          dta $00                         ; przechowuje atrybut(kolor) jakim narysujemy pasek
Char_Bar                                 dta $00                         ; przechowuje kod znaku paska (zwykle $FF)
Pos_Char_Bar                             dta $00                         ; warto, ktr si dodaje w celu obliczenia nastpnej pozycji paska (po ktrych skacze BOMB JACK)
Offset_Char_Bar                          .dw $0000                       ; offset, od ktrego bdziemy rysowa pasek (do tego dodajemy ScreenBuff40x25 lub ColorRAM40x25, eby mie peny adres)
tab_Move_Left_or_Right_or_Down_LetterEB  dta $00,$00,$00,$00,$00,$00,$00 ; =0 - wylosuj miejsce pojawienia si "LITERY", =1 - ruch w lewo, =2 - ruch w prawo, =3 - ruch w d
tab_Can_Show_LetterP_on_Board            dta $00,$00,$00,$00,$00,$00,$00 ; 0 - mona wywietli "LITERE P", 1 - nie mona (SPRITES #1-#7)(UWAGA! ustawiane na 0 przed kad kolejn plansz oraz po zebraniu pewnej iloci BOMB!)
tab_Is_Astronaut_Change_PosX             dta $00,$00,$00,$00,$00,$00,$00 ; =1 "ASTRONAUTA" zmieni swoj wsp.X, =0 nie zmieni
tab_Every_100th_Move_Follow_BOMB_JACK    dta $00,$00,$00,$00,$00,$00,$00 ; 100-0 - jak osignie 0 to wywoanie procedury ledzcej gdzie jest BOMB JACK i prba zmiany ruchu tak, eby go dopa

index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform         dta $00                         ; licznik wskazujcy na coraz groniejszego przeciwnika, w ktrego przeksztaca si kady kolejny "ASTRONAUTA"
tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform               dta $00,$00,$00,$00,$00         ; np: $02,$02,$02,$06,$00 ($02-DRILL, $06-UFO) Typy groniejszych przeciwnikw dla kolejnych "ASTRONAUTW", ktrzy podlegaj transformacji
MAX_TRANSFORM                                                           = * - tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform

tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7 dta $00,$00,$00,$00,$00,$00,$00 ; +1 za kadym razem kiedy "ASTRONAUTA" dojdzie do lewego lub prawego brzegu "kadki" (te po ktrych moe skaka BOMB JACK)
tab_Every_Second_Frame_Drill_UFO_Sprite                                 dta $00,$00,$00,$00,$00,$00,$00   ; 0-rysuj "WIDERKA" lub "UFO", 1-nie rysuj "WIDERKA" lub "UFO" (dziki temu rysujemy co 2-g ramke)

Store_Sprite1_PosX                                             dta $00 ; zapamitatuje wsp.X powikszon o +8, pniej wykorzystywana jest do odtworzenia wsp.X powikszonej o +8
Store_Sprite1_PosY                                             dta $00 ; zmienna tymczasowa dla zapamitania i pniejszego odtworzenia "Sprite1_PosY"
Opposite_Direction_Move_New_Apper_Astronaut_than_Old_Astronaut dta $00 ; w lewo(=2) czy w prawo(=1)? ma si zacz przesuwa nowy "ASTRONAUTA", ktry si pojawi
Store_Do_Number_SPRITE_1_7                                     dta $00 ; zmienna tymczasowa dla zapamitania i pniejszego odtworzenia "Do_Number_SPRITE_1_7"
Is_New_Astronaut_Appear                                        dta $00 ; =1 pojawi si nowy przeciwnik "ASTRONAUTA", =0 nie pojawi si nowy przeciwnik (bo np: ju max. liczba przeciwnikw na ekranie)

; wsprzdne X i Y dla SPRITE'a #0 ("bomb jack")
Sprite0_PosX dta $00                                                   ; zawiera aktualn wsp.X dla SPRITE'a #0
Sprite0_PosY dta $00                                                   ; zawiera aktualn wsp.Y(bity 0-7) dla SPRITE'a #0

Sprite1_PosX dta $32                                                   ; wsprzdne X i Y dla SPRITE'w #1 - #7
Sprite1_PosY dta $32

Sprite2_PosX dta $46
Sprite2_PosY dta $32

Sprite3_PosX dta $5A
Sprite3_PosY dta $32

Sprite4_PosX dta $6E
Sprite4_PosY dta $32

Sprite5_PosX dta $82
Sprite5_PosY dta $32

Sprite6_PosX dta $C3
Sprite6_PosY dta $32

Sprite7_PosX dta $EB
Sprite7_PosY dta $32

Buffor_Offset_in_tab_Screen_BOMB :24 .dw $0000 ; zawiera adres pozycji BOMBy w tablicy 'tab_Screen_BOMB' (maksymalna liczba bomb na ekranie to 24)

tab_conv_sprite_number_C64_to_ATARI
 dta Square_Ball+0,Square_Ball+1,Square_Ball+2,Square_Ball+3,Square_Ball+4,Square_Ball+5,Dot_Ball+0,Dot_Ball+1,Dot_Ball+2,Points_200x1+0,Bird_Right+0,Bird_Right+1,Bird_Right+2,Drill_Left+0,Drill_Left+1,Drill_Left+2
 dta Drill_Left+3,Drill_Right+0,Drill_Right+1,Drill_Right+2,Drill_Right+3,Bird_Left+0,Bird_Left+1,Bird_Left+2,Feeler_Ball+0,Feeler_Ball+1,Feeler_Ball+2,Feeler_Ball+3,Letter_B+0,Letter_B+1,Letter_B+2,Letter_E+0

 dta Letter_E+1,Smilling_Face+0,Smilling_Face+1,Smilling_Face+2,Smilling_Face+3,Smilling_Face+4,Bird_Down+0,Bird_Down+1,Bird_Down+2,Astronaut_Right+0,Astronaut_Right+1,Astronaut_Right+2,Astronaut_Right+3,Astronaut_Left+0,Astronaut_Left+1,Astronaut_Left+2
 dta Astronaut_Left+3,Astronaut_Up_Down+0,$00,$00,Letter_P+0,Letter_P+1,Letter_P+2,New_Opponent_Apear+0,New_Opponent_Apear+1,New_Opponent_Apear+2,StartU+0,StartU+1,StartU+2,StartU+3,Points_200x2+0,StartD+0

 dta StartD+1,StartD+2,StartD+3,Points_200x3+0,UFO+0,UFO+1,UFO+2,$00,Jack_HandsUp_CapeDn+0,Jack_HandsUp_CapeUp+0,Jack_Right_Dn+0,Jack_Left_Dn+0,Jack_Right_Stand+0,Jack_Left_Stand+0,Jack_Dead+0,Jack_Dance+0
 dta Jack_Dance+1,Jack_Dance+2,Jack_Right+0,Jack_Right+1,Jack_Right+2,Jack_Right+3,Jack_Left+0,Jack_Left+1,Jack_Left+2,Jack_Left+3,Jack_Dead_Bird+0,Jack_Dead_Bird+1,Jack_Dead_Bird+2,Points_2000+0,$00,$00

 dta BlinkBomb+0,Points_100+0,Points_200+0,Points_300+0,Points_400+0,Points_500+0,Points_600+0,$00,$00,$00,$00,$00,$00,$00,$00,$00
 dta GameOver+0,GameOver+1,GameOver+2,GameOver+3,GameOver+4,$00,$00,$00,$00,$00,$00,$00,Letter_B+0,Letter_B+1,Letter_B+2,$00

StoreA_address1     .word $0000 ; zapamituje do pniejszego odtworzenia (address1)
StoreB_address1     .word $0000 ; tymczasowy adres dla zapamietania (address1), eby potem odtworzy ten adres
index_Address_BOMBS .byte $00   ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y

Index_charset     .byte $00         ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany
Char_Board1       .word $E000       ; 1KB - plansza gry #1 (ekran gry #1)
Attribute1        .word $0906       ;
                  .word $E400       ; 1KB - plansza gry #2 (ekran gry #2)
                  .word $0C06
                  .word $E800       ; 1KB - plansza gry #3 (ekran gry #3)
                  .word $0C06
                  .word $EC00       ; 1KB - plansza gry #4 (ekran gry #4)
                  .word $0C06
                  .word $F000       ; 1KB - plansza gry #5 (ekran gry #5)
                  .word $0709

Attrib_Board1     .word $A000       ; 1KB atrybutw - plansza gry #1 (ekran gry #1)
                  .word $A400       ; 1KB atrybutw - plansza gry #2 (ekran gry #2)
                  .word $F400       ; 1KB atrybutw - plansza gry #3 (ekran gry #3)
                  .word $F800       ; 1KB atrybutw - plansza gry #4 (ekran gry #4)
                  .word $FC00       ; 1KB atrybutw - plansza gry #5 (ekran gry #5)

Is_Draw_Back_On_Collected_Bomb     dta $00 ; =1 rysuj na przerwaniu VBL to w miejscu zebranej BOMBY
index_Address_BOMBS2               dta $00 ; wskanik dla tablicy 'Buffor_Offset_in_tab_Screen_BOMB' skd pobieramy adres kolejnej migajcej bomby
Loop_All_BOMBS                     dta $00 ; licznik zliczajcy w ptli BOMBY
Counter_5th_BOMBS_to_Show_LETTER_B dta $00 ; licznik zliczajcy, e po 5-ciu zebranych BOMB-ach ma si pokaza "LITERA B" do zebrania
Counter_9th_BOMBS_to_Show_LETTER_P dta $00 ; licznik zliczajcy, e po 5-ciu zebranych BOMB-ach ma si pokaza "LITERA P" do zebrania
Counter_Collected_BOMBS            dta $00 ; zlicza ile BOMB zebra ju 'bomb jack'

tab_Screen_BOMB :@sw*@sh           dta $00 ; tablica odzwierciedlajca rozkad BOMB na ekranie gry (jeeli bajt=$01 tzn. e w tym miejscu jest lewy grny rg BOMB-y do zebrania przez BOMB JACK-a)
tab_Back32x26   :@sw*@sh           dta $00 ; tablica odzwierciedlajca plansze gry bez BOMB na ekranie gry

Offset_Bomb_to_Clear               .dw $0000 ; zawiera offset BOMBY, ktra podczas najbliszego przerwania VBL zostanie skasowana poprzez zapisanie w jej miejscu ta
Offset_Bomb_to_Blink               .dw $0000 ; zawiera offset BOMBY, ktra bdzie miga poprzez mazanie i ponowne rysowanie na przerwaniu VBL
Draw_Buffor                        .dw $0000 ; ustaw jaki aktualnie bufor ekranowy bdzie modyfikowany

Blink_BOMB                         dta $00     ; =0 rysuj migajc bomb (VBL), =1 zma migajc bomb (VBL)
;Bonus_x_Points                     dta $00     ; mnonik punktw jakie zdobywa 'bomb jack' (np: x1,x2,x3,x4)

choose_buff          dta $00                              ; wybr buffora B2 lub B3, na ktrym bdziemy rysowa

save_portb           dta $00 ; zapmituje na chwil rej. portb

; tab. 8-bajtowa (nr 0) - pierwszy wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score0       .byte $10,$00,$00
                  .byte $07,$15,$04
                  .byte $00,$00
; tab. 8-bajtowa (nr 1) - drugi wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score1       .byte $09,$00,$00
                  .byte $0C,$15,$0B
                  .byte $00,$00
; tab. 8-bajtowa (nr 2) - trzeci wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score2       .byte $08,$00,$00
                  .byte $17,$09,$16
                  .byte $00,$00
; tab. 8-bajtowa (nr 3) - czwarty wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score3       .byte $07,$00,$00
                  .byte $19,$0F,$12
                  .byte $00,$00
; tab. 8-bajtowa (nr 4) - pity wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score4       .byte $06,$00,$00
                  .byte $0E,$05,$17
                  .byte $00,$00
; tab. 8-bajtowa (nr 5) - szsty wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score5       .byte $05,$00,$00
                  .byte $0A,$0F,$02
                  .byte $00,$00
; tab. 8-bajtowa (nr 6) - sidmy wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score6       .byte $04,$90,$00
                  .byte $07,$12,$08
                  .byte $00,$00
; tab. 8-bajtowa (nr 7) - smy wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 4 bajty-ksywa(+$D0), 1 bajt-nieuywane)
tab8_score7       .byte $03,$80,$00
               ;  .byte $00,$00,$00
                  .byte $02,$19,$05
                  .byte $00,$00

; tutaj jest przepisywana cz listy HI-SCORE jeeli wpisano lepszy rezultat gracza na list HI-SCORE!
tab8_score_hide   .byte $00,$00,$00,$07,$01,$0B,$00,$00

; tablica 8-bajtowa
tab8_player1      .byte $00,$00,$00,$18,$18,$18,$00,$00

Is_Blink_PMG               dta $00 ; =1 migaj PMG #0
Counter_Collected_Letter_B dta $00 ; licznik ile zebrano "LITER B" na planszy
counter_show_Letter_E      dta $00 ; licznik ile wywietlono "LITER E" na planszy (w sumie max. to mona jedn zebra na planszy)

data_end = *

; .print 'Data uses: ',*-data_start,' bytes'

;              org free_mem

old_posy                           dta $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00 ; zapamituje star wsp.Y sprite'a #0-#7
old_patt                           dta $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00 ; zapamituje stary numer klatki animacyjnej sprite'a #0-#7
choose_PMG                         dta $00     ; 0 lub 1 - wskazuje jakie PMG jest aktualnie wykorzytywane do rysowania (a drugie wywietlane na ekranie)
choose_PMG_on_VBL                  dta $00     ; j.w. z tym, e to brane pod uwage podczas przerwania VBL
Smiling_Time                       dta $00     ; =1 aktualnie jest cigle czas zbierania 'umiechnitych buziek'

; zmienne ustawiane w programie obsugi sprite #0-#7
posx_P0        dta $00,$00 ; pozycja X dla gracza 0
posx_P1        dta $00,$00
posx_P2        dta $00,$00
posx_P3        dta $00,$00
posx_P4        dta $00,$00
posx_P5        dta $00,$00
posx_P6        dta $00,$00
posx_P7        dta $00,$00

posx_M0        dta $00,$00 ; pozycja X dla pocisku 0
posx_M1        dta $00,$00
posx_M2        dta $00,$00
posx_M3        dta $00,$00
posx_M4        dta $00,$00
posx_M5        dta $00,$00
posx_M6        dta $00,$00
posx_M7        dta $00,$00

col_PM0        dta $00     ; kolor dla gracza+pocisku 0
col_PM1        dta $00
col_PM2        dta $00
col_PM3        dta $00
col_PM4        dta $00
col_PM5        dta $00
col_PM6        dta $00
col_PM7        dta $00

; zmienne, do ktrych s przepisywane zmienne(patrz wyej) podczas przerwania VBL
posx_P0_vbl    dta $00 ; pozycja X dla gracza 0
posx_P1_vbl    dta $00 ; pozycja X dla gracza 1
posx_P2_vbl    dta $00 ; pozycja X dla gracza 2
posx_P3_vbl    dta $00 ; pozycja X dla gracza 3
posx_P4_vbl    dta $00 ; pozycja X dla gracza 4 (tworzony programowo - multiplexer PMG)
posx_P5_vbl    dta $00 ; pozycja X dla gracza 5 (tworzony programowo - multiplexer PMG)
posx_P6_vbl    dta $00
posx_P7_vbl    dta $00

posx_M0_vbl    dta $00 ; pozycja X dla pocisku 0
posx_M1_vbl    dta $00 ; pozycja X dla pocisku 1
posx_M2_vbl    dta $00 ; pozycja X dla pocisku 2
posx_M3_vbl    dta $00 ; pozycja X dla pocisku 3
posx_M4_vbl    dta $00 ; pozycja X dla pocisku 4
posx_M5_vbl    dta $00 ; pozycja X dla pocisku 5
posx_M6_vbl    dta $00
posx_M7_vbl    dta $00

col_PM0_vbl    dta $00 ; kolor dla gracza+pocisku 0
col_PM1_vbl    dta $00 ; kolor dla gracza+pocisku 1
col_PM2_vbl    dta $00 ; kolor dla gracza+pocisku 2
col_PM3_vbl    dta $00 ; kolor dla gracza+pocisku 3
col_PM4_vbl    dta $00 ; kolor dla gracza+pocisku 4
col_PM5_vbl    dta $00 ; kolor dla gracza+pocisku 5
col_PM6_vbl    dta $00
col_PM7_vbl    dta $00

size_P0_vbl    dta $00 ; szeroko dla gracza 0
size_P1_vbl    dta $00 ; szeroko dla gracza 1
size_P2_vbl    dta $00 ; szeroko dla gracza 2
size_P3_vbl    dta $00 ; szeroko dla gracza 3
size_P4_vbl    dta $00 ; szeroko dla gracza 4
size_P5_vbl    dta $00 ; szeroko dla gracza 5
size_P6_vbl    dta $00
size_P7_vbl    dta $00
size_MM_vbl    dta $00 ; szeroko pociskw

AddrDisplayList                      .dw $00 ; address of Display List
Time_Get_SmilingFace_Soon_Finish     .dw $0000 ; czas jaki zosta jeszcze na zebranie "UMIECHNITYCH BUZI" przez BOMB JACK-a

Random_Value                         dta $00 ; tutaj zapamitujemy losow warto...
Random_Value_x2                      dta $00 ; ...a tutaj zapamitujemy t sam warto x2

Do_Number_SPRITE_1_7                 dta $00 ; przechowuje, ktry SPRITE #1-#7 w danej chwili jest obsugiwany (przyjmuje wartoi: 0-6)
Counter_Move_Left_Right_Up_Down_Bird dta $32 ; licznik ile razy przesun "PTASZKA" z ustalonym ju kierunku (jeeli licznik dojdzie do -1 to "reset" i ponowne ustalanie kierunku ruchu "PTASZKA")
Choose_Move_Up_Down_Bird             dta $00 ; =1 ruch SPRITE'a w d,   =2 ruch w gr, =0 warto neutralna (na podstawie porwnania wsp.Y "PTASZKA" i BOMB JACKA bdzie wykonany ruch w gr lub w d)
Choose_Move_Left_Right_Bird          dta $00 ; =1 ruch SPRITE'a w prawo, =2 ruch w lewo, =0 warto neutralna (na podstawie porwnania wsp.X "PTASZKA" i BOMB JACKA bdzie wykonany ruch w lewo lub w prawo)
Service_Bird_Every_2th_Frame         dta $00 ; bit0 zminiany raz na 0, a raz na 1 - dziki temu obsuga "PTASZKA" jest realizowana co 2-g ramk

Time_Delay_Animate_Dead_BOMB_JACK    dta $00                          ; jak dugie ma by opnienie pomidzy klatkami animujcymi mier BOMB JACK-a

is_jack_left_or_right                dta $00                          ; Czy BJ natkn si na kadk z lewej lub prawej strony?
Is_Dance_BOMB_JACK                   dta $00                          ; Czy BOMB JACK taczy? (po zebraniu wszystkich BOMB na planszy)
Add_Value_to_Score_Player            dta $00,$00,$00                  ; warto dodawana do SCORE PLAYER

Add_PosY_BOMB_JACK_Better_Jump                dta $00                 ; ile naley doda do wsp.Y podczas skoku BOMB JACK-a (+5 jeeli skok tylko z FIRE, +6 jeeli skok z FIRE+UP)
Decrease_Value_Add_PosY_during_JUMP_BOMB_JACK dta $00                 ; zmniejsza warto dodawan do wsp.Y BOMB JACK-a podczas jego skoku

index_tab_Addr_SPRITE_ScreenBuff40x25         dta $00                 ; wskanik do tablicy "tab_Addr_SPRITE_ScreenBuff40x25"
                                                                      ; bajty 0,1: adres pozycji na ekranie jeeli wiersz=0
                                                                      ;    bajt 2: wsp.Y dla wiersza=0
                                                                      ; bajty 3,4: powtrka od pocztku! patrz bajty 0,1

Is_FIRE_Still_Pressed             dta $00                             ; =0 FIRE niewcinity, =1 FIRE wcinity i wci trzymany
Store_Action                      dta $00                             ; "kod akcji" dla kadego z 256 znakw w zestawie (np: $01 tzn. e to jest zielony margines lub kadka)
Sprite0_7_PosY_div_8              dta $00                             ; przechowuje wyliczony wiersz (wsp.Y / 8) dla SPRITE #x
Repeat_PosY_Ground                dta $00                             ; ile razy wykona ptle modyfikujc wsp.Y BOMB JACK-a (tak, eby zlecia na ziemie lub kadk po zablokowaniu jego lotu w gr)
Offset_PosY_Ground                dta $00                             ; o ile zmodyfikowa w kolejnym przejciu ptli wsp. Y BOMB JACK-a
Sprite0_7_PosX_8bit               dta $00                             ; zawiera 8-my bit wsp.X dla SPRITE'w #0 - #7
Sprite0_7_PosX_div_8              dta $00                             ; przechowuje wyliczon kolumne (wsp.X / 8) dla SPRITE #x
Is_Collision_with_LEDGE_BOMB_JACK dta $00                             ; czy BOMB JACK zderzy si z "KADK" (lub zielonym murkiem)?
Delay_Animate_Dead_BOMB_JACK      dta $00                             ; opnienie pomidzy wywietlaniem kolejnych klatek mierci BOMB JACK-a
index_tab_Bird_Over_BOMB_JACK     dta $00                             ; wskanik nastpnej klatki w tablicy poniej
Is_Dead_BOMB_JACK                 dta $00                             ; =1 zabito BOMB JACK-a!
is_anim_dead_bird                 .db $00                             ; =1 oznacza, e wanie jest animowany ptaszek mierci nad gow BJ

index_tab_Dead_BOMB_JACK          dta $00

Is_No_Flight_BOMB_JACK            dta $00                             ; =0 - BOMB JACK lata! / =1 - BOMB JACK nie lata!
Delay_Dance_BOMB_JACK             dta $00                             ; opnienie pomidzy kolejnymi klatkami robicymi animacje taczcego BOMB JACK-a
Dance_Nothing                     dta $00                             ; zbdna dana???? nie jest nigdzie w grze wykorzystywana
index_tab_Dance_BOMB_JACK         dta $00                             ; wskazuje na kolejn klatk cigu powodujcego taczenie BOMB JACK-a (po zebraniu wszystkich bomb)

__bta                             .dw 0                               ; uywane przez proc. dzielenia 'div'
__btb                             .dw 0
__rsl                             .dw 0
store_adr_buffor                  .dw $00                             ; suy do tymczasowego przechowywania adresu bufora, w ktrym bdziemy co dorysowywa (np: proc. rys. 'KADKI' lub 'BOMBY' wykorzystuj to)
Counter_Blink_BOMBS               dta $00                             ; licznik zebranych migajcych BOMB (jeeli zbierzemy 24 to pojawia si BONUS SCREEN)
count_draw                        dta $00                             ; licznik narysowanych BOMB na planszy
Is_Blink_BOMB                     dta $00                             ; =0 nie naley miga BOMB-, <>0 naley miga BOMB-

Store_help2                       dta $00                             ; przechowuj chwilowo pewne wartoci
Store_help4                       dta $00

Count_Bomb                        dta 0                               ; licznik zliczajcy ile BOMB narysowa
Pos_Bomb                          dta 0                               ; ile doda do pozycji X lub Y dla narysowania nastpnej BOMBY

Add_to_CoordinateX_Sprite_1_7                          dta $00                         ; warto, o ktr zwikszamy wsp.X (SPRITES #1-#7)
Add_to_CoordinateY_Sprite_1_7                          dta $00                         ; warto, o ktr zwikszamy wsp.Y (SPRITES #1-#7)

tab_After_255_Clips_Change_Behavior_UFO                dta $00,$00,$00,$00,$00,$00,$00 ; ($FF-$00) =$00 - zmie sposb zachowania "UFO"
tab_Every_Second_Frame_UFO_Sprite                      dta $00,$00,$00,$00,$00,$00,$00 ; 0 - rys. "UFO", 1- nie rys. "UFO" (rysowanie co 2-g ramk)

tab_Every_Second_Frame_Feeler_Ball_Sprite              dta $00,$00,$00,$00,$00,$00,$00 ; 0-rysuj "KUL Z CZUKAMI", 1-nie rysuj "KULI Z CZUKAMI" (dziki temu "KULA" jest rys. co 2 ramki)

tab_Move_Left_or_Right_Sprite_1_7                      dta $00,$00,$00,$00,$00,$00,$00 ; w ktr stron przesuwa si SPRITE #1-#7 (0 - w lewo, 1 - w prawo)

tab_Move_Up_or_Down_Sprite_1_7                         dta $00,$00,$00,$00,$00,$00,$00 ;  =1 SPRITE ma si przesuwa w d, =0 w gr

Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7  dta $00,$00,$00,$00,$00,$00,$00 ;  =0 testowa z prawej strony, =8 z lewej
Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7 dta $00,$00,$00,$00,$00,$00,$00 ;  =0 testowa z prawej strony, =8 z lewej

Is_Sprite1_7_Block_During_Move_Left                    dta $00,$00,$00,$00,$00,$00,$00 ;  =1 podczas ruchu w lewo SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Right_Side_Sprite1_7                       dta $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z prawej strony SPRITE'a

Is_Sprite1_7_Block_During_Move_Right                   dta $00,$00,$00,$00,$00,$00,$00 ; =1 podczas ruchu w prawo SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Left_Side_Sprite1_7                        dta $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z lewej strony SPRITE'a

Is_Sprite1_7_Block_During_Move_Up                      dta $00,$00,$00,$00,$00,$00,$00 ;  =1 podczas ruchu w gr SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Down_Side_Sprite1_7                        dta $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z dolnej strony SPRITE'a

Is_Sprite1_7_Block_During_Move_Down                    dta $00,$00,$00,$00,$00,$00,$00 ;  =1 podczas ruchu w d SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Up_Side_Sprite1_7                          dta $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z grnej strony SPRITE'a

Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7     dta $00,$00,$00,$00,$00,$00,$00 ;  =0 testowa z dolnej strony, =8 z grnej

tab_Delay_Points_100_600_SPRITES_1_7              dta $00,$00,$00,$00,$00,$00,$00 ; tablica zliczajca od 0-50, po osigniciu 50 SPRITE z punktami znika z widocznego ekranu (wic punkty na planszy gry wida tylko przez 1s)
tab_Points_100_600_SPRITES_1_7                    dta $00,$00,$00,$00,$00,$00,$00 ; zawiera aktualne adresy ((wskanik+$C0)*64+$4000) danych def. wzr SPRITE'a - punkty! (100-600) ($7040,$7080,$70C0....itd. - def.100, 200, 300....itd.)
Counter_Add_100_600_Points_for_Every_SmilingFace  dta $00                         ; licznik zwikszany o +1 po zebraniu kadej kolejnej "UMIECHNITEJ BUKI", dziki temu za kad kolejn zebran "BUK" dostajemy o 100 punktw wicej

 ;             org data_end

