
;-------------------------------;
;- Software Sprite Engine v1.9 -;
;-------------------------------;
;- changes: 09.01.2008          ;
;-------------------------------;

/*

 wersja zrwnowaona wzgldem szybkosci i pamicioernoci

 !!! w celu modyfikacji rozmiaru obrazu, wczenia/wyczenia detekcji kolizji naley modyfikowa plik ..GLOBAL\GLOBAL.HEA !!!

 !!! tylko jedna procedura tworzca ducha na stronie zerowej >> SHAPEZP << !!!
 !!! programy obsugi duchw B2CALC, B3CALC w dwch bankach pamici !!!

 sprite: 12x24 pixli na znakach, programy obsugi B2CALC i B3CALC, zmienna isSiz3=0
         maksymalnie 11 duchw w 2 ramkach (ekran 32x26 bez detekcji kolizji)

 sprite: 8x24 pixli na znakach, programy obsugi B2CALC i B3CALC, zmienna isSiz3<>0
 	 maksymalnie 14 duchw w 2 ramkach (ekran 32x26 bez detekcji kolizji)

 strona zerowa zajta jest od adresu ZPAGE przez procedur SHAPEZP i zmienne do ktrych przepisywane s parametry duchw
 aby doda nowe zmienne na stronie zerowej mona zmodyfikowa plik ..GLOBAL\GLOBAL.HEA (doda zmienne przez .DS)

 albo doda nowe zmienne od adresu freeZP bez potrzeby modyfikacji pliku ..GLOBAL\GLOBAL.HEA

 tablice przechowujce parametry duchw i ksztatw definiuj struktury @SPRITE i @SHAPE (plik DATA.ASM), rozmiar
 tych struktur decyduje o maksymalnej moliwej liczbie duchw i maksymalnej moliwej liczbie ksztatw

 MAX AVAILABLE SPRITES: maksymalna liczba duchw ktr moe przetworzy silnik = 256/@SPRITE
  MAX AVAILABLE SHAPES: maksymalna liczba ksztatw ktre moe przetworzy silnik = 256/@SHAPE

 dane klatek i masek animacji ducha umieszczone s w bankach dodatkowej pamici co $0800 bajtw
 maksymalnie w 1 banku mona przechowa 15 klatek animacji ducha 12x24 razem z klatkami przesunitymi o pixel

 $4000-$47FF SHP.SHR0		$6000-$67FF MSK.SHR0
 $4800-$4FFF SHP.SHR2		$6800-$6FFF MSK.SHR2
 $5000-$57FF SHP.SHR4		$7000-$77FF MSK.SHR4
 $5800-$5FFF SHP.SHR6		$7800-$7FFF MSK.SHR6

 SHP - bitmapa ksztatu ducha, bitmapa ksztatu potrzebna jest dla operacji ORA
 MSK - bitmapa maski ducha, maska wycina dziur w obrazie, dziki niej moemy take doda np. czarn obwdk
       na krawdzi ducha, bitmapa naski ducha potrzebna jest dla operacji AND

 SHR0, SHR2, SHR4, SHR6	- przesunite bitmapy o zadan liczb bitw (0,2,4,6)

 znaki wykorzystywane przez duchy przydzielane s dynamicznie, pierwszym wolnym znakiem jest !!! charsBAK !!!
 charsBAK wyznacza liczb znakw przeznaczonych na to <0..charsBAK-1>
 pozostae znaki <charsBAK..127> przeznaczone zostaj na duchy

*/

	icl 'global\global.hea'

speed	= $200			; aktualna liczba ramek, czyli szybko dziaania silnika pod adresem SPEED

@TAB_MEM_BANKS	= $0100		; tablica z kodami bankw dla rejestru $d301 (PORTB)

pmg0		= $0000		; adres pamici dla PMG #0
pmg1		= $0800		; adres pamici dla PMG #1

prg		= $1000		; adres programu, im niszy tym wicej cigego obszaru pamieci do wykorzystania

max_shapes	= 256/@SHAPE	; maksymalna dopuszczalna liczba ksztatw duchw (@SHAPE to struktura danych)

min_frames	= 2		; minimalna liczba klatek synchronizacji dla silnika poniej ktrej nie moe zej
				; to na wypadek gdyby silnik przetwarza mniejsz liczb duchw, wwczas widoczne byyby
				; przyspieszenia i zwolnienia albo gdyby silnik by uruchamiany na szybszej Atarce :)

max_sprites	= 8		; liczba duchw do wywietlenia


	ert max_sprites > 256/@SPRITE

	ert max_shapes > 256/@SHAPE

* ---	INIT

.local loading_jack
        icl 'init\tlo\loading_jack.asm'
.endl

	org prg

	icl 'global\@mem_detect.asm'

test_size_mem
        jsr @mem_detect
        cmp #[320-64]/16
        scc
        jmp show_loading_jack                   ; odpowiednia ilo pamici

no_mem  mva #$00 712
        sta      710
        mva #$0F 709

        mwa #mem_txt address1
        ldy #len_txt
        mva (address1),y (88),y-
        rpl
        jmp *

mem_txt dta d'             Too low memory!             '
        dta d'      You have to 320KB at least!        ',0
len_txt = *-mem_txt

	ini test_size_mem

	org $0600
	.ds 64
@PROC_ADD_BANK			; adres procedury przeczajcej banki dla LMB, NMB

* ---	BANKI PAMICI
	opt b+				; BANK SENSITIVE ON

; w MADS etykiety zdefiniowane w banku >0 sa zasigu lokalnego
; nieograniczony dostp do takich etykiet moliwy jest tylko z poziomu banku 0
;
	LMB #0				; startujemy od banku #0 z pamici podstawowej RAM $4000..$7FFF

* ---	PROCEDURY OBSLUGI DUCHA 12x24 i 8x24, BUFOR #2

.local	@@@tmp
	.link 'b2calc.obx'
.endl
B2CALC	= @@@tmp.BCALC			; etykieta lokalna B2CALC dla tego banku
B2INIT	= @@@tmp.BINIT

	.print 'RAM-BANK #0: $4000..',*


* ---	PROCEDURY OBSLUGI DUCHA 12x24 i 8x24, BUFOR #3

	NMB
	.link 'b3calc.obx'
B3CALC	= BCALC				; etykieta lokalna B3CALC dla tego banku
B3INIT	= BINIT

	.print 'EXT-BANK #1: $4000..',*


* ---	dane dla SHAPE0 co $800 bajtow
	NMB
	.pages $40

.local	shape0

	ins 'BJshape\BJ0.obx'

.endl
	.endpg


* ---	dane dla SHAPE1 co $0800 bajtow
	NMB
	.pages $40

.local	shape1

	ins 'BJshape\BJ1.obx'

.endl
	.endpg


* ---	dane dla SHAPE2 co $800 bajtow
	NMB
	.pages $40

.local	shape2

	ins 'BJshape\BJ2.obx'

.endl
	.endpg

* ---	dane dla SHAPE3 co $800 bajtow
	NMB
	.pages $40

.local	shape3

	ins 'BJshape\BJ3.obx'

.endl
	.endpg

* ---	dane dla SHAPE4 co $800 bajtow
	NMB
	.pages $40

.local	shape4

	ins 'BJshape\BJ4.obx'

.endl
	.endpg

* ---	dane dla SHAPE5 co $800 bajtow
	NMB
	.pages $40

.local	shape5

	ins 'BJshape\BJ5.obx'

.endl
	.endpg

* ---	dane dla SHAPE6 co $800 bajtow
	NMB
	.pages $40

.local	shape6

	ins 'BJshape\BJ6.obx'

.endl
	.endpg

;-----------------------------------------------
inz .macro
        ins :1
        ins :2
        rts
.endm

inp .macro
        ins :1
      .if :0=3
        jmp :3
      .else
        rts
      .endif
.endm

ina .macro
        ins :1
.def :3
        ins :2
        rts
.endm

; programy rysujce na PMG #0
	NMB
	.pages $40
pmg0_jack_st   inz 'BJshapePMG\pmg\pmg0000_pla0_07x00.pmg','BJshapePMG\pmg\pmg0000_mis0_07x00.pmg'
pmg0_jack_up   inz 'BJshapePMG\pmg\pmg0000_pla0_07x01.pmg','BJshapePMG\pmg\pmg0000_mis0_07x01.pmg'
pmg0_jack_dn   inz 'BJshapePMG\pmg\pmg0000_pla0_07x02.pmg','BJshapePMG\pmg\pmg0000_mis0_07x02.pmg'
pmg0_jack_rd   inz 'BJshapePMG\pmg\pmg0000_pla0_07x03.pmg','BJshapePMG\pmg\pmg0000_mis0_07x03.pmg'
pmg0_jack_ld   inz 'BJshapePMG\pmg\pmg0000_pla0_07x04.pmg','BJshapePMG\pmg\pmg0000_mis0_07x04.pmg'
pmg0_jack_ri   inz 'BJshapePMG\pmg\pmg0000_pla0_07x05.pmg','BJshapePMG\pmg\pmg0000_mis0_07x05.pmg'
pmg0_jack_le   inz 'BJshapePMG\pmg\pmg0000_pla0_07x06.pmg','BJshapePMG\pmg\pmg0000_mis0_07x06.pmg'
pmg0_jack_de   inz 'BJshapePMG\pmg\pmg0000_pla0_07x07.pmg','BJshapePMG\pmg\pmg0000_mis0_07x07.pmg'
pmg0_jack_da01 inz 'BJshapePMG\pmg\pmg0000_pla0_07x08.pmg','BJshapePMG\pmg\pmg0000_mis0_07x08.pmg'
pmg0_jack_da02 inz 'BJshapePMG\pmg\pmg0000_pla0_08x00.pmg','BJshapePMG\pmg\pmg0000_mis0_08x00.pmg'
pmg0_jack_da03 inz 'BJshapePMG\pmg\pmg0000_pla0_08x01.pmg','BJshapePMG\pmg\pmg0000_mis0_08x01.pmg'
pmg0_jack_mr01 inz 'BJshapePMG\pmg\pmg0000_pla0_08x02.pmg','BJshapePMG\pmg\pmg0000_mis0_08x02.pmg'
pmg0_jack_mr02 inz 'BJshapePMG\pmg\pmg0000_pla0_08x03.pmg','BJshapePMG\pmg\pmg0000_mis0_08x03.pmg'
pmg0_jack_mr03 inz 'BJshapePMG\pmg\pmg0000_pla0_08x04.pmg','BJshapePMG\pmg\pmg0000_mis0_08x04.pmg'
pmg0_jack_mr04 inz 'BJshapePMG\pmg\pmg0000_pla0_08x05.pmg','BJshapePMG\pmg\pmg0000_mis0_08x05.pmg'
pmg0_jack_ml01 inz 'BJshapePMG\pmg\pmg0000_pla0_08x06.pmg','BJshapePMG\pmg\pmg0000_mis0_08x06.pmg'
pmg0_jack_ml02 inz 'BJshapePMG\pmg\pmg0000_pla0_08x07.pmg','BJshapePMG\pmg\pmg0000_mis0_08x07.pmg'
pmg0_jack_ml03 inz 'BJshapePMG\pmg\pmg0000_pla0_08x08.pmg','BJshapePMG\pmg\pmg0000_mis0_08x08.pmg'
pmg0_jack_ml04 inz 'BJshapePMG\pmg\pmg0000_pla0_08x09.pmg','BJshapePMG\pmg\pmg0000_mis0_08x09.pmg'
pmg0_bird_de01 inz 'BJshapePMG\pmg\pmg0000_pla0_09x00.pmg','BJshapePMG\pmg\pmg0000_mis0_09x00.pmg'
pmg0_bird_de02 inz 'BJshapePMG\pmg\pmg0000_pla0_09x01.pmg','BJshapePMG\pmg\pmg0000_mis0_09x01.pmg'
pmg0_bird_de03 inz 'BJshapePMG\pmg\pmg0000_pla0_09x02.pmg','BJshapePMG\pmg\pmg0000_mis0_09x02.pmg'

len_jack = *-pmg0_jack_st

pmg0_jack_08   inz 'BJshapePMG\pmg\pmg0800_pla0_07x00.pmg','BJshapePMG\pmg\pmg0800_mis0_07x00.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x01.pmg','BJshapePMG\pmg\pmg0800_mis0_07x01.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x02.pmg','BJshapePMG\pmg\pmg0800_mis0_07x02.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x03.pmg','BJshapePMG\pmg\pmg0800_mis0_07x03.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x04.pmg','BJshapePMG\pmg\pmg0800_mis0_07x04.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x05.pmg','BJshapePMG\pmg\pmg0800_mis0_07x05.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x06.pmg','BJshapePMG\pmg\pmg0800_mis0_07x06.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x07.pmg','BJshapePMG\pmg\pmg0800_mis0_07x07.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_07x08.pmg','BJshapePMG\pmg\pmg0800_mis0_07x08.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x00.pmg','BJshapePMG\pmg\pmg0800_mis0_08x00.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x01.pmg','BJshapePMG\pmg\pmg0800_mis0_08x01.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x02.pmg','BJshapePMG\pmg\pmg0800_mis0_08x02.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x03.pmg','BJshapePMG\pmg\pmg0800_mis0_08x03.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x04.pmg','BJshapePMG\pmg\pmg0800_mis0_08x04.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x05.pmg','BJshapePMG\pmg\pmg0800_mis0_08x05.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x06.pmg','BJshapePMG\pmg\pmg0800_mis0_08x06.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x07.pmg','BJshapePMG\pmg\pmg0800_mis0_08x07.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x08.pmg','BJshapePMG\pmg\pmg0800_mis0_08x08.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_08x09.pmg','BJshapePMG\pmg\pmg0800_mis0_08x09.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_09x00.pmg','BJshapePMG\pmg\pmg0800_mis0_09x00.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_09x01.pmg','BJshapePMG\pmg\pmg0800_mis0_09x01.pmg'
               inz 'BJshapePMG\pmg\pmg0800_pla0_09x02.pmg','BJshapePMG\pmg\pmg0800_mis0_09x02.pmg'

board5	 ins 'init\tlo\s5.gz'
;--------------------------------
pmg0_clr_pla0
     lda is_anim_dead_bird                        ; Czy BJ jest martwy?
     seq                                          ; TAK! wic nie kasuj rysownia na PMG #0 (dziki temu BJ i ptaszek mierci nad jego gow bd mi biay kolor)
     ldy posy
     lda #0
     :21 sta pmg0+$400+y_pmg+#,y
     .rept 21
       lda pmg0+$300+y_pmg+#,y
       and #%11111100
       sta pmg0+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg1_clr_pla0
     lda is_anim_dead_bird                        ; Czy BJ jest martwy?
     seq                                          ; TAK! wic nie kasuj rysownia na PMG #0 (dziki temu BJ i ptaszek mierci nad jego gow bd mi biay kolor)
     ldy posy
     lda #0
     :21 sta pmg1+$400+y_pmg+#,y
     .rept 21
       lda pmg1+$300+y_pmg+#,y
       and #%11111100
       sta pmg1+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg0_clr_pla1
     lda #0
     :21 sta pmg0+$500+y_pmg+#,y
     .rept 21
       lda pmg0+$300+y_pmg+#,y
       and #%11110011
       sta pmg0+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg1_clr_pla1
     lda #0
     :21  sta pmg1+$500+y_pmg+#,y
     .rept 21
       lda pmg1+$300+y_pmg+#,y
       and #%11110011
       sta pmg1+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg0_clr_pla2
     lda #0
     :21  sta pmg0+$600+y_pmg+#,y
     .rept 21
       lda pmg0+$300+y_pmg+#,y
       and #%11001111
       sta pmg0+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg1_clr_pla2
     lda #0
     :21  sta pmg1+$600+y_pmg+#,y
     .rept 21
       lda pmg1+$300+y_pmg+#,y
       and #%11001111
       sta pmg1+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg0_clr_pla3
     lda #0
     :21  sta pmg0+$700+y_pmg+#,y
     .rept 21
       lda pmg0+$300+y_pmg+#,y
       and #%00111111
       sta pmg0+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------
pmg1_clr_pla3
     lda #0
     :21  sta pmg1+$700+y_pmg+#,y
     .rept 21
       lda pmg1+$300+y_pmg+#,y
       and #%00111111
       sta pmg1+$300+y_pmg+#,y
     .endr
     rts
;--------------------------------

.print "adr: ",*," len: ",*-pmg0_jack_st
        .endpg

; programy rysujce na PMG #1
	NMB
	.pages $40
pmg1_squar_b01 ina 'BJshapePMG\pmg\pmg0000_pla1_00x00.pmg','BJshapePMG\pmg\pmg0000_mis1_00x00.pmg',pmg0_squar_b01_clr_mis1
pmg1_squar_b02 inp 'BJshapePMG\pmg\pmg0000_pla1_00x01.pmg','BJshapePMG\pmg\pmg0000_mis1_00x01.pmg',pmg0_squar_b01_clr_mis1
pmg1_squar_b03 inp 'BJshapePMG\pmg\pmg0000_pla1_00x02.pmg','BJshapePMG\pmg\pmg0000_mis1_00x02.pmg',pmg0_squar_b01_clr_mis1
pmg1_squar_b04 inz 'BJshapePMG\pmg\pmg0000_pla1_00x03.pmg','BJshapePMG\pmg\pmg0000_mis1_00x03.pmg'
pmg1_squar_b05 inz 'BJshapePMG\pmg\pmg0000_pla1_00x04.pmg','BJshapePMG\pmg\pmg0000_mis1_00x04.pmg'
pmg1_squar_b06 inp 'BJshapePMG\pmg\pmg0000_pla1_00x05.pmg','BJshapePMG\pmg\pmg0000_mis1_00x05.pmg',pmg0_squar_b01_clr_mis1
pmg1_dot_b01   inz 'BJshapePMG\pmg\pmg0000_pla1_00x06.pmg','BJshapePMG\pmg\pmg0000_mis1_00x06.pmg'
pmg1_dot_b02   inz 'BJshapePMG\pmg\pmg0000_pla1_00x07.pmg','BJshapePMG\pmg\pmg0000_mis1_00x07.pmg'
pmg1_dot_b03   inz 'BJshapePMG\pmg\pmg0000_pla1_00x08.pmg','BJshapePMG\pmg\pmg0000_mis1_00x08.pmg'
pmg1_bird_r01  inz 'BJshapePMG\pmg\pmg0000_pla1_01x00.pmg','BJshapePMG\pmg\pmg0000_mis1_01x00.pmg'
pmg1_bird_r02  ina 'BJshapePMG\pmg\pmg0000_pla1_01x01.pmg','BJshapePMG\pmg\pmg0000_mis1_01x01.pmg',pmg0_bird_r02_clr_mis1
pmg1_bird_r03  inp 'BJshapePMG\pmg\pmg0000_pla1_01x02.pmg','BJshapePMG\pmg\pmg0000_mis1_01x02.pmg',pmg0_bird_r02_clr_mis1
pmg1_bird_l01  inz 'BJshapePMG\pmg\pmg0000_pla1_01x03.pmg','BJshapePMG\pmg\pmg0000_mis1_01x03.pmg'
pmg1_bird_l02  inz 'BJshapePMG\pmg\pmg0000_pla1_01x04.pmg','BJshapePMG\pmg\pmg0000_mis1_01x04.pmg'
pmg1_bird_l03  inz 'BJshapePMG\pmg\pmg0000_pla1_01x05.pmg','BJshapePMG\pmg\pmg0000_mis1_01x05.pmg'
pmg1_bird_d01  inz 'BJshapePMG\pmg\pmg0000_pla1_01x06.pmg','BJshapePMG\pmg\pmg0000_mis1_01x06.pmg'
pmg1_bird_d02  inz 'BJshapePMG\pmg\pmg0000_pla1_01x07.pmg','BJshapePMG\pmg\pmg0000_mis1_01x07.pmg'
pmg1_bird_d03  inz 'BJshapePMG\pmg\pmg0000_pla1_01x08.pmg','BJshapePMG\pmg\pmg0000_mis1_01x08.pmg'
pmg1_feele_b01 inz 'BJshapePMG\pmg\pmg0000_pla1_02x05.pmg','BJshapePMG\pmg\pmg0000_mis1_02x05.pmg'
pmg1_feele_b02 inp 'BJshapePMG\pmg\pmg0000_pla1_02x06.pmg','BJshapePMG\pmg\pmg0000_mis1_02x06.pmg',pmg0_squar_b01_clr_mis1
pmg1_feele_b03 inz 'BJshapePMG\pmg\pmg0000_pla1_02x07.pmg','BJshapePMG\pmg\pmg0000_mis1_02x07.pmg'
pmg1_feele_b04 inp 'BJshapePMG\pmg\pmg0000_pla1_02x08.pmg','BJshapePMG\pmg\pmg0000_mis1_02x08.pmg',pmg0_squar_b01_clr_mis1
pmg1_UFO01     inz 'BJshapePMG\pmg\pmg0000_pla1_03x05.pmg','BJshapePMG\pmg\pmg0000_mis1_03x05.pmg'
pmg1_UFO02     inp 'BJshapePMG\pmg\pmg0000_pla1_03x06.pmg','BJshapePMG\pmg\pmg0000_mis1_03x06.pmg',pmg0_squar_b01_clr_mis1
pmg1_UFO03     inz 'BJshapePMG\pmg\pmg0000_pla1_03x07.pmg','BJshapePMG\pmg\pmg0000_mis1_03x07.pmg'
pmg1_astro_r01 inp 'BJshapePMG\pmg\pmg0000_pla1_04x00.pmg','BJshapePMG\pmg\pmg0000_mis1_04x00.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_r02 inp 'BJshapePMG\pmg\pmg0000_pla1_04x01.pmg','BJshapePMG\pmg\pmg0000_mis1_04x01.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_r03 inp 'BJshapePMG\pmg\pmg0000_pla1_04x02.pmg','BJshapePMG\pmg\pmg0000_mis1_04x02.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_r04 inp 'BJshapePMG\pmg\pmg0000_pla1_04x03.pmg','BJshapePMG\pmg\pmg0000_mis1_04x03.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_l01 inp 'BJshapePMG\pmg\pmg0000_pla1_04x04.pmg','BJshapePMG\pmg\pmg0000_mis1_04x04.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_l02 inp 'BJshapePMG\pmg\pmg0000_pla1_04x05.pmg','BJshapePMG\pmg\pmg0000_mis1_04x05.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_l03 inp 'BJshapePMG\pmg\pmg0000_pla1_04x06.pmg','BJshapePMG\pmg\pmg0000_mis1_04x06.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_l04 inp 'BJshapePMG\pmg\pmg0000_pla1_04x07.pmg','BJshapePMG\pmg\pmg0000_mis1_04x07.pmg',pmg0_squar_b01_clr_mis1
pmg1_astro_d01 inp 'BJshapePMG\pmg\pmg0000_pla1_04x08.pmg','BJshapePMG\pmg\pmg0000_mis1_04x08.pmg',pmg0_squar_b01_clr_mis1
pmg1_opp_ape01 inz 'BJshapePMG\pmg\pmg0000_pla1_05x05.pmg','BJshapePMG\pmg\pmg0000_mis1_05x05.pmg'
pmg1_opp_ape02 inp 'BJshapePMG\pmg\pmg0000_pla1_05x06.pmg','BJshapePMG\pmg\pmg0000_mis1_05x06.pmg',pmg0_squar_b01_clr_mis1
pmg1_opp_ape03 inz 'BJshapePMG\pmg\pmg0000_pla1_05x07.pmg','BJshapePMG\pmg\pmg0000_mis1_05x07.pmg'
pmg1_smil_fa01 ina 'BJshapePMG\pmg\pmg0000_pla1_03x00.pmg','BJshapePMG\pmg\pmg0000_mis1_03x00.pmg',pmg0_smil_fa01_clr_mis1
pmg1_smil_fa02 inp 'BJshapePMG\pmg\pmg0000_pla1_03x01.pmg','BJshapePMG\pmg\pmg0000_mis1_03x01.pmg',pmg0_smil_fa01_clr_mis1
pmg1_smil_fa03 inp 'BJshapePMG\pmg\pmg0000_pla1_03x02.pmg','BJshapePMG\pmg\pmg0000_mis1_03x02.pmg',pmg0_smil_fa01_clr_mis1
pmg1_smil_fa04 inp 'BJshapePMG\pmg\pmg0000_pla1_03x03.pmg','BJshapePMG\pmg\pmg0000_mis1_03x03.pmg',pmg0_smil_fa01_clr_mis1
pmg1_smil_fa05 inp 'BJshapePMG\pmg\pmg0000_pla1_03x04.pmg','BJshapePMG\pmg\pmg0000_mis1_03x04.pmg',pmg0_smil_fa01_clr_mis1
pmg1_drill_l01 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx00.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx00.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_l02 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx01.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx01.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_l03 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx02.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx02.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_l04 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx03.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx03.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_r01 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx04.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx04.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_r02 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx05.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx05.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_r03 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx06.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx06.pmg',pmg0_squar_b01_clr_mis1
pmg1_drill_r04 inp 'BJshapePMG\pmg\pmg0000_pla1_0Bx07.pmg','BJshapePMG\pmg\pmg0000_mis1_0Bx07.pmg',pmg0_squar_b01_clr_mis1
len_opponent = *-pmg1_squar_b01

pmg1_squar_08
 ina 'BJshapePMG\pmg\pmg0800_pla1_00x00.pmg','BJshapePMG\pmg\pmg0800_mis1_00x00.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_00x01.pmg','BJshapePMG\pmg\pmg0800_mis1_00x01.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_00x02.pmg','BJshapePMG\pmg\pmg0800_mis1_00x02.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_00x03.pmg','BJshapePMG\pmg\pmg0800_mis1_00x03.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_00x04.pmg','BJshapePMG\pmg\pmg0800_mis1_00x04.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla1_00x05.pmg','BJshapePMG\pmg\pmg0800_mis1_00x05.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_00x06.pmg','BJshapePMG\pmg\pmg0800_mis1_00x06.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_00x07.pmg','BJshapePMG\pmg\pmg0800_mis1_00x07.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_00x08.pmg','BJshapePMG\pmg\pmg0800_mis1_00x08.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x00.pmg','BJshapePMG\pmg\pmg0800_mis1_01x00.pmg'
 ina 'BJshapePMG\pmg\pmg0800_pla1_01x01.pmg','BJshapePMG\pmg\pmg0800_mis1_01x01.pmg',pmg1_bird_r02_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_01x02.pmg','BJshapePMG\pmg\pmg0800_mis1_01x02.pmg',pmg1_bird_r02_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x03.pmg','BJshapePMG\pmg\pmg0800_mis1_01x03.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x04.pmg','BJshapePMG\pmg\pmg0800_mis1_01x04.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x05.pmg','BJshapePMG\pmg\pmg0800_mis1_01x05.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x06.pmg','BJshapePMG\pmg\pmg0800_mis1_01x06.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x07.pmg','BJshapePMG\pmg\pmg0800_mis1_01x07.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_01x08.pmg','BJshapePMG\pmg\pmg0800_mis1_01x08.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla1_02x05.pmg','BJshapePMG\pmg\pmg0800_mis1_02x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla1_02x06.pmg','BJshapePMG\pmg\pmg0800_mis1_02x06.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_02x07.pmg','BJshapePMG\pmg\pmg0800_mis1_02x07.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla1_02x08.pmg','BJshapePMG\pmg\pmg0800_mis1_02x08.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_03x05.pmg','BJshapePMG\pmg\pmg0800_mis1_03x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla1_03x06.pmg','BJshapePMG\pmg\pmg0800_mis1_03x06.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_03x07.pmg','BJshapePMG\pmg\pmg0800_mis1_03x07.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x00.pmg','BJshapePMG\pmg\pmg0800_mis1_04x00.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x01.pmg','BJshapePMG\pmg\pmg0800_mis1_04x01.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x02.pmg','BJshapePMG\pmg\pmg0800_mis1_04x02.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x03.pmg','BJshapePMG\pmg\pmg0800_mis1_04x03.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x04.pmg','BJshapePMG\pmg\pmg0800_mis1_04x04.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x05.pmg','BJshapePMG\pmg\pmg0800_mis1_04x05.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x06.pmg','BJshapePMG\pmg\pmg0800_mis1_04x06.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x07.pmg','BJshapePMG\pmg\pmg0800_mis1_04x07.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_04x08.pmg','BJshapePMG\pmg\pmg0800_mis1_04x08.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_05x05.pmg','BJshapePMG\pmg\pmg0800_mis1_05x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla1_05x06.pmg','BJshapePMG\pmg\pmg0800_mis1_05x06.pmg',pmg1_squar_b01_clr_mis1
 inz 'BJshapePMG\pmg\pmg0800_pla1_05x07.pmg','BJshapePMG\pmg\pmg0800_mis1_05x07.pmg'
 ina 'BJshapePMG\pmg\pmg0800_pla1_03x00.pmg','BJshapePMG\pmg\pmg0800_mis1_03x00.pmg',pmg1_smil_fa01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_03x01.pmg','BJshapePMG\pmg\pmg0800_mis1_03x01.pmg',pmg1_smil_fa01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_03x02.pmg','BJshapePMG\pmg\pmg0800_mis1_03x02.pmg',pmg1_smil_fa01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_03x03.pmg','BJshapePMG\pmg\pmg0800_mis1_03x03.pmg',pmg1_smil_fa01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_03x04.pmg','BJshapePMG\pmg\pmg0800_mis1_03x04.pmg',pmg1_smil_fa01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx00.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx00.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx01.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx01.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx02.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx02.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx03.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx03.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx04.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx04.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx05.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx05.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx06.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx06.pmg',pmg1_squar_b01_clr_mis1
 inp 'BJshapePMG\pmg\pmg0800_pla1_0Bx07.pmg','BJshapePMG\pmg\pmg0800_mis1_0Bx07.pmg',pmg1_squar_b01_clr_mis1
	.endpg

; programy rysujce na PMG #2
	NMB
	.pages $40
pmg2_squar_b01 ina 'BJshapePMG\pmg\pmg0000_pla2_00x00.pmg','BJshapePMG\pmg\pmg0000_mis2_00x00.pmg',pmg0_squar_b01_clr_mis2
pmg2_squar_b02 inp 'BJshapePMG\pmg\pmg0000_pla2_00x01.pmg','BJshapePMG\pmg\pmg0000_mis2_00x01.pmg',pmg0_squar_b01_clr_mis2
pmg2_squar_b03 inp 'BJshapePMG\pmg\pmg0000_pla2_00x02.pmg','BJshapePMG\pmg\pmg0000_mis2_00x02.pmg',pmg0_squar_b01_clr_mis2
pmg2_squar_b04 inz 'BJshapePMG\pmg\pmg0000_pla2_00x03.pmg','BJshapePMG\pmg\pmg0000_mis2_00x03.pmg'
pmg2_squar_b05 inz 'BJshapePMG\pmg\pmg0000_pla2_00x04.pmg','BJshapePMG\pmg\pmg0000_mis2_00x04.pmg'
pmg2_squar_b06 inp 'BJshapePMG\pmg\pmg0000_pla2_00x05.pmg','BJshapePMG\pmg\pmg0000_mis2_00x05.pmg',pmg0_squar_b01_clr_mis2
pmg2_dot_b01   inz 'BJshapePMG\pmg\pmg0000_pla2_00x06.pmg','BJshapePMG\pmg\pmg0000_mis2_00x06.pmg'
pmg2_dot_b02   inz 'BJshapePMG\pmg\pmg0000_pla2_00x07.pmg','BJshapePMG\pmg\pmg0000_mis2_00x07.pmg'
pmg2_dot_b03   inz 'BJshapePMG\pmg\pmg0000_pla2_00x08.pmg','BJshapePMG\pmg\pmg0000_mis2_00x08.pmg'
pmg2_bird_r01  inz 'BJshapePMG\pmg\pmg0000_pla2_01x00.pmg','BJshapePMG\pmg\pmg0000_mis2_01x00.pmg'
pmg2_bird_r02  ina 'BJshapePMG\pmg\pmg0000_pla2_01x01.pmg','BJshapePMG\pmg\pmg0000_mis2_01x01.pmg',pmg0_bird_r02_clr_mis2
pmg2_bird_r03  inp 'BJshapePMG\pmg\pmg0000_pla2_01x02.pmg','BJshapePMG\pmg\pmg0000_mis2_01x02.pmg',pmg0_bird_r02_clr_mis2
pmg2_bird_l01  inz 'BJshapePMG\pmg\pmg0000_pla2_01x03.pmg','BJshapePMG\pmg\pmg0000_mis2_01x03.pmg'
pmg2_bird_l02  inz 'BJshapePMG\pmg\pmg0000_pla2_01x04.pmg','BJshapePMG\pmg\pmg0000_mis2_01x04.pmg'
pmg2_bird_l03  inz 'BJshapePMG\pmg\pmg0000_pla2_01x05.pmg','BJshapePMG\pmg\pmg0000_mis2_01x05.pmg'
pmg2_bird_d01  inz 'BJshapePMG\pmg\pmg0000_pla2_01x06.pmg','BJshapePMG\pmg\pmg0000_mis2_01x06.pmg'
pmg2_bird_d02  inz 'BJshapePMG\pmg\pmg0000_pla2_01x07.pmg','BJshapePMG\pmg\pmg0000_mis2_01x07.pmg'
pmg2_bird_d03  inz 'BJshapePMG\pmg\pmg0000_pla2_01x08.pmg','BJshapePMG\pmg\pmg0000_mis2_01x08.pmg'
pmg2_feele_b01 inz 'BJshapePMG\pmg\pmg0000_pla2_02x05.pmg','BJshapePMG\pmg\pmg0000_mis2_02x05.pmg'
pmg2_feele_b02 inp 'BJshapePMG\pmg\pmg0000_pla2_02x06.pmg','BJshapePMG\pmg\pmg0000_mis2_02x06.pmg',pmg0_squar_b01_clr_mis2
pmg2_feele_b03 inz 'BJshapePMG\pmg\pmg0000_pla2_02x07.pmg','BJshapePMG\pmg\pmg0000_mis2_02x07.pmg'
pmg2_feele_b04 inp 'BJshapePMG\pmg\pmg0000_pla2_02x08.pmg','BJshapePMG\pmg\pmg0000_mis2_02x08.pmg',pmg0_squar_b01_clr_mis2
pmg2_UFO01     inz 'BJshapePMG\pmg\pmg0000_pla2_03x05.pmg','BJshapePMG\pmg\pmg0000_mis2_03x05.pmg'
pmg2_UFO02     inp 'BJshapePMG\pmg\pmg0000_pla2_03x06.pmg','BJshapePMG\pmg\pmg0000_mis2_03x06.pmg',pmg0_squar_b01_clr_mis2
pmg2_UFO03     inz 'BJshapePMG\pmg\pmg0000_pla2_03x07.pmg','BJshapePMG\pmg\pmg0000_mis2_03x07.pmg'
pmg2_astro_r01 inp 'BJshapePMG\pmg\pmg0000_pla2_04x00.pmg','BJshapePMG\pmg\pmg0000_mis2_04x00.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_r02 inp 'BJshapePMG\pmg\pmg0000_pla2_04x01.pmg','BJshapePMG\pmg\pmg0000_mis2_04x01.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_r03 inp 'BJshapePMG\pmg\pmg0000_pla2_04x02.pmg','BJshapePMG\pmg\pmg0000_mis2_04x02.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_r04 inp 'BJshapePMG\pmg\pmg0000_pla2_04x03.pmg','BJshapePMG\pmg\pmg0000_mis2_04x03.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_l01 inp 'BJshapePMG\pmg\pmg0000_pla2_04x04.pmg','BJshapePMG\pmg\pmg0000_mis2_04x04.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_l02 inp 'BJshapePMG\pmg\pmg0000_pla2_04x05.pmg','BJshapePMG\pmg\pmg0000_mis2_04x05.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_l03 inp 'BJshapePMG\pmg\pmg0000_pla2_04x06.pmg','BJshapePMG\pmg\pmg0000_mis2_04x06.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_l04 inp 'BJshapePMG\pmg\pmg0000_pla2_04x07.pmg','BJshapePMG\pmg\pmg0000_mis2_04x07.pmg',pmg0_squar_b01_clr_mis2
pmg2_astro_d01 inp 'BJshapePMG\pmg\pmg0000_pla2_04x08.pmg','BJshapePMG\pmg\pmg0000_mis2_04x08.pmg',pmg0_squar_b01_clr_mis2
pmg2_opp_ape01 inz 'BJshapePMG\pmg\pmg0000_pla2_05x05.pmg','BJshapePMG\pmg\pmg0000_mis2_05x05.pmg'
pmg2_opp_ape02 inp 'BJshapePMG\pmg\pmg0000_pla2_05x06.pmg','BJshapePMG\pmg\pmg0000_mis2_05x06.pmg',pmg0_squar_b01_clr_mis2
pmg2_opp_ape03 inz 'BJshapePMG\pmg\pmg0000_pla2_05x07.pmg','BJshapePMG\pmg\pmg0000_mis2_05x07.pmg'
pmg2_smil_fa01 ina 'BJshapePMG\pmg\pmg0000_pla2_03x00.pmg','BJshapePMG\pmg\pmg0000_mis2_03x00.pmg',pmg0_smil_fa01_clr_mis2
pmg2_smil_fa02 inp 'BJshapePMG\pmg\pmg0000_pla2_03x01.pmg','BJshapePMG\pmg\pmg0000_mis2_03x01.pmg',pmg0_smil_fa01_clr_mis2
pmg2_smil_fa03 inp 'BJshapePMG\pmg\pmg0000_pla2_03x02.pmg','BJshapePMG\pmg\pmg0000_mis2_03x02.pmg',pmg0_smil_fa01_clr_mis2
pmg2_smil_fa04 inp 'BJshapePMG\pmg\pmg0000_pla2_03x03.pmg','BJshapePMG\pmg\pmg0000_mis2_03x03.pmg',pmg0_smil_fa01_clr_mis2
pmg2_smil_fa05 inp 'BJshapePMG\pmg\pmg0000_pla2_03x04.pmg','BJshapePMG\pmg\pmg0000_mis2_03x04.pmg',pmg0_smil_fa01_clr_mis2
pmg2_drill_l01 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx00.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx00.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_l02 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx01.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx01.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_l03 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx02.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx02.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_l04 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx03.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx03.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_r01 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx04.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx04.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_r02 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx05.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx05.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_r03 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx06.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx06.pmg',pmg0_squar_b01_clr_mis2
pmg2_drill_r04 inp 'BJshapePMG\pmg\pmg0000_pla2_0Bx07.pmg','BJshapePMG\pmg\pmg0000_mis2_0Bx07.pmg',pmg0_squar_b01_clr_mis2

pmg2_squar_08
 ina 'BJshapePMG\pmg\pmg0800_pla2_00x00.pmg','BJshapePMG\pmg\pmg0800_mis2_00x00.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_00x01.pmg','BJshapePMG\pmg\pmg0800_mis2_00x01.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_00x02.pmg','BJshapePMG\pmg\pmg0800_mis2_00x02.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_00x03.pmg','BJshapePMG\pmg\pmg0800_mis2_00x03.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_00x04.pmg','BJshapePMG\pmg\pmg0800_mis2_00x04.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla2_00x05.pmg','BJshapePMG\pmg\pmg0800_mis2_00x05.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_00x06.pmg','BJshapePMG\pmg\pmg0800_mis2_00x06.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_00x07.pmg','BJshapePMG\pmg\pmg0800_mis2_00x07.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_00x08.pmg','BJshapePMG\pmg\pmg0800_mis2_00x08.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x00.pmg','BJshapePMG\pmg\pmg0800_mis2_01x00.pmg'
 ina 'BJshapePMG\pmg\pmg0800_pla2_01x01.pmg','BJshapePMG\pmg\pmg0800_mis2_01x01.pmg',pmg1_bird_r02_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_01x02.pmg','BJshapePMG\pmg\pmg0800_mis2_01x02.pmg',pmg1_bird_r02_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x03.pmg','BJshapePMG\pmg\pmg0800_mis2_01x03.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x04.pmg','BJshapePMG\pmg\pmg0800_mis2_01x04.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x05.pmg','BJshapePMG\pmg\pmg0800_mis2_01x05.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x06.pmg','BJshapePMG\pmg\pmg0800_mis2_01x06.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x07.pmg','BJshapePMG\pmg\pmg0800_mis2_01x07.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_01x08.pmg','BJshapePMG\pmg\pmg0800_mis2_01x08.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla2_02x05.pmg','BJshapePMG\pmg\pmg0800_mis2_02x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla2_02x06.pmg','BJshapePMG\pmg\pmg0800_mis2_02x06.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_02x07.pmg','BJshapePMG\pmg\pmg0800_mis2_02x07.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla2_02x08.pmg','BJshapePMG\pmg\pmg0800_mis2_02x08.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_03x05.pmg','BJshapePMG\pmg\pmg0800_mis2_03x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla2_03x06.pmg','BJshapePMG\pmg\pmg0800_mis2_03x06.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_03x07.pmg','BJshapePMG\pmg\pmg0800_mis2_03x07.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x00.pmg','BJshapePMG\pmg\pmg0800_mis2_04x00.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x01.pmg','BJshapePMG\pmg\pmg0800_mis2_04x01.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x02.pmg','BJshapePMG\pmg\pmg0800_mis2_04x02.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x03.pmg','BJshapePMG\pmg\pmg0800_mis2_04x03.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x04.pmg','BJshapePMG\pmg\pmg0800_mis2_04x04.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x05.pmg','BJshapePMG\pmg\pmg0800_mis2_04x05.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x06.pmg','BJshapePMG\pmg\pmg0800_mis2_04x06.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x07.pmg','BJshapePMG\pmg\pmg0800_mis2_04x07.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_04x08.pmg','BJshapePMG\pmg\pmg0800_mis2_04x08.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_05x05.pmg','BJshapePMG\pmg\pmg0800_mis2_05x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla2_05x06.pmg','BJshapePMG\pmg\pmg0800_mis2_05x06.pmg',pmg1_squar_b01_clr_mis2
 inz 'BJshapePMG\pmg\pmg0800_pla2_05x07.pmg','BJshapePMG\pmg\pmg0800_mis2_05x07.pmg'
 ina 'BJshapePMG\pmg\pmg0800_pla2_03x00.pmg','BJshapePMG\pmg\pmg0800_mis2_03x00.pmg',pmg1_smil_fa01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_03x01.pmg','BJshapePMG\pmg\pmg0800_mis2_03x01.pmg',pmg1_smil_fa01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_03x02.pmg','BJshapePMG\pmg\pmg0800_mis2_03x02.pmg',pmg1_smil_fa01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_03x03.pmg','BJshapePMG\pmg\pmg0800_mis2_03x03.pmg',pmg1_smil_fa01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_03x04.pmg','BJshapePMG\pmg\pmg0800_mis2_03x04.pmg',pmg1_smil_fa01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx00.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx00.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx01.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx01.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx02.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx02.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx03.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx03.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx04.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx04.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx05.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx05.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx06.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx06.pmg',pmg1_squar_b01_clr_mis2
 inp 'BJshapePMG\pmg\pmg0800_pla2_0Bx07.pmg','BJshapePMG\pmg\pmg0800_mis2_0Bx07.pmg',pmg1_squar_b01_clr_mis2
	.endpg

; programy rysujce na PMG #3
	NMB
	.pages $40
pmg3_squar_b01 ina 'BJshapePMG\pmg\pmg0000_pla3_00x00.pmg','BJshapePMG\pmg\pmg0000_mis3_00x00.pmg',pmg0_squar_b01_clr_mis3
pmg3_squar_b02 inp 'BJshapePMG\pmg\pmg0000_pla3_00x01.pmg','BJshapePMG\pmg\pmg0000_mis3_00x01.pmg',pmg0_squar_b01_clr_mis3
pmg3_squar_b03 inp 'BJshapePMG\pmg\pmg0000_pla3_00x02.pmg','BJshapePMG\pmg\pmg0000_mis3_00x02.pmg',pmg0_squar_b01_clr_mis3
pmg3_squar_b04 inz 'BJshapePMG\pmg\pmg0000_pla3_00x03.pmg','BJshapePMG\pmg\pmg0000_mis3_00x03.pmg'
pmg3_squar_b05 inz 'BJshapePMG\pmg\pmg0000_pla3_00x04.pmg','BJshapePMG\pmg\pmg0000_mis3_00x04.pmg'
pmg3_squar_b06 inp 'BJshapePMG\pmg\pmg0000_pla3_00x05.pmg','BJshapePMG\pmg\pmg0000_mis3_00x05.pmg',pmg0_squar_b01_clr_mis3
pmg3_dot_b01   inz 'BJshapePMG\pmg\pmg0000_pla3_00x06.pmg','BJshapePMG\pmg\pmg0000_mis3_00x06.pmg'
pmg3_dot_b02   inz 'BJshapePMG\pmg\pmg0000_pla3_00x07.pmg','BJshapePMG\pmg\pmg0000_mis3_00x07.pmg'
pmg3_dot_b03   inz 'BJshapePMG\pmg\pmg0000_pla3_00x08.pmg','BJshapePMG\pmg\pmg0000_mis3_00x08.pmg'
pmg3_bird_r01  inz 'BJshapePMG\pmg\pmg0000_pla3_01x00.pmg','BJshapePMG\pmg\pmg0000_mis3_01x00.pmg'
pmg3_bird_r02  ina 'BJshapePMG\pmg\pmg0000_pla3_01x01.pmg','BJshapePMG\pmg\pmg0000_mis3_01x01.pmg',pmg0_bird_r02_clr_mis3
pmg3_bird_r03  inp 'BJshapePMG\pmg\pmg0000_pla3_01x02.pmg','BJshapePMG\pmg\pmg0000_mis3_01x02.pmg',pmg0_bird_r02_clr_mis3
pmg3_bird_l01  inz 'BJshapePMG\pmg\pmg0000_pla3_01x03.pmg','BJshapePMG\pmg\pmg0000_mis3_01x03.pmg'
pmg3_bird_l02  inz 'BJshapePMG\pmg\pmg0000_pla3_01x04.pmg','BJshapePMG\pmg\pmg0000_mis3_01x04.pmg'
pmg3_bird_l03  inz 'BJshapePMG\pmg\pmg0000_pla3_01x05.pmg','BJshapePMG\pmg\pmg0000_mis3_01x05.pmg'
pmg3_bird_d01  inz 'BJshapePMG\pmg\pmg0000_pla3_01x06.pmg','BJshapePMG\pmg\pmg0000_mis3_01x06.pmg'
pmg3_bird_d02  inz 'BJshapePMG\pmg\pmg0000_pla3_01x07.pmg','BJshapePMG\pmg\pmg0000_mis3_01x07.pmg'
pmg3_bird_d03  inz 'BJshapePMG\pmg\pmg0000_pla3_01x08.pmg','BJshapePMG\pmg\pmg0000_mis3_01x08.pmg'
pmg3_feele_b01 inz 'BJshapePMG\pmg\pmg0000_pla3_02x05.pmg','BJshapePMG\pmg\pmg0000_mis3_02x05.pmg'
pmg3_feele_b02 inp 'BJshapePMG\pmg\pmg0000_pla3_02x06.pmg','BJshapePMG\pmg\pmg0000_mis3_02x06.pmg',pmg0_squar_b01_clr_mis3
pmg3_feele_b03 inz 'BJshapePMG\pmg\pmg0000_pla3_02x07.pmg','BJshapePMG\pmg\pmg0000_mis3_02x07.pmg'
pmg3_feele_b04 inp 'BJshapePMG\pmg\pmg0000_pla3_02x08.pmg','BJshapePMG\pmg\pmg0000_mis3_02x08.pmg',pmg0_squar_b01_clr_mis3
pmg3_UFO01     inz 'BJshapePMG\pmg\pmg0000_pla3_03x05.pmg','BJshapePMG\pmg\pmg0000_mis3_03x05.pmg'
pmg3_UFO02     inp 'BJshapePMG\pmg\pmg0000_pla3_03x06.pmg','BJshapePMG\pmg\pmg0000_mis3_03x06.pmg',pmg0_squar_b01_clr_mis3
pmg3_UFO03     inz 'BJshapePMG\pmg\pmg0000_pla3_03x07.pmg','BJshapePMG\pmg\pmg0000_mis3_03x07.pmg'
pmg3_astro_r01 inp 'BJshapePMG\pmg\pmg0000_pla3_04x00.pmg','BJshapePMG\pmg\pmg0000_mis3_04x00.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_r02 inp 'BJshapePMG\pmg\pmg0000_pla3_04x01.pmg','BJshapePMG\pmg\pmg0000_mis3_04x01.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_r03 inp 'BJshapePMG\pmg\pmg0000_pla3_04x02.pmg','BJshapePMG\pmg\pmg0000_mis3_04x02.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_r04 inp 'BJshapePMG\pmg\pmg0000_pla3_04x03.pmg','BJshapePMG\pmg\pmg0000_mis3_04x03.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_l01 inp 'BJshapePMG\pmg\pmg0000_pla3_04x04.pmg','BJshapePMG\pmg\pmg0000_mis3_04x04.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_l02 inp 'BJshapePMG\pmg\pmg0000_pla3_04x05.pmg','BJshapePMG\pmg\pmg0000_mis3_04x05.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_l03 inp 'BJshapePMG\pmg\pmg0000_pla3_04x06.pmg','BJshapePMG\pmg\pmg0000_mis3_04x06.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_l04 inp 'BJshapePMG\pmg\pmg0000_pla3_04x07.pmg','BJshapePMG\pmg\pmg0000_mis3_04x07.pmg',pmg0_squar_b01_clr_mis3
pmg3_astro_d01 inp 'BJshapePMG\pmg\pmg0000_pla3_04x08.pmg','BJshapePMG\pmg\pmg0000_mis3_04x08.pmg',pmg0_squar_b01_clr_mis3
pmg3_opp_ape01 inz 'BJshapePMG\pmg\pmg0000_pla3_05x05.pmg','BJshapePMG\pmg\pmg0000_mis3_05x05.pmg'
pmg3_opp_ape02 inp 'BJshapePMG\pmg\pmg0000_pla3_05x06.pmg','BJshapePMG\pmg\pmg0000_mis3_05x06.pmg',pmg0_squar_b01_clr_mis3
pmg3_opp_ape03 inz 'BJshapePMG\pmg\pmg0000_pla3_05x07.pmg','BJshapePMG\pmg\pmg0000_mis3_05x07.pmg'
pmg3_smil_fa01 ina 'BJshapePMG\pmg\pmg0000_pla3_03x00.pmg','BJshapePMG\pmg\pmg0000_mis3_03x00.pmg',pmg0_smil_fa01_clr_mis3
pmg3_smil_fa02 inp 'BJshapePMG\pmg\pmg0000_pla3_03x01.pmg','BJshapePMG\pmg\pmg0000_mis3_03x01.pmg',pmg0_smil_fa01_clr_mis3
pmg3_smil_fa03 inp 'BJshapePMG\pmg\pmg0000_pla3_03x02.pmg','BJshapePMG\pmg\pmg0000_mis3_03x02.pmg',pmg0_smil_fa01_clr_mis3
pmg3_smil_fa04 inp 'BJshapePMG\pmg\pmg0000_pla3_03x03.pmg','BJshapePMG\pmg\pmg0000_mis3_03x03.pmg',pmg0_smil_fa01_clr_mis3
pmg3_smil_fa05 inp 'BJshapePMG\pmg\pmg0000_pla3_03x04.pmg','BJshapePMG\pmg\pmg0000_mis3_03x04.pmg',pmg0_smil_fa01_clr_mis3
pmg3_drill_l01 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx00.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx00.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_l02 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx01.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx01.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_l03 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx02.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx02.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_l04 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx03.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx03.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_r01 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx04.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx04.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_r02 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx05.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx05.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_r03 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx06.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx06.pmg',pmg0_squar_b01_clr_mis3
pmg3_drill_r04 inp 'BJshapePMG\pmg\pmg0000_pla3_0Bx07.pmg','BJshapePMG\pmg\pmg0000_mis3_0Bx07.pmg',pmg0_squar_b01_clr_mis3

pmg3_squar_08
 ina 'BJshapePMG\pmg\pmg0800_pla3_00x00.pmg','BJshapePMG\pmg\pmg0800_mis3_00x00.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_00x01.pmg','BJshapePMG\pmg\pmg0800_mis3_00x01.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_00x02.pmg','BJshapePMG\pmg\pmg0800_mis3_00x02.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_00x03.pmg','BJshapePMG\pmg\pmg0800_mis3_00x03.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_00x04.pmg','BJshapePMG\pmg\pmg0800_mis3_00x04.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla3_00x05.pmg','BJshapePMG\pmg\pmg0800_mis3_00x05.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_00x06.pmg','BJshapePMG\pmg\pmg0800_mis3_00x06.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_00x07.pmg','BJshapePMG\pmg\pmg0800_mis3_00x07.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_00x08.pmg','BJshapePMG\pmg\pmg0800_mis3_00x08.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x00.pmg','BJshapePMG\pmg\pmg0800_mis3_01x00.pmg'
 ina 'BJshapePMG\pmg\pmg0800_pla3_01x01.pmg','BJshapePMG\pmg\pmg0800_mis3_01x01.pmg',pmg1_bird_r02_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_01x02.pmg','BJshapePMG\pmg\pmg0800_mis3_01x02.pmg',pmg1_bird_r02_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x03.pmg','BJshapePMG\pmg\pmg0800_mis3_01x03.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x04.pmg','BJshapePMG\pmg\pmg0800_mis3_01x04.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x05.pmg','BJshapePMG\pmg\pmg0800_mis3_01x05.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x06.pmg','BJshapePMG\pmg\pmg0800_mis3_01x06.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x07.pmg','BJshapePMG\pmg\pmg0800_mis3_01x07.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_01x08.pmg','BJshapePMG\pmg\pmg0800_mis3_01x08.pmg'
 inz 'BJshapePMG\pmg\pmg0800_pla3_02x05.pmg','BJshapePMG\pmg\pmg0800_mis3_02x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla3_02x06.pmg','BJshapePMG\pmg\pmg0800_mis3_02x06.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_02x07.pmg','BJshapePMG\pmg\pmg0800_mis3_02x07.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla3_02x08.pmg','BJshapePMG\pmg\pmg0800_mis3_02x08.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_03x05.pmg','BJshapePMG\pmg\pmg0800_mis3_03x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla3_03x06.pmg','BJshapePMG\pmg\pmg0800_mis3_03x06.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_03x07.pmg','BJshapePMG\pmg\pmg0800_mis3_03x07.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x00.pmg','BJshapePMG\pmg\pmg0800_mis3_04x00.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x01.pmg','BJshapePMG\pmg\pmg0800_mis3_04x01.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x02.pmg','BJshapePMG\pmg\pmg0800_mis3_04x02.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x03.pmg','BJshapePMG\pmg\pmg0800_mis3_04x03.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x04.pmg','BJshapePMG\pmg\pmg0800_mis3_04x04.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x05.pmg','BJshapePMG\pmg\pmg0800_mis3_04x05.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x06.pmg','BJshapePMG\pmg\pmg0800_mis3_04x06.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x07.pmg','BJshapePMG\pmg\pmg0800_mis3_04x07.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_04x08.pmg','BJshapePMG\pmg\pmg0800_mis3_04x08.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_05x05.pmg','BJshapePMG\pmg\pmg0800_mis3_05x05.pmg'
 inp 'BJshapePMG\pmg\pmg0800_pla3_05x06.pmg','BJshapePMG\pmg\pmg0800_mis3_05x06.pmg',pmg1_squar_b01_clr_mis3
 inz 'BJshapePMG\pmg\pmg0800_pla3_05x07.pmg','BJshapePMG\pmg\pmg0800_mis3_05x07.pmg'
 ina 'BJshapePMG\pmg\pmg0800_pla3_03x00.pmg','BJshapePMG\pmg\pmg0800_mis3_03x00.pmg',pmg1_smil_fa01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_03x01.pmg','BJshapePMG\pmg\pmg0800_mis3_03x01.pmg',pmg1_smil_fa01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_03x02.pmg','BJshapePMG\pmg\pmg0800_mis3_03x02.pmg',pmg1_smil_fa01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_03x03.pmg','BJshapePMG\pmg\pmg0800_mis3_03x03.pmg',pmg1_smil_fa01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_03x04.pmg','BJshapePMG\pmg\pmg0800_mis3_03x04.pmg',pmg1_smil_fa01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx00.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx00.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx01.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx01.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx02.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx02.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx03.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx03.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx04.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx04.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx05.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx05.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx06.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx06.pmg',pmg1_squar_b01_clr_mis3
 inp 'BJshapePMG\pmg\pmg0800_pla3_0Bx07.pmg','BJshapePMG\pmg\pmg0800_mis3_0Bx07.pmg',pmg1_squar_b01_clr_mis3
	.endpg

; ---	dane
	NMB
	.pages $40

hi_score ins 'init\tlo\hi-score-rays.gz'
title    ins 'init\tlo\title.gz'

board1	 ins 'init\tlo\s1.gz'
board2	 ins 'init\tlo\s2.gz'
board3	 ins 'init\tlo\s3.gz'

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia wsp. X i Y, wsp. Ground oraz wygld dla Sprite'a #0
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_Sprites_Parameters_Bank
                  mva #$88-16         Sprite0_PosX
                  mva #$77-32         Sprite0_PosY
                  sta                 sprites[0].psy

; kod likwidujcy bd blokowania si BJ na kadce na 9-tym levelu
                  lda                 Number_Round_BIN
                  cmp                 #9
                  bne                 set_1

                  mva #$77-48         Sprite0_PosY
                  sta                 sprites[0].psy

set_1             mva #$00            Offset_PosY_Ground    ; ile doda do wsp.Y, aby BOMB JACK wrci na ziemie lub kadke
                  mva #$07/SPEED_SPRITE Repeat_PosY_Ground  ; ile razy wykona ptle
                  mva #$A8            BombJack_SHP_C64      ; 64-bajtowy blok danych - sprite #0 ($A8*$40 = $6A00) - klatka z BOMB JACK'iem z uniesionymi rkami i spuszczon peleryn

                  mwa #Exec_BombJack  sprites[0].prg+0      ; set the address of service procedure
                  mva #<Exec_opp_PMG  sprites[1].prg+0      ; set the address of service procedure
                  sta                 sprites[2].prg+0
                  sta                 sprites[3].prg+0
                  sta                 sprites[4].prg+0
                  sta                 sprites[5].prg+0
                  sta                 sprites[6].prg+0
                  sta                 sprites[7].prg+0
                  mva #>Exec_opp_PMG  sprites[1].prg+1      ; set the address of service procedure
                  sta                 sprites[2].prg+1
                  sta                 sprites[3].prg+1
                  sta                 sprites[4].prg+1
                  sta                 sprites[5].prg+1
                  sta                 sprites[6].prg+1
                  sta                 sprites[7].prg+1

; procedura wywoywana rwnie po zakoczeniu czasu na zebranie 'umiechnitych buziek'
Set_Sprites_Parameters_after_Get_Smiling_Faces
                  ldx #04

Game_FIRE2_loop5  mva #$00 test_max_sprites_in_row.allow,x            ; wyzeruj wsk. pozwolenia na pojawienie si sprite'a

                  lda tab_Type_SPRITES_1_7,x
                  cmp #$07                                 ; Czy "UMIECHNITA BUKA"?
                  bne Game_FIRE2_skipP

                  mva save_tab_Type_SPRITES_1_7,x tab_Type_SPRITES_1_7,x

Game_FIRE2_skp1   dex
                  bpl Game_FIRE2_loop5

                  jmp Game_FIRE2_skipS

Game_FIRE2_skipP  lda Number_Round_BIN                      ; pobierz nr.rundy
                  asl @                                     ; *2
                  tay
                  mwa tab_parameters_for_sprites-2,y address1 ; pobranie adresu zgodnie z nr.rundy
                  txa
                  tay
                  lda (address1),y

            ;      sta                   tab_Show_Type_Sprite1_7_After_Animation_Appearing,x
              ;    mva #C64_New_Opponent tab_Type_SPRITES_1_7,x
                  sta tab_Type_SPRITES_1_7,x                ; zapisz typ SPRITE'a #1-#7
                  adb address1 #$07
                  bcc Game_FIRE2_skipR

                  inc address1+1
                  clc

Game_FIRE2_skipR  txa
                  asl @
                  tay
                  sbb (address1),y #2*8 Sprite1_PosX,y
                  iny
                  sbb (address1),y #4*8-7 Sprite1_PosX,y         ; tak naprawd do zapis idzie do Sprite1_PosY,y!
                  mva #$00 tab_Is_Sprite1_7_on_Screen,x
                  sta      tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,x
                  sta      index_tab_clips_Move_Opponent,x
                  sta      tab_Every_Third_Frame_Move_Sprite,x
                  sta      tab_Is_Astronaut_Change_PosX,x
                  sta      tab_Every_100th_Move_Follow_BOMB_JACK,x
                  jmp Game_FIRE2_skp1

Game_FIRE2_skipS  mva #$00 index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform
                  rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypenia wskazany obszar pamici wartoci 'byt'
;--------------------------------------------------------------------------------------------------------------------------------------------------------
fil_mem_bank .PROC
fil_me2  LDA #$ff
byt = *-1
         LDY #$00
         BEQ FillM03

FillM01  STA (address1),Y+
         BNE FillM03
         INC address1+1

FillM03  LDX address2
         BNE FillM04
         LDX address2+1
         BEQ FillM05
         DEC address2+1

FillM04  DEC address2
         JMP FillM01

FillM05  RTS
.ENDP

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; proc. kopiuje obszar pamici o zadanej dugoci w nowe miejsce
;--------------------------------------------------------------------------------------------------------------------------------------------------------
cop_mem_bank .PROC
CopyMem00 LDX address2+1
          LDA address3
          BNE CopMem01
          LDY address3+1
          BNE CopMem01
          RTS

CopMem01  CPX address1+1
          bcc CopMem06
          BNE CopMem02
          LDX address2
          CPX address1
          bcc CopMem06
          BEQ CopMem06

CopMem02  LDA address1+1
          CLC
          ADC address3+1
          STA address1+1
          LDA address2+1
          CLC
          ADC address3+1
          STA address2+1
          LDY address3
          BEQ CopMem05
          BNE CopMem04

CopMem03  LDA (address1),Y
          STA (address2),Y
CopMem04  DEY
          BNE CopMem03
          LDA (address1),Y
          STA (address2),Y
CopMem05  DEC address1+1
          DEC address2+1
          DEC address3+1
          LDA address3+1
          CMP #$FF
          BNE CopMem04
          RTS

CopMem06  LDY #$00
CopMem07  LDA (address1),Y
          STA (address2),Y
          INY
          CPY address3
          BCC CopMem07
          LDA address3+1
          SNE
          RTS

          LDA address1
          CLC
          ADC address3
          STA address1
          LDA address1+1
          ADC #$00
          STA address1+1
          LDA address2
          CLC
          ADC address3
          STA address2
          LDA address2+1
          ADC #$00
          STA address2+1
CopMem08  LDY #$00
CopMem09  LDA (address1),Y
          STA (address2),Y
          INY
          BNE CopMem09
          INC address1+1
          INC address2+1
          DEC address3+1
          BNE CopMem08

          RTS
.ENDP

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; poka mnonik: x1, x2, x3 , x4 dla otrzymywanych punktw
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Digital_Panel_Bank
        lda Counter_Collected_Letter_B
        asl @
        tay
        mva tab_xBonus+0,y xBonus+3
        mva tab_xBonus+1,y xBonus+3+32
        rts

tab_xBonus
  dta $84,$8A
  dta $D2,$BF
  dta $D2,$D9
  dta $D3,$DA

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wywietla aktualn liczb y 'bomb jacka'
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Lifes_BombJack_Bank
        jsr life_skp1
        lda pos_tab_addr_live
        bne *+3
        rts

        asl @
        tay
        dey

life_lop1
        mva tab_lifes+0,y  life_panelu,y
        mva tab_lifes+12,y life_paneld,y
        dey
        bpl life_lop1

        rts
;-------
life_skp1
        lda #$00
        ldy #11

life_lop2
        sta life_panelu,y
        sta life_paneld,y
        dey
        bpl life_lop2

        rts

tab_lifes dta d'<=<=<=<=<=<='
          dta d'>?>?>?>?>?>?'*

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura rysuje wszystkie BOMBY jakie maj si pojawi na danym ekranie
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Bombs_Bank   mwa #B1SCR store_adr_buffor
                  jsr Draw_Bombs_0
                  mwa #B2SCR store_adr_buffor
                  jsr Draw_Bombs_0
                  mwa #B3SCR store_adr_buffor

Draw_Bombs_0      mva #$00 count_draw
                  lda Number_Round_BIN                           ; numer rundy - ekranu
                  asl @                                          ;*2
                  tay
                  mwa tab_pos_bombs_on_screens-2,y address1
                  mwa tab_bomb-2,y                 Draw_Bombs_1+2  ; dostosowanie ta BOMB z wersji C64 do wersji ATARI
                  jmp Draw_Bombs_4
;-----------------
Draw_Bombs_1      tax
                  lda $FFFF,x
                  sta is_no_invers                               ; zapamitaj znacznik czy wymusi rys. bomby bez inwersu (=2 TAK!)
                  :2 asl @                                       ;*4
                  tax
                  mwa tab_bombs+$00,x BOMB+0                     ; pobiera 2 grne i 2 dolne bajty z definicj "bomby" (ta ktr zbiera BOMB JACK)
                  mwa tab_bombs+$02,x BOMB+2
                  iny
                  mva (address1),y+ Pos_Bomb                     ; o ile zmieni pozycje rysowania BOMBY?
                  mva (address1),y+ Count_Bomb                   ; ile BOMB narysowa?

; obl. pozycji na ekranie od ktrego zaczniemy rysowa BOMBY
                  mva (address1),y+ address2
                  mva (address1),y  address2+1

                  jsr Calculate_address2_from_40_to_32_wide_screen ; przelicz przesunicie bo na ATARI mamy ekran o szerokoci 32 znakw (a nie jak na C64 - 40 znakw)
                  adw address2 store_adr_buffor

                  jmp Draw_Bombs_3

; tutaj ustawiamy, ktre BOMBY kolejno na ekranie bd "miga" - rysujemy cay wiersz z BOMB-ami (np: 3 sztuki)
Draw_Bombs_2      lda count_draw                                  ; licznik wskazujcy, ktr BOMB- aktualnie rysujemy...
                  asl @                                           ; ... *2
                  tax

                  lda Number_Round_BIN                            ; jaka runda (ekran)?
                  asl @                                           ; *2
                  tay
                  mwa tab_Address_Next_Blink_Bomb_BOARD-2,y address3; ustaw np: "Pointer_Address_Next_Blink_Bomb_BOARD_01" dla pierwszej planszy gry
                  ldy count_draw
                  lda (address3),y                                ; pobierz wskanik, ktry *2 + Buffor_Offset_in_tab_Screen_BOMB - da adres nastpnej BOMBY na ekranie, ktra ma miga
                  pha

                  sbw address2 store_adr_buffor address3          ; obl. offset pooenia BOMBY - [adres BOMB-y na ekranie-$5000]
                  adw address3 #tab_Screen_BOMB                   ; dodaj adres tablicy "tab_Screen_BOMB" i zapamitaj w address3
                  mwa address3 Buffor_Offset_in_tab_Screen_BOMB,x ; obl. adres zapamitaj w 'Buffor_Offset_in_tab_Screen_BOMB,x'

                  pla
                  ldy #$01
                  sta      (address3),y-                          ; zapisz warto w odpowiedniej pozycji tablicy "tab_Screen_BOMB+1"
                  mva #$01 (address3),y                           ; zapisz warto $01 w odpowiedniej pozycji tablicy "tab_Screen_BOMB" (wskazuje lewy grny rg BOMBY)

                  inc count_draw                                  ; +1 kolejna BOMB-a narysowana (dla cisoci: waciwie za chwile dopiero zostanie narysowana na ekranie)

; rysujemy jedn BOMB (z uwzgldnieniem inwersu pobieranego z ta)
Draw_Bomb         ldy #$00
                  jsr draw_one_bomb_bak_invers

                  lda is_no_invers
                  cmp #2
                  bne draw_bomb_skp1
                  ldy #$00
                  jsr draw_one_bomb_no_invers

draw_bomb_skp1    lda address2
                  add Pos_Bomb                                    ; np: +3 - narysuj kolejn BOMB z prawej strony
                  sta address2
                  bcc Draw_Bombs_3
                  inc address2+1

Draw_Bombs_3      dec Count_Bomb
                  jpl Draw_Bombs_2                                ; rysuj nastpn bomb w wierszu lub kolumnie

                  adw address1 #$05                               ; natpne pi bajtw z danymi jak narysowa wiersz (kolumne) BOMB

Draw_Bombs_4      ldy #$00
                  lda (address1),y
                  cmp #$FF                                        ; Czy koniec danych?
                  jne Draw_Bombs_1

                  rts                                             ; TAK! Wic wyjcie z procedury

draw_one_bomb_bak_invers
                  lda (address2),y                                ; rysuje 1-szy bajt BOMBY
                  and #%10000000                                  ; uwzgldnij invers ta
                  ora BOMB+0
                  sta (address2),y+

                  lda (address2),y                                ; rysuje 2-gi bajt BOMBY
                  and #%10000000
                  ora BOMB+1
                  sta (address2),y

                  ldy #$20                                        ; przejd wiersz niej

                  lda (address2),y                                ; rysuje 3-ci bajt BOMBY
                  and #%10000000
                  ora BOMB+2
                  sta (address2),y+

                  lda (address2),y                                ; rysuje 4-ty bajt BOMBY
                  and #%10000000
                  ora BOMB+3
                  sta (address2),y
                  rts

draw_one_bomb_no_invers
                  mva BOMB+0 (address2),y+
                  mva BOMB+1 (address2),y
                  ldy #$20                                        ; przejd wiersz niej
                  mva BOMB+2 (address2),y+
                  mva BOMB+3 (address2),y
                  rts

is_no_invers dta $00                                              ; =2 wymusza rys. bomby bez inwersu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura rysuje belki na ekranie gry - te po ktrych mona skaka zbierajc BOMBY (UWAGA: wywoywa od 'Draw_Bars')
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; pobranie 7 typw SPRITE'w #1-#7 jakie pojawi si na tej planszy gry
Draw_Bars_skip1   :3 iny                                  ; przejcie do kolejnej 6-bajtowej paczki danych
                  ldx #$00

Draw_Bars_loop2   mva (address1),y+ tab_Type_SPRITES_1_7,x
                  mva #$00         tab_Is_Sprite1_7_on_Screen,x
                  sta              tab_Move_Left_or_Right_or_Down_LetterEB,x
                  sta              tab_Can_Show_LetterP_on_Board,x
                  sta              tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,x
                  sta              tab_Is_Astronaut_Change_PosX,x
                  sta              tab_Every_100th_Move_Follow_BOMB_JACK,x+
                  cpx #$07
                  bne Draw_Bars_loop2  ;slow

; ustaw pocztkowe wsprzdne X i Y dla SPRITE'w #1-#7
                  ldx #$00
Draw_Bars_loop3   mva (address1),y+ Sprite1_PosX,x+
                  cpx #$0E
                  bne Draw_Bars_loop3

; zapamitaj 5 jaki wartoci w odwrotnej kolejnoci
                  ldx #$04
Draw_Bars_loop4   mva (address1),y+ tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform,x-
                  bpl Draw_Bars_loop4

                  rts

; rozpoczcie rysowania kadek
Draw_Bars_Bank    mwa #B1SCR store_adr_buffor             ; musimy dorysowa 'KADKI' na trzech buforach, eby zmiana uwidocznia si na ekranie
                  jsr Draw_Bars_1
                  mwa #B2SCR store_adr_buffor
                  jsr Draw_Bars_1
                  mwa #B3SCR store_adr_buffor

Draw_Bars_1       lda Number_Round_BIN                    ; pobierz nr. RUNDY
                  asl @                                   ; *2
                  tax
                  mwa tab_addr_char_bars-2,x address1

; pobieramy 6 bajtw danych z tablicy
Draw_Bars_loop1   ldy #$00
                  mva (address1),y+ Count_Char_Bar        ; przechowuje dugo na jak rozrysujemy pasek
                  dec               Count_Char_Bar        ; ???
                  mva (address1),y+ Attrib_Char_Bar       ; przechowuje atrybut(kolor) jakim narysujemy pasek

                  lda (address1),y+
                  tax
                  mva tab_ledgeHV-$F9,x Char_Bar          ; tablica konwertujca rodzaje kadek z C64 na te, ktre s na ATARI

                  mva (address1),y  Pos_Char_Bar          ; o ile przesun pozycje, aby rys. kolejny znak paska
                  jeq Draw_Bars_skip1  ;slow

; obliczenie adresu, od ktrego zaczniemy rysowa pasek
                  iny
                  mva (address1),y+ address2
                  mva (address1),y  address2+1

                  jsr Calculate_address2_from_40_to_32_wide_screen ; przelicz przesunicie bo na ATARI mamy ekran o szerokoci 32 znakw (a nie jak na C64 - 40 znakw)
                  mwa address2 Offset_Char_Bar

                  adw address1 #$0006                         ; nastpny pakiet danych (kady pakiet ma 6 bajtw)
                  adw address2 store_adr_buffor               ; ubezwzgldnij adres, od ktrego bdziem rysowa

                  jsr Draw_Bar

; Obliczenie adresu, od ktrego wstawimy atrybut dla paska i zapis tego
                   jmp Draw_Bars_loop1

; narysowanie paska na ekranie(store_adr_buffor) lub w pamici koloru(ColorRAM40x25)
Draw_Bar          ldx Count_Char_Bar
                  ldy #$00

Draw_Bars_loop5   mva Char_Bar (address2),y                   ; znak z "belk" zapisywany na ekranie
                  adb address2 Pos_Char_Bar                   ; skoryguj pozycj, od ktrej narysujemy kolejny znak belki (zwykle o +1)
                  bcc Draw_Bars_skip2

                  inc address2+1

Draw_Bars_skip2   dex
                  bpl Draw_Bars_loop5

                  rts

; przelicz przesunicie bo na ATARI mamy ekran o szerokoci 32 znakw (a nie jak na C64 - 40 znakw)
Calculate_address2_from_40_to_32_wide_screen
                  lda address2              ; address2 / 40
                  ldx address2+1
                  ldy #40
                  jsr div
                  lda __rsl                 ; cz cakowita*32znaki
                  ldx #32
                  mvy __bta __rsl           ; reszta zostanie dodana do wyniku mnoenia
                  mvy #0    __rsl+1
                  jsr mul
                  adw __rsl #1 address2     ; dodaj +1 kolumn, eby wycelowa na ekranie mniej wicej w t sam pozycj co na C64
                  rts

; ---
; ---	FADE
; ---
.local	FADE

	stx	jsr+1
	sty	jsr+2

	ldx	#6
	jsr	wait

	mva	#16	cnt

lcol	mva	<$ff	fcnt
hcol	mva	>$ff	fcnt+1

	ldx	#2
	jsr	wait

jsr	jsr	$ffff

	dec	cnt
	bne	lcol

	ldx	#6

wait	lda:cmp:req cloc
	dex
	bne	wait

        rts

cnt	brk
.end


; ---
; ---	FADE IN
; ---
.local	FADE_IN_BANK

	ldx	<fade
	ldy	>fade
	jmp	:fade

fade	ldy	#0
	mva	(fcnt),y	fadr

	iny
	lda	(fcnt),y
	sne:rts

	sta	fadr+1

	lda	(fadr),y
	tax

	iny
	eor	(fcnt),y
	beq	skp

	dey

	pha

	and	#$f0
	beq	plus1

plus16	txa
	add	#$10
	tax

plus1	pla
	and	#$0f
	seq
	inx

	txa
	sta	(fadr),y

skp	adw	fcnt	#3

	jmp	fade
.end


; ---
; ---	FADE OUT
; ---
.local	FADE_OUT_BANK

	ldx	<fade
	ldy	>fade
	jmp	:fade

fade	ldy	#0
	mva	(fcnt),y	fadr

	iny
	lda	(fcnt),y
	sne:rts

	sta	fadr+1

	lda	(fadr),y
	tax

	and	#$0f
	beq	skp0

	dex
skp0
	txa
	and	#$f0
	beq	skp1

	txa
	sub	#$10
	tax
skp1
	txa

	sta	(fadr),y

	adw	fcnt	#3

	jmp	fade
.end


; ---
; ---	SAVE COLOR
; ---
.local	SAVE_COLOR_BANK

	mva	fade.lcol+1	fcnt
	mva	fade.hcol+1	fcnt+1

loop	ldy	#0
	mva	(fcnt),y	fadr

	iny
	lda	(fcnt),y
	sne:rts

	sta	fadr+1

	lda	(fadr),y

	iny
	sta	(fcnt),y

	dey
	mva	#0	(fadr),y	; black screen (all colors = $00)

	adw	fcnt	#3

	jmp	loop
.end

tcol_title dta t(d9,d10,d11,d13,d14,d15,d16,d17,d18,d19,d20,d21,d22,d23,d24,d25,d26,d27,d28,d29,d30,d31,d32,d33,d34,d35,d36,d37,d38,d39,$00)
tcol_score dta t(c9,c10,c11,c12,c13,c14,c15,c16,c17,c18,c19,c20,c21,c22,c23,c24,c25,c26,c27,c28,c29,c30,c31,c32,c33,c34,c35,c36,c37,c38,c39,c40,c41,c42,c43,x00,x01,x02,$00)
tcol_board .rept 26,#
             dta t(dli:1[0].ldx,dli:1[0].ldy,dli:1[0].lda2,dli:1[0].ldx2)
           .endr
tcol_pmg     dta t(    col_PM0-1,    col_PM1-1,    col_PM2-1,    col_PM3-1,    col_PM4-1,    col_PM5-1,    col_PM6-1,    col_PM7-1)
tcol_pmg_vbl dta t(col_PM0_vbl-1,col_PM1_vbl-1,col_PM2_vbl-1,col_PM3_vbl-1,col_PM4_vbl-1,col_PM5_vbl-1,col_PM6_vbl-1,col_PM7_vbl-1)
             dta t($00)

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; kod gry umieszczony w banku pamici z powodu braku pamici podstawowej
;--------------------------------------------------------------------------------------------------------------------------------------------------------
main_score .proc
        mva <tcol_score fade.lcol+1
        mva >tcol_score fade.hcol+1
        jsr Show_HiScore_score
        jsr print_score_list
	mva #$04       count1           ; delay counter 1

	ldx #10

wait    wait_vbl
        dex
        bne wait

        mva >pmg_2               $d407		; missiles and players data address
	mva #3                   $d01d		; enable players and missiles
	mwa #ANTIC_PROGRAM_SCORE $d402          ; ANTIC address program
	mwa #dlx_start           nmi_score.dlxv
        mwa #NMI_SCORE           $fffa	        ; new NMI handler (VBL+DLI)
	mva #$c0                 $d40e	        ; switch on NMI (VBL+DLI)

	jsr fade_in		        ; fade in colors

   	mva #$88 c12+1                  ; set rotating colors
   	mva #$86 c13+1
   	mva #$84 c14+1
   	mva #$82 c15+1

        ldy #3

wait1   ldx #255

wait2   lda cloc
        cmp cloc
        beq *-2

	lda $d010 		        ; trig0
	bne skp1

        mva #$ff       count1           ; rotating colors OFF
	jsr fade_out		        ; fade out colors
        sec
        rts

skp1    dex
        bne wait2

        dey
        bne wait1

        mva #$ff       count1           ; rotating colors OFF
	jsr fade_out		        ; fade out colors
        clc
        rts
.endp
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wypisanie punktw i nickw graczy
;--------------------------------------------------------------------------------------------------------------------------------------------------------
print_score_list  mwa #scr_2+32*12 put_char+1   ; UWAGA! te 2 linie musz by na pocztku procki!
                  mwa #tab8_score0             address2     ; zapamitaj adres pierwszej tablicy HI-SCORE
                  mva #$07                     counter

HI_SCORE_loop2    ldx #10
                  mvy #$00 pos_tab8_score

HI_SCORE_loop3    lda (address2),y
                  :4  lsr @                            ; podziel A przez 16 - aby uzyska starszy nibbel (bity 4-7)
                  add #16
                  jsr put_char

                  inx
                  lda (address2),y
                  and #$0F                             ; teraz pobierz z bieacego bajta tylko modszy nibble (bity 0-3)
                  add #16
                  jsr put_char

                  inx
                  iny
                  cpy #$03
                  bne HI_SCORE_loop3

                  :2 inx
                  mva #$04 counter2

score_lop1        lda (address2),y
                  add #33+128
                  jsr put_char
                  inx
                  iny
                  dec counter2
                  bne score_lop1

                  adw put_char+1 #32+32              ; dodaj 70 (40 znakw + 30znakw) - przenosi kursor o 2 wiersze w d aby wywietli kolejne HI-SCORE
                  adw address2   #$08                ; dodaj 8 bajtw aby wskanik wskazywa na kolejn tablic 8-bajtow (kada tablica to jeden HI-SCORE)

                  dec counter
                  jpl HI_SCORE_loop2

                  rts

; wypisuje na ekranie jeden znak
put_char          sta $ffff,x
                  rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ---	DLI PROGRAM
;--------------------------------------------------------------------------------------------------------------------------------------------------------

	?old_dlx = *

dlx_start
dlx6    lda >fnt_2+$400*$00	;hi-score logo font 1
c10	ldx #$28
c11	ldy #$2C
	sta $d40a		;line=16
	sta chbase
c9	lda #$24
	sta color0
	stx color1
	sty color2
	sta $d40a		;line=17

        dec count1		; delay counter of the colour rotation
	bmi xskip1
        bne xskip1 		; slow things down a bit

	mva #$04 count1		; reset timer

	ldx c12+1		; now rotate values 1 byte from right to left
	ldy c13+1
        mva c15+1 c12+1
	mva c14+1 c15+1
	stx c13+1
	sty c14+1

xskip1	sta $d40a		;line=18
	sta $d40a		;line=19
	sta $d40a		;line=20

; LOGO COLOUR ROTATION IS HERE
c12	ldx #$88
c13	lda #$86
c14	ldy #$84
	sta $d40a		;line=21
	sta color3
	stx colpm0
	sty colpm1
	sty colpm2
c15	lda #$82
	sta colpm3

	lda #$01
	ldx #$71
	ldy #$90
	sta $d40a		;line=22
	sta sizep0
	sta sizep1
	stx hposp0
	sty hposp1
	sta $d40a		;line=23
	sta $d40a		;line=24
	sta $d40a		;line=25
	lda #$C0
	ldx #$5D
	ldy #$81
	sta $d40a		;line=26
	sta sizem
	stx hposp2
	sty hposp3
	lda #$70
	sta hposm0
	lda #$8E
	sta hposm1
	lda #$89
	sta hposm3
	DLINEWx dlx7

dlx7

	sta $d40a		;line=32
	lda #$80
	ldx #$7E
	sta $d40a		;line=33
	sta hposp3
	stx hposm0
	DLINEWx dlx8

dlx8

	sta $d40a		;line=40
	sta $d40a		;line=41
	lda #$00
	sta $d40a		;line=42
	sta sizep0
	sta $d40a		;line=43
	sta $d40a		;line=44
	lda #$77
	sta $d40a		;line=45
	sta hposp0
	lda #$9A
	ldx #$7D
	ldy #$66
	sta $d40a		;line=46
	sta hposp0
	stx hposm0
	sty hposm2
	lda #$00
	ldx #$5D
	sta $d40a		;line=47
	sta sizem
	stx hposm3
	sta $d40a		;line=48
	sta $d40a		;line=49
	sta $d40a		;line=50
	sta $d40a		;line=51
	sta $d40a		;line=52
	lda #$60
	sta $d40a		;line=53
	sta hposp3
	DLINEWx dlx2


dlx2
	lda >fnt_2+$400*$01	;hi-score logo font 2
	sta $d40a		;line=56
	sta chbase
	sta $d40a		;line=57
	sta $d40a		;line=58
	sta $d40a		;line=59
	sta $d40a		;line=60
x00	lda #$84
	sta colpm3
	sta $d40a		;line=61
c16	lda #$84
	sta $d40a		;line=62
	sta color3
	sta $d40a		;line=63
	sta $d40a		;line=64
c17	lda #$82
	sta $d40a		;line=65
	sta color3
	sta $d40a		;line=66
c18	lda #$80
	sta $d40a		;line=67
	sta color3
c19	lda #$82
	sta $d40a		;line=68
	sta color3
	lda #$74
c20	ldx #$0E
	sta $d40a		;line=69
	sta hposp0
	stx colpm0
c21	lda #$2C
c22	ldx #$24
	ldy #$83
	sta $d40a		;line=70
	sta color0
	stx color2
	sty hposp2
	lda #$7C
	sta hposm0
	lda #$8B
	sta hposm2
c23	lda #$0E
	sta colpm2
	sta $d40a		;line=71
c24	lda #$84
	ldx #$00
	ldy #$8F
	sta $d40a		;line=72
	sta color3
	stx sizep1
	sty hposp1
	lda #$6F
	sta hposm1
c25	lda #$82
	sta colpm1
	sta $d40a		;line=73
c26	lda #$80
	sta $d40a		;line=74
	sta colpm1
	sta $d40a		;line=75
	lda #$8B
	ldx #$7C
c27	ldy #$8C
	sta $d40a		;line=76
	sta hposp1
	stx hposm1
	sty colpm1
c28	lda #$2A
c29	ldx #$0C
c30	ldy #$8A
	sta $d40a		;line=77
	sta color0
	stx colpm0
	sty colpm1
c31	lda #$0C
	sta colpm2
	sta $d40a		;line=78
c32	lda #$22
	ldx #$69
	ldy #$8F
	sta $d40a		;line=79
	sta color2
	stx hposp3
	sty hposm3
c33	lda #$88
c34	ldx #$80
	sta $d40a		;line=80
	sta colpm1
	stx colpm3
c35	lda #$82
c36	ldx #$0A
	sta $d40a		;line=81
	sta color3
	stx colpm0
	stx colpm2
c37	lda #$28
	sta $d40a		;line=82
	sta color0
c38	lda #$22
c39	ldx #$20
	sta $d40a		;line=83
	sta color1
	stx color2
c40	lda #$08
	sta $d40a		;line=84
	sta colpm0
	sta colpm2
c41	lda #$26
c42	ldx #$06
	sta $d40a		;line=85
	sta color0
	stx colpm0
	stx colpm2
c43	lda #$24
	sta $d40a		;line=86
	sta color0
	DLINEWx dlx3

dlx3
	lda >BJ_panel    	;bjack1 font to end of screen
x01     ldx #$0C
x02     ldy #$F8
	sta $d40a		;line=88
	sta chbase
	stx color2
	sty color3
	DLINEWx dlx9

dlx9

c44	lda #$78
c45	ldx #$0E
c46	ldy #$FC		;bottom score panel colours
	sta $d40a		;line=224
	sta color0
	stx color1
	sty color2
c47	lda #$B6
	sta color3
	DLINEWx dlx10

dlx10

c48	lda #$24
c49	ldx #$0E
c50	ldy #$54
	sta $d40a		;line=232
	sta color0
	stx color2
	sty color3
	jmp nmi_score.quit

;---

CHANGES

;---

.PROC nmi_score
	sta rA
	stx rX
	sty rY

	bit $d40f
	bpl VBL

	jmp dlx_start
dlxv	= *-2

VBL
	sta $d40f		        ;reset NMI flag

	inc cloc		        ;little timer

	mwa #ANTIC_PROGRAM_SCORE $d402  ;ANTIC address program

	mva #scr32               $d400	;set new screen's width

;--- first line of screen initialization

	lda >BJ_panel    	;bjack1 font top score panel
	sta chbase
c0	lda #$00
	sta colbak
c1	lda #$72
	sta color0
c2	lda #$7A
	sta color1
c3	lda #$0E
	sta color2
c4	lda #$FA
	sta color3
	lda #$04
	sta gtictl
	lda #$00
	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	sta sizem       ; colour rotation effect on score top panel

	lda #139+6      ;$72
	sta hposp0	; 4 PLAYERS - SHAPE = #192
	lda #139+4      ;$70
	sta hposp1
	lda #139+2      ;$6E
	sta hposp2
	lda #139        ;$6C
	sta hposp3
	lda #108        ;$8B 4 MISSILES - SHAPE = #255
	sta hposm0
	lda #108+2      ;$8D
	sta hposm1
	lda #108+4      ;$8F
	sta hposm2
	lda #108+6      ;$91
	sta hposm3

c5	lda #$78	; COLOURS IN REVERSE PM0=LIGHT PM3=DARK
	sta colpm0
c6	lda #$76
	sta colpm1
c7	lda #$74
	sta colpm2
c8	lda #$72
	sta colpm3

	mwa #dlx_start dlxv	;set the first address of DLI interrupt

;this area is for yours routines
	jsr external_vbl

quit
	lda rA
	ldx rX
	ldy rY
	rti

.ENDP

.macro	DLINEWx
	ift .hi(?old_dlx)==.hi(:1)
	mva <:1 nmi_score.dlxv
	els
	mwa #:1 nmi_score.dlxv
	eif

	jmp nmi_score.quit

	.def ?old_dlx = *
.endm

; kod gry umieszczony w banku pamici z powodu braku pamici podstawowej
main_title .proc
        mva <tcol_title fade.lcol+1
        mva >tcol_title fade.hcol+1
        jsr Show_HiScore_title
	mva #$04               count1 ; delay counter 1
  	mva #[len_color_txt+1] count2 ; colors of the blinking text

	ldx #10

wait    wait_vbl
        dex
        bne wait

        mva >pmg_1     $d407	       ; missiles and players data address
	mva #3         $d01d	       ; enable players and missiles
	mwa #ANTIC_PROGRAM_TITLE $d402 ; ANTIC address program
        mwa #dl__start nmi_title.dl_v  ; restore
	mwa #nmi_title $fffa	       ; new NMI handler (VBL+DLI)
	mva #$c0       $d40e	       ; switch on NMI (VBL+DLI)

	jsr fade_in      	      ; fade in colors

        mva #$82  d9+1                ; set rotating colors
	mva #$86 d10+1
	mva #$88 d11+1

        ldy #3

wait1   ldx #255

wait2   lda cloc
        cmp cloc
        beq *-2

	lda $d010 		      ; trig0
	beq skp1

        dex
        bne wait2

        dey
        bne wait1

        mva #$ff       count1         ; rotating colors OFF
        sta            count2
        jsr fade_out                  ; fade out colors
        clc                           ; FIRE is not pressed!
        rts

skp1    mva #$ff       count1         ; rotating colors OFF
	sta            count2
        jsr fade_out ;_title            ; fade out colors
        sec                           ; FIRE is pressed!
        rts
.endp
; ---	DLI PROGRAM

	?old_dli = *
dl__start
dl_6	lda count1		; delay counter of the colour rotation
        cmp #$ff
        beq skip1
        dec count1
        bne skip1 		; slow things down a bit

	mva #$04 count1         ; reset timer

	ldx  d9+1		; now rotate values 1 byte from right to left
	ldy d10+1
	lda d11+1
	sta  d9+1
	stx d10+1
	sty d11+1

skip1
d9	lda #$82
d10	ldx #$86
d11	ldy #$88
	sta $d40a

   	sta color1
	stx colpm0
	stx colpm1
	stx colpm2
	sty color3
	DLINEW dl_7

dl_7  	lda >fnt_1        	; Logo first font
d13	ldx #$18
d14	ldy #$34
	sta $d40a		;line=24
	sta chbase
	stx color0
	sty color2
d15	lda #$34
d16	ldx #$18
	sta $d40a		;line=25 - line change on top of logo frame
	sta color0		;swap color0 and color 2 values
	stx color2
d17	lda #$18
d18	ldx #$34
	ldy #$03
	sta $d40a		;line=26
	sta color0		;now swap them back to normal on the next line
	stx color2
	sty sizep2
	lda #$76
	sta hposp2
	lda #$01
	ldx #$9D
	ldy #$68
	sta $d40a		;line=27
	sta sizep0
	stx hposp0
	sty hposp1
	lda #$75
	sta hposp2
	sta $d40a		;line=28
	lda #$00
	ldx #$33
	ldy #$51
	sta $d40a		;line=29
	sta sizep0
	stx sizem
	sty hposp0
	lda #$65
	sta hposp3
	lda #$A6
	sta hposm0
	lda #$9E
	sta hposm2
d19	lda #$22
	sta colpm3
	lda #$37
	ldx #$70
	sta $d40a		;line=30
	sta sizem
	stx hposm1
	sta $d40a		;line=31
	sta $d40a		;line=32
	sta $d40a		;line=33
	lda #$3F
	ldx #$6C
	ldy #$9C
	sta $d40a		;line=34
	sta sizem
	stx hposp1
	sty hposm0
	lda #$A4
	sta hposm1
	sta $d40a		;line=35
	lda #$0F
	ldx #$85
	sta $d40a		;line=36
	sta sizem
	stx hposm2
	lda #$03
	ldx #$00
	ldy #$89
	sta $d40a		;line=37
	sta sizep1
	stx sizem
	sty hposp1
	lda #$71
	sta hposm0
	lda #$72
	sta hposm1
	lda #$7A
	sta hposm2
	lda #$7E
	ldx #$85
	ldy #$76
	sta $d40a		;line=38
	sta hposp3
	stx hposm2
	sty hposm3
d20	lda #$34
	sta colpm3
	sta $d40a		;line=39
	sta $d40a		;line=40
	lda #$66
d21	ldx #$0E
	sta $d40a		;line=41
	sta hposp3
	stx colpm3
	sta $d40a		;line=42
	sta $d40a		;line=43
	lda #$64
	sta $d40a		;line=44
	sta hposp0
	DLINEW dl_8

dl_8	lda #$84
d22	ldx #$34
	sta $d40a		;line=48
	sta hposm3
	stx colpm3
	sta $d40a		;line=49
	lda #$01
	ldx #$87
	sta $d40a		;line=50
	sta sizep0
	stx hposp0
	sta $d40a		;line=51
	lda #$62
	ldx #$7A
d23	ldy #$0E
	sta $d40a		;line=52
	sta hposp3
	stx hposm0
	sty colpm3
	sta $d40a		;line=53
	sta $d40a		;line=54
	lda #$86
	sta $d40a		;line=55
	sta hposm0
	lda #$0C
	ldx #$A6
	sta $d40a		;line=56
	sta sizem
	stx hposm1
	lda #$00
	ldx #$95
	ldy #$9D
	sta $d40a		;line=57
	sta sizep1
	sta sizep2
	stx hposp1
	sty hposp2
	lda #$A5
	sta hposm0
	lda #$AC
	sta hposm2
	sta $d40a		;line=58
	lda #$A5
	sta $d40a		;line=59
	sta hposm2
	lda #$88
	sta $d40a		;line=60
	sta hposm0
	sta $d40a		;line=61
	lda #$00
	ldx #$8D
	ldy #$A5
	sta $d40a		;line=62
	sta sizep0
	stx hposp0
	sty hposm0
	lda #$AC
	sta hposm2
	DLINEW dl_2


dl_2	lda >fnt_1+$400*$01
	sta $d40a		;line=64 LOGO SECOND FONT
	sta chbase
	sta $d40a		;line=65
	sta $d40a		;line=66
	sta $d40a		;line=67
	lda #$51
	sta $d40a		;line=68
	sta hposm0
	DLINEW dl_9

dl_9	lda #$98
d24	ldx #$34
	sta $d40a		;line=72
	sta hposp3
	stx colpm3
	lda #$7A
	sta $d40a		;line=73
	sta hposp2
	lda #$5E
	ldx #$72
	sta $d40a		;line=74
	sta hposp0
	stx hposp1
	sta $d40a		;line=75
	lda #$8B
	sta $d40a		;line=76
	sta hposp3
	lda #$8E
	ldx #$89
	sta $d40a		;line=77
	sta hposm2
	stx hposm3
	sta $d40a		;line=78
	lda #$00
	ldx #$9A
	sta $d40a		;line=79
	sta sizem
	stx hposm1
	lda #$99
	ldx #$98
	sta $d40a		;line=80
	sta hposp3
	stx hposm2
	lda #$83
	sta $d40a		;line=81
	sta hposm3
	lda #$71
	sta $d40a		;line=82
	sta hposm0
	lda #$6D
	sta $d40a		;line=83
	sta hposp0
	lda #$03
	ldx #$54
	sta $d40a		;line=84
	sta sizep0
	stx hposp0
	lda #$9B
	sta $d40a		;line=85
	sta hposm1
	sta $d40a		;line=86
	lda #$10
	ldx #$A7
	sta $d40a		;line=87
	sta sizem
	stx hposm2
	sta $d40a		;line=88
	lda #$A6
	sta $d40a		;line=89
	sta hposp2
	sta $d40a		;line=90
	sta $d40a		;line=91
	sta $d40a		;line=92
	lda #$A5
	ldx #$AD
d25	ldy #$0E
	sta $d40a		;line=93
	sta hposp3
	stx hposm3
	sty colpm3
	DLINEW dl_10

dl_10	sta $d40a		;line=96
	sta $d40a		;line=97
	sta $d40a		;line=98
	sta $d40a		;line=99
	lda #$34
	ldx #$83
	ldy #$87
	sta $d40a		;line=100
	sta sizem
	stx hposm0
	sty hposm1
	lda #$8E
	sta hposm2
	sta $d40a		;line=101
d26	lda #$34
d27	ldx #$18
	sta $d40a		;line=102
	sta color0
	stx color2
d28	lda #$18
d29	ldx #$34
	sta $d40a		;line=103
	sta color0
	stx color2
	DLINEW dl_11 ;dl_3

dl_3	lda >BJ_panel	        ;Set BJACK1.FNT
d30	ldx #$42
d31	ldy #$0E
	sta $d40a		;line=112 START OF BOMBJACK TEXT
	sta chbase
	stx color1
	sty color2
d32	lda #$26
	sta color3
	DLINEW dl_11

dl_11
; blinking text 1 PLAYER START
        ldy >BJ_panel
        ldx count2
        cpx #$ff
        beq dl__a
        dex
        bne skip3

  	ldx #[len_color_txt+1]

skip3   lda tab_color_txt-1,x
        sta d33+1

dl__a	sta $d40a	    ; line=128
        sty chbase
d33     lda #$ff
  	sta color2 	    ; and store it in colour register pf2
        stx count2
        DLINEW dl_12

tab_color_txt
              ?col = $10    ; shades of the blinking color
              .rept 7
                :10 dta ?col+[#+6]*$01
                :10 dta ?col+[15-#]*$01
                ?col = ?col + $20
              .endr
len_color_txt = * - tab_color_txt

dl_12
d34	lda #$0E		;text white
	sta $d40a		;line=136
	sta color2
	DLINEW dl_13

dl_13
d35	lda #$26		;TEBE Author text
	sta $d40a		;line=160
	sta color3
	DLINEW dl_14

dl_14
d36	lda #$66		;VEGA Author text
	sta $d40a		;line=168
	sta color3
	DLINEW dl_15

dl_15
d37	lda #$46		;TEZZ Author text
	sta $d40a		;line=176
	sta color3
	DLINEW dl_16

dl_16
d38	lda #$C6
        sta $d40a		;line=184
	sta color3
	DLINEW dl_17

dl_17
d39	lda #$18
	sta $d40a		;line=208
	sta color3
	DLINEW dl_18

dl_18
d40	lda #$78
d41	ldx #$0E
d42	ldy #$FC
	sta $d40a		;line=224
	sta color0
	stx color1
	sty color2
d43	lda #$B6
	sta color3
	DLINEW dl_19

dl_19
d44	lda #$24
d45	ldx #$0E
d46	ldy #$54
	sta $d40a		;line=232
	sta color0
	stx color2
	sty color3
	jmp nmi_title.quit
;-------
.PROC nmi_title
	sta rA
	stx rX
	sty rY

	bit $d40f
	bpl VBL

	jmp dl__start
dl_v	equ *-2

VBL
	sta $d40f		;reset NMI flag

	inc cloc		;little timer

	mwa #ANTIC_PROGRAM_TITLE $d402	;ANTIC address program

	mva #scr32               $d400	;set new screen's width

;--- first line of screen initialization

	lda >BJ_panel	        ; TOP SCORE PANEL BJACK1.FNT
	sta chbase
d0	lda #$00
	sta colbak
d1	lda #$72
	sta color0
d2	lda #$7A
	sta color1
d3	lda #$FA
	sta color2
d4	lda #$0E
	sta color3
	lda #$04
	sta gtictl
	lda #$00
	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	sta sizem       ; colour rotation effect on score top panel

	lda #139+6      ;$72
	sta hposp0	; 4 PLAYERS - SHAPE = #192
	lda #139+4      ;$70
	sta hposp1
	lda #139+2      ;$6E
	sta hposp2
	lda #139        ;$6C
	sta hposp3
	lda #108        ;$8B 4 MISSILES - SHAPE = #255
	sta hposm0
	lda #108+2      ;$8D
	sta hposm1
	lda #108+4      ;$8F
	sta hposm2
	lda #108+6      ;$91
	sta hposm3

d5	lda #$78	; COLOURS IN REVERSE PM0=LIGHT PM3=DARK
	sta colpm0
d6	lda #$76
	sta colpm1
d7	lda #$74
	sta colpm2
d8	lda #$72
	sta colpm3

	mwa #dl__start dl_v	;set the first address of DLI interrupt

;this area is for yours routines
	jsr external_vbl

quit    lda rA
	ldx rX
	ldy rY
	rti
.ENDP

.macro	DLINEW
	ift .hi(?old_dli)==.hi(:1)
	mva <:1 nmi_title.dl_v
	els
	mwa #:1 nmi_title.dl_v
	eif

	jmp nmi_title.quit

	.def ?old_dli = *
.endm

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Wywietl aktualn liczb punktw gracza na bonusowym ekranie
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Score_Player_Bonus1
                  ldx #2
                  ldy #5

scor_loop3        lda Add_Value_to_Score_Player,x
                  and #$0F
                  add #16
                  sta text_POINTS_add+10,y-

                  lda Add_Value_to_Score_Player,x
                  :4 lsr @
                  add #16
                  sta text_POINTS_add+10,y-

                  dex
                  bpl scor_loop3

                  rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura przygotowuje ekran, na ktrym potem mona wywietli "PERFECT SCREEN" i "GET NICK SCREEN"
;--------------------------------------------------------------------------------------------------------------------------------------------------------
prepare_screen .proc
                  lda #$00
               :8 sta        sprites[#].sts
               :4 sta        col_PM0+#
                  lda #$ff
               :7 sta tab_choose_sprite+1+#

                  jsr init_B2
               ;   jsr init_B3
                  cop_mem #b2scr,#tab_Back32x26,#@sh*@sw
                  rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura pokazuje ekran gdzie wpisujemy nick gracza, umoliwia wpisanie 3-literowego nicka i zapisuje wynik+nicka gracza w tablicy tab8_player1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Get_Nick_Screen .proc
; sprawd czy wynik osignity przez gracza jest wyszy ni najgorszy rezultat w wynikach HI SCORE
                  jsr zero_multiplex_DLI                       ; wycz dziaanie MULTIPLEXER'a PMG

                  lda tab8_score7+$00
                  cmp Score_Player+$00
                  beq Get_Nick_skip1
                  bcc Get_Nick_skip4
                  rts

Get_Nick_skip1    lda tab8_score7+$01
                  cmp Score_Player+$01
                  beq Get_Nick_skip2
                  bcc Get_Nick_skip4
                  rts

Get_Nick_skip2    lda tab8_score7+$02
                  cmp Score_Player+$02
                  bcc Get_Nick_skip4                                 ; wynik jest gorszy wic nie wpisuj na list HI SCORE i uruchom gr od pocztku

; gracz osign lepszy wynik ni ten najgorszy z listy HI SCORE
Get_Nick_skip4    cop_mem #tab_Back32x26,#b2scr,#@sh*@sw
                  mwa #B2ant AddrDisplayList
                  mva #$00   choose_PMG
                  sta        choose_PMG_on_VBL

                  jsr InitFont2                                      ; skopiowanie fontu A-V i 0-9 do znakw normalnie wykorzystywanych przez SPRITE'y

                  mwa #text_AN_ACE_BOMBJACKER address1
                  mwa #B2SCR+10*32            address2
                  jsr print_bonus_text

                  mwa #text_YOUR_NAME_PLEASE  address1
                  mwa #B2SCR+11*32            address2
                  jsr print_bonus_text

                  mwa #text_NICK              address1
                  mwa #B2SCR+13*32            address2
                  jsr print_bonus_text

; ustaw PMG #1-#3 tak, eby napisy byy kolorowe
                  jsr init_pmg

                  mva #3 counter
                  ldx #0

nick_lop0         ldy counter
                  lda tab_pmg_nick1-1,y
                  tay
                  add #8
                  sta nick_cpy+1

nick_lop1         mva pmg3_AN_ACE_BOMBJACKER+0,x pmg0+$500,y
                  mva pmg3_AN_ACE_BOMBJACKER+1,x pmg0+$600,y
                  mva pmg3_AN_ACE_BOMBJACKER+2,x pmg0+$700,y
                  iny
nick_cpy          cpy #$ff
                  bne nick_lop1

                  :3 inx

                  dec counter
                  bne nick_lop0

; ustaw PMG #0 dla migajcej litery
                  ldy #16*8+7
                  ldx #7
                  lda #$80

nick_lop2         sta pmg0+$400,y
                  dey
                  dex
                  bpl nick_lop2

                  mva #$04      board_prior
                  mva #84+36    posx_P0_vbl
                  mva #84-8     posx_P1_vbl
                  mva #84+32-8  posx_P2_vbl
                  mva #84+64-8  posx_P3_vbl
                  mva #84+92-8  posx_M1_vbl
                  mva #84+96-8  posx_M2_vbl
                  mva #84+104-8 posx_M3_vbl

                  ldx Number_Board
                  mva tab_col_bonus1-1,x tcol_pmg+2
                  sta                    tcol_pmg_vbl+2
                  mva tab_col_bonus2-1,x tcol_pmg+5
                  sta                    tcol_pmg_vbl+5
                  sta                    tcol_pmg+8
                  sta                    tcol_pmg_vbl+8
                  sta                    tcol_pmg+11
                  sta                    tcol_pmg_vbl+11

                  mvx #$FF size_P0_vbl
                  stx      size_P1_vbl
                  stx      size_P2_vbl
                  stx      size_P3_vbl
                  stx      size_MM_vbl

; tutaj pobieramy 3 litery wpisane z wykorzystaniem JOYSTICK'a - nick gracza, ktry wraz z punktami znajdzie si na licie HI SCORE
                  jsr fade_in
                  mva #mus_hall_fame number_song                ; set number of music
                  jsr play_music

                  mvx #0   index_nick
                  inx
                  stx      Is_Blink_PMG                         ; migaj PMG #0
                  mva #33  letter_nick
letter_nick = *+1
Get_Nick_loop1    lda #$ff
index_nick = *+1
                  ldx #$ff
                  add #charsBAK-33
                  sta B2SCR+32*13+14,x

                  ldx #9
                  jsr wait_time
                  lda porta
                  and #$01                         ; Joystick w gr ?
                  beq up_nick
                  lda porta
                  and #$02                         ; czy w d JOYSTICK?
                  beq down_nick
                  lda porta                        ; Czy joystick w lewo?
                  and #$04
                  beq left_nick
                  lda porta
                  and #$08                         ; Czy joystick w prawo?
                  beq right_nick
                  lda trig0                        ; czy wcinieto FIRE?
                  jne Get_Nick_loop1               ; NIE!

; pobranie caego wpisanego nicka i zapamitanie go
                  mva #0   Is_Blink_PMG           ; nie migaj PMG #0
                  ldy #7
                  sta pmg0+$400+16*8,y-           ; kasowanie wzoru kursora
                  rpl

; ptla przepisuje wynik gracza+nick(7 bajtw) do tablicy, ktra potem zostanie wpisana do listy HI SCORE
                  ldx #$02
                  mva Score_Player,x tab8_player1+$00,x-
                  rpl

                  ldx #$03
                  sbb B2SCR+32*13+14,x #charsBAK tab8_player1+$03,x-
                  rpl

                  ldx #10
                  jsr wait_time

                  jsr stop_music
                  jsr fade_out
                  jmp Add_Player_Score

; zmiana litery na poprzedni w alfabecie w miejscu wskazywanym przez kursor
up_nick           dec letter_nick
                  lda letter_nick
                  cmp #33-1                        ; czy litera "A"?
                  jne Get_Nick_loop1               ; NIE!

                  mva #59 letter_nick              ; ustaw litere "Z"
                  jmp Get_Nick_loop1

; zmiana litery na kolejn w alfabecie w miejscu wskazywanym przez kursor
down_nick         inc letter_nick
                  lda letter_nick
                  cmp #59+1                        ; czy litera "Z"?
                  jne Get_Nick_loop1               ; NIE!

                  mva #33 letter_nick              ; ustaw litere "A"
                  jmp Get_Nick_loop1

; przesunicie kursora wprowadzania w lewo
left_nick         dec index_nick
                  dec index_nick

; przesunicie kursora wprowadzania w prawo
right_nick        inc index_nick
                  lda index_nick
                  and #3
                  sta index_nick
                  tay
                  :2 asl @
                  adc #84+36
                  sta posx_P0_vbl

                  ldx #9
                  jsr wait_time

; pobranie jednej litery z pozycji kursora
                  lda B2SCR+32*13+14,y
                  sub #charsBAK-33
                  sta letter_nick
                  jmp  get_nick_loop1

tab_pmg_nick1           dta 16*8,14*8,13*8
tab_pmg_nick2           dta 18*8,14*8,14*8

tab_col_nick1           dta $0F,$0F,$0F,$0F,$0F
tab_col_nick2           dta $FF,$FF,$FF,$FF,$FF

text_AN_ACE_BOMBJACKER  dta "       YOU ARE A BOMB ACE       "
text_YOUR_NAME_PLEASE   dta "        YOUR NAME PLEASE        "
text_NICK               dta "              AAAA              "

pmg3_AN_ACE_BOMBJACKER  dta %00001110,%11101011,%11011100
pmg3_YOUR_NAME_PLEASE   dta %00000111,%10111101,%11111000
pmg3_NICK               dta %00000000,%00011110,%00000000
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Wywietl aktualn liczb punktw gracza na bonusowym ekranie
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Score_Player_Bonus2
                  ldx #2
                  ldy #5

scor_loop2        lda Score_Player,x
                  and #$0F
                  add #16
                  sta text_POINTS_all+10,y-

                  lda Score_Player,x
                  :4 lsr @
                  add #16
                  sta text_POINTS_all+10,y-

                  dex
                  bpl scor_loop2

                  rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypisuje text na planszy (wykorzystywane np: przez "BONUS SCREEN")
;--------------------------------------------------------------------------------------------------------------------------------------------------------
print_bonus_text  ldy #31
shw_bonus_lop1    lda (address1),y
                  beq shw_bonus_skp2
                  cmp #33
                  bcs shw_bonus_skp1

                  adc #charsBAK+22-16-[charsBAK-33]

shw_bonus_skp1    add #charsBAK-33
                  sta (address2),y
shw_bonus_skp2    dey
                  bpl shw_bonus_lop1

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; skopiowanie czci fontu dla "PERFECT SCREEN" (litery A-V oraz cyfry 0-9 - niekompletny font bo mamy miejsce tylko na 32 znaki) do znakw normalnie wykorzystywanych przez SPRITE'y
; skopiowanie caego fontu dla "GET NICK SCREEN"
;--------------------------------------------------------------------------------------------------------------------------------------------------------
InitFont2         ldx #tab_font_dst2-tab_font_src2-2
                  mwa #InitFont_lop2    jmp_loop+1

InitFont_lop2     mwa tab_font_src2,x   address1
                  mwa tab_font_dst2,x   address2
                  mva tab_font_len2+1,x Init_lop1+1
                  lda tab_font_len2+0,x
                  tay
                  beq Init_lop1
                  bne Init_lop0               ; jmp
;-----------------
InitFont          ldx #tab_font_dst-tab_font_src-2
                  mwa #InitFont_lop   jmp_loop+1

InitFont_lop      mwa tab_font_src,x   address1
                  mwa tab_font_dst,x   address2
                  mva tab_font_len+1,x Init_lop1+1
                  lda tab_font_len+0,x
                  tay
                  beq Init_lop1

; kopiowanie reszty z podziau przez liczb 256
Init_lop0         dey
                  lda (address1),y
                  eor #$ff
                  sta *+6
                  lda #%01010101
                  and #$ff
                  sta (address2),y
                  cpy #0
                  bne Init_lop0

Init_lop1         ldy #$ff
                  beq Init_lop3

; skopiuj bloki po 256 bajtw
                  sty counter
                  ldy #0
Init_lop2         lda (address1),y
                  eor #$ff
                  sta *+6
                  lda #%01010101
                  and #$ff
                  sta (address2),y
                  iny
                  bne Init_lop2

                  dec counter
                  bne Init_lop2

Init_lop3         :2 dex
                  bmi InitFont_RTS

jmp_loop          jmp InitFont_lop

InitFont_RTS      rts

tab_font_src  .dw           BJ_panel+57*8,         BJ_panel+57*8,         BJ_panel+57*8,         BJ_panel+57*8,         BJ_panel+57*8,         BJ_panel+57*8,         BJ_panel+57*8,         BJ_panel+57*8,        BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,        BJ_panel+16*8,         BJ_panel+16*8,         BJ_panel+16*8,         BJ_panel+16*8,         BJ_panel+16*8,         BJ_panel+16*8,         BJ_panel+16*8,         BJ_panel+16*8
tab_font_dst  .dw  B2fnt0+(charsBAK+16)*8,B2fnt1+(charsBAK+16)*8,B2fnt2+(charsBAK+16)*8,B2fnt3+(charsBAK+16)*8,B3fnt0+(charsBAK+16)*8,B3fnt1+(charsBAK+16)*8,B3fnt2+(charsBAK+16)*8,B3fnt3+(charsBAK+16)*8,B2fnt0+(charsBAK+0)*8, B2fnt1+(charsBAK+0)*8, B2fnt2+(charsBAK+0)*8, B2fnt3+(charsBAK+0)*8, B3fnt0+(charsBAK+0)*8, B3fnt1+(charsBAK+0)*8, B3fnt2+(charsBAK+0)*8, B3fnt3+(charsBAK+0)*8,B2fnt0+(charsBAK+22)*8,B2fnt1+(charsBAK+22)*8,B2fnt2+(charsBAK+22)*8,B2fnt3+(charsBAK+22)*8,B3fnt0+(charsBAK+22)*8,B3fnt1+(charsBAK+22)*8,B3fnt2+(charsBAK+22)*8,B3fnt3+(charsBAK+22)*8
tab_font_len  .dw                     1*8,                   1*8,                   1*8,                   1*8,                   1*8,                   1*8,                   1*8,                   1*8,                 22*8,                  22*8,                  22*8,                  22*8,                  22*8,                  22*8,                  22*8,                  22*8,                  10*8,                  10*8,                  10*8,                  10*8,                  10*8,                  10*8,                  10*8,                  10*8

tab_font_src2 .dw           BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8,         BJ_panel+33*8
tab_font_dst2 .dw  B2fnt0+(charsBAK+$0)*8,B2fnt1+(charsBAK+$0)*8,B2fnt2+(charsBAK+$0)*8,B2fnt3+(charsBAK+$0)*8,B3fnt0+(charsBAK+$0)*8,B3fnt1+(charsBAK+$0)*8,B3fnt2+(charsBAK+$0)*8,B3fnt3+(charsBAK+$0)*8
tab_font_len2 .dw                    27*8,                  27*8,                  27*8,                  27*8,                  27*8,                  27*8,                  27*8,                  27*8
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wywietla ekran z BONUSem
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Bonus_Screen lda Counter_Blink_BOMBS
                  cmp #20
                  bcs *+3
                  rts

                  jsr zero_multiplex_DLI                       ; wycz dziaanie MULTIPLEXER'a PMG
                  cop_mem #tab_Back32x26,#b2scr,#@sh*@sw
                  mwa #B2ant AddrDisplayList
                  mva #$00   choose_PMG
                  sta        choose_PMG_on_VBL

                  jsr InitFont                 ; skopiowanie fontu A-V i 0-9 do znakw normalnie wykorzystywanych przez SPRITE'y

                  lda Counter_Blink_BOMBS
                  and #7
                  tay
                  mva tab_get_digital,y text_YOU_HAVE_GOTTEN+19
                  lda tab_get_scoreH,y
                  ldx tab_get_scoreL,y
                  ldy #0
                  jsr Add_Points_to_SCORE_PLAYER_AXY
                  jsr Show_Score_Player_Bonus1
                  jsr Show_Score_Player_Bonus2

                  mwa #text_YOU_HAVE_GOTTEN   address1
                  mwa #B2SCR+9*32             address2
                  jsr print_bonus_text

                  mwa #text_POINTS_add        address1
                  mwa #B2SCR+11*32            address2
                  jsr print_bonus_text

                  mwa #text_GIVING_YOU        address1
                  mwa #B2SCR+13*32            address2
                  jsr print_bonus_text

                  mwa #text_POINTS_all        address1
                  mwa #B2SCR+15*32            address2
                  jsr print_bonus_text

; ustaw PMG #1-#3 tak, eby napisy byy kolorowe
                  jsr init_pmg

                  mva #4 counter
                  ldx #0

bonus_lop0        ldy counter
                  lda tab_pmg_bonus1-1,y
                  tay
                  add #8
                  sta bonus_cpy+1

bonus_lop1        mva pmg3_YOU_HAVE_GOTTEN+3,x pmg0+$300,y
                  mva pmg3_YOU_HAVE_GOTTEN+0,x pmg0+$500,y
                  mva pmg3_YOU_HAVE_GOTTEN+1,x pmg0+$600,y
                  mva pmg3_YOU_HAVE_GOTTEN+2,x pmg0+$700,y
                  iny
bonus_cpy         cpy #$ff
                  bne bonus_lop1

                  :4 inx

                  dec counter
                  bne bonus_lop0

; ustaw PMG #0 tak, eby napisy byy kolorowe
                  mva #4 counter
                  ldx #0

bonus_lop2        ldy counter
                  lda tab_pmg_bonus1-1,y
                  tay
                  add #8
                  sta bonus_cpy2+1

bonus_lop3        lda pmg0+$300,y
                  ora pmg0_YOU_HAVE_GOTTEN+2,x
                  sta pmg0+$300,y
                  mva pmg0_YOU_HAVE_GOTTEN+1,x pmg0+$400,y
                  iny
bonus_cpy2        cpy #$ff
                  bne bonus_lop3

                  :4 inx

                  dec counter
                  bne bonus_lop2

                  mva #$04    board_prior
                  mva #72     posx_P1_vbl
                  mva #72+32  posx_P2_vbl
                  sta         posx_P0_vbl
                  mva #72+64  posx_P3_vbl
                  sta         posx_M0_vbl
                  mva #72+92  posx_M1_vbl
                  mva #72+96  posx_M2_vbl
                  mva #72+104 posx_M3_vbl

                  ldx Number_Board
                  mva tab_col_bonus1-1,x tcol_pmg+2
                  sta                    tcol_pmg_vbl+2
                  mva tab_col_bonus2-1,x tcol_pmg+5
                  sta                    tcol_pmg_vbl+5
                  sta                    tcol_pmg+8
                  sta                    tcol_pmg_vbl+8
                  sta                    tcol_pmg+11
                  sta                    tcol_pmg_vbl+11

                  mvx #$FF size_P0_vbl
                  stx      size_P1_vbl
                  stx      size_P2_vbl
                  stx      size_P3_vbl
                  stx      size_MM_vbl

                  jsr fade_in
                  mva #mus_perfect number_song                ; set number of music
                  jsr play_music

                  wait_trig0

                  jsr stop_music
                  jmp fade_out

tab_pmg_bonus1  dta 18*8,16*8,14*8,12*8
tab_pmg_bonus2  dta 18*8,18*8,14*8,14*8

tab_col_bonus1  dta $0F,$0F,$0F,$0F,$0F
tab_col_bonus2  dta $FF,$FF,$FF,$FF,$FF

tab_get_digital dta $04+16,$00+16,$00+16,$00+16,$00+16,$01+16,$02+16,$03+16   ; kocowa cyfra 0,1,2,3,4 w zalenoci od "Counter_Blink_BOMBS"
tab_get_scoreL  dta    $00,   $00,   $00,   $00,   $00,   $10,   $20,   $30   ; modszy bajt punktw przyznawanych za zebranie bomb w iloci: 20-24
tab_get_scoreH  dta    $05,   $00,   $00,   $00,   $02,   $02,   $02,   $02   ; starszy bajt punktw przyznawanych za zebranie bomb w iloci: 20-24

text_YOU_HAVE_GOTTEN  dta "  QOU HAVE GOTTEN 20 FIREBOMBS  "
text_POINTS_add       dta "          000000 POINTS         "
text_GIVING_YOU       dta "      GIVING QOU A SCORE OF     "
text_POINTS_all       dta "          000000 POINTS         "

pmg0_YOU_HAVE_GOTTEN  dta %00000000,%00000000,%00000011,%00000000
pmg0_POINTS_add       dta %00000000,%11111100,%00000000,%00000000
pmg0_GIVING_YOU       dta %00000000,%00000000,%00000000,%00000000
pmg0_POINTS_all       dta %00000000,%11111100,%00000000,%00000000

pmg3_YOU_HAVE_GOTTEN  dta %11101111,%01111110,%00011111,%11110000
pmg3_POINTS_add       dta %00000000,%00000001,%11111000,%00000000
pmg3_GIVING_YOU       dta %00001111,%11011101,%01111101,%00000100
pmg3_POINTS_all       dta %00000000,%00000001,%11111000,%00000000

        .endpg
/*
; ---	dane
	NMB
	.pages $40
board6	 ins 'init\tlo\s6.gz'
board7   ins 'init\tlo\s7.gz'
board8	 ins 'init\tlo\s8.gz'
board9	 ins 'init\tlo\s9.gz'
board10	 ins 'init\tlo\s10.gz'
        .endpg
*/
last_used_bank

	opt b-				; BANK SENSITIVE OFF

	RMB				; BANK = 0

; od teraz mamy dostp do wszystkich etykiet zdefiniowanych w obszarze dodatkowych bankw

; ---	MAIN PROGRAM

	org prg

BJ_panel ins 'bj_panel.fnt'

; ---	ANTIC PROGRAMs

ANTIC_PROGRAM_TITLE
        dta $44,a(gorny_panel),$84,$C4,a(scr_1+@sw*2),$04,$04,$84,$04,$84,$84,$04,$04,$84,$04,$84
        dta $04,$84,$84,$04,$04,$84,$84,$84,$04,$84,$04,$04,$04,$84,$C4,a(dolny_panel),$04
        dta $41,a(ANTIC_PROGRAM_TITLE)

ANTIC_PROGRAM_SCORE
	dta $44,a(gorny_panel),$84,$44,a(scr_2+@sw*2),$84,$84,$04,$84,$04,$04,$04,$84,$04,$04,$04
	dta $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$84,$C4,a(dolny_panel),$04
	dta $41,a(ANTIC_PROGRAM_SCORE)

B2ant	dta $44+$80,a(gorny_panel),$84
	dta $c4,a(B2scr)
	:25 dta $84
	dta $44+$80,a(dolny_panel),4
	dta b($41),a(B2ant)

B3ant	dta $44+$80,a(gorny_panel),$84
	dta $c4,a(B3scr)
	:25 dta $84
	dta $44+$80,a(dolny_panel),4
	dta b($41),a(B3ant)

gorny_panel	dta d' PL-SCORE    !"'
xBonus = *-2
                dta d'#$%'*
                dta d'&             '
                dta d"   "
panel_score_player
                dta d"000000    '"
                dta d"()*+,             "*

life_panelu
dolny_panel	dta d'<=<=<=        '
                dta d'ROUND'*
                dta d'     HI-SCORE'
life_paneld     dta d'>?>?>?         '*
                dta d'-'*
panel_round     dta d'00-'*
                dta d'       081710'
panel_HiScore = *-6

; ---	DATA

	icl 'data.asm'

; ---	DLI PROGRAM
; program przerwania DLI

@DLI	.struct
	lda	.word
	ldx	.word
	ldy	.word
	stad40a	.long
	sta	.long
	stx	.long
	sty	.long
	lda2	.word
	sta2	.long
	ldx2	.word
	stx2	.long
;	ldy2	.word
;	sty2	.long
	.ends


__dli	;lda #$00		; przerwanie dla 2 wiersza panelu grnego
	;ldx #$00
	mvy #$0E	color2
;	sta color1
;	stx color2
;	sty color3

	ift .hi(dli0)==.hi(__dli)
	mva <dli0 vdli
	els
	mwa #dli0 vdli
	eif

	lda rA
	ldx rX
	ldy rY
	rti

; programy DLI(1-24) dla kolejnych wierszy (MULTIPLEXER PMG)
        .rept 25,#
pmg7_multiplex_row:1 .proc
	  mva posx_P7_vbl hposp3
	  mva posx_M7_vbl hposm3
	  mva col_PM7_vbl colpm3
          jmp ret_pmg7_row:1
 .endp

pmg6_multiplex_row:1 .proc
	  mva posx_P6_vbl hposp2
	  mva posx_M6_vbl hposm2
	  mva col_PM6_vbl colpm2
          jmp ret_pmg6_row:1
 .endp
        .endr

count_shd_pmg dta $00
tab_shd_pmg   dta $08,$08,$0A,$0A,$0C,$0C,$0E,$0E

	.rept @sh , # , #+1

dli:1	dta @dli [0] ($a9, $a2, $a0, $d40a8d, $d4098d, $d01e8e, $d01e8c, $a9, $d01e8d, $a2, $d01e8e) ;, $a9,$d01e8d, $a2,$d01e8e, $a0,$d01e8c)

	ift :2=1                            ; ustaw pozycj i kolor PMG dla planszy ('bomb jack' i 'przeciwnicy')
board_prior = *+1
          mva #$ff        prior
          mva size_MM_vbl sizem

	  mva posx_P0_vbl hposp0
	  mva posx_M0_vbl hposm0
	  mva col_PM0_vbl colpm0
          mva size_P0_vbl sizep0

	  mva posx_P1_vbl hposp1
	  mva posx_M1_vbl hposm1
	  mva col_PM1_vbl colpm1
          mva size_P1_vbl sizep1

	  mva posx_P2_vbl hposp2
	  mva posx_M2_vbl hposm2
	  mva col_PM2_vbl colpm2
          mva size_P2_vbl sizep2

	  mva posx_P3_vbl hposp3
	  mva posx_M3_vbl hposm3
	  mva col_PM3_vbl colpm3
          mva size_P3_vbl sizep3
	eif
        ift :1<25                    ; tutaj wstawiamy adres procki zmieniajcej pozycje i kolor dla PMG #2-#3 (dla multiplexer'a PMG)
          jmp pmg7_multiplex_row:1
ret_pmg7_row:1
          jmp pmg6_multiplex_row:1
ret_pmg6_row:1
        eif

        ift :2<26

	ift .hi(dli:1)==.hi(dli:2)
	mva <dli:2 vdli
	els
	mwa #dli:2 vdli
	eif

	els

	ift .hi(dli:1)==.hi(_dli26)
	mva <_dli26 vdli
	els
	mwa #_dli26 vdli
	eif

	eif

        ift :2=2
          lda Is_Blink_PMG
          beq dli_skp1

          lda count_shd_pmg       ; migaj PMG podczas wpisywania Nicka
          add #1
          and #7
          sta count_shd_pmg
          tax
          lda col_PM0_vbl
          and #%11110000
          ora tab_shd_pmg,x
          sta col_PM0_vbl
dli_skp1
        eif

	lda rA
	ldx rX
	ldy rY
	rti
	.endr


_dli26	lda #>bj_panel
	ldx #$78
	ldy #$B6
	sta $d40a
	sta chbase

;	sty      colbak
	stx      color0
        sty      color3
        mva #$FC color2
	mva #$0E color1

	ift .hi(_dli27)==.hi(_dli26)
	mva <_dli27 vdli
	els
	mwa #_dli27 vdli
	eif

	lda rA
	ldx rX
	ldy rY
	rti


_dli27	lda #$0E
        ldx #$24
	sta $d40a

;	sta      colbak
	stx      color0
	sta      color1
        mva #$0E color2
        mva #$54 color3

	lda rA
	ldx rX
	ldy rY
	rti

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Procedura ustawia numer planszy w zalenoci od aktualnej rundy
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Round2Board
        lda Number_Round_BIN            ; podziel numer rundy przez 5 bo jest tylko 5 planszy!
        ldx #$00
        ldy #5
        jsr div
        ldx __bta                       ; reszta po podzieleniu przez 5
        bne *+4
        ldx #5
        stx Number_Board                ; #1-#10 ;5
        rts

;########################################################################################################################################################
* ---	MAIN PROGRAM
;########################################################################################################################################################
main    ldx #$7f		               ; skasowanie bit0 w kodach bankw pamici
_cl	lda @TAB_MEM_BANKS,x
	and #$fe
	sta @TAB_MEM_BANKS,x
	dex
	bpl _cl

        ldx <tcol_title
        ldy >tcol_title
	jsr save_color
        ldx <tcol_score
        ldy >tcol_score
	jsr save_color

; wywietl TITLE SCREEN
        cld
        sei
	mva #$00 nmien
	sta      dmactl

start_game
        mva #$00 is_mute_music
        sta      Show_Number_Round.repeat_20levels
        mva @TAB_MEM_BANKS+=title portb        ; ustaw bank, w ktrym jest plansza
        mwa #title inputPointer
        mwa #$D800-6 outputPointer
        jsr inflate

        mwa #hi_score inputPointer
        mwa #$E800-6 outputPointer
        jsr inflate

        mva #mus_title     number_song
        jsr play_music
        mva #num_rot cnt_rot                ; set index to rotating color table
        mva #num_col cnt_col                ; set color for rotating colors
        mva #num_shd cnt_shd                ; set shadow for rotating colors

        mva @TAB_MEM_BANKS+=:main_title portb

        mva #$01       is_rotating_colors
        jsr Set_Number_of_Round             ; in reg.A must be = 1!

        mva #$00 Score_Player+0
        sta      Score_Player+1
        sta      Score_Player+2
        sta      Counter_Collected_Letter_B ; ile zebrano na planszy "LITER B"
        mva #3   pos_tab_addr_live          ; pozycja gdzie mona narysowa dodatkowe ycie
        jsr refresh_info                    ; aktualizuj wszystkie informacje na grnym i dolnym panelu

title_screen
        jsr :main_title
        jcs main2
        jsr :main_score                     ; wywietl HI-SCRORE SCREEN
        jcs main2
        jmp title_screen

; wyczamy ROM, inicjalizujemy odpowiednie rejestry
main2   lda:cmp:req cloc
        jsr stop_music

        jsr init_pmg
        mva >pmg0      pmbase		    ; missiles and players data address
	mva #3         $d01d	            ; enable players and missiles

	mva #0 sizem		            ; pociski i duchy normalnej szerokoci (pojedyczej)
	sta    sizep0
	sta    sizep1
	sta    sizep2
	sta    sizep3

	?b = 115+24
	?c = 84+24
	mva #?b+0	panel_posx_P3
	mva #?c+0       panel_posx_M0

	mva #?b+2	panel_posx_P2
	mva #?c+2       panel_posx_M1

	mva #?b+4	panel_posx_P1
	mva #?c+4       panel_posx_M2

	mva #?b+6	panel_posx_P0
	mva #?c+6       panel_posx_M3

;---	inicjalizacja silnika
	jsr shapeMOV		        ; przepisanie procedury SHAPEZP na stron zerow

	lda #0			        ; zerowanie statusu duchw, wszystkie wyczone STS=0
	:max_sprites sta sprites[#].sts

        ldx #0
        ldy #21

        .rept 7,#
	  mva   @TAB_MEM_BANKS+[=shape:1] shapes[#].bnk ; dopisanie ksztatu SHAPE #0 do tablicy SHAPES
          stx	shapes[#].typ   		        ; =0 ksztat o rozmiarze 12x24
          sty	shapes[#].hig		                ; wysoko dla tego ksztatu
        .endr

next_board
        ldx #$ff
        txs
        mva #$00 size_MM_vbl
        mva #$ff key
        jsr Round2Board                 ; ustawia numer planszy #1-5  zalenoci od aktualnej rundy
        jsr init_scr

        icl 'BombGame.asm'

	jmp	loop		        ; LET'S GO

	opt l-
	icl 'global\align.mac'
	icl 'global\@bank_add.mac'
	icl 'global\@bank_jmp.mac'
        opt l+

	icl 'loop.asm'

	ift COLLISION_DETECTION
	icl 'detect.asm'
	eif


; obsuga zebrania 'LITERY B'
service_letter_B .proc
        mva #C64_Points tab_Type_SPRITES_1_7+letter_sprite-1          ; typ sprite'a - punkty
        mva #$05 tab_Points_100_600_SPRITES_1_7+letter_sprite-1       ; ile punktw wywietli: $05 - 500 punktw
        tax
        lda #$00
        tay
        jsr Add_Points_to_SCORE_PLAYER_AXY              ; dodaj 500 punktw zawartych w rej. A,X,Y do punktw gracza
        mva #sfx_get_letter_B sfx_effect                ; odtwrz SFX zebrania litery B
        inc Counter_Collected_Letter_B                  ; zebrano kolejn "LITERE B"
        jsr Show_Digital_Panel                          ; poka mnonik: x1, x2, x3 , x4 dla otrzymywanych punktw
        jmp Exec_BJ0
.endp

; obsuga zebrania 'LITERY E'
service_letter_E .proc
        mva #$00 tab_Type_SPRITES_1_7+letter_sprite-1   ; zma liter
        mva #sfx_get_letter_E sfx_effect                ; odtwrz SFX zebrania litery B
        lda pos_tab_addr_live                           ; sprawdzamy czy ju max. dozowlona liczba y zostaa osignita
        cmp #6
        scs
        inc pos_tab_addr_live                           ; wskazuje na pozycje w tablicy, gdzie jest adres, pod ktrym mona narysowa nowe ycie BOMB JACK-a
        jsr Show_Lifes_BombJack
        jmp Exec_BJ0
.endp

; obsuga zebrania 'LITERY P'
service_letter_P .proc
        mwa #$96*2 Time_Get_SmilingFace_Soon_Finish
        mva #$01   Counter_Add_100_600_Points_for_Every_SmilingFace

        ldx #$04                                    ; sprawd wszystkich 5-ciu przeciwnikw
ex_lop1 mva #$00                   index_tab_clips_Move_Opponent,x
        sta                        tab_Every_Third_Frame_Move_Sprite,x

        mva tab_Type_SPRITES_1_7,x save_tab_Type_SPRITES_1_7,x
        mva tab_Addr_Sprite1_7_Pattern,x save_tab_Addr_Sprite1_7_Pattern,x
        beq ex_lop2

        cmp #$0E                                    ; Czy wolne miejsce, eby pojawi si nowy przeciwnik?
        beq ex_lop2                                 ; TAK!

        mva #C64_Smiling_Face tab_Type_SPRITES_1_7,x

ex_lop2 dex                                         ; kolejny SPRITE
        bpl ex_lop1

        mva #$00 tab_Type_SPRITES_1_7+letter_sprite-1 ; wyczy typ sprite'a
        mva #mus_bonus number_song                    ; set number of music
        jsr play_music
        mva #1    Smiling_Time
        jmp Exec_BJ0
.endp

;------------------------------------------------------------------
; procedura wykonywana jeeli wykryto zebrania "buki" przez BJ
;------------------------------------------------------------------
set_get_smilling_face .proc
        mva #C64_Points          tab_Type_SPRITES_1_7,y                                       ; typ sprite'a - punkty
        mva #$0E                 save_tab_Type_SPRITES_1_7,y                                  ; ta buka zostaa ju zebrana wic ten sprite jest wolny
        mva Counter_Add_100_600_Points_for_Every_SmilingFace tab_Points_100_600_SPRITES_1_7,y ; ile punktw wywietli: $01-$05 - 100-500 punktw
        tax
        lda #$00
        tay
        jsr Add_Points_to_SCORE_PLAYER_AXY
        inc Counter_Add_100_600_Points_for_Every_SmilingFace
        mva #sfx_get_opponent sfx_effect                                                      ; odtwrz SFX zebrania "buki"
        mva #2 clr_second_time_pmg                                                            ; =1 ustaw znacznik kasowania PMG w nastpnej ramce
        jmp Exec_BJ0
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; program obsugi 'bomb jack-a'
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Exec_BombJack .proc
        lda Is_Dead_BOMB_JACK                           ; Jeeli BJ jest martwy to ju adnych kolizji nie sprawdzaj!
        jne exit                                        ; Obsu tylko rysowanie PMG od razu!

        ldx DETECT_UPD.HIT+1                            ; Czy nastpia jaka kolizja BJ z czym?
        jeq exit                                        ; NIE! wic koniec programu obsugi BJ

        dex                                             ; koniecznie cofamy si o 1 pozycj
        stx count

; jeeli tak to tutaj ustalamy z jakim spritem zetkn si BJ
test    ldx count
        ldy DETECT_UPD.STATUS,x
        jsr test_collision
        dec count
        bpl test

exit    jsr fill_pmg_clip

        lda choose_PMG
        eor #1
        sta choose_PMG
        rts

count dta $00
.endp

test_collision
        cpy #@sprite*letter_sprite                      ; Czy kolizja 'bomb jacka' ze spritem nr. 'letter_sprite'?
        jne Exec_BJ02                                   ; NIE!

        lda tab_Type_SPRITES_0_7+letter_sprite
        cmp #C64_Letter_B                               ; Czy sprite #7 to litera B?
        jeq service_letter_B                            ; TAK!
        cmp #C64_Letter_E                               ; Czy sprite #7 to litera E?
        jeq service_letter_E                            ; TAK!
        cmp #C64_Letter_P                               ; Czy sprite #7 to litera P?
        jeq service_letter_P                            ; TAK!
        jmp Exec_BJ0                                    ; Czyli natrafiono na C64_Points (wstawiane zaraz po zebraniu danej litery)

; obsuga zbierania 'umiechnitej buki'
Exec_BJ02
        tya
        ldx #0
        ldy #@sprite
        jsr div
        ldy __rsl
        dey                                             ; pobierz cz cakowit
        lda tab_Type_SPRITES_1_7,y
        beq Exec_BJ0
        cmp #C64_Smiling_Face                           ; Czy kolizja z 'umiechnit buk'?
        jeq set_get_smilling_face                       ; TAK!
        cmp #C64_New_Opponent
        bcs Exec_BJ0
        lda Smiling_Time
        bne Exec_BJ0

        lda Is_Dead_BOMB_JACK
        bne Exec_BJ0

; nastpia kolizja z przeciwnikiem
        lda is_turn_immortal                            ; Sprawd czy czasem nie wczono niemiertelno?
        bne Exec_BJ0

        mva #1             Is_Dead_BOMB_JACK
        mva #sfx_dead_jack sfx_effect

; brak kolizji
Exec_BJ0
Exec_RTS
        rts

; procedura czyci przeciwnika z jego starego miejsca
clr_pmg_clip .proc
      ;  ldy Do_Number_SPRITE_1_7                     ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
      ;  iny
      ;  ldx tab_choose_sprite,y                      ; na jakim PMG #0-7 ma by kasowany i rysowany nowy wzr PMG (PMG #4-7 to tak naprawd PMG #0-3 tylko rozmnoone przez PMG multiplexer)
      ;  spl
      ;  rts
        mva #$FF tab_choose_sprite,y

        txa                                          ; obliczamy - nr.PMG * 2 + choose_PMG
        and #$0F
        asl @
        adc choose_PMG
        tax

        ldy old_posy,x
        mva @TAB_MEM_BANKS+=pmg0_clr_pla1 portb
        mva tab_pmg01_clrl,x              clr1+1
        mva tab_pmg01_clrh,x              clr1+2
clr1    jmp $ffff
.endp

;----------------------------------------------
; procka dodajca PMG dla 3-ch przeciwnikw: ptaszek, UFO i jaki wybrany na danej planszy
Exec_opp_PMG

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; New very fast PMG routine!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
fill_pmg_clip .proc
        ldy no_sprite
        ldx tab_choose_sprite,y                      ; na jakim PMG #0-7 ma by kasowany i rysowany nowy wzr PMG (PMG #4-7 to tak naprawd PMG #0-3 tylko rozmnoone przez PMG multiplexer)
        cpx #$FF                                     ; $FF - nie rysujemy ani nie kasujemy wogle PMG
        sne
        rts
        cpx #$F0                                     ; $Fx - kasujemy tylko PMG  (w  miejscu x - warto 0-7)
        bcs clr_pmg_clip

;        jmp ptr_pmg_clip                             ; pozostae przypadki - kasujemy na starej pozycji i rysujemy na nowej PMG
.endp

ptr_pmg_clip .proc
        mva tab_choose_col_PMG,y  col_PM0,x          ; ustaw odpowiedni kolor dla PMG

        txa                                          ; obliczamy - nr.PMG * 2 + choose_PMG
        asl @
        adc choose_PMG
        tax

; sprawdzamy czy poprzednio by taki sam wzr sprite'a ju narysowany...
        lda tab_Addr_Sprite0_7_Pattern,y
        cmp old_patt,x
        bne skp1
        ldy old_posy,x                               ; TAK! ...oraz czy wsp.Y sprite'a si nie zmienia?
        cpy posy
        beq set_posx                                 ; TAK! 2 warunki spenione cznie wic wystarczy tylko zaktualizowa wsp.X i nie kasowa ani nie rysowa na nowo sprite'a

skp1    sta old_patt,x                               ; zapamitaj numer klatki animacyjnej sprite'a

; pobierz star wsp. sprite'a 0-7
        ldy old_posy,x                               ; To przypiesza rysowanie sprite'a jeeli nie zmienia si wsp.Y...
        cpy posy                                     ; ...bo pomijamy kasowanie sprite'a na starej pozycji PMG
        beq clr1+3

; kasujemy sprite'a na starej pozycji
        mva posy                          old_posy,x
        mva @TAB_MEM_BANKS+=pmg0_clr_pla1 portb
        mva tab_pmg01_clrl,x              clr1+1
        mva tab_pmg01_clrh,x              clr1+2
clr1    jsr $ffff

; rysowanie ksztatu PMG na nowej pozycji
        lda addr_pmg+1                               ; Czy istnieje w pamici procka wypenienia ksztatem PMG? (=$ff ten sprite'a nie wykorzystuje PMG bo korzysta tylko z 2-ch kolorw)
        spl                                          ; TAK!
        rts

        lda addr_pmg
        add tab_addrl,x
        sta addr_pmg
        lda addr_pmg+1
        adc tab_addrh,x
        sta addr_pmg+1

        jsr set_posx
        inw addr_pmg
        ldy posy
        jmp (addr_pmg)
.endp

; ustawia pocisk i gracza na odpowiedniej wsp.X
set_posx
        ldy tab_pmg_bank,x
        mva @TAB_MEM_BANKS,y portb
        ldy #0                                       ; odczytaj przesunicie pmg (X Offset)
        lda (addr_pmg),y
        add posx
        adc #x_pmg
        sta posx_P0,x
        adc #8
        sta posx_M0,x
        rts

tab_pmg_bank
        .by =pmg0_jack_08,=pmg0_jack_st,=pmg1_squar_08,=pmg1_squar_b01,=pmg2_squar_08,=pmg2_squar_b01,=pmg3_squar_08,=pmg3_squar_b01
        .by =pmg0_jack_08,=pmg0_jack_st,=pmg1_squar_08,=pmg1_squar_b01,=pmg2_squar_08,=pmg2_squar_b01,=pmg3_squar_08,=pmg3_squar_b01
tab_addrl
        .by <len_jack,0,<len_opponent,0,<len_opponent,0,<len_opponent,0,<len_opponent,0,<len_opponent,0,<len_opponent,0,<len_opponent,0
tab_addrh
        .by >len_jack,0,>len_opponent,0,>len_opponent,0,>len_opponent,0,>len_opponent,0,>len_opponent,0,>len_opponent,0,>len_opponent,0


* ---	SHAPEZP
; uniwersalna procedura modyfikujaca zestaw znakw (procedur definiuje struktura @ZPVAR)
;
; SRC -> adresy znakw ktre zostan odczytane i poddane modyfikacji
; MSK -> maska ksztatu ducha dla operacji AND
; SHP -> maska z ksztatem ducha dla operacji OR (maska i kszat nie musz by wzgldem siebie "symetryczne")
; DST -> adresy znakw docelowych, tutaj zostanie zapisany wynik operacji LDA:AND:ORA:STA DST
;
; shapeTMP zostanie przepisany na stron zerow od adresu shapeZP

shapeMOV
	ldx	#0
mov	mva	shapeTMP,x	shapeZP,x+
	cpx	#shapeTMP_end-shapeTMP
	bne	mov
	rts

*---

shapeTMP	dta @ZPVAR [15] ( {lda*,y}, $ffff, {and*,y}, $ffff, {ora*,y}, $ffff, {sta*,y}, $ffff )

	dey
	smi
	jmp shapeZP
	rts

shapeTMP_end


;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ---	NMI   ---
;--------------------------------------------------------------------------------------------------------------------------------------------------------
nmi	bit $d40f
	bpl vbl

	sta rA
	stx rX
	sty rY

	jmp __dli
vdli	equ *-2

vbl	phr
	sta $d40f

	inc cloc

	mva sts_screen      dmactl
	mwa AddrDisplayList dlistl
	mva >bj_panel       chbase

        ldy choose_PMG_on_VBL
        mva tab_choose_PMBASE,y pmbase

; rotating colors on panel
        jsr rotating_colors

panel_prior = *+1
        mva #$ff          prior

panel_size = *+1
        mva #$ff          sizep0
        sta               sizep1
        sta               sizep2
        sta               sizep3
        sta               sizem

panel_posx_P0 = *+1
        mva #$ff hposp0
panel_posx_M0 = *+1
	mva #$ff hposm0

panel_posx_P1 = *+1
        mva #$ff hposp1
panel_posx_M1 = *+1
	mva #$ff hposm1

panel_posx_P2 = *+1
        mva #$ff hposp2
panel_posx_M2 = *+1
	mva #$ff hposm2

panel_posx_P3 = *+1
        mva #$ff hposp3
panel_posx_M3 = *+1
	mva #$ff hposm3

        mwa	#__dli	vdli

	lda sfx_effect
	bmi vbl0

	asl @   			 ; * 2
	tay				 ; Y = 2,4,..,16	instrument number * 2 (0,2,4,..,126)
	ldx #3				 ; X = 2		channel (0..3 or 0..7 for stereo module)
	lda #$00			 ; A = 0		note (0..60)
	@BANK_JSR rmt_sfx                ; RMT_SFX start tone (It works only if FEAT_SFX is enabled !!!)

	mva #$ff sfx_effect		 ; reinit value

vbl0    lda is_play_music                ; Is music play on VBL?
        beq vbl1                         ; =0 NO!

        @BANK_JSR rmt_play

vbl1    lda blink_faces
        beq vbla
        dec blink_faces
        bne vbla

        mva #TIME_BLINK_FACES blink_faces
vbl_val lda #$ff
        and #1
        tax
        lda tab_blink_smi,x                                  ; blink the PMG of the smiling face
        :7 sta col_PM1+#
        :7 sta col_PM1_vbl+#
        inc vbl_val+1

vbla    lda skctl
        and #$04
        bne vbl2

        lda kbcode
        cmp CH1
        beq vbl3

        sta Key
        sta CH1
        jmp vbl3

vbl2    mva #$ff CH1

vbl3    lda Time_Get_SmilingFace_Soon_Finish+1
        bne vbl33
        lda Time_Get_SmilingFace_Soon_Finish
        seq

vbl33   dew Time_Get_SmilingFace_Soon_Finish

        plr
	rti

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wycz wszystkie sprite'y
;--------------------------------------------------------------------------------------------------------------------------------------------------------
disable_sprites
          lda #0
        .rept 8
          sta sprites[#].sts
          sta Sprite0_PosY+#*2
        .endr

     ;   .rept 7
     ;     sta tab_Type_SPRITES_1_7+#
     ;   .endr

        ldx #<Exec_RTS
        ldy #>Exec_RTS
        .rept 8
          stx sprites[#].prg+0
          sty sprites[#].prg+1
        .endr
        jmp Convert_Sprites_C64_to_ATARI

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wycz muzyk
;--------------------------------------------------------------------------------------------------------------------------------------------------------
stop_music .proc
        mva portb                       save+1
        mva #0 is_play_music
        mva @TAB_MEM_BANKS+=rmt_silence portb
	jsr rmt_silence	                        ; all sounds off
save    mva #$ff                        portb
        rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura gra muzyk dla ekranu "nick"
;--------------------------------------------------------------------------------------------------------------------------------------------------------
play_music .proc
        lda is_mute_music
        seq
        rts

skp     mva portb                       save+1
        jsr stop_music
        mva @TAB_MEM_BANKS+=rmt_init portb
        ldx #<MODUL				; low byte of RMT module to X reg
	ldy #>MODUL				; hi byte of RMT module to Y reg
	lda number_song  			; starting song line 0-255 to A reg
	jsr rmt_init		                ; Init
  ;      lda is_mute_music                       ; Czy Muzyka ma by wyczona i nie gra?
   ;     sne
        mva #1 is_play_music

save    mva #$ff                        portb
        rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wywietla aktualn liczb y 'bomb jacka'
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Lifes_BombJack
        mva @TAB_MEM_BANKS+=:Show_Lifes_BombJack_Bank portb
        jmp Show_Lifes_BombJack_Bank

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; poka mnonik: x1, x2, x3 , x4 dla otrzymywanych punktw
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Digital_Panel
        mva @TAB_MEM_BANKS+=:Show_Digital_Panel_Bank portb
        jmp Show_Digital_Panel_Bank

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wykorzystywane podczas przerw.VBL dla TITLE SCREEN i HI-SCORE SCREEN
;--------------------------------------------------------------------------------------------------------------------------------------------------------
external_vbl .proc
        lda is_play_music                ; Is music play on VBL?
        beq skp1                         ; =0 NO!

        @BANK_JSR rmt_play

skp1    lda is_rotating_colors
        bne *+3
        rts

        jmp rotating_colors
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; zapamitaj kolory caego ekranu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
save_color
        mva @TAB_MEM_BANKS+=:save_color_bank portb
        stx fade.lcol+1
        sty fade.hcol+1
        jmp save_color_bank

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; rozjanij kolory caego ekranu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
fade_in
        mva @TAB_MEM_BANKS+=:fade_in_bank portb
        jmp fade_in_bank

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ciemnij kolory caego ekranu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
fade_out
        mva @TAB_MEM_BANKS+=:fade_out_bank portb
        jmp fade_out_bank

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; czyci 2 obszary PMG
;--------------------------------------------------------------------------------------------------------------------------------------------------------
clear_pmg
	ldy #$18			; wyczyszczenie pamici dla duchw sprztowych
	lda #$00

clrPMG1	:5 sta	pmg0+$300+#*$100,y      ; czyszczenie caego PMG oprcz grnego panelu
	:5 sta	pmg1+$300+#*$100,y
	iny
	bne	clrPMG1

        rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ustawiamy wygld PMG na grnym panelu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
set_pattern_panel .proc
	ldy #15			        ; ustawienie wzoru na grnym panelu
        lda Counter_Collected_BOMBS     ; dodanie efektu rozrastania si migajcego paska na grnym panelu
        lsr @
        tax
        lda tab_mis,x

clrPMG2	sta	pmg0+$300+8,y
	sta	pmg1+$300+8,y
	dey
	bpl	clrPMG2

	ldy #15			        ; ustawienie wzoru na grnym panelu
        lda Counter_Collected_BOMBS
        lsr @
        tax

clrPMG3 mva tab_pl0,x pmg0+$400+8+0*$100,y
        sta           pmg1+$400+8+0*$100,y
        mva tab_pl1,x pmg0+$400+8+1*$100,y
        sta           pmg1+$400+8+1*$100,y
        mva tab_pl2,x pmg0+$400+8+2*$100,y
        sta           pmg1+$400+8+2*$100,y
        mva tab_pl3,x pmg0+$400+8+3*$100,y
        sta           pmg1+$400+8+3*$100,y
	dey
	bpl	clrPMG3

        rts

tab_mis dta $00,$00,$00,$40,$C0,$D0,$F0,$F4,$FC,$FD,$FF,$FF,$FF
tab_pl0 dta $00,$00,$00,$00,$00,$00,$00,$00,$00,$80,$C0,$C0,$C0
tab_pl1 dta $00,$00,$00,$00,$00,$00,$00,$80,$C0,$C0,$C0,$C0,$C0
tab_pl2 dta $00,$00,$00,$00,$00,$80,$C0,$C0,$C0,$C0,$C0,$C0,$C0
tab_pl3 dta $00,$00,$00,$80,$C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura mnoy A*X  (i dodaje warto w '__rsl') - WYNIK ZWRACA W '__rsl'
;--------------------------------------------------------------------------------------------------------------------------------------------------------
mul   eor #%11111111 ;modyfikacja
      sta __bta   ;pierwszego czynnika

      stx __btb   ;przygotowanie
      ldx #0      ;drugiego czynnika
      stx __btb+1

      ldx #8      ;dugo sowa


lop1  lsr __bta   ;sprawdzenie aktualnej
      bcs nxt1    ;potgi dwjki

      lda __btb   ;dodanie __BTB
      adc __rsl   ;pomnoonego przez 2
      sta __rsl   ;2 do potgi 8-.X do
      lda __btb+1 ;wyniku
      adc __rsl+1
      sta __rsl+1

nxt1  asl __btb   ;pomnoenie __BTB
      rol __btb+1 ;przez kolejn potg
                  ;liczby 2

      dex
      bne lop1
      rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura dzieli XA(MSB,LSB) przez Y - WYNIK: w '__rsl' cz cakowita,  a w '__bta' reszta z dzielenia
;--------------------------------------------------------------------------------------------------------------------------------------------------------
div   sta __bta   ;przygotowanie
      stx __bta+1 ;danych
      ldx #0
      stx __btb
      sty __btb+1 ;dzielnik*2^8

      ldx #8      ;dugo sowa

lop2  lsr __btb+1 ;dzielnik*2(.X-1)
      ror __btb

      lda __bta   ;dzielna-dzielnik
      sub __btb   ;a zarazem porwnanie
      tay
      lda __bta+1
      sbc __btb+1
      bcc nxt2    ;skok gdy __BTA<__BTB

      sty __bta   ;dzielna=dzielna-
      sta __bta+1 ; -dzielnik*2(.X-1)

nxt2  rol __rsl   ;"wcignicie" potgi

      dex         ;.X-1 do wyniku
      bne lop2

      rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; rotacja kolorw na TITLE SCREEN
;--------------------------------------------------------------------------------------------------------------------------------------------------------
rotating_colors
        dec cnt_shd
        bne rot6

        mva #num_shd cnt_shd

        dec cnt_col
        bne rot8

        mva #num_col cnt_col

        dec cnt_rot
        bne rot8

        mva #num_rot cnt_rot

rot8    ldx cnt_rot
        lda rot1+1 \ and #$0F \ ora tab_rot_col-1,x \ sta rot7+1
        lda rot2+1 \ and #$0F \ ora tab_rot_col-1,x \ sta rot1+1
        lda rot3+1 \ and #$0F \ ora tab_rot_col-1,x \ sta rot2+1
        lda rot4+1 \ and #$0F \ ora tab_rot_col-1,x \ sta rot3+1
        lda rot5+1 \ and #$0F \ ora tab_rot_col-1,x \ sta rot4+1
        lda rot6+1 \ and #$0F \ ora tab_rot_col-1,x \ sta rot5+1
rot7    lda #$ff   \ and #$0F \ ora tab_rot_col-1,x \ sta rot6+1

rot6	mva	#$8C	color0
rot5	mva	#$8A	color1
	mva	#$FC	color2
	mva	#$0E	color3
bak	mva	#0	colbak

rot1	mva	#$82	colpm0
rot2	mva	#$84	colpm1
rot3	mva	#$86	colpm2
rot4	mva	#$88	colpm3
        rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura sprawdza czy wynik gracza nie jest lepszy ni jaka pozycja w licie HI-SCORE, jeeli tak to wpisuje nowy rezultat na liste
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Add_Player_Score  .proc
                  mva #$00 count_tab8

Add_Player_loop1  lda count_tab8
                  :3 asl @               ;*8
                  tax

                  ldy #$00

Add_Player_loop2  lda tab8_player1,y     ; sprawd HI-SCORE gracza z rezultatami...
                  cmp tab8_score0,x      ; ... na licie
                  beq Add_Player_skip0   ; takie same dwie cyfry
                  bcs Add_Player_skip2   ; wynik HI-SCORE gracza jest wikszy od aktualnego z listy - WIC ZAPISZ NOWY REKORD na licie!
                  jmp Add_Player_skip1   ; wynik HI-SCORE gracza jest mniejszy od aktualnego z listy

Add_Player_skip0  iny                    ; przejd do bajtu z kolejnymi dwiema cyframi
                  cpy #$03
                  beq Add_Player_skip1

                  inx                    ; przejd do kolejnego bajtu z danego wiersza HI-SCORE
                  jmp Add_Player_loop2

Add_Player_skip1  inc count_tab8         ; kolejny wiersz z listy HI-SCORE
                  lda count_tab8
                  cmp #8                 ; Czy ju wszystkie 8 wierszy z listy HI-SCORE porwnane z tab8_player1?
                  bne Add_Player_loop1   ; NIE!

                  rts

Add_Player_skip2  lda count_tab8
                  :3 asl @               ;*8
                  add #<tab8_score0
                  sta address1
                  sta address1_hlp1      ; zachowaj modszy bajt adresu gdzie wpisa rezultat gracza

                  lda #>tab8_score0
                  adc #$00
                  sta address1+1
                  sta address1_hlp1+1    ; zachowaj starszy bajt adresu gdzie wpisa rezultat gracza

                  clc
                  mwa address1 address1_hlp2

                  lda #<tab8_score7      ; ustaw adresy, eby przepisa blok HI-SCORE tak aby zrobi miejsce na rezultat gracza
                  sta address1
                  add #$08 ;-1
                  sta address2
                  lda #>tab8_score7
                  sta address1+1
                  adc #$00
                  sta address2+1

; ponisza procedura przesuwa wyniki HI-SCORE gracza w d (tak, eby zrobi miejsce na nowy, lepszy rezultat gracza)
Add_Player_loop3  ldy #$00
                  mva (address1),y (address2),y
                  sbw address1 #$01
                  sbw address2 #$01

                  lda address2
                  cmp address1_hlp2
                  bne Add_Player_loop3  ;slow

                  lda address2+1
                  cmp address1_hlp2+1
                  bne Add_Player_loop3  ;slow

                  mwa address1_hlp1 address1         ; kopiuj adres gdzie wpisa rezultat gracza

; ponisza ptla wpisuje rezultat gracza na list HI-SCORE i kasuje jego rezultat
                  ldy #$07

Add_Player_loop4  mva tab8_player1,y (address1),y
                  mva #$00           tab8_player1,y
                  dey
                  bpl Add_Player_loop4

                  rts

count_tab8    dta $00
address1_hlp1 .dw $0000
address1_hlp2 .dw $0000
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; napisz najwyszy wynik (tab8_score0)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_HiScore .proc
        mwa  #tab8_score0 address1

        ldx #5
        ldy #2

hi_lop1 lda (address1),y
        and #$0F
        add #16
        sta panel_HiScore,x
        dex
        lda (address1),y
        :4 lsr @
        add #16
        sta panel_HiScore,x
        dex
        dey
        bpl hi_lop1

        rts
.endp

Show_HiScore_title .proc
        mwa  #tab8_score0 address1

        ldx #5
        ldy #2

hi_lop1 lda (address1),y
        and #$0F
        add #16
        sta scr_1+32*29+26,x
        dex
        lda (address1),y
        :4 lsr @
        add #16
        sta scr_1+32*29+26,x
        dex
        dey
        bpl hi_lop1

        rts
.endp

Show_HiScore_score .proc
        mwa  #tab8_score0 address1

        ldx #5
        ldy #2

hi_lop1 lda (address1),y
        and #$0F
        add #16
        sta scr_2+32*29+26,x
        dex
        lda (address1),y
        :4 lsr @
        add #16
        sta scr_2+32*29+26,x
        dex
        dey
        bpl hi_lop1

        rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia na pocztkowe wartoci rne zmienne wystpujce w grze
;--------------------------------------------------------------------------------------------------------------------------------------------------------
reset_variables_game .proc
        mva #FALSE Is_No_Flight_BOMB_JACK            ; BOMB JACK don't flight at this moment
        sta        Is_Collision_with_LEDGE_BOMB_JACK
        lda        #$00
        sta        blink_faces                       ; ustaw opnienie dla efektu migania kolorem buziek kiedy koczy si czas
        sta        is_anim_dead_bird                 ; nie animujemy ju ptaszka mierci nad gow BJ
        sta        is_fast_move_on                   ; wycz szybki przesw przeciwnikw w pionie (bo pojawiajcy si napis "START" nie dziaa wtedy poprawnie)
        sta        index_tab_Dead_BOMB_JACK
        sta        index_tab_Bird_Over_BOMB_JACK
        sta        Is_Dead_BOMB_JACK
        sta        Counter_Blink_BOMBS               ; ustaw liczb zebranych migajcych bomb na 0 (jeeli zbierzemy 24 migajcych bomb to pojawia si BONUS SCREEN)
        sta        index_tab_Dance_BOMB_JACK
        sta        Is_Draw_Back_On_Collected_Bomb
        sta        Counter_Collected_Letter_B        ; ile zebrano na planszy "LITER B"
        sta        Is_Blink_PMG
        sta        Counter_5th_BOMBS_to_Show_LETTER_B
        sta        Counter_9th_BOMBS_to_Show_LETTER_P
        sta        Is_Dance_BOMB_JACK
        sta        choose_PMG                        ; wskanik, ktry obszar PMG aktualnie mamy wywietlany
        sta        choose_PMG_on_VBL
        sta        Time_Get_SmilingFace_Soon_Finish  ; ile czasu zostao jeszcze na zebranie 'umiechnitych buziek'
        sta        Time_Get_SmilingFace_Soon_Finish+1
        sta        counter_show_Letter_E             ; ile razy pokazano liter "E"
        mva #$0A-1 Delay_Dance_BOMB_JACK
        mva #$ff   tab_choose_sprite+7               ; ju nie wykorzystujemy PMG #0 dla ptaszka mierci nad gow BJ
        :16 sta old_patt+#
        rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; makro czeka, a nacinity zostanie FIRE w joysticku 0
;--------------------------------------------------------------------------------------------------------------------------------------------------------
wait_trig0 .macro
        lda trig0
        bne *-3
.endm

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura inicjuje grafik PMG dla danej planszy
;--------------------------------------------------------------------------------------------------------------------------------------------------------
init_pmg .proc
        jsr clear_pmg
        jsr set_pattern_panel
        jmp disable_sprites
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura odwierza wszystkie dane informacyjne na grnym i dolnym panelu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
refresh_info .proc
        jsr Show_Number_Round
        jsr Show_HiScore
        jsr Show_Digital_Panel
        jsr Show_Score_Player
        jmp Show_Lifes_BombJack
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; makro czeka, a narysowany zostanie widoczny obszar gry
;--------------------------------------------------------------------------------------------------------------------------------------------------------
wait_vbl .macro
        lda #MAX_LINES_SCR/2
        cmp vcount
        bcs *-3
.endm

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura czeka warto rej.X (s)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
wait_time
        lda cloc
        cmp cloc
        beq *-2

        dex
        bne wait_time

        rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; set number of Round
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_Number_of_Round_Bank .proc
         sta Number_Round_BIN
         ldx #0
         ldy #10
         jsr div
         lda __rsl
         :4 asl @
         ora __bta
         sta Number_Round_BCD   ; number of ROUND in BCD
         rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura kasuje wskazany obszar pamici wartoci $00
;--------------------------------------------------------------------------------------------------------------------------------------------------------
clr_mem_bank .PROC
         mva #$00 fil_mem_bank.byt
         jmp fil_mem_bank.fil_me2
.ENDP

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Wywietl aktualn liczb punktw gracza
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Score_Player ldx #2
                  ldy #5

scor_loop1        lda Score_Player,x
                  and #$0F
                  add #16+128
                  sta panel_score_player,y-
                  lda Score_Player,x
                  :4 lsr @
                  add #16+128
                  sta panel_score_player,y-
                  dex
                  bpl scor_loop1

                  rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Wywietl aktualny numer planszy(rundy)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Number_Round .proc
                  lda Number_Round_BCD
                  :4 lsr @
                  add #16+128
                  add repeat_20levels
                  sta panel_round+$00
                  lda Number_Round_BCD
                  and #$0F
                  add #16+128
                  sta panel_round+$01
                  rts

repeat_20levels  dta $00
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura animuje napis "START !" przed rozpoczciem gry (z wykorzystaniem sprite'w)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_START_Sprites .proc
                  lda #$01
               :8 sta sprites[#].sts

                  ldx #$07*2
                  ldy #$07                                                 ; sprite'y #7-#0

skp1              mva tab_definition_START,y tab_Addr_Sprite0_7_Pattern,y
                  mva tab_x_START,y          Sprite0_PosX,x                ; ustaw wsp.X dla sprite'w 0-7
                  mva #$82-CORR_Y            Sprite0_PosY,x                ; ustaw wsp.Y dla sprite'w #0-#7
               :2 dex
                  dey
                  bpl skp1
;dupa
                  mva #$82-2*CORR_Y          sprites[0].psy

skp2              lda Sprite0_PosX                                         ; Pobiera wsp.X sprite'a nr.0
                  cmp #$60                                                 ; Czy ju wykonana animacja napisu START?
                  bcs Anim_START_skip2                                     ; TAK!

                  adb Sprite0_PosX #4
                  adb Sprite1_PosX #4
                  adb Sprite2_PosX #4
                  adb Sprite3_PosX #4
                  sbb Sprite4_PosX #4
                  sbb Sprite5_PosX #4
                  sbb Sprite6_PosX #4
                  sbb Sprite7_PosX #4
                  jsr Anim_START_skip1
                  jmp skp2

; procedura(ptla) wprowadza pewne opnienie w wykonywaniu kodu - najkrtsze opnienie
Anim_START_skip1  jsr show_buff
                  ldx #$32/2
Anim_START_loop4  ldy #$37
                  dey
                  bne *-1
                  dex
                  bne Anim_START_loop4

                  rts

; procedura(ptla) wprowadza pewne opnienie w wykonywaniu kodu - najdusze opnienie
Anim_START_skip2  jsr show_buff
                  jsr Anim_START_skip3
                  jsr Anim_START_skip3
                  rts

; procedura(ptla) wprowadza pewne opnienie w wykonywaniu kodu - rednie opnienie
Anim_START_skip3  jsr show_buff
                  ldx #$FF/2
                  ldy #$FF
Anim_START_loop6  dey
                  bne *-1
                  dex
                  bne Anim_START_loop6

                  rts

tab_definition_START dta $9A,$9B,$9C,$9D,$9F,$A0,$A1,$A2  ; *64+$4000 wskazuje na adres definicji sprite'a (64 bajty)
tab_x_START          dta $1C,$34,$4C,$64,$A4,$BC,$D4,$EC  ; wsprzdna X - sprite'y 0-7
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura animuje napis "START !" przed rozpoczciem gry (z wykorzystaniem sprite'w)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
show_buff .proc   
                  jsr Convert_Sprites_C64_to_ATARI
                  lda choose_buff
                  eor #1
                  sta choose_buff
                  jne skp1

                  WAIT B2
                  jsr INITDLI_B2
                  mva	#charsBAK	free
                  INITBUF B3
	          mva cloc speed			; w komrce SPEED liczba ramek reprezentujca szybko silnika
                  rts

skp1              WAIT B3
                  jsr INITDLI_B3
                  mva	#charsBAK	free
                  INITBUF B2
                  mva cloc speed			; w komrce SPEED liczba ramek reprezentujca szybko silnika
                  rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia wsprzdn X na podzieln przez 4-ry (dziki temu silnik rysuje szybciej takie sprite'y)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
set_PosX_div4 .proc
; badaj czy przeciwnik przesun si w pionie?
; jeeli tak to wyrwnaj do wielokrotnoci 4-ki dziki czemu silnik rysuje szybciej sprite'a bo ma on szeroko tylko 3-ch, a nie 4-rech znakw
                .rept 6,#+1
                  lda is_fast_move_on
                  beq skip_mod0_x:1

                  lda Sprite0_PosY+[:1]*2
                  sub #CORR_Y
                  cmp sprites[:1].psy
                  bne skip_mod1_x:1

skip_mod0_x:1     lda Sprite0_PosX+[:1]*2
                  lsr @
                  sta sprites[:1].psx
                  jmp skip_mod2_x:1

skip_mod1_x:1     lda Sprite0_PosX+[:1]*2
                  cmp sprites[:1].psx
                  bne skip_mod0_x:1

                  lda Sprite0_PosX+[:1]*2
                  and #%11111100
                  sta Sprite0_PosX+[:1]*2
                  lsr @
                  sta sprites[:1].psx     ; PosX/2

skip_mod2_x:1
                .endr

; dla 7-mego sprite'a nie modyfikujemy wsp. X bo gupio wyglda wtedy latanie bonusowej litery
                  lda Sprite0_PosX+[7]*2                    ; litery bonusowe zawsze wykorzystuj numer tego sprite'a
                  lsr @
                  sta sprites[7].psx

                  rts
.endp

; tablice z danymi

tab6_multiplex_l .db <pmg6_multiplex_row0,<pmg6_multiplex_row1,<pmg6_multiplex_row2,<pmg6_multiplex_row3,<pmg6_multiplex_row4,<pmg6_multiplex_row5
                 .db <pmg6_multiplex_row6,<pmg6_multiplex_row7,<pmg6_multiplex_row8,<pmg6_multiplex_row9,<pmg6_multiplex_row10,<pmg6_multiplex_row11
                 .db <pmg6_multiplex_row12,<pmg6_multiplex_row13,<pmg6_multiplex_row14,<pmg6_multiplex_row15,<pmg6_multiplex_row16,<pmg6_multiplex_row17
                 .db <pmg6_multiplex_row18,<pmg6_multiplex_row19,<pmg6_multiplex_row20,<pmg6_multiplex_row21,<pmg6_multiplex_row22,<pmg6_multiplex_row23
                 .db <pmg6_multiplex_row24
tab6_multiplex_h .db >pmg6_multiplex_row0,>pmg6_multiplex_row1,>pmg6_multiplex_row2,>pmg6_multiplex_row3,>pmg6_multiplex_row4,>pmg6_multiplex_row5
                 .db >pmg6_multiplex_row6,>pmg6_multiplex_row7,>pmg6_multiplex_row8,>pmg6_multiplex_row9,>pmg6_multiplex_row10,>pmg6_multiplex_row11
                 .db >pmg6_multiplex_row12,>pmg6_multiplex_row13,>pmg6_multiplex_row14,>pmg6_multiplex_row15,>pmg6_multiplex_row16,>pmg6_multiplex_row17
                 .db >pmg6_multiplex_row18,>pmg6_multiplex_row19,>pmg6_multiplex_row20,>pmg6_multiplex_row21,>pmg6_multiplex_row22,>pmg6_multiplex_row23
                 .db >pmg6_multiplex_row24
tab7_multiplex_l .db <pmg7_multiplex_row0,<pmg7_multiplex_row1,<pmg7_multiplex_row2,<pmg7_multiplex_row3,<pmg7_multiplex_row4,<pmg7_multiplex_row5
                 .db <pmg7_multiplex_row6,<pmg7_multiplex_row7,<pmg7_multiplex_row8,<pmg7_multiplex_row9,<pmg7_multiplex_row10,<pmg7_multiplex_row11
                 .db <pmg7_multiplex_row12,<pmg7_multiplex_row13,<pmg7_multiplex_row14,<pmg7_multiplex_row15,<pmg7_multiplex_row16,<pmg7_multiplex_row17
                 .db <pmg7_multiplex_row18,<pmg7_multiplex_row19,<pmg7_multiplex_row20,<pmg7_multiplex_row21,<pmg7_multiplex_row22,<pmg7_multiplex_row23
                 .db <pmg7_multiplex_row24
tab7_multiplex_h .db >pmg7_multiplex_row0,>pmg7_multiplex_row1,>pmg7_multiplex_row2,>pmg7_multiplex_row3,>pmg7_multiplex_row4,>pmg7_multiplex_row5
                 .db >pmg7_multiplex_row6,>pmg7_multiplex_row7,>pmg7_multiplex_row8,>pmg7_multiplex_row9,>pmg7_multiplex_row10,>pmg7_multiplex_row11
                 .db >pmg7_multiplex_row12,>pmg7_multiplex_row13,>pmg7_multiplex_row14,>pmg7_multiplex_row15,>pmg7_multiplex_row16,>pmg7_multiplex_row17
                 .db >pmg7_multiplex_row18,>pmg7_multiplex_row19,>pmg7_multiplex_row20,>pmg7_multiplex_row21,>pmg7_multiplex_row22,>pmg7_multiplex_row23
                 .db >pmg7_multiplex_row24

tab6_ret_l       .db <[ret_pmg6_row0-2],<[ret_pmg6_row1-2],<[ret_pmg6_row2-2],<[ret_pmg6_row3-2],<[ret_pmg6_row4-2],<[ret_pmg6_row5-2]
                 .db <[ret_pmg6_row6-2],<[ret_pmg6_row7-2],<[ret_pmg6_row8-2],<[ret_pmg6_row9-2],<[ret_pmg6_row10-2],<[ret_pmg6_row11-2]
                 .db <[ret_pmg6_row12-2],<[ret_pmg6_row13-2],<[ret_pmg6_row14-2],<[ret_pmg6_row15-2],<[ret_pmg6_row16-2],<[ret_pmg6_row17-2]
                 .db <[ret_pmg6_row18-2],<[ret_pmg6_row19-2],<[ret_pmg6_row20-2],<[ret_pmg6_row21-2],<[ret_pmg6_row22-2],<[ret_pmg6_row23-2]
                 .db <[ret_pmg6_row24-2]
tab6_ret_h       .db >[ret_pmg6_row0-2],>[ret_pmg6_row1-2],>[ret_pmg6_row2-2],>[ret_pmg6_row3-2],>[ret_pmg6_row4-2],>[ret_pmg6_row5-2]
                 .db >[ret_pmg6_row6-2],>[ret_pmg6_row7-2],>[ret_pmg6_row8-2],>[ret_pmg6_row9-2],>[ret_pmg6_row10-2],>[ret_pmg6_row11-2]
                 .db >[ret_pmg6_row12-2],>[ret_pmg6_row13-2],>[ret_pmg6_row14-2],>[ret_pmg6_row15-2],>[ret_pmg6_row16-2],>[ret_pmg6_row17-2]
                 .db >[ret_pmg6_row18-2],>[ret_pmg6_row19-2],>[ret_pmg6_row20-2],>[ret_pmg6_row21-2],>[ret_pmg6_row22-2],>[ret_pmg6_row23-2]
                 .db >[ret_pmg6_row24-2]
tab7_ret_l       .db <[ret_pmg7_row0-2],<[ret_pmg7_row1-2],<[ret_pmg7_row2-2],<[ret_pmg7_row3-2],<[ret_pmg7_row4-2],<[ret_pmg7_row5-2]
                 .db <[ret_pmg7_row6-2],<[ret_pmg7_row7-2],<[ret_pmg7_row8-2],<[ret_pmg7_row9-2],<[ret_pmg7_row10-2],<[ret_pmg7_row11-2]
                 .db <[ret_pmg7_row12-2],<[ret_pmg7_row13-2],<[ret_pmg7_row14-2],<[ret_pmg7_row15-2],<[ret_pmg7_row16-2],<[ret_pmg7_row17-2]
                 .db <[ret_pmg7_row18-2],<[ret_pmg7_row19-2],<[ret_pmg7_row20-2],<[ret_pmg7_row21-2],<[ret_pmg7_row22-2],<[ret_pmg7_row23-2]
                 .db <[ret_pmg7_row24-2]
tab7_ret_h       .db >[ret_pmg7_row0-2],>[ret_pmg7_row1-2],>[ret_pmg7_row2-2],>[ret_pmg7_row3-2],>[ret_pmg7_row4-2],>[ret_pmg7_row5-2]
                 .db >[ret_pmg7_row6-2],>[ret_pmg7_row7-2],>[ret_pmg7_row8-2],>[ret_pmg7_row9-2],>[ret_pmg7_row10-2],>[ret_pmg7_row11-2]
                 .db >[ret_pmg7_row12-2],>[ret_pmg7_row13-2],>[ret_pmg7_row14-2],>[ret_pmg7_row15-2],>[ret_pmg7_row16-2],>[ret_pmg7_row17-2]
                 .db >[ret_pmg7_row18-2],>[ret_pmg7_row19-2],>[ret_pmg7_row20-2],>[ret_pmg7_row21-2],>[ret_pmg7_row22-2],>[ret_pmg7_row23-2]
                 .db >[ret_pmg7_row24-2]

tab_no_pmg       .db $03,$02,$01,$07,$06,$05                                ; tablica podaje jaki numer PMG wykorzysta

jeq_a        .macro \ cmp :1 \ jeq :2 \ .endm
jne_a        .macro \ cmp :1 \ jne :2 \ .endm
joy1_up      .macro \ lda porta \ and #$01 \ jeq :1 \ .endm
joy1_noup    .macro \ lda porta \ and #$01 \ jne :1 \ .endm
joy1_left    .macro \ lda porta \ and #$04 \ jeq :1 \ .endm
joy1_noleft  .macro \ lda porta \ and #$04 \ jne :1 \ .endm
joy1_right   .macro \ lda porta \ and #$08 \ jeq :1 \ .endm
joy1_noright .macro \ lda porta \ and #$08 \ jne :1 \ .endm
joy1_fire    .macro \ lda trig0 \ jeq :1 \ .endm
joy1_nofire  .macro \ lda trig0 \ jne :1 \ .endm
joy1_stay    .macro \ lda porta \ and #$0F \ cmp #$0F \ jeq :1 \ .endm
joy1_nostay  .macro \ lda porta \ and #$0F \ cmp #$0F \ jne :1 \ .endm

; procedura ustawiajca pewne rzeczy przed rozpoczciem gry na danej planszy
game_settings .proc
        jsr zero_multiplex_DLI                       ; wycz dziaanie MULTIPLEXER'a PMG
        jsr reset_variables_game                     ; procedura ustawia na pocztkowe wartoci rne zmienne wystpujce w grze

        mva #num_rot cnt_rot                         ; set index to rotating color table
        mva #num_col cnt_col                         ; set color for rotating colors
        mva #num_shd cnt_shd                         ; set shadow for rotating colors

        cop_mem #B1scr,#tab_Back32x26,#@sh*@sw       ; zapamietaj do pniejszego odtwarzania ta w miejscu zebrania BOMBY

        mva @TAB_MEM_BANKS+=Draw_Bombs_Bank portb
        jsr Draw_Bombs_Bank                          ; drawing 'BOMBS'
        jsr Draw_Bars_Bank                           ; drawing 'LEDGES'
        jsr refresh_info
        jsr disable_sprites

        lda Counter_Collected_BOMBS
        beq skp1

lop1    ldx #2
        jsr wait_time
        wait_vbl                                     ; dziki temu mamy pynne zmiejszenie migajcego paska na grnym panelu
        jsr set_pattern_panel
        dec Counter_Collected_BOMBS
        bne lop1

skp1    mva #$00        size_P0_vbl
        sta             size_P1_vbl
        sta             size_P2_vbl
        sta             size_P3_vbl
        sta             panel_size
        mva #$01        panel_prior                   ; piorytet dla PMG na grnym panelu
        sta             board_prior                   ; piorytet dla PMG na dolnym panelu
        rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Blink the bomb
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Exec_Blink_Bomb .proc
                  lda Is_Blink_BOMB
                  sne
                  rts

                  mva #C64_Blink_Bomb tab_Type_SPRITES_0_7+bomb_sprite
                  mva #Bomb_Blink     tab_Addr_Sprite0_7_Pattern+bomb_sprite

                  lda Blink_BOMB
                  eor #1
                  sta Blink_BOMB
                  sta sprites[bomb_sprite].sts

                  jsr conv_offset_to_xy
                  stx Sprite0_PosX+bomb_sprite*2
                  sty Sprite0_PosY+bomb_sprite*2
                  rts

conv_offset_to_xy lda Offset_Bomb_to_Blink              ; Offset_Bomb_to_Blink / 32
                  ldx Offset_Bomb_to_Blink+1
                  ldy #32
                  jsr div

                  lda __rsl                             ; cz cakowita
               :3 asl @                                 ; *8
                  add #CORR_Y-1
                  tay
                  lda __bta
               :3 asl @                                 ; *8
                  tax
                  rts
.endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Zmienne i procedury wykorzystywane przez now procedur MULTIPLEXER'a
/*
.STRUCT row
   counter .byte
   sprite0 .byte
   sprite1 .byte
   sprite2 .byte
   sprite3 .byte
   sprite4 .byte
   sprite5 .byte
   sprite6 .byte
  ; sprite7 .byte                               ; usunite bo dziki temu uproszczony dostp do tej tablicy o wielkoci 8 bajtw! a i tak nie wykorzystywane
.ENDS

multiplex_row dta row [30]

.PROC multiplexer
init  lda #$00                                  ; kasuj procedur aktywujc MULTIPLEXER
      sta init_multiplex_VBL.sav2+1
      sta init_multiplex_VBL.sav4+1

      ldx #29
lop1  sta multiplex_row[0].counter,x            ; zerowanie tablic MULTIPLEXER'a
      sta multiplex_row[0].sprite1,x
      sta multiplex_row[0].sprite2,x
      sta multiplex_row[0].sprite3,x
      sta multiplex_row[0].sprite4,x
      sta multiplex_row[0].sprite5,x
      dex
      bpl lop1

      lda #$ff
      ldx #7
lop2  sta tab_choose_sprite,x
      dex
      bne lop2

      ldx sprites[1].psy                        ; ustawiamy numery sprite'w, ktre s w wierszach (0-29)
      ldy tab_Type_SPRITES_0_7+1
      mva sprites[1].sts multiplex_row[0].sprite1,x
      jsr setr
      ldx sprites[2].psy
      ldy tab_Type_SPRITES_0_7+2
      mva sprites[2].sts multiplex_row[0].sprite2,x
      jsr setr
      ldx sprites[3].psy
      ldy tab_Type_SPRITES_0_7+3
      mva sprites[3].sts multiplex_row[0].sprite3,x
      jsr setr
      ldx sprites[4].psy
      ldy tab_Type_SPRITES_0_7+4
      mva sprites[4].sts multiplex_row[0].sprite4,x
      jsr setr
      ldx sprites[5].psy
      ldy tab_Type_SPRITES_0_7+5
      mva sprites[5].sts multiplex_row[0].sprite5,x
      jsr setr

      ldx #$ff                                  ; ustawiamy jakie PMG uy
      stx crow
      inx
      ldy #0
      mva #30 cnt1

lop3  inc crow                                  ; +1 do licznika wiersza
      lda multiplex_row[0].sprite1,y            ; testuj czy w tym wierszu jest dany sprite?
      seq
      mva tab_no_pmg,x+ tab_choose_sprite+1
      lda multiplex_row[0].sprite2,y
      seq
      mva tab_no_pmg,x+ tab_choose_sprite+2
      lda multiplex_row[0].sprite3,y
      seq
      mva tab_no_pmg,x+ tab_choose_sprite+3
      lda multiplex_row[0].sprite4,y
      seq
      mva tab_no_pmg,x+ tab_choose_sprite+4
      lda multiplex_row[0].sprite5,y
      seq
      mva tab_no_pmg,x+ tab_choose_sprite+5
      dec cnt1                                  ; sprawdzamy czy ju wszystkie wiersze przeszukane?
      bmi ende

      tya
      add #row
      tay
      lda tabx,x
      beq lop3
      bmi skp1

      mva crow init_multiplex_VBL.sav2+1
      jmp lop3

skp1  mva crow init_multiplex_VBL.sav4+1        ; wykorzystano ju wszystkie 5 dostpnych PMG wic nie przeszukuj dalej kolejnych wierszy

ende  lda clr_second_time_pmg
      cmp #2
      sne
      rts

      mva #1   is_init_multiplex_VBL            ; aktywacja multiplexer'a PMG podczas przerwania VBL
      rts

setr  beq set0                                  ; czy sts = 0?
      cpy #C64_Letter_P                         ; jeeli typ sprite'a to litera lub np. punkty to nie uwzgldniaj go
      bcc set1
      cpy #C64_Bird
      beq set1
      cpy #C64_New_Opponent
      beq set1
set0  rts

set1  inc multiplex_row[0].counter,x
      inc multiplex_row[1].counter,x
      inc multiplex_row[2].counter,x
      txa                                       ; sprawd czy sprite'a zajmuje 4-ry wiersze
      and #$07
      seq
      inc multiplex_row[3].counter,x
      rts

cnt1  dta $00                                   ; licznik ptli
crow  dta $00                                   ; licznik wiersza ekranowego
tabx  dta $00,$00,$00,$01,$ff                   ; wspczynnik wskazujcy czy dla danego wiersza aktywowa DLI
.ENDP
  */
;-------------------------------------------------------
/*
spr_y             lda sprites[0].psy
                  add #CORR_Y
                  cmp Sprite0_PosY
                  bcs dup0

                  lda Sprite0_PosY
                  sub #CORR_Y
                  sub sprites[0].psy
                  jmp dup2

dup0              lda sprites[0].psy
                  add #CORR_Y
                  sub Sprite0_PosY
dup2              cmp #20
                  bcc dup1

                  inc dupa
                  lda dupa
                  cmp #4
                  bcc dup1

                  dta $f2

dup1              rts
  */
; ---	VARIABLE

	ert *>$3fff

; ---	RUN

        .print 'FREE_MEM1: ',*,'..$3FFF'

        icl 'BombProc.asm'

        .print 'FREE_MEM2: ',*,'..$BFFF'
        .print 'FREE_MEM3: ',free_mem,'..$FFF0'
	.print 'FREE_ZPAGE: ',freeZP,'..$00FF'
	.print 'MAX AVAILABLE SPRITES: ',256/@SPRITE
	.print 'MAX AVAILABLE SHAPES: ',256/@SHAPE

	run main


