
voice1DispDataAdr = dispData + 2
voice2DispDataAdr = dispData + 12
voice3DispDataAdr = dispData + 22
voice4DispDataAdr = dispData + 32

voiceDispDataAdrsMSBs
	.db >voice1DispDataAdr, >voice2DispDataAdr, >voice3DispDataAdr, >voice4DispDataAdr
voiceDispDataAdrsLSBs
	.db <voice1DispDataAdr, <voice2DispDataAdr, <voice3DispDataAdr, <voice4DispDataAdr

voiceDispWaveOffset = 2
voiceDispDivOffset = 4
voiceDispSmpShfOffset = 7

; refreshes voice's wave/off status on screen
; input:
;	X: voice index 0-3
rfshWave
	lda voiceDispDataAdrsLSBs,X
	sta tgtPtr
	lda voiceDispDataAdrsMSBs,X
	sta tgtPtr + 1
	ldy voiceControlX,X
	lda voiceControlToWaveChar,Y
	ldy #voiceDispWaveOffset
	sta (tgtPtr),Y
	rts

voiceControlToWaveChar
	dta d'CA '

; refreshes value of voice's frequency divisor on screen
; input:
;	X: voice index 0-3
rfshAudF
	lda voiceDispDataAdrsLSBs,X
	sta tgtPtr
	lda voiceDispDataAdrsMSBs,X
	sta tgtPtr + 1
	ldy #voiceDispDivOffset
	lda vAudFx,X
	lsr
	lsr
	lsr
	lsr
	jsr nibbleToHex
	sta (tgtPtr),Y
	iny
	lda vAudFx,X
	and #$0F
	jsr nibbleToHex
	sta (tgtPtr),Y
	rts

; refreshes all voices' wave/off status and frequency divisor on screen
rfshAllChnWaveAudF
	ldx #0
	jsr rfshAudF
	jsr rfshWave
	ldx #1
	jsr rfshAudF
	jsr rfshWave
	ldx #2
	jsr rfshAudF
	jsr rfshWave
	ldx #3
	jsr rfshAudF
	jmp rfshWave

; refreshes value of voice's poly4 counter synchronization point on screen
; input:
;	X: voice index 0-3
rfshSmpShf
	lda voiceDispDataAdrsLSBs,X
	sta tgtPtr
	lda voiceDispDataAdrsMSBs,X
	sta tgtPtr + 1
	ldy #voiceDispSmpShfOffset
	lda poly4SyncPointX,X
	and #$0F
	jsr nibbleToHex
	sta (tgtPtr),Y
	rts

syncDispDataAdr = dispData + 45
syncOnData
	dta d'on '
syncOffData
	dta d'off'

; refreshes synchronization on/off status on screen
rfshSync
	lda syncWithPoly4MasterFlag
	bne rfshSnc1
	lda <syncOffData
	sta tgtPtr
	lda >syncOffData
	bne rfshSnc2 ; branch always
rfshSnc1
	lda <syncOnData
	sta tgtPtr
	lda >syncOnData
rfshSnc2
	sta tgtPtr + 1
	ldy #syncOffData - syncOnData - 1
rfshSnc3
	lda (tgtPtr),Y
	sta syncDispDataAdr,Y
	dey
	bpl rfshSnc3
	rts

baseClkDispDataAdr = dispData + 68
div28ClkData
	dta d' div28/64kHz'
div114ClkData
	dta d'div114/15kHz'

; refreshes current base clock on screen
rfshBaseClk
	lda vAudCtl
	bne rfshBsClk1
	lda <div28ClkData
	sta tgtPtr
	lda >div28ClkData
	bne rfshBsClk2 ; branch always
rfshBsClk1
	lda <div114ClkData
	sta tgtPtr
	lda >div114ClkData
rfshBsClk2
	sta tgtPtr + 1
	ldy #div114ClkData - div28ClkData - 1
rfshBsClk3
	lda (tgtPtr),Y
	sta baseClkDispDataAdr,Y
	dey
	bpl rfshBsClk3
	rts

scalDispDataAdr = dispData + 55
scalDiaData
	dta d'dia' ; diatonic scale
scalChrData
	dta d'chr' ; chromatic scale

; refreshes current scale type number on screen
rfshScale
	lda scale
	bne rfshScal1
	lda <scalDiaData
	sta tgtPtr
	lda >scalDiaData
	bne rfshScal2 ; branch always
rfshScal1
	lda <scalChrData
	sta tgtPtr
	lda >scalChrData
rfshScal2
	sta tgtPtr + 1
	ldy #scalChrData - scalDiaData - 1
rfshScal3
	lda (tgtPtr),Y
	sta scalDispDataAdr,Y
	dey
	bpl rfshScal3
	rts

; refreshes current octave number on screen
octaveDispDataAdr = dispData + 66
rfshOctave
	lda octave
	jsr nibbleToHex
	sta octaveDispDataAdr
	rts
