
;Constants used for synchronization of POKEY channels playing distortion C and frequencies for which an effective frequency divisor is a multiple of 3 (M3).
;Constants used by synchronization method 2 which uses POKEY reset but does not write to STIMER register.
;In general, the values of constants (selectors) in this file are just 1 less (modulo 15) than values of respective constants in the pokeyDistortionCSynchronizationConstants.asm file.
;There is also a difference in the formulas for available register's setup time.

;Author: Pawel Rosowski (pavros)
;Date: 2018.04.09

;Synchronization points are points in time.
;They are associated with 15 particular elements of poly4 sequence (Ex) from which the sampling starts and thus are associated with concrete
;sampling tracks (ST0-ST2) and rough phase delays (D0-D4).
;There are 15 different synchronization points for normal base clock (div28/64kHz) and 5 different synchronization points for low base clock (div114/15kHz) available for each channel.
;There are only 5 synchronization points available while using div114 clock because in that case there is only one sampling track hardwired to the channel.
;Synchronization points repeat periodically. The same synchronization point repeats every 15 pulses of div28 and every 5 pulses of div114 clock.
;Synchronization point selectors are the values which are initially written to AUDFx registers by synchronization procedure in order to start sampling from associated element Ex of poly4 sequence.
;For normal base clock the selector values may be added any possible multiple of 15 and would still point to the same Ex element.
;For low base clock the selector values may be added any possible multiple of 5 and would still point to the same Ex element.



;The 15 synchronization point selectors for channel 1 for normal base clock (div28/64kHz), representing 15 particular elements of poly4 sequence (Ex) from which the sampling starts.
;The values of the selectors are just initial AudF values to be set in timer of channel 1 before synchronization procedure.
;The formulas in the comments may be preferred by advanced programmers for calculating selector values exactly according to the needed register's setup time.
;For more information see explanations on the bottom.
;To find a maximum available setup time based on the 15 assignments below take the lowest assignment value (let's call it N) and use a formula setupTime = (N + 1) * 28.
;The values selected below guarantee that POKEY synchronization code will work correct even if its execution will be suspended by ANTIC's bad line DMA cycles (setupTime > 180).
sE0Ch1N2  = 4 + 15 ; advanced:  sE0Ch1N2  = (4  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE1Ch1N2  = 11     ; advanced:  sE1Ch1N2  = (11 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE2Ch1N2  = 3 + 15 ; advanced:  sE2Ch1N2  = (3  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE3Ch1N2  = 10     ; advanced:  sE3Ch1N2  = (10 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE4Ch1N2  = 2 + 15 ; advanced:  sE4Ch1N2  = (2  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE5Ch1N2  = 9      ; advanced:  sE5Ch1N2  = (9  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE6Ch1N2  = 1 + 15 ; advanced:  sE6Ch1N2  = (1  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE7Ch1N2  = 8      ; advanced:  sE7Ch1N2  = (8  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE8Ch1N2  = 0 + 15 ; advanced:  sE8Ch1N2  = (0  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE9Ch1N2  = 7      ; advanced:  sE9Ch1N2  = (7  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE10Ch1N2 = 14     ; advanced:  sE10Ch1N2 = (14 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE11Ch1N2 = 6      ; advanced:  sE11Ch1N2 = (6  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE12Ch1N2 = 13     ; advanced:  sE12Ch1N2 = (13 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE13Ch1N2 = 5 + 15 ; advanced:  sE13Ch1N2 = (5  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE14Ch1N2 = 12     ; advanced:  sE14Ch1N2 = (12 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN

;The 15 synchronization point selectors for channel 2 for normal base clock (div28/64kHz)
sE0Ch2N2 = sE1Ch1N2
sE1Ch2N2 = sE2Ch1N2
sE2Ch2N2 = sE3Ch1N2
sE3Ch2N2 = sE4Ch1N2
sE4Ch2N2 = sE5Ch1N2
sE5Ch2N2 = sE6Ch1N2
sE6Ch2N2 = sE7Ch1N2
sE7Ch2N2 = sE8Ch1N2
sE8Ch2N2 = sE9Ch1N2
sE9Ch2N2 = sE10Ch1N2
sE10Ch2N2 = sE11Ch1N2
sE11Ch2N2 = sE12Ch1N2
sE12Ch2N2 = sE13Ch1N2
sE13Ch2N2 = sE14Ch1N2
sE14Ch2N2 = sE0Ch1N2

;The 15 synchronization point selectors for channel 3 for normal base clock (div28/64kHz)
sE0Ch3N2 = sE1Ch2N2
sE1Ch3N2 = sE2Ch2N2
sE2Ch3N2 = sE3Ch2N2
sE3Ch3N2 = sE4Ch2N2
sE4Ch3N2 = sE5Ch2N2
sE5Ch3N2 = sE6Ch2N2
sE6Ch3N2 = sE7Ch2N2
sE7Ch3N2 = sE8Ch2N2
sE8Ch3N2 = sE9Ch2N2
sE9Ch3N2 = sE10Ch2N2
sE10Ch3N2 = sE11Ch2N2
sE11Ch3N2 = sE12Ch2N2
sE12Ch3N2 = sE13Ch2N2
sE13Ch3N2 = sE14Ch2N2
sE14Ch3N2 = sE0Ch2N2

;The 15 synchronization point selectors for channel 4 for normal base clock (div28/64kHz)
sE0Ch4N2 = sE1Ch3N2
sE1Ch4N2 = sE2Ch3N2
sE2Ch4N2 = sE3Ch3N2
sE3Ch4N2 = sE4Ch3N2
sE4Ch4N2 = sE5Ch3N2
sE5Ch4N2 = sE6Ch3N2
sE6Ch4N2 = sE7Ch3N2
sE7Ch4N2 = sE8Ch3N2
sE8Ch4N2 = sE9Ch3N2
sE9Ch4N2 = sE10Ch3N2
sE10Ch4N2 = sE11Ch3N2
sE11Ch4N2 = sE12Ch3N2
sE12Ch4N2 = sE13Ch3N2
sE13Ch4N2 = sE14Ch3N2
sE14Ch4N2 = sE0Ch3N2



;The 5 synchronization point selectors for channel 1 for low base clock (div114/15kHz), representing 5 particular elements of poly4 sequence (Ex) from which the sampling starts.
;The values assigned to the selectors are just initial AudF values to be set in timer of channel 1 before synchronization procedure.
;The formulas in the comments may be preferred by advanced programmers for calculating selectors values exactly according to the needed register's setup time.
;For more information see explanations on the bottom.
;To find a maximum available setup time based on the 5 assignments below take the lowest assignment value (let's call it N) and use a formula setupTime = (N + 1) * 114.
;The values selected below guarantee that POKEY synchronization code will work correct even if its execution will be suspended by ANTIC's bad line DMA cycles (setupTime > 180).
sE0Ch1L2 = 3     ; advanced:  sE0Ch1L2  = (3 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE3Ch1L2 = 0 + 5 ; advanced:  sE3Ch1L2  = (0 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE6Ch1L2 = 2     ; advanced:  sE6Ch1L2  = (2 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE9Ch1L2 = 4     ; advanced:  sE9Ch1L2  = (4 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE12Ch1L2 = 1    ; advanced:  sE12Ch1L2 = (1 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL

;The 5 synchronization point selectors for channel 2 for low base clock (div114/15kHz)
sE2Ch2L2 = sE3Ch1L2
sE5Ch2L2 = sE6Ch1L2
sE8Ch2L2 = sE9Ch1L2
sE11Ch2L2 = sE12Ch1L2
sE14Ch2L2 = sE0Ch1L2

;The 5 synchronization point selectors for channel 3 for low base clock (div114/15kHz)
sE1Ch3L2 = sE2Ch2L2
sE4Ch3L2 = sE5Ch2L2
sE7Ch3L2 = sE8Ch2L2
sE10Ch3L2 = sE11Ch2L2
sE13Ch3L2 = sE14Ch2L2

;The 5 synchronization point selectors for channel 4 for low base clock (div114/15kHz)
sE0Ch4L2 = sE3Ch1L2  ; = sE1Ch3L2
sE3Ch4L2 = sE6Ch1L2  ; = sE4Ch3L2
sE6Ch4L2 = sE9Ch1L2  ; = sE7Ch3L2
sE9Ch4L2 = sE12Ch1L2  ; = sE10Ch3L2
sE12Ch4L2 = sE0Ch1L2  ; = sE13Ch3L2



;mapping: poly4 sequence elements (Ex) -> sampling track (STx) and timbres (Tx)
;E0,E3,E6,E9,E12 -> ST0, T0/T2
;E1,E4,E7,E10,E13 -> ST1, T1
;E2,E5,E8,E11,E14 -> ST2, T2/T0

;When sampling track ST0 or ST2 is used then the timbre depends on frequency divisor and it may be T0 or T2.
;When sampling track ST1 is used then the timbre is always T1.


;mapping: timbre (Tx) -> bit sequence
;T0 -> 00111
;T1 -> 01000
;T2 -> 01101


;mapping: channel -> sampling track (STx) and timbres (Tx) - for low base clock (div114/15kHz)
;ch1 -> ST0, T0/T2
;ch2 -> ST2, T2/T0
;ch3 -> ST1, T1
;ch4 -> ST0, T0/T2



;Selectors of sampling tracks (ST0 - ST2) for channel 1 for normal base clock (div28/64kHz)
sST0Ch1 = sE6Ch1N2 ; sampling starts from E6 on ST0
sST1Ch1 = sE10Ch1N2 ; sampling starts from E10 on ST1
sST2Ch1 = sE8Ch1N2 ; sampling starts from E8 on ST2

;Selectors of sampling tracks (ST0 - ST2) for channel 2 for normal base clock (div28/64kHz)
sST0Ch2 = sE6Ch2N2
sST1Ch2 = sE10Ch2N2
sST2Ch2 = sE8Ch2N2

;Selectors of sampling tracks (ST0 - ST2) for channel 3 for normal base clock (div28/64kHz)
sST0Ch3 = sE6Ch3N2
sST1Ch3 = sE10Ch3N2
sST2Ch3 = sE8Ch3N2

;Selectors of sampling tracks (ST0 - ST2) for channel 4 for normal base clock (div28/64kHz)
sST0Ch4 = sE6Ch4N2
sST1Ch4 = sE10Ch4N2
sST2Ch4 = sE8Ch4N2



;Advanced calculations of synchronization point selector (sps) values


;Uncomment the assignment below if you prefer advanced calculation of sps.
;p4SeqLen = 15 ;number of elements of poly4 counter sequence

;WARNING! The maxPokeyAudFSetupTime constant must be provided.
;The maxPokeyAudFSetupTime means maximum number of phi2 cycles needed for CPU to setup all POKEY registers after finishing POKEY reset (storing 3 to SKCTL).
;It's an arbitrary value, just what's needed.
;Examples:
;1. While handling VBLK interrupt we assume there is no scanlines displayed and we only need to take into consideration the DRAM refresh cycles.
;In case we need to setup all 4 channels the maxPokeyAudFSetupTime value would be:
;maxPokeyAudFSetupTime = 32 + 9 ; 4 *( lda # + sta audfx) + 9 refresh cycles
;minPokeyAudFSetupDelayN = 1 (see below)
;2. If the POKEY synchronization occurs while displaying screen then in worst case executing our 32 cycles may take 180 (one bad line + more than half of next one). If less than 32 is needed then we can deduct the difference twice.
;maxPokeyAudFSetupTime = 180
;minPokeyAudFSetupDelayN = 6 (see below)

;The minPokeyAudFSetupDelayN represents the maxPokeyAudFSetupTime value translated into number of pulses of normal base clock (div28/64kHz).

;Uncomment the assignment below if you prefer advanced calculation of sps.
;minPokeyAudFSetupDelayN = maxPokeyAudFSetupTime / 28

;mapping: maxPokeyAudFSetupTime range -> minPokeyAudFSetupDelayN value
;0 .. 27 -> 0
;28 .. 55 -> 1
;56 .. 83 -> 2
;84 .. 111 -> 3
;112 .. 139 -> 4
;140 .. 167 -> 5
;168 .. 195 -> 6

;Uncomment the assignment below if you prefer advanced calculation of sps.
;spCntN = p4SeqLen ; number of synchronization points for normal base clock (div28/64kHz); it's equal to p4SeqLen/GCD(p4SeqLen, 28) where GCD (greatest common divisor) of 15 and 28 is 1


;The minPokeyAudFSetupDelayL represents maxPokeyAudFSetupTime value translated into number of pulses of low base clock (div114/15kHz).

;Uncomment the assignment below if you prefer advanced calculation of sps.
;minPokeyAudFSetupDelayL = maxPokeyAudFSetupTime / 114

;mapping: maxPokeyAudFSetupTime range -> minPokeyAudFSetupDelayL value
;0 .. 113 -> 0
;114 .. 227 -> 1
;228 .. 341 -> 2

;Uncomment the assignment below if you prefer advanced calculation of sps.
;spCntL = 5 ; number of synchronization points for low base clock(div114/15kHz); it's equal to p4SeqLen/GCD(p4SeqLen, 114) where GCD (greatest common divisor) of 15 and 114 is 3
