
;Constants used for synchronization of POKEY channels playing distortion C and frequencies for which an effective frequency divisor is a multiple of 3 (M3).
;Constants used by synchronization method 1b which uses POKEY reset and forces reloading timers by writing to STIMER register. The method sets final divisors after switching POKEY back to normal work.

;Author: Pawel Rosowski (pavros)
;Date: 2018.04.09

;Synchronization points are points in time.
;They are associated with 15 particular elements of poly4 sequence (Ex) from which the sampling starts and thus are associated with concrete
;sampling tracks (ST0-ST2) and rough phase delays (D0-D4).
;There are 15 different synchronization points for normal base clock (div28/64kHz) and 5 different synchronization points for low base clock (div114/15kHz) available for each channel.
;There are only 5 synchronization points available while using div114 clock because in that case there is only one sampling track hardwired to the channel.
;Synchronization points repeat periodically. The same synchronization point repeats every 15 pulses of div28 and every 5 pulses of div114 clock.
;Synchronization point selectors are the values which are initially written to AUDFx registers by synchronization procedure in order to start sampling from associated element Ex of poly4 sequence.
;For normal base clock the selector values may be added any possible multiple of 15 and would still point to the same Ex element.
;For low base clock the selector values may be added any possible multiple of 5 and would still point to the same Ex element.



;The 15 synchronization point selectors for channel 1 for normal base clock (div28/64kHz), representing 15 particular elements of poly4 sequence (Ex) from which the sampling starts.
;The values of the selectors are just initial AudF values to be set in timer of channel 1 before synchronization procedure.
;The formulas in the comments may be preferred by advanced programmers for calculating selector values exactly according to the needed register's setup time.
;For more information see explanations on the bottom.
;To find a maximum available setup time based on the 15 assignments below take the lowest assignment value (let's call it N) and use a formula setupTime = 24 + N * 28.
;The values selected below guarantee that POKEY synchronization code will work correct even if its execution will be suspended by ANTIC's bad line DMA cycles (setupTime > 180).
sE0Ch1N  = 5 + 15 ; advanced:  sE0Ch1N  = (5  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE1Ch1N  = 12     ; advanced:  sE1Ch1N  = (12 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE2Ch1N  = 4 + 15 ; advanced:  sE2Ch1N  = (4  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE3Ch1N  = 11     ; advanced:  sE3Ch1N  = (11 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE4Ch1N  = 3 + 15 ; advanced:  sE4Ch1N  = (3  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE5Ch1N  = 10     ; advanced:  sE5Ch1N  = (10 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE6Ch1N  = 2 + 15 ; advanced:  sE6Ch1N  = (2  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE7Ch1N  = 9      ; advanced:  sE7Ch1N  = (9  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE8Ch1N  = 1 + 15 ; advanced:  sE8Ch1N  = (1  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE9Ch1N  = 8      ; advanced:  sE9Ch1N  = (8  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE10Ch1N = 0 + 15 ; advanced:  sE10Ch1N = (0  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE11Ch1N = 7      ; advanced:  sE11Ch1N = (7  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE12Ch1N = 14     ; advanced:  sE12Ch1N = (14 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE13Ch1N = 6      ; advanced:  sE13Ch1N = (6  + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN
sE14Ch1N = 13     ; advanced:  sE14Ch1N = (13 + spCntN - minPokeyAudFSetupDelayN) % spCntN + minPokeyAudFSetupDelayN

;The 15 synchronization point selectors for channel 2 for normal base clock (div28/64kHz)
sE0Ch2N = sE1Ch1N
sE1Ch2N = sE2Ch1N
sE2Ch2N = sE3Ch1N
sE3Ch2N = sE4Ch1N
sE4Ch2N = sE5Ch1N
sE5Ch2N = sE6Ch1N
sE6Ch2N = sE7Ch1N
sE7Ch2N = sE8Ch1N
sE8Ch2N = sE9Ch1N
sE9Ch2N = sE10Ch1N
sE10Ch2N = sE11Ch1N
sE11Ch2N = sE12Ch1N
sE12Ch2N = sE13Ch1N
sE13Ch2N = sE14Ch1N
sE14Ch2N = sE0Ch1N

;The 15 synchronization point selectors for channel 3 for normal base clock (div28/64kHz)
sE0Ch3N = sE1Ch2N
sE1Ch3N = sE2Ch2N
sE2Ch3N = sE3Ch2N
sE3Ch3N = sE4Ch2N
sE4Ch3N = sE5Ch2N
sE5Ch3N = sE6Ch2N
sE6Ch3N = sE7Ch2N
sE7Ch3N = sE8Ch2N
sE8Ch3N = sE9Ch2N
sE9Ch3N = sE10Ch2N
sE10Ch3N = sE11Ch2N
sE11Ch3N = sE12Ch2N
sE12Ch3N = sE13Ch2N
sE13Ch3N = sE14Ch2N
sE14Ch3N = sE0Ch2N

;The 15 synchronization point selectors for channel 4 for normal base clock (div28/64kHz)
sE0Ch4N = sE1Ch3N
sE1Ch4N = sE2Ch3N
sE2Ch4N = sE3Ch3N
sE3Ch4N = sE4Ch3N
sE4Ch4N = sE5Ch3N
sE5Ch4N = sE6Ch3N
sE6Ch4N = sE7Ch3N
sE7Ch4N = sE8Ch3N
sE8Ch4N = sE9Ch3N
sE9Ch4N = sE10Ch3N
sE10Ch4N = sE11Ch3N
sE11Ch4N = sE12Ch3N
sE12Ch4N = sE13Ch3N
sE13Ch4N = sE14Ch3N
sE14Ch4N = sE0Ch3N



;The 5 synchronization point selectors for channel 1 for low base clock (div114/15kHz), representing 5 particular elements of poly4 sequence (Ex) from which the sampling starts.
;The values assigned to the selectors are just initial AudF values to be set in timer of channel 1 before synchronization procedure.
;The formulas in the comments may be preferred by advanced programmers for calculating selectors values exactly according to the needed register's setup time.
;For more information see explanations on the bottom.
;To find a maximum available setup time based on the 5 assignments below take the lowest assignment value (let's call it N) and use a formula setupTime = 83 + N * 114.
;The values selected below guarantee that POKEY synchronization code will work correct even if its execution will be suspended by ANTIC's bad line DMA cycles (setupTime > 180).
sE0Ch1L = 4     ; advanced:  sE0Ch1L  = (4 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE3Ch1L = 1     ; advanced:  sE3Ch1L  = (1 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE6Ch1L = 3     ; advanced:  sE6Ch1L  = (3 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE9Ch1L = 0 + 5 ; advanced:  sE9Ch1L  = (0 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL
sE12Ch1L = 2    ; advanced:  sE12Ch1L = (2 + spCntL - minPokeyAudFSetupDelayL) % spCntL + minPokeyAudFSetupDelayL

;The 5 synchronization point selectors for channel 2 for low base clock (div114/15kHz)
sE2Ch2L = sE3Ch1L
sE5Ch2L = sE6Ch1L
sE8Ch2L = sE9Ch1L
sE11Ch2L = sE12Ch1L
sE14Ch2L = sE0Ch1L

;The 5 synchronization point selectors for channel 3 for low base clock (div114/15kHz)
sE1Ch3L = sE2Ch2L
sE4Ch3L = sE5Ch2L
sE7Ch3L = sE8Ch2L
sE10Ch3L = sE11Ch2L
sE13Ch3L = sE14Ch2L

;The 5 synchronization point selectors for channel 4 for low base clock (div114/15kHz)
sE0Ch4L = sE3Ch1L  ; = sE1Ch3L
sE3Ch4L = sE6Ch1L  ; = sE4Ch3L
sE6Ch4L = sE9Ch1L  ; = sE7Ch3L
sE9Ch4L = sE12Ch1L  ; = sE10Ch3L
sE12Ch4L = sE0Ch1L  ; = sE13Ch3L



;mapping: poly4 sequence elements (Ex) -> sampling track (STx) and timbres (Tx)
;E0,E3,E6,E9,E12 -> ST0, T0/T2
;E1,E4,E7,E10,E13 -> ST1, T1
;E2,E5,E8,E11,E14 -> ST2, T2/T0

;When sampling track ST0 or ST2 is used then the timbre depends on frequency divisor and it may be T0 or T2.
;When sampling track ST1 is used then the timbre is always T1.


;mapping: timbre (Tx) -> bit sequence
;T0 -> 00111
;T1 -> 01000
;T2 -> 01101


;mapping: channel -> sampling track (STx) and timbres (Tx) - for low base clock (div114/15kHz)
;ch1 -> ST0, T0/T2
;ch2 -> ST2, T2/T0
;ch3 -> ST1, T1
;ch4 -> ST0, T0/T2



;Selectors of sampling tracks (ST0 - ST2) for channel 1 for normal base clock (div28/64kHz)
sST0Ch1 = sE6Ch1N ; sampling starts from E6 on ST0
sST1Ch1 = sE10Ch1N ; sampling starts from E10 on ST1
sST2Ch1 = sE8Ch1N ; sampling starts from E8 on ST2

;Selectors of sampling tracks (ST0 - ST2) for channel 2 for normal base clock (div28/64kHz)
sST0Ch2 = sE6Ch2N
sST1Ch2 = sE10Ch2N
sST2Ch2 = sE8Ch2N

;Selectors of sampling tracks (ST0 - ST2) for channel 3 for normal base clock (div28/64kHz)
sST0Ch3 = sE6Ch3N
sST1Ch3 = sE10Ch3N
sST2Ch3 = sE8Ch3N

;Selectors of sampling tracks (ST0 - ST2) for channel 4 for normal base clock (div28/64kHz)
sST0Ch4 = sE6Ch4N
sST1Ch4 = sE10Ch4N
sST2Ch4 = sE8Ch4N



;Advanced calculations of synchronization point selector (sps) values


;Uncomment the assignment below if you prefer advanced calculation of sps.
;p4SeqLen = 15 ;number of elements of poly4 counter sequence

;WARNING! The maxPokeyAudFSetupTime constant must be provided.
;The maxPokeyAudFSetupTime means maximum number of phi2 cycles needed for CPU to setup all POKEY registers after finishing POKEY reset (storing 3 to SKCTL).
;It's an arbitrary value, just what's needed.
;Examples:
;1. While handling VBLK interrupt we assume there is no scanlines displayed and we only need to take into consideration the DRAM refresh cycles.
;In case we need to setup all 4 channels the maxPokeyAudFSetupTime value would be:
;maxPokeyAudFSetupTime = 32 + 9 ; 4 *( lda # + sta audfx) + 9 refresh cycles
;minPokeyAudFSetupDelayN = 1 (see below)
;2. If the POKEY synchronization occurs while displaying screen then in worst case executing our 32 cycles may take 180 (one bad line + more than half of next one). If less than 32 is needed then we can deduct the difference twice.
;maxPokeyAudFSetupTime = 180
;minPokeyAudFSetupDelayN = 6 (see below)

;The minPokeyAudFSetupDelayN represents the maxPokeyAudFSetupTime value translated into number of pulses of normal base clock (div28/64kHz).
;The number 24 in the formula is a number of phi2 clock cycles between end of POKEY reset and first effective sampling by first timerX clock pulse (following first div28 clock pulse). Updating any of AudFx registers within these 24 cycles timespan will be effective for first timerX clock pulse.

;Uncomment the assignment below if you prefer advanced calculation of sps.
;minPokeyAudFSetupDelayN = (maxPokeyAudFSetupTime + 28 - 1 - 24) / 28

;mapping: maxPokeyAudFSetupTime range -> minPokeyAudFSetupDelayN value
;0 .. 24 -> 0
;25 + (0 .. 27) -> 1
;25 + (28 .. 55) -> 2
;25 + (56 .. 83) -> 3
;25 + (84 .. 111) -> 4
;25 + (112 .. 139) -> 5
;25 + (140 .. 167) -> 6
;25 + (168 .. 195) -> 7

;Uncomment the assignment below if you prefer advanced calculation of sps.
;spCntN = p4SeqLen ; number of synchronization points for normal base clock (div28/64kHz); it's equal to p4SeqLen/GCD(p4SeqLen, 28) where GCD (greatest common divisor) of 15 and 28 is 1


;The minPokeyAudFSetupDelayL represents maxPokeyAudFSetupTime value translated into number of pulses of low base clock (div114/15kHz).
;The number 83 in the formula is a number of phi2 clock cycles between end of POKEY reset and first effective sampling by first timerX clock pulse (following first div114 clock pulse). Updating any of AudFx registers within these 83 cycles timespan will be effective for first timerX clock pulse.

;Uncomment the assignment below if you prefer advanced calculation of sps.
;minPokeyAudFSetupDelayL = (maxPokeyAudFSetupTime + 114 - 1 - 83) / 114

;mapping: maxPokeyAudFSetupTime range -> minPokeyAudFSetupDelayL value
;0 .. 83 -> 0
;84 + (0 .. 113) -> 1
;84 + (114 .. 227) -> 2
;84 + (228 .. 341) -> 3

;Uncomment the assignment below if you prefer advanced calculation of sps.
;spCntL = 5 ; number of synchronization points for low base clock(div114/15kHz); it's equal to p4SeqLen/GCD(p4SeqLen, 114) where GCD (greatest common divisor) of 15 and 114 is 3
