

	lda rtclock + 2
	cmp rtclock + 2
	beq *-2			;wait for VBL

	lda #$00
	sta nmien		;turn off all NMI
	sta nmires
	sei				;turn off all IRQ
	sta irqen		;turn off POKEY interrupts
	;lda #$00
	;sta dmactls
	sta dmactl		;disable screen dma

;copy char definitions to RAM
	ldy #$00
cpChLoop
	ldx #OS_BANKSTD
	stx portb
	lda STD_CHARS_DEF_ADR,Y
	pha
	lda STD_CHARS_DEF_ADR+$100,Y
	pha
	lda STD_CHARS_DEF_ADR+$200,Y
	pha
	lda STD_CHARS_DEF_ADR+$300,Y
	pha
	ldx #BANKSTD
	stx portb
	pla
	sta STD_CHARS_DEF_ADR+$300,Y
	pla
	sta STD_CHARS_DEF_ADR+$200,Y
	pla
	sta STD_CHARS_DEF_ADR+$100,Y
	pla
	sta STD_CHARS_DEF_ADR,Y
	dey
	bne cpChLoop

	;lda #BANKSTD
	;sta portb

	lda #.lo(nmiCommonHnd)
	sta nmivec
	lda #.hi(nmiCommonHnd)
	sta nmivec+1
	lda #.lo(irqCommonHnd)
	sta irqvec
	lda #.hi(irqCommonHnd)
	sta irqvec+1

	lda #.lo(dList)  ;setup Display List vector
	sta dlptr
	;sta dlptrs
	lda #.hi(dList)
	sta dlptr+1
	;sta dlptrs+1

	lda #2
	sta chrctl
	sta chact

;initialize indicators on screen
	ldx #3
scrInitLp
	stx temp0
	jsr rfshWave
	ldx temp0
	jsr rfshAudF
	ldx temp0
	jsr rfshSmpShf
	ldx temp0
	dex
	bpl scrInitLp
	jsr rfshBaseClk
	jsr rfshSync
	jsr rfshScale
	jsr rfshOctave

	lda #$40
	sta nmien       ;enable VBLKI
	lda #$22
	;sta dmactls
	sta dmactl      ;enable screen dma

	cli

;main loop
loop:
	jmp loop
	