
delayAccuratePhase
	lda #0
	sta pIrqEn
	sta irqen
	ldy #$0E ; rough phase neutral divider 15 * 28 = 420 phi2 cycles
	;ldy #$1D ; rough phase neutral divider 840 phi2 cycles
	inc phsDelVblCnt
	lda phsDelVblCnt
	cmp #8
	bcc delAcrPhs1
	lda #0
	sta phsDelVblCnt
delAcrPhs1
	cmp #7
	bne delAcrPhs2
	; delay accurate phase of channel 4 on every 8th invocation
	sty audF4
	tax
	lda pIrqEn
	ora #4
	sta pIrqEn
	txa
delAcrPhs2
	and #3
	cmp #3
	bne delAcrPhs3
	; delay accurate phase of channel 2 on every 4th invocation
	sty audF2
	tax
	lda pIrqEn
	ora #2
	sta pIrqEn
	txa
delAcrPhs3
	and #1
	beq delAcrPhs4
	; delay accurate phase of channel 1 on every 2nd invocation
	sty audF1
	ora pIrqEn
	sta pIrqEn
delAcrPhs4
	lda pIrqEn
	sta irqen ;enable Timer interrupts
	rts

phsDelVblCnt
	.db 0


irqRestoreAudF
	pha
	txa
	pha
	lda irqst
	tax
	and pIrqEn
	sta irqen ; clear Timer interrupt requests and disable requested interrupts
	txa
	lsr
	bcs irqRstA1
	ldx vAudF1
	stx audF1
irqRstA1
	lsr
	bcs irqRstA2
	ldx vAudF2
	stx audF2
irqRstA2
	lsr
	bcs irqRstA3
	ldx vAudF4
	stx audF4
irqRstA3
	pla
	tax
	pla
	rti

pIrqEn
	.db 0
