pico-8 cartridge // http://www.pico-8.com
version 16
__lua__
hiscore=0

function _init()
 --state=0
 cartdata("konwoj")
 hiscore = dget(0) 
 frame=0
 menu_init()
 -- 0: menu
 -- 1: game
 --game_init()
end

function _update()
 frame+=1
 if(state==0) then
  menu_update()
 elseif(state==1) then
  game_update()
 elseif(state==2) then
  gameover_update()
 elseif(state==3) then
  intro_update()
 end
end

function _draw()
 if(state==0) then
  menu_draw()
 elseif(state==1) then
  game_draw()
 elseif(state==2) then
  gameover_draw()
 elseif(state==3) then
  intro_draw()
 end
end

-->8
-- menu and gameover
function menu_init()
 frame=0
 state=0
 music(0)
end

function menu_update()
 if(btnp(4) and frame>30) then
  intro_init()
 end
end

function menu_draw()
 cls(1)
 map(0,48,0,0,16,16)
 pset(0,0,11)
end

function gameover_init()
 frame=0
 state=2
 newhiscore=false
 if score > hiscore then
  newhiscore = true
  hiscore = score
  dset(0, hiscore)
 end
end

function gameover_update()
 if (btnp(4) and frame>30) then
  menu_init()
 end
end

function gameover_draw()
 cls(5)
 print("game over", 48, 58, 8)
 print("your score:", 48, 64, 8)
 print(score, 48, 70, 8)
 if newhiscore and flr(frame/10%2)==0 then
  print("new hi-score!", 48, 76, 8)
 end
end

function intro_init()
 state=3
 frame=0
 convx=0
 convy=tank_y
 bgdx=0
 cavex=128
 
 intro_update()
end

function intro_update()
 if btnp(4) and frame>30 then
  game_init()
  return
 end

 if frame < 90 then
  convx = 20-(90-frame)
 elseif frame < 180 then
  bgdx = frame%8
 elseif frame < 180+7*8 then
  bgdx = frame%8
  cavex -= 1
 elseif frame < 300+7*8 then
  convx += 1
 else 
 --elseif frame==180 then
  game_init()
 end 
end

function intro_draw()
 cls(0)
 rectfill(
  0,0,cavex,128,12
 )
 circfill(
  30-frame/100, 90+frame/20, 17, 9
 )
 -- earth
 for i=0,18 do
  spr(2, i*8-bgdx, bottom_y)
  spr(18, i*8-bgdx, bottom_y+8)
  spr(19, i*8-bgdx, bottom_y+16)
  spr(18, i*8-bgdx, bottom_y+24)
 end
 --cave
 map(
  121, 52,
  cavex, 0,
  5, 12
 )
 --tanks
 for i=0,2 do
  spr(
   anim_spr(32,2,frame/4,2),
   convx+i*20,
   convy,
   2, 2
  )
  line(
   convx+i*20+8,
   tank_y+4,
   convx+i*20+14,
   tank_y+4,
   3
  )
  line(
   convx+i*20+6,
   tank_y+4,
   convx+i*20+9,
   tank_y+4,
   tankcol[1+i]
  )
 end
 --cave
 map(
  126, 52,
  cavex+5*8, 0,
  2, 12
 )
 --print(
 -- hiscore,
 -- cavex+19, 33,
 -- 0
 --)
 print(
  hiscore,
  cavex+4*8-(#tostr(hiscore)*2), 33,
  0
 )
end
-->8
tmpval=0
tiles_top=4
tiles_bottom=4
bottom_y=128-tiles_bottom*8

tank_x=10
tank_y=bottom_y-16

gun_x=tank_x+8
gun_y=tank_y+4
gun_len=10

bat_spr=7
bg_speed=0.7

maxammo=6
tankcol={8, 9, 10}

function game_init()
 lives=3
 state=1
 frame=0
 stopf=0
 ammo=maxammo
 reloadstartframe=0
 score=0
 tank_angle=0.0
 enemies={}
 bullets={}
 frame=0

 cavea_dx=0
 caveb_dx=0
 cavec_dx=0
 
 music(5)
 
 game_update()
 lastupdated=0
 
 --spawn_enemy()
end

function game_update()
 if (frame-stopf)%30==0 and (frame-stopf) != lastupdated then
  score += 10
  lastupdated = frame-stopf
 end
 -- logic
 if (btn(4)) then
  stopf+=1
  if (ammo<maxammo) then
   reload_ammo()
  end
  stopped=true
 else
  stopped=false
 end
 framem=frame-stopf
 bgdx=(bg_speed*framem)%8
 -- background
 if not stopped then
  cavea_dx-=bg_speed/4
  if cavea_dx<-127 then cavea_dx=0 end
  caveb_dx-=bg_speed/2
  if caveb_dx<-127 then caveb_dx=0 end
  cavec_dx-=bg_speed
  if cavec_dx<-127 then cavec_dx=0 end
 end
 -- fire
 if (btnp(5)) then
  if (ammo>0 and not stopped) then
   ammo-=1
   add(bullets, bullet_build())
   sfx(63)
  else
   sfx(61)
  end
 end
 -- gun angle
 if (btn(2)) then
  tank_angle=min(90, tank_angle+3)
 elseif (btn(3)) then
  tank_angle=max(-20, tank_angle-3)
 end
 -- bullets move
 foreach(bullets, bullet_update)
 -- bullets cleanup
 for b in all(bullets) do
  if (not bullet_alive(b)) then
   del(bullets, b)
  end
 end
 -- bullet-enemy collision
 for b in all(bullets) do
  tmp_bullet_hit=false
  for e in all(enemies) do
   if be_coll(b, e) then
    tmp_bullet_hit=true
    enemy_destroy(e)
    sfx(59)
    break
   end
  end
  if tmp_bullet_hit then
   del(bullets, b)
  end
 end
 -- player-enemy collision
 for e in all(enemies) do
  if pe_coll(e) then
   del(enemies, e)
   lives-=1
   sfx(60)
  end
 end
 if lives<=0 then
  gameover_init()
 end
 -- enemies
 foreach(enemies, update_enemy)
 -- enemy spawner
 enemyspawner()
end

function draw_bg()
 for i=0,18 do
  spr(2, i*8-bgdx, bottom_y)
  spr(18, i*8-bgdx, bottom_y+8)
  spr(19, i*8-bgdx, bottom_y+16)
  spr(18, i*8-bgdx, bottom_y+24)
 end
 for i=0,18 do
  spr(2, i*8-bgdx, 24, 1, 1, false, true)
  spr(18, i*8-bgdx, 16)
  spr(19, i*8-bgdx, 8)
  spr(18, i*8-bgdx, 0)
 end
 
 map(32,0,cavea_dx,32,16,8)
 map(32,0,128+cavea_dx,32,16,8)
 map(16,0,caveb_dx,32,16,8)
 map(16,0,128+caveb_dx,32,16,8)
 map(0,0,cavec_dx,32,16,8)
 map(0,0,128+cavec_dx,32,16,8)
 
 --rectfill(0,0,128,tiles_top*8,4)
 --rectfill(0,(16-tiles_bottom)*8,128,128,4)
end

function draw_tanks()
 for i=0,lives-1 do
  spr(
   anim_spr(32,2,framem/3,2),
   tank_x-i*20,
   tank_y,
   2, 2)
 end
 -- gun
 pset(gun_x, gun_y, 11)
-- line(gun_x, gun_y, gun_x+cos(tank_angle/360)*200, gun_y+sin(tank_angle/360)*200, 5)
 line(
  gun_x,
  gun_y,
  gun_x+cos(tank_angle/360)*gun_len,
  gun_y+sin(tank_angle/360)*gun_len,
  3
 )
  line(
  tank_x+6,
  tank_y+4,
  tank_x+9,
  tank_y+4,
  tankcol[lives]
 )
end

function draw_enemies()
 -- enemies
 foreach(enemies, draw_enemy)
 --draw_bat(100,40+sin(frame/100)*5)
end

function draw_bullets()
 for b in all(bullets) do
  pset(b.x, b.y, 10)
 end
end

function draw_ui()
 rectfill(0,0,128,8,0)
 rectfill(0,120,128,128,0)
 --print(tank_angle, 100, 0, 3)
 for i=0,lives-1 do
  spr(1,i*9,0)
 end
 for i=0,ammo-1 do
  spr(16,30+i*4,0)
 end
 print(score,0,120,7)
 --print(tmpval,100,120,7)
 --print(frame-reloadstartframe, 120,0,3)
end

function game_draw()
 cls(0)
 draw_bg()
 draw_tanks()
 draw_bullets()
 draw_enemies()
 draw_ui()
end
-->8
-- utils
function anim_spr(basespr, sprw, count, animtotal)
 return basespr+flr(count)%animtotal*sprw
end

function reload_ammo()
 if frame-1 != reloadlastframe then
  reloadstartframe = frame
 end
 reloadlastframe=frame
 if ((frame-reloadstartframe+1)%20==0) then
  ammo+=1
  sfx(62)
 end
end

function bullet_build()
 return {
  x=gun_x,
  y=gun_y,
  dx=cos(tank_angle/360)*3,
  dy=sin(tank_angle/360)*3
 }
end

function bullet_update(b)
 b.x+=b.dx
 b.y+=b.dy
end

function bullet_alive(b)
 return b.x<128
end

-->8
-- bat
function build_bat()
 basey=16+rnd(64)
 amp=rnd(min(basey-8,24))
 return {
  type="bat",
  x=128,
  y=64,
  w=8,
  h=8,
  basey=basey,
  amp=amp,
  speedx=.2,
  speedy=.01,
  startframe=frame,
  anim_sprite=0,
  thresh_x=64,
  alive=true,
  rushx=0,
  rushy=0,
 }
end
function update_bat(e)
 f=frame-e.startframe
 e.x-=e.speedx
 if (e.x>e.thresh_x) then -- fly
	 e.y=e.basey+sin(f*e.speedy)*e.amp
 else --attack
  if (e.rushx==0) then
   e.rushx = (gun_x - e.x)/30
   e.rushy = (gun_y - e.y)/30
  end 
  e.x+=e.rushx
  e.y+=e.rushy
 end
 e.anim_sprite=anim_spr(7,1,f/4,2)
end
function draw_bat(e)
 spr(e.anim_sprite,e.x,e.y)
end

-- spider

function build_spider()
 fallx=gun_x+5+rnd(128-gun_x-10)
 return {
  type="spider",
  x=128,
  y=32,
  w=16,
  h=8,
  speedx=1.5,
  speedy=0,
  startframe=frame,
  anim_sprite=20,
  ontop=1,
  fallx=fallx,
  floorboost=1.5
 }
end

function update_spider(e)
 f=frame-e.startframe
 if e.ontop == 1 then
  e.x-=e.speedx
 elseif e.speedy == 0 then
  e.x-=e.speedx*e.floorboost
 else
  if not stopped then
   e.x-=bg_speed
  end
 end
 if e.x<e.fallx then
  e.ontop=0
  e.speedy=3
 end
 e.y+=e.speedy
 if e.y+e.h >= bottom_y then
  e.speedy = 0
  e.y = bottom_y-e.h
 end

 e.anim_sprite=anim_spr(20,2,f/2,2)
 --tmpval=e.anim_sprite
end

function draw_spider(e)
 spr(e.anim_sprite, e.x, e.y, 2, 1, false, e.ontop==1)
end

-- stone
function build_stone()
 return {
  type="stone",
  x=128,
  y=bottom_y-16,
  w=8,
  h=16,
 }
end

function update_stone(e)
 if not stopped then
  e.x-=bg_speed
 end
end

function draw_stone(e)
 spr(9, e.x, e.y, 1, 2)
end

-- general
function draw_enemy(e)
 if (e.type=="bat") then
  draw_bat(e)
 elseif (e.type=="spider") then
  draw_spider(e)
 elseif (e.type=="stone") then
  draw_stone(e)
 end
end

function update_enemy(e)
 if (e.type=="bat") then
  update_bat(e)
 elseif (e.type=="spider") then
  update_spider(e)
 elseif (e.type=="stone") then
  update_stone(e)
 end
end

function spawn_enemy()
 tmp_r = rnd(3)
 --tmp_r=7
 if tmp_r < 1 then
  add(enemies, build_bat())
 elseif tmp_r < 2 then
  add(enemies, build_spider())
 else
  add(enemies, build_stone())
 end
end

function enemy_destroy(e)
 del(enemies, e)
 if e.type=="bat" then
  score+=100
 elseif e.type=="spider" then
  score+=200
 end
end

function enemyspawner()
 if (frame%85==0) then
  spawn_enemy()
 end
end
-->8
--collisions

function be_coll(b, e)
 if b.x>=e.x and b.x<e.x+e.w then
  if b.y>=e.y and b.y<e.y+e.h then
   return true
  end
 end
 return false
end

function pe_coll(e)
 if e.x <= gun_x then
  return true
 end
 return false
end
__gfx__
00000000000000009999999999999999550555500111111c10000000001001000010010000006000000000000000000000000000000000000000000110000000
000000000003333349994494494999490555505501c1111110000000001111000011110000066000000000000001000000000000000000000000001111000000
007007000003300044944444444494945550555001111c1110000000101111010011110000066600000000000011100000000001110000000000011111100000
00077000003333004444545445494445505555550c11111110000000211e1e12011e1e1000666600000000000011100000000111111100000000111111110000
000770000333333054555555545554555554554501111111c0000000221111221211112100666600000000000111110000001111111100000011111111111000
00700700055555505555545455545554454454540111c11110000000021111202211112206666660000000001111111000111111111111000011111111111100
000000005000000545455555555556554544445401c1111110000000001111002011110206666660000000001111111101111111111111100111111111111110
0000000005555550555555455455555504044040011111c1c0000000000110000001100006666660000000001111111111111111111111111111111111111111
00000000666666665956545555555559000000000000000000000000000000000000000006666660000000000000000000000000000000000000000000000000
05000000666666665455555559555545006660000066600000066600000666000000000066666660000000000000000000000000000000000000000000000000
55500000666666665555555555554555060006666600060000600066666000600000000066646660000000000000000000000000000000000000000000000000
44400000666666665555456554555555600666666666006006006666666660060000000066446666000000000000000000000000000000000000000000000000
44400000666666664555555559555554606066666660606006060666666606060000000066446466000000000000000000000000000000000000000000000000
44400000666666665555554555555555060060606006060606060606060606060000000064464646000000000000000000000000000000000000000000000000
44400000666666665545555555545655060606000606060606060606060606060000000064444444000000000000000000000000000000000000000000000000
00000000666666665555555455555555060606000606060606060606060606060000000044444444000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000022222222000000022000000000000000555555555555555555555555000000000000000000000000
00000000000000000000000000000000000000000002000022222222000000222200000000000000055555555555555055555555000000000000000000000000
00000000000000000000000000000000000000000002200022222222000002222220000000000000005555555555550055555555000000000000000000000000
00000033330000000000003333000000000000000022220022222222000022222222000000000000000555555555500055555555000000000000000000000000
00000033330000000000003333000000000000000022220022222222000222222222200000000000000055555555000055555555000000000000000000000000
00000033330000000000003333000000000000000022220022222222002222222222220000000000000005555550000055555555000000000000000000000000
00003333333300000000333333330000000000000222222022222222022222222222222000000000000000555500000055555555000000000000000000000000
00033333333330000003333333333000000000002222222222222222222222222222222200000000000000055000000055555555000000000000000000000000
00033333333330000003333333333000000000000000000000000000000000001111111100000000555555555555555555555555000000000000000000000000
00033333333330000003333333333000000000000002000000000000000100001111111100000000555555555555555555555555000000000000000000000000
00555555555555000055555555555500000000000022200000020000001110001111111100000000555555555555555555555555000000000000000000000000
05111511115111500511115111151150000000000022200000222000001110001111111100000000055555550055555505555555000000000000000000000000
51115151151511155111151511515115000000000222220002222000011111001111111100000000005555500055555000505550000000000000000000000000
51115151151511155111151511515115000000002222222002222220111111101111111100000000000555000005555000005550000000000000000000000000
05111511115111500511115111151150000000002222222222222222111111111111111100000000000050000005550000000500000000000000000000000000
00555555555555000055555555555500000000002222222222222222111111111111111100000000000000000000500000000000000000000000000000000000
00000000cccccccc33333333000000005555555566cccc66cc6666cc66cccc66666666cc66cccc66cccccccc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566ccc66cc66cc66c66cccc6666ccc6cc66ccc666cccccccc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566cc66cc66cccc6666cccc6666cccc6c66cc6666cccccccc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566666ccc66cccc666666666666cccc6c66cc6c66cccccccc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566666ccc66cccc6666666666666666cc66c66c66cccccccc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566cc66cc66cccc6666cccc6666cccc6c66c6cc66cc6cc6cc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566ccc66cc66cc66c66cccc6666cccc6c6666cc66ccc66ccc0000000000000000000000000000000000000000
00000000cccccccc33333333000000005555555566cccc66cc6666cc66cccc66666666cc666ccc66cccccccc0000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000b5000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
14141414141414141414141414141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
14141414141414141414141414a41414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
14141454146414741484146414941414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
14141414141414141414141414141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
14141414141414141414141414141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014141414141414
14141414141424242424241414141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014141414141414
14141414141424242424242424242414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014143131313131
14141414141424242424241414141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014313131313131
14141414242424242424242424141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031311111111131
14141414242424242424242424141414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031313131313131
14142424242424242424242424242414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031313100003131
14142424242424242424242424242414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031310000000031
14144444444444444444444444444414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031310000000031
14444444444444444444444444444444140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031310000000031
14444414444414444444144444144444140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031310000000031
14144444444444444444444444444414140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031310000000031
__map__
2c2c2c2c2c2c2c2c2c2c2c2c2c2c2c2c3c2f2f00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3a3a3a3a3a3c2b3c2b3a3b3b2a2c2c2b1e2f2f00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2f2f2f2e2e2e2e2e2e2e2e2e2e2a3b2e1e2f2f000000000000000000000000000000002f00000e0f000000000e0d00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1f1f1f1f1f1f1f1f2e2e2e2e2e2e2e2e1e00000000000000000000000000000037370c0d370e38380f0c0b0c38380f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1f1f1f1f1f1f1f1f1f1f1f1f1f1f1f1f1e2f00000000000000000000000000003838383838383838383838383838380f0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2e2e2e2e2e2e1f1f2e2e2e2e2f2e2e2e1e0000250000000025351f0000000025383838383838383838383838383838380000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e25362726362536272626283535252726383838383838383838383838383838380000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e26262626262626262626262626262626383838383838383838383838383838380000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000026262626262626262626262626262626383838383838383838383838383838380000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
0012000015050150501505017050180501805018050150501805518050170501505017050170501005010050170501705017050180501a0501a0501a050170501a0551a05018050170501505017050180501a050
011200001c0501c05021050210501f0501f050210501f0501d0551d0501c0501a0501c0501c0501505015050000001d0501d0501a0501c0501c0501c050180501a0551a05018050170501505017050180501a050
00120000021200211002140021300212002110021400213002120021100214002130021100214002130021200211002140021300212002110021400213002120021100214002130021200211002050020501a050
001200000211002170021200211002140021300212002110021400213002120021100214002130021200211002140021300212002110021400213002120021100214002130021200211002140021300212002110
001200000c0430000000000000000c0430000000000000000c0430000000000000000c0430000000000000000c0430000000000000000c0430000000000000000c0430000000000000000c043000000000000000
001200001c0501c05021050210501f0501f050210501f0501d0551d0501c0501a0501c0501c0501505015050000001d0501d0501a0501c0501c0501c050180501a0551a050180501705015050150500000000000
001200001305013050000001305013050130551605016050180501805013050130500000013050130501305511050110501205012050000001305013050000001305013050130551605016050180501805013050
001c0000073400c3400c34007340093400b3400b34004345043400934009340073400534007340073400034500340023400234002340043400534005340053400734009340093400b3400c3400e3400e3400e340
001c00000735010350103500e3500c3500e3500e3500b350073500c3500c3500b350093500b3500b350043550435009350093500735005350073500735000355003500c3500c3500b35009350073500735013350
001c0000103501035010350103500e3500c3500b3500c3500e3500e3500e350073500735007350073500c3500c3500c3500c3500b3500935007350093500b3500b3500b350043500435504350043500000000000
001c00001a0501a0501a0501a0501805017050150501705018050180501805015050150551505015050150501805018050170501505013050130500c0500c0550000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001c00000c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c0200c0100c0300c020
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000002535027350333503635000300003000030000300003000030000300003000030000300003000030000300003000030000300003000030000300003000030000300003000030000300003000030000300
0000000015550175501a5501d5501f5502155022550245502555001550015500000000000000000000000000000001e5501f5501e5501d5501c5501b550195501755015550145501255000000000000000000000
00000000212502125021250212500020000200002000020000200002000020000200002000020000200002000020000200002000020000200002000020000200002000020000200002002c2002c2002c20000200
000000000000000000000000000010650106501265012650136501465015650156501565000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000186601861017630356403565035660356603566035670356703567035670356703567035670346703467032660316602e6602b650286502665024640226401e6301b63017630146300c6500965001650
__music__
01 00020304
00 01020304
00 00020304
02 05020304
00 40404040
01 070c4440
02 080c4444
00 090c4444
00 07080809
00 08434344
00 09000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000
00 00000000

