pico-8 cartridge // http://www.pico-8.com
version 16
__lua__
t=-1
freeze=0

update_coroutines={}
draw_coroutines={}

ground = 112;
log1 = "";
log2 = "";
log3 = "";

function _init()
	add(update_coroutines,cocreate(_start));
	music(0,0,1+2);
end

function _update()
		t+=1;
	if freeze>0 then
		freeze-=1;
	else
		_up_par();
		_up_coroutines(update_coroutines);
		_up_relation();
		_update_player(player1);
		_update_player(player2);
	end
end

function _draw()
	cls();
	_draw_bg();
	_draw_players();
	_up_coroutines(draw_coroutines);
	_draw_par();
	_draw_banner();
	print(log1);
	print(log2);
	print(log3);
	print("");
end

function _up_coroutines(cs)
	for i=#cs,1,-1 do
		local c = cs[i];
		coresume(c);
		if costatus(c)=="dead" then
			del(cs, c);
		end
	end
end

function _draw_banner()
	if banner > 0 then
		spr(banner,47,51,4,4);
	end
end
-->8
draw_colliders=false

checkb1=0b0101101001011010.1
checkb2=0b1010010110100101.1
function checkb()
	if (flr(t/7)%2==0) then 
		return checkb1 
	else 
		return checkb2 
	end
end

bg={
fl=18,
ug=33,
bg=34,
clin=2,
clout=17,
crin=3,
crout=20,
wl=1,
wr=4,
topbot=52,
topbg=36
}

function _draw_bg()
	srand(2132);
	local s=0;
	for y=0,127,8 do
		for x=0,127,8 do
			local fx=false;
			local fy=false;
			if y < 8 then
				s=bg.topbot;
				fy=true;
			elseif y < 24 then
				s=bg.topbg;
			elseif y < 32 then
				s=bg.topbot;
			elseif y < ground then
				if x < 8 then
					s=bg.ug;
				elseif x < 16 then
					s=bg.wl;
				elseif x < 112 then
					s=bg.bg;
				elseif x < 120 then
					s=bg.wr;
				else
					s=bg.ug;
				end
			elseif y > ground then
				s=bg.ug;
			else
				if x < 8 then
					s=bg.ug;
				elseif x < 16 then
					s=bg.clout;
				elseif x < 112 then
					s=bg.fl;
				elseif x < 120 then
					s=bg.crout;
				else
					s=bg.ug;
				end
			end
			spr(s,x,y,1,1,fx,fy);
		end
	end
	spr(bg.clin,16,ground-8);
	spr(bg.crin,104,ground-8);
	sspr(18,95,92,1,18,112);

	for i=0,5 do
		sspr(80+i,64,1,16,15,94-16*i);
		sspr(88+i,64,1,16,112,94-16*i);
	end

	_draw_top();
end

top={
	x=4,y=13,
	w=50,h=6,
	mirr=128,
	cbg=8,
	chp=9,
	chpi=10,
	cb1=4,
	cb2=13
}

function _draw_top()
	local t=top;
	local m=t.mirr;
	local hp=ceil(player2.hp*t.w*.01);
	local hpi=ceil(player2.hpind*t.w*.01);

	rectfill(t.x,t.y,t.x+t.w-1,t.y+t.h-1,t.cbg); // bg
	if(player2.hp>0)then
		fillp(checkb());
		rectfill(t.x,t.y,t.x+hpi-1,t.y+t.h-1,t.chpi); // hp ind
		fillp();
		rectfill(t.x,t.y,t.x+hp-1,t.y+t.h-1,t.chp); // hp
	end
	rect(t.x-1,t.y-1,t.x+t.w,t.y+t.h,t.cb2); // border
	
	local hp=ceil(player1.hp*t.w*.01);
	local hpi=ceil(player1.hpind*t.w*.01);

	rectfill(m-t.x,t.y,m-(t.x+t.w-1),t.y+t.h-1,t.cbg); // bg
	if(player1.hp>0)then
		fillp(checkb());
		rectfill(m-t.x,t.y,m-(t.x+hpi-1),t.y+t.h-1,t.chpi); // hp ind
		fillp();
		rectfill(m-t.x,t.y,m-(t.x+hp-1),t.y+t.h-1,t.chp); // hp
	end
	rect(m-t.x+1,t.y-1,m-(t.x+t.w),t.y+t.h,t.cb1); // border

	print(player2.points .. ":" .. player1.points,59,13,8);
end

function _draw_players()
	if freeze>0 and player1.lasthit >= player2.lasthit then pal(15,14); end
	_draw_player(player1);
	pal();
	pal(4,13);
	if freeze>0 and player2.lasthit >= player1.lasthit then pal(15,14); end
	_draw_player(player2);
	pal();
end

function _draw_player(pl)
	spr(pl.s,pl.x,pl.y,2,2,pl.lft,pl.down);
	if draw_colliders then
		local x=pl.x+pl.cx;
		local y=pl.y+pl.cy;
		fillp(checkb());
		rect(x,y,x+pl.cw,y+pl.ch,11);
		fillp(0);
		pset(cenx(pl),ceny(pl),11);
		if pl.lattack!=nil then
			for i=1,#pl.lattack.p,2 do
				pset(pl.lattack.p[i],pl.lattack.p[i+1], 8);
			end
		end
	end
end
-->8
player1={idx=0,inx=0,iny=0,dd=1,
x=96,y=96,s=64,lft=true,down=false,
vx=0,vy=0,
anim="idle",af=0,
cx=5,cy=1,cw=5,ch=14,
state="paused",st=0,
stun=false,recovery=0,
attack=nil,hit=nil,lattack=nill,attacked=false,
hp=100,hpind=100,lasthit=0,
points=0
}

player2={idx=1,inx=0,bx=0,by=0,dd=-1,
x=16,y=96,s=64,lft=false,down=false,
vx=0,vy=0,
anim="idle",af=0,
cx=5,cy=1,cw=5,ch=14,
state="paused",st=0,
stun=false,recovery=0,
attack=nil,hit=nil,lattack=nill,attacked=false,
hp=100,hpind=100,lasthit=0,
points=0
}

anims={
idle = {64,64,66,66},
walk = {68,70},
kick = {72,72,74,74},
fall = {96,98},
jump = {100,102},
predive = {104},
dive = {100,102},
recovery = {134,132,130,128},
dash = {106,108},
die = {132,130,130,128},
dead = {136}
}

run_s=2;
grav=1;

rel={
	overlap=false,
	dx=0,
	dy=0
}

function _update_player(pl)
	_up_input(pl);
	_up_physics(pl);
	_up_anims(pl);
end

function _up_input(pl)
	pl.inx=0;
	pl.bx=0;
	pl.by=0;
	if btn(0,pl.idx) then
		pl.inx-=1;
	end
	if btn(1,pl.idx) then
		pl.inx+=1;
	end
	if btnp(0,pl.idx) then
		pl.bx-=1;
	end
	if btnp(1,pl.idx) then
		pl.bx+=1;
	end
	if btnp(2,pl.idx) then
		pl.by+=1;
	end
	if btnp(3,pl.idx) then
		pl.by-=1;
	end
end

function _up_physics(pl)
	if pl.state!="paused" then
		local input={}
		input.grounded=pl.y>=96;
		
		local other = nil;
		if (pl.idx == 0) then other=player2 else other=player1 end
	
		pl.st+=1;
		states[pl.state](pl,other,input);
		//pl.x=flr(pl.x);
		//pl.y=flr(pl.y);
	end
end

function _up_anims(pl)
	pl.af+=.25;
	a = anims[pl.anim];
	if pl.anim=="recovery" then
		pl.s=a[min(#a, max(1, flr(pl.recovery*.25)))];
	else
		pl.s=a[flr(pl.af)%#a+1];
	end
end

function set_anim(pl,a,f)
	if f or pl.anim!=a then
		pl.anim=a;
		pl.af=0;
	end
end

function set_state(pl,s)
	pl.state=s;
	pl.st=-1;
	statess[s](pl);
end

function _up_relation()
	rel.overlap=check_pl(player1,player2);
	rel.dx = player2.x - player1.x;
	rel.dy = player2.y - player1.y;

	check_hit(player1, player2);
	check_hit(player2, player1);
end

function check_hit(at, def)
	def.hit=nil;
	at.attacked=false;
	if at.attack!=nil then
		local a=at.attack;
		at.lattack=a;
		local hitted=false;
		local x;
		local y;
		for i=1,#a.p,2 do
			x=a.p[i];
			y=a.p[i+1];
			if (check_point(def,x,y)) then
				hitted=true;
				break;
			end
		end
		if hitted then
			at.attacked=true;
			if a.rec==nill then a.rec=0 end
			def.lasthit=t;
			def.hit={
				dx=a.dx,
				dy=a.dy,
				rec=a.rec
			};
			def.hp-=a.dmg;
			if def.hp <= 0 then
				def.hp=-1;
				set_state(def, "death");
			end

			bleed(x, y,a.dx,a.dy);
			freeze=2;
			hit_flash(x, y);
			hit_sound(def);

		end
	end
	at.attack=nil;
	
	if(def.hpind > def.hp)def.hpind-=.5;
	if(def.hpind<def.hp)def.hpind=def.hp;
end

attack_interface={
	p={12,32, 32,42},
	dx=2,
	dy=-.2,
	dmg=8
}

hit_interface={
	dx=2,
	dy=-.4
}
-->8
function _up_par()
	up_dust();
	up_blood();
end

function _draw_par()
	draw_dust();
	draw_blood();
end

function random(from, to)
	return from + rnd() * (to - from);
end
function random_flr(from, to)
	return flr(from + rnd() * (to - from));
end

pats={
  0b1111111111111111.1,
  0b0111111111111111.1,
  0b0111111111011111.1,
  0b0101111111011111.1,
  0b0101111101011111.1,
  0b0101101101011111.1,
  0b0101101101011110.1,
  0b0101101001011110.1,
  0b0101101001011010.1,
  0b0001101001011010.1,
  0b0001101001001010.1,
  0b0000101001001010.1,
  0b0000101000001010.1,
  0b0000001000001010.1,
  0b0000001000001000.1
}

// dust

dust_p={}

function landing_par(pl, wave)
	local x = cenx(pl);
	local y = ceny(pl);
	if wave then
		air_wave(x);
	end
	for i=-4,4 do
		put_dust(
			x+i*.6+random(-.3,.3),
			y+6+ random(-1,1),
			i*.05+random(-.02,.02),
			-random(.2,.4),
			random(10,24),
			-.04
		);
	end
end

function put_dust(x,y,dx,dy,lt,g)
	add(dust_p,{
		x=x,
		y=y,
		dx=dx,
		dy=dy,
		lt=lt,
		g=g
	});
end

function up_dust()
	local p;
	for i=#dust_p,1,-1 do
		p=dust_p[i];
		if(p.lt>0 and p.y<=112)then
			p.x+=p.dx;
			p.y+=p.dy;
			p.dy-=p.g;
			p.lt-=1;
		else
			del(dust_p, p);
		end
	end
end

function draw_dust()
	for p in all(dust_p) do
		pset(p.x, p.y, 9);
	end
end

// blood

blood_p={}

function bleed(x,y,dx,dy)

	for i=1,32 do
		put_blood(
			x+random(-1,1),
			y+random(-1,1),
			random(-.4,.4),
			random(-.2,.6),
			random(6,16),
			-.06
		);
	end
end

function put_blood(x,y,dx,dy,lt,g)
	add(blood_p,{
		x=x,
		y=y,
		dx=dx,
		dy=dy,
		lt=lt,
		g=g
	});
end

function up_blood()
	local p;
	for i=#blood_p,1,-1 do
		p=blood_p[i];
		
		if(p.y>110)then
			sset(p.x, 95, 8);
		end
		if p.x <= 15 then
			local y = p.y;
			y -= 30;
			local t = flr(y/16);
			local x = 84 - t;
			y = y % 16;
			sset(x,y+64,8);
			log1 = x;
			log2 = y;
			log3 = p.y-30;
		end
		if p.x >= 112 then
			local y = p.y;
			y -= 30;
			local t = flr(y/16);
			local x = 92 - t;
			y = y % 16;
			sset(x,y+64,8);
			log1 = x;
			log2 = y;
			log3 = p.y-30;
		end
		if(p.lt>0 and p.y<=112)then
			p.x+=p.dx;
			p.y+=p.dy;
			p.dy-=p.g;
			p.lt-=1;
		else
			del(blood_p, p);
		end
	end
end

function draw_blood()
	for p in all(blood_p) do
		pset(p.x, p.y, 8);
	end
end

// visual effects

function hit_flash(x, y)
	add(draw_coroutines, cocreate(function()
		x-=2;
		y-=2;
		local endt = t+4;
		while(t < endt)do
			spr(5,x,y,.625,.625);
		end
	end));
end

function air_bubble(pl, size, late)
	local x = cenx(pl);
	local y = ceny(pl);
	local st = t;
	add(draw_coroutines, cocreate(function()
		for i=1,late do yield(); end
		local d = t-st;
		while(d < 16)do
		
			circfill(x+d*.4,y,4-d/6, 7);
			circfill(x-d*.4,y,4-d/6, 7);

			yield();
			d=t-st;
		end
	end));
end

function air_wave(x)
	local st = t;
	add(draw_coroutines, cocreate(function()
		local d = t-st;
		while(d < 24)do
			local n = 6 + flr(d * .25);
			spr(n,x+3+d*1.4, 104, 1, 1, false);
			spr(n,x-8-d*1.4, 104, 1, 1, true);
			yield();
			d=t-st;
		end
	end));
end

// audio

function hit_sound(pl)
	sfx(random_flr(10,14), 2+pl.idx);
end
-->8
function check_walls(pl)
	if pl.x < 12 then pl.x=12; return 1;end
	if pl.x > 100 then pl.x=100; return -1; end
	return 0;
end

function check_pl(pla,plb)
	local aminx = pla.x+pla.cx;
	local aminy = pla.y+pla.cy;
	local amaxx = aminx + pla.cw;
	local amaxy = aminy + pla.ch;
	local bminx = plb.x+plb.cx;
	local bminy = plb.y+plb.cy;
	local bmaxx = bminx + plb.cw;
	local bmaxy = bminy + plb.ch;
	return not(aminx > bmaxx or bminx > amaxx or aminy > bmaxy or bminy > amaxy);
end

function check_point(pl, x, y)
	local minx = pl.x+pl.cx;
	if(x<minx or x>=minx+pl.cw) return false;
	local miny = pl.y+pl.cy;
	if(y<miny or y>=miny+pl.ch) return false;
	return true;
end

function cenx(pl)
	if pl.lft then
		return pl.x + 7;
	else
		return pl.x + 8;
	end
end

function ceny(pl)
	return pl.y + 8;
end
-->8
banner=-1;

function _start()
	while(true)do
		banner=-1;
		yield();
		yield();
		banner=192;
		for i=1,30 do yield() end
		banner=196;
		for i=1,30 do yield() end
		banner=-1;
		for i=1,4 do yield() end
		set_state(player1,"grounded");
		set_state(player2,"grounded");
		while(player1.hp>0 and player2.hp>0)do
			yield();
		end

		if	player1.hp <= 0 and player2.hp <= 0 then
			// draw
		elseif player1.hp <= 0 then
			player2.points+=1;
		else
			player1.points+=1;
		end

		banner=200;
		for i=1,50 do yield() end
		banner=-1;
		reset_player(player1);
		reset_player(player2);
	end
end

function reset_player(pl)
	pl.s=64;
	pl.down=false;
	pl.vx=0;
	pl.vy=0;
	pl.anim="idle";
	pl.af=0;
	pl.state="paused";
	pl.st=0;
	pl.stun=false;
	pl.recovery=0;
	pl.attack=nil;
	pl.hit=nil;
	pl.lattack=nill;
	pl.attacked=false;
	pl.hp=100;
	pl.hpind=100;
	if pl.idx==0 then
		pl.x=96;
		pl.y=96;
		pl.lft=true;
	else
		pl.x=16;
		pl.y=96;
		pl.lft=false;
	end
end
-->8
statess={

grounded = function(pl)
	pl.stun=false;
	pl.down=false;
	if pl.recovery>0 then
		set_state(pl,"recovery");
	end
end,

kick = function(pl)
	pl.stun=true;
	pl.down=false;
	set_anim(pl,"kick",true);
	
	local dr=1;
	if (pl.lft) dr=-1;
	local x=cenx(pl);
	local y=ceny(pl);
	local other = player1;
	if pl.idx==0 then other = player2; end
	if not check_point(other, x+dr*8, y) then
		pl.x+=dr*4
	end
	check_walls(pl);
	x=cenx(pl);
	y=ceny(pl);
	pl.attack={
		p={
			x+6*dr,y-2,
			x+6*dr,y-4,
			x+9*dr,y-4,
		},
		dx=5*dr,
		dy=-4,
		dmg=dmgs.kick,
	};
end,

fall = function(pl)
	pl.stun=false;
	pl.down=false;
	set_anim(pl,"fall",false);
end,

jump = function(pl)
	pl.stun=false;
	pl.down=false;
	set_anim(pl,"jump",false);
	pl.vy=-8;
	if pl.inx==0 then pl.vy-=1 end
	pl.vx=pl.inx*3;
end,

predive = function(pl)
	pl.stun=false;
	pl.down=false;
	set_anim(pl,"predive",false);
end,

dive = function(pl)
	pl.stun=false;
	pl.down=true;
	set_anim(pl,"dive",false);
end,

recovery = function(pl)
	pl.stun=true;
	pl.down=false;
	set_anim(pl,"recovery",false);
end,

dash = function(pl)
	pl.stun=false;
	pl.down=false;
	set_anim(pl,"dash",false);
end,

death = function(pl)
	pl.stun=true;
	pl.down=false;
	set_anim(pl,"die",true);
end
}

dmgs={
	kick=10,
	walk=5,
	dive=25,
	dash=15
}
-->8
states={

grounded = function(pl,other,input)
	if false then
	elseif pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	elseif simple_col(pl,other,put) then
	elseif pl.by>0 then
		set_state(pl,"jump");
	elseif pl.by<0 and pl.st>0 then
		set_state(pl,"kick");
	elseif pl.inx==0 then
		set_anim(pl,"idle",false);
		check_walls(pl);
	else
		set_anim(pl,"walk",false);
		pl.lft = pl.inx < 0;
		pl.x+=run_s*pl.inx;
		check_walls(pl);
	end
end,

kick = function(pl,other,input)
	pl.stun=true;
	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	elseif pl.st > 11 then
		set_state(pl,"grounded");
	end
	if simple_col(pl,other,put) then
		pl.hp -= dmgs.walk;
	end
end,

fall = function(pl,other,input)
	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	else
		pl.x += pl.vx;
		pl.y += (pl.vy);
		pl.vy += grav;
		check_walls(pl);
	end
	if pl.y>=96 then
		pl.y=96;
		landing_par(pl);
		set_state(pl,"grounded");
	end
end,

jump = function(pl)
	if pl.vy < 0 then
		set_anim(pl,"jump",false);
	end

	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	else
		pl.x += pl.vx;
		pl.y += (pl.vy);
		pl.vy += grav;
		check_walls(pl);
	end
	if pl.y>=96 then
		pl.y=96;
		landing_par(pl);
		set_state(pl,"grounded");
	elseif pl.y<72 and pl.by<0 then
		set_state(pl,"predive");
	elseif pl.y<76 and pl.bx!=0 then
		local dr = 1;
		pl.lft=pl.bx<0;
		air_bubble(pl, 2, 4);
		set_state(pl, "dash");
	end
end,

predive = function(pl)
	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	elseif pl.st > 4 then
		air_bubble(pl, 2, 4);
		set_state(pl,"dive");
	end
end,

dive = function(pl)
	pl.y += 8;
	local dr=1;
	if pl.lft then dr=-1 end
	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	elseif pl.y>=96 then
		pl.y=96;
		landing_par(pl);
		landing_par(pl, true);
		pl.recovery=24;
		set_state(pl,"grounded");
	elseif pl.attacked then
		just_fall(pl,dr*2,-6);
	else
		local x=cenx(pl);
		local y=ceny(pl);
		pl.attack={
		p={
			x,y+16,
			x-2*dr,y+14,
			x-4*dr,y+12,
			x+2*dr,y+14,
			x+4*dr,y+12,
		},
		dx=5*dr,
		dy=-4,
		dmg=dmgs.dive,
		rec=16
	};
	end
end,

recovery = function(pl)
	pl.recovery-=1;
	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	elseif pl.recovery <=0 then
		pl.recovery=0;
		set_state(pl,"grounded");
	end
end,

dash = function(pl)
	local dr=1;
	if pl.lft then dr=-1 end
	if pl.st>2 then
		pl.x += 4 * dr;
		pl.y += 5;
	end
	local w=check_walls(pl);
	if pl.hit!=nil then
		pl.recovery=pl.hit.rec;
		just_fall(pl,pl.hit.dx,pl.hit.dy);
	elseif pl.y>=96 then
		pl.y=96;
		landing_par(pl, true);
		pl.recovery=24;
		set_state(pl,"grounded");
	elseif w != 0 then
		pl.recovery=24;
		just_fall(pl,w*5,pl.vy);
	elseif pl.attacked then
		just_fall(pl,-dr*2,-6);
	else
		pl.recovery=16;
		local x=cenx(pl);
		local y=ceny(pl);
		pl.attack={
		p={
			x+10*dr,y+12,
			x+12*dr,y+8,
			x+8*dr,y+12,
			x+4*dr,y+12,
		},
		dx=6*dr,
		dy=-2,
		dmg=dmgs.dash,
		rec=24
	};
	end
end,

death = function(pl)

	if pl.st>12 then set_anim(pl,"dead") end
	if pl.y < 96 then
		pl.x += pl.vx;
		pl.y += (pl.vy);
		pl.vy += grav;
		check_walls(pl);
	end
	if pl.y>=96 then
		pl.y=96;
	end
end
}

function simple_col(pl,other,input)
	if rel.overlap then
		local dir = 1;
		if (rel.dx * pl.dd > 0) then dir = -1 end
		if (rel.dx==0) dir=pl.dd;
		pl.x+=(2+abs(rel.dx))*dir;
		if not other.stun then
			pl.y-=2;
			//local dx=2*dir-pl.inx*.8+other.inx*.8;
			local dx=2*dir;
			local dy=-.2;
			just_fall(pl,dx,dy);
		end
		return true;
	end
	return false;
end

function just_fall(pl,dx,dy)
	pl.vx=dx;
	pl.vy=dy;
	pl.lft=dx>0;
	set_state(pl,"fall");
end
__gfx__
00000000999994945555555555555555449494990070000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000994949445555555555555555494999990777000070000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700999994945555555555555555449494997777700070000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000994949445555555555555555494999990777000070000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000999994945555555555555555449494990070000077000000770000007000000000000000000000000000000000000000000000000000000000000000
00700700994949445555555555555555494999990000000077700000777000007000000000000000000000000000000000000000000000000000000000000000
00000000999994944555555555555554449494990000000077770000777700007700000070000000000000000000000000000000000000000000000000000000
00000000994949444455555555555544494999990000000077777700777770007777000077700700000000000000000000000000000000000000000000000000
00000000999994944444444444444444449494990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999949494949494949494949494999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000994994949494949494949494949494990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999494949494949494949494999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999949949494949494949494949999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999999949990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999499494949494949494949999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999999999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999995555555599999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999e0e0e0e00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000009999999999999999999999990e0e0e0e0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999eeeeeeee0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000009999999999999999999999992e2e2e2e0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999121212120000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999999999999999999999999111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000044400000000000000000000000000000004440000000000000000000000000000040000000000000000000000000000000000000000000000000000000
0000044ff00000000000004440000000000004044ff0000000000000444000000000000400000000000000000000000000000000000000000000000000000000
0000044ff00000000000044ff0000000000000044ff00000000440044ff000000040444000000000000044400000000000000000000000000000000000000000
0000044f440000000000044ff000000000004444f4400000000004044ff0000000044ff00400000f00044ff40000000000000000000000000000000000000000
00000444440000000000044f44000000000400444440000000000044f440000000044ff0000000ff00044ff40000000000000000000000000000000000000000
000000f44ff0000000000444440000000000040f44f00000000040444440000000044f4400000ff000044f440000000000000000000000000000000000000000
00000f44440fff00000000f44ff00000000000f4444fff000004000f44ff0000000444440fffff0000044444000f000000000000000000000000000000000000
000000ff4400000000000f44440fff000000f04444000000000000f44440fff000000f4444fff00000400f4444ffff0000000000000000000000000000000000
0000004444000000000000ff44000000000f004444000000000000ff440000000000ffff44ff00000040ffff44ff0ff000000000000000000000000000000000
00000044440000000000004444000000000000444400000000000044440000000000f0444ff000000000f0444ff000f000000000000000000000000000000000
0000004fff0000000000004444000000000004fff00000000000004444000000000000444f000000000000444f00000000000000000000000000000000000000
000000f00f0000000000004fff00000000000f00f0000000000004fff00000000000004ff00000000000004ff000000000000000000000000000000000000000
000000f00f000000000000f00f00000000000f0f0000000000000f00f0000000000000f000000000000000f00000000000000000000000000000000000000000
000000f00f000000000000f00f000000000000f00000000000000f00f0000000000000f000000000000000f00000000000000000000000000000000000000000
000000f00f00000000000f0000f000000000000f000000000000f0000f00000000000f000000000000000f000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000040000404040000040004400000000000004000000000000000000000000000
00000044404000000000000000000000000000000000000000000044000000000004404440000000004000040000000000400404000000000000000000000000
000044ff04040000000004440044000000000000000000000000004f400000000000044f40004000004044400000000000040440000000000000000000000000
000044ff4000000000044ff04400000000000004f00000000000004f400000000000444f4444000000044ff40000000000044ff4000000000000000000000000
00004f440400000000044ff00000000000000004f40000000000044444000000000400444000000000444ff400f0000004004ff4000000000000000000000000
00004440004400000004f4440040000000000044f44000000000044444000000004000444400000004004f4400f0000000444f44000000000000000000000000
000f44ff0000000000044400440000000000004444400000000044f4f04000000000fff4ff40000000f004440f00000000000444fff000000000000000000000
00f44440fff0000000f44ff0000000000000044f4f040000000040f4f00400000fff0044f00fff00000fff444400000000000044440f00000000000000000000
00004444000000000f44440fff0000000000040f4f00400000040ff44f0000000000004440000000000000ff4440000000000fff444000000000000000000000
00004444000000000004444000000000000040fff4f0000000000f444f00000000000044400000000000004444400000000ff044444000000000000000000000
000004fff00000000004444000000000000000f444f000000000f04ff0f000000000004ff0000000000000444fff0000000000444fff00000000000000000000
00000f00f000000000004fff0000000000000f04ff0f0000000000f0f0000000000000fff000000000000004fffff0000000000ffffff0000000000000000000
00000f00f000000000000f00f00000000000000f0f000000000000f0f000000000000000f0000000000000000ffff000000000000ffff0000000000000000000
00000f00f000000000000f00f00000000000000f0f000000000000f0f000000000000000f0000000000000000000ff00000000000000ff000000000000000000
000000f00f000000000000f00f0000000000000f0f000000000000f0f000000000000000f00000000000000000000fff0000000000000fff0000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000044440000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000044ff44000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000044ff44000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000044440000000000044ff44000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000044ff440000000000444444000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000044ff440000000000ff44ff000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000044440000000000044ff44000000000f0f44f0f00000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000044ff440000000000ff44ff000000000f044440f00000000000000000000000000000000000000000000000000000000000000000000
00000044440000000000044ff44000000000f0f44f0f0000000f00444400f0000000000000000000000000000000000000000000000000000000000000000000
00000444444000000000044ff44000000000f044440f0000000f00444400f0000000000000000000000000000000000000000000000000000000000000000000
0000044ff440000000000ff44ff00000000f00444400f000000000ffff0000000000004444000000000000000000000000000000000000000000000000000000
00000ff44ff000000000f0f44f0f0000000000ffff000000000000f00f0000000000044488400000000000000000000000000000000000000000000000000000
000ff0f44f0ff0000000f044440f0000000000f00f000000000000f00f0000000000048ff4400000000000000000000000000000000000000000000000000000
00f0004444000f00000f00f00f00f000000000f00f000000000000f00f00000000088ff84ff88000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000009990000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000009aaa9000000999000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000009a88aa900009aaa900009999000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000009a888a900009a88a9999aaaa999000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000009a888a900009a88a99aa888aaaa900000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000009aa888a9009a888aaa88888888a990000000000000000000000000000000000
0000000000000000000000000000000000000099999000000000000000000000009a888a999aa888aa8888888888a99000000000000000000000000000000000
00000000000000000000000000000000000999aaaaa990000000000000000000009aa88a999a888aa888aaaaa8888a9000000000000000000000000000000000
00999000000000000000000000000000009aaa88888aa90000000000000000000009a888a99a888aa88aaaaaaa888a9000000000000000000000000000000000
09aaa999000000000000000000000000009a888888888a9000000000000000000009a888aaa888aaa88aaaaaaaa88a9000000000000000000000000000000000
9aa88aa9909990000000000000000000099a8888a8888a90000000099999000000009a88aa8888aaa88aaa9aaaa88a9000000000000000000000000000000000
9a8888aa99aaa900000000009000000009a888aaaaa88a900000099aaaaa900000009a88aa888aaa888aa999aaa88a9000000000000000000000000000000000
9a8aa88aaa88a90000000009a900000009a888a9999aaa9000009aa88888a90000009a888888aaaa888aa9999aa88a9000000000000000000000000000000000
9a8aa88a88a88a999900099a8a90000009a88a99999999900099a8888888a90000009a88888aa99a888aa9999aa88a9000000000000000000000000000000000
9a8888aa8aa88aaaaa999aa8a990090099a88a9999999999009a88888a888a900009a8888888aa9a88aaa9999aa88a9000000000000000000000000000000000
9a8a88aa8888aa888a99a888a9999a9099a88a9aaaaaa99999a8888aaa888a900009a88888888a9a88aaa999aaa88a9000000000000000000000000000000000
9a8aa8aa8aaaa88a8a9a888aaaaaa8a999a88a9a88888aaaa9a888a99a888a900009a88aaa888aaa88aaa999aaa88a9000000000000000000000000000000000
9a8aa88a88aaa8aa8a9a8a8aa88a88a999a88a9a88888888aa888aa99a88a900009aa88a99a88aaa888aa999aa888a9000000000000000000000000000000000
99aaa88aa88aa8888a9a8a8aaa888aa999a88aaaa8888888aa88aa99aa88a900009a888a99a888aa8888a99aaa88a90000000000000000000000000000000000
0999aaaa9aa99aa888aa8888aaa8a99999a888aaaaa888aa9a88aa99a888a900009a88aa99a888aaa888aaaaa888a99000000000000000000000000000000000
099999999999999aa8a9aaaa9a88a90009a8888888888a999a88aa99a888a90009a888a9009a88aaaa888aaaa888a99000000000000000000000000000000000
09999990999999999a9999999a8a9900009a888888888a999a888a99a88a990009a888a9009a888a9aa888aaa88aa99900000000000000000000000000000000
0099990099099900099990999a8a99000009aaaaaaaaaa999a8888aa888a90009a888a90009a888a99a88888888aaaa900000000000000000000000000000000
00999000900090000090909999a90900000999999999990099a88888888a90009a888a900099a88aaaaa8888888a88a900000000000000000000000000000000
000990009000900000909099009000900009999909909900099a888888a990009a88a9000099aaaa888aaaaaaaaa88a990000000000000000000000000000000
0009900000009000009000090000009000009990090099000999aaa88a9090009aaa99000099999a888a9999999aaa9990000000000000000000000000000000
0009000000009000009000090000000000009990000009000099999aa9009000999999000099009a88a999000999999990000000000000000000000000000000
0009000000000000009000090000000000009990000009000090009999000000900999000090009aaa9099000090009990000000000000000000000000000000
00000000000000000000000900000000000009000000090000900000990000009009990000900099990009000090009900000000000000000000000000000000
00000000000000000000000000000000000009000000000000900000990000000009990000900090090000000090000900000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000090000000000990000000090000000000000000900000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000090000000000000000000000000000000000000000000000000000000000
__sfx__
010c00000c033000000e033100330c0330000010033100330c033000000e033100330c033000000e0330e0330c033000000e0330e0330c0330000010033100330c0330c0330c0330e0331003311033100330e033
010c00002b2212b2212b2212b2212d2212d2212d2212d2212d0002b0002b0002d0002d0000000000000000002b2002b2002b2002b2002d2002d2002d2002d200242002420024200242002d2002d2002d2002d200
010c00002b2212b2212b2212b2212d2212d2212d2212d221242212422124221242212d2212d2212d2212d2212b2212b2212b2212b221242212422124221242212d2212d221242212422124221242212d2212d221
010c00000c033000000c0331000015033000000c033100000c033000000c0331000015033000000c0330e0000c033000000c0330e00015033000000c033100000c033000000c0330e0330c0330e0330c0330e033
010c00001a2151c2151c2151a2151c21518000180001800018000180001800018000180001800018000180001a2151c2151c2151a2151c2151800018000180001800018000180000000000000000000000000000
010c00001a2151c2151c2151a2151c21518000180001800018000180001800018000180001800018000180001a2151c2151c2151d2151f2151d2151f2151d2151c2151a21518215182151c2151a2151c2151a215
010c00001a215180001800018000180001800018000182151a2151a2151800018000180001800018000182151a2151a2151800018000180001800018000182151a2151f2151f2151f2151f215180001800018000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00001877300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00001a77300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00001c17300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00001d17300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
01 03044344
00 03054344
00 03044344
00 03064344
00 00014344
00 00454344
00 00024344
00 00464344
00 00014344
00 00454344
00 00024344
02 00424344
02 41424344

