pico-8 cartridge // http://www.pico-8.com
version 16
__lua__

-- helpers --
function backout(t,s)
 return sin(t*0.25*s)/sin(0.25*s)
end

function dot(x1,y1,x2,y2)
 return x1*x2+y1*y2
end

function cccolide(c1,c2)
 local dx = c1.x - c2.x
 local dy = c1.y - c2.y
 local dist = sqrt(dx*dx+dy*dy)
 if dist < c1.r+c2.r then
  return true
 else
  return false
 end
end
-- helpsers end --
-- state funcs --
function start_if_any_but()
 if ( btnp(0,0) or btnp(1,0) or btnp(2,0) or btnp(3,0) or btnp(4,0) or btnp(5,0) ) then
  state_fun = nil
  state_update = update_gameplay
  spawn_new_enemy = true
  next_enemy_eta = 3
  any_but_timestamp = time()
 end
end

function update_gameplay()
 move_virus(virus)
 shooting(virus)
 move_bullets()
 move_enemies()
 move_kzones()
 update_holes()
 try_spawn_cell()
 try_spawn_enemy()

 solve_holes_coll()
 solve_enem_coll()
 solve_cells_coll()
 solve_bullets_coll()

 update_score(virus)
end
-- state funcs end --

-- virus --
function make_virus_elem(v)
 local el = {}
 if(v.elems and count(v.elems) > 0) then
  el.x = v.elems[count(v.elems)].x
  el.y = v.elems[count(v.elems)].y
 else
  el.x = v.x
  el.y = v.y
 end
 el.r = v.r
 el.in_hole = false
 add(v.elems,el)
end

function make_virus(id)
 local v = {}
 v.id = id
 v.x = 64
 v.y = 64
 v.px = 64
 v.py = 65
 v.vx = 0
 v.vy = 0
 v.vmax = 2.0
 v.vdash = 6
 v.dash_tleft = -1
 v.moved = false
 v.score = 0
 v.r = 4
 v.edist = 3
 v.hittimestamp = -100
 v.hittime = 1
 v.alive = true
 v.deathtimestamp = -1
 v.in_hole = false
 v.elems = {} 

 for i=1,15 do
  make_virus_elem(v)
 end
 return v
end

function kill_virus(v)
 if not v.alive then
  return
 end

 sfx(10)

 v.alive = false
 v.deathtimestamp = time()
end

function move_virus(v)
 v.moved = false

 if v.alive then
  if btn(0,virus.id) then
   v.vx -= 1
   v.moved = true
  end
  if btn(1,virus.id) then
   v.vx += 1
   v.moved = true
  end
  if btn(2,virus.id) then
   v.vy -= 1
   v.moved = true
  end
  if btn(3,virus.id) then
   v.vy += 1
   v.moved = true
  end
 end

 local vv = sqrt(v.vx*v.vx+v.vy*v.vy)
 local vmax = v.vmax

 v.dash_tleft -= 1/30

 if btn(5,virus.id) then
  if v.dash_tleft < -1 then
   v.dash_tleft = 0.2
  end
 end

 if v.dash_tleft > 0 then
  vmax = v.vdash
 end

 if time() - v.hittimestamp < v.hittime then
  vmax *= 0.6
 end

 if vv > vmax then
  v.vx *= vmax/vv
  v.vy *= vmax/vv
 end

 if not v.moved then
  v.vx *= 0.8
  v.vy *= 0.8
 end

 local nx = v.x + v.vx
 local ny = v.y + v.vy

 if abs(nx-v.x) > 1 or abs(ny-v.y) > 1 then
  v.px = v.x
  v.py = v.y
 end

 v.x = nx
 v.y = ny

 v.x = min(max(v.x,v.r-1),128-v.r)
 v.y = min(max(v.y,v.r-1),128-v.r)

 local tx = v.x
 local ty = v.y

 for e_id=1,count(v.elems) do
  local elem = v.elems[e_id]
  if e_id > 1 then
   tx = v.elems[e_id-1].x
   ty = v.elems[e_id-1].y
  end

  local dx = tx-elem.x
  local dy = ty-elem.y
  local dist = sqrt(dx*dx+dy*dy)
  if dist > v.edist then
   local factor = min(((dist-v.edist)/v.edist)*0.5,0.5)
   elem.x += dx*factor
   elem.y += dy*factor
  end
 end
end

function draw_virus(v)
 fillp(0b0010000000000000)
 local dt = time() - v.hittimestamp
 local hit_pal = false
 if dt < v.hittime then
  if sin(dt*5) < 0 then
   pal(15,2)
   pal(10,5)
   pal(14,1)
   hit_pal = true
  end
 end

 for elem in all(v.elems) do
  if elem.in_hole then
   pal(15,14)
   pal(14,2)
  elseif not hit_pal then
   pal()
  end
  circfill(elem.x,elem.y,v.r,0xef)
 end
 local extra_w = (sin(time()*2)+1)*0.5*2
 if v.in_hole then
  pal(10,8)
  pal(9,2)
 end
 circfill(v.x,v.y,v.r+extra_w,0x9a)
 fillp()
 pal()
end

function update_score(v)
 if not v.alive then
  return
 end
 v.score += #v.elems/100 + 1/30
 if hiscore < v.score then
  hiscore = v.score
  dset(0,hiscore)
 end
end

function draw_score(v)
 local score_text = ""..flr(v.score)
 for x=0,5-#score_text do
  score_text = "0"..score_text
 end

 local hiscore_text = ""..flr(hiscore)
 for x=0,5-#hiscore_text do
  hiscore_text = "0"..hiscore_text
 end

 hiscore_text = "hi:"..hiscore_text

 print(score_text,100+1,10+1,9)
 print(score_text,100,10,7)
 print(hiscore_text,88,4,9)
end

function draw_end_score(v)
 local score_text = ""..flr(v.score)
 for x=0,5-#score_text do
  score_text = "0"..score_text
 end

 score_text = "score:"..score_text

 local hiscore_text = ""..flr(hiscore)
 for x=0,5-#hiscore_text do
  hiscore_text = "0"..hiscore_text
 end

 hiscore_text = "hi:"..hiscore_text

 print(score_text,45+1,60+1,9)
 print(score_text,45,60,7)
 print(hiscore_text,50,53,9)
end

function draw_controls(virus)
 local dcolor = 7

 local dt = 0

 if any_but_timestamp then
  dt = time() - any_but_timestamp
  if dt < 0.2 then
   dcolor=14
  elseif dt < 0.4 then
   dcolor=1
  elseif dt < 0.5 then
   dcolor=2
  else
   draw_interface = draw_score
   return
  end

 end

 local t = sin(time()*1.5)
 local t2 = sin((time()+0.5)*1.5)
 local t3 = sin(time()*0.4)

 sspr(8,0,32,32,1,-10-(4*dt*dt)*64+t3,128,128)

 print("\139",50+t,62,dcolor)
 print("\145",73-t,62,dcolor)
 print("\148",61,52+t,dcolor) 
 print("\131",61,73-t,dcolor)

 print("shoot: z",47,83-t2,dcolor)
 print("dash : x",47,90-t2,dcolor)
 --print("shoot: \142",47,83-t2,dcolor)

end

-- virus end --
-- shooting --
function make_bullet(v)
 local b = {}
 b.health = 2
 b.x = v.x
 b.y = v.y
 b.r = 3

 local dx = v.x-v.px
 local dy = v.y-v.py
 local len = sqrt(dx*dx+dy*dy)

 b.vx = dx/len*4
 b.vy = dy/len*4

 del(v.elems,v.elems[#v.elems])
 sfx(8)

 add(bullets,b)
 return b
end

function dmg_bullet(b,n)
 if n < 0 then
  del(bullets,b)
  return
 end

 b.health -= n
 if b.health <= 0 then
  del(bullets,b)
 end
end

function shooting(v)
 if btnp(4,v.id) and #v.elems > 1 then
  make_bullet(v)
 end
end

function move_bullets()
 for b in all(bullets) do
  b.x += b.vx
  b.y += b.vy

  if b.x < -b.r or b.x > 128+b.r or b.y < -b.r or b.y > 128+b.r then
   dmg_bullet(b,-1)
  end
 end
end

function draw_bullets()
 for b in all(bullets) do
  circfill(b.x,b.y,b.r,10)
 end
end
-- shooting end --
-- enemy --

function get_new_e_pos()
 local angle = rnd(1)
 local sa = sin(angle)
 local ca = cos(angle)

 if sa*sa>ca*ca then
  sa = sgn(sa)
 else
  ca = sgn(ca)
 end

 local x = (sa+1)*0.5*127
 local y = (ca+1)*0.5*127

 return x,y
end

function make_enemy(x,y)
 local e = {}
  next_ex = nil
  next_ey = nil
  spawn_new_enemy = false
  e.r = 8
  e.fspawnpos = {}

  if x == nil or y == nil then
   x,y = get_new_e_pos()
  end

  e.x = x
  e.y = y

  e.fspawnpos.x = x
  e.fspawnpos.y = y

  local dev = 10
  local rnd_angle = rnd(dev*2)-dev
  e.vx = 64-e.x+rnd_angle
  e.vy = 64-e.y+rnd_angle

  e.vmax = 2
  e.vx *= e.vmax
  e.vy *= e.vmax

  e.health = 2

  add(enemies,e)
 return e
end

function kill_enemy(e)
 del(enemies,e)
 next_enemy_eta = 1+rnd(1.5)
 spawn_new_enemy = true
end

function try_spawn_enemy()
 if not spawn_new_enemy then
  return
 end

 if next_ex == nil or next_ey == nil then
  next_ex, next_ey = get_new_e_pos()
 end

 next_enemy_eta -= 1/30
 if next_enemy_eta > 0 then
  if comming_e_pos == nil then
   local cx = 64 - next_ex
   local cy = 64 - next_ey
   local len = sqrt(cx*cx+cy*cy)

   comming_e_pos = {}
   comming_e_pos.x = next_ex + cx/len * 5
   comming_e_pos.y = next_ey + cy/len * 5
  end
 else
  comming_e_pos = nil
  make_enemy(next_ex, next_ey)
 end
end

function move_enemies()
 for e in all(enemies) do
  local tpx = virus.x - e.x
  local tpy = virus.y - e.y
  local len = sqrt(tpx*tpx+tpy*tpy)
  if dot(tpx/len,tpy/len,e.vx/e.vmax,e.vy/e.vmax) > 0.8 then
   e.vx += tpx/len*0.1
   e.vy += tpy/len*0.1
  end

  local l = sqrt(e.vx*e.vx+e.vy*e.vy)
  e.vx *= e.vmax/l
  e.vy *= e.vmax/l

  e.x += e.vx
  e.y += e.vy

  if e.x + e.r < 0 or e.x - e.r > 128 or e.y + e.r < 0 or e.y - e.r > 128 then
   kill_enemy(e)
  else
   local dx = e.x - e.fspawnpos.x
   local dy = e.y - e.fspawnpos.y

   local dist = dx*dx+dy*dy
   if dist > 3*3 then
    local factor = sgn(rnd(2)-1)
    local vx = factor*dy*0.02*rnd(100)/100
    local vy = -factor*dx*0.02*rnd(100)/100
    make_kzone(e.x,e.y,vx,vy)
    e.fspawnpos.x = e.x
    e.fspawnpos.y = e.y
   end
  end
 end
end

function draw_incomming_e()
 if comming_e_pos != nil and next_enemy_eta < 0.5 then
  circfill(comming_e_pos.x, comming_e_pos.y, 5*(sin(time()*4)+1.0)*0.5, 12)
 end
end

function draw_enemies()
 for e in all(enemies) do
  fillp(0b0011011011000110)
  circfill(e.x,e.y,e.r,0xcd)
  fillp()
  circ(e.x,e.y,e.r,0xc)
 end
end
-- enemy end --
-- killing zones --
function make_kzone(x,y,vx,vy)
 local kz = {}
  kz.x = x
  kz.y = y
  kz.vx = vx
  kz.vy = vy
  kz.r = 3+rnd(5)
  kz.org_r = kz.r
  kz.ttd = 5+rnd(2) --time to die
  kz.org_ttd = kz.ttd
  kz.killing = true
  add(kzones,kz)
 return kz
end

function draw_kzones()
 for kz in all(kzones) do
  if kz.killing then
   circfill(kz.x+1, kz.y+1, kz.r,14)
  end
 end

 for kz in all(kzones) do
  if kz.killing then
   circfill(kz.x, kz.y, kz.r,6)
  else
   circfill(kz.x, kz.y, kz.r,14)
  end
 end

 for kz in all(kzones) do
  if kz.killing and kz.r > 4 then
   local f = kz.r / kz.org_r
   circfill(kz.x-2*f, kz.y-2*f, kz.r/2*f,7)
  end
 end
end

function move_kzones()
 for kz in all(kzones) do
  kz.x += kz.vx
  kz.y += kz.vy

  kz.ttd -= 1/30
  if kz.ttd <= 0 then
   del(kzones,kz)
  else
   local f = 1-kz.ttd/kz.org_ttd
   f *= -f*f*f
   f +=1

   kz.r = f * kz.org_r
   if kz.r < 2 then
    kz.killing = false
   end
  end
 end
end

-- killing zones end --
-- collisions --
function solve_enem_coll()
 local hit = false

 local dx
 local dy
 local dist

 for el in all(virus.elems) do
  if not el.in_hole then
   for kz in all(kzones) do
    if cccolide(el,kz) and kz.killing then
     del(virus.elems,el)
     hit = true
    end
   end
  end
 end

 if #virus.elems == 0 then
  kill_virus(virus)
 end

 if not virus.in_hole then
  for en in all(enemies) do
   if cccolide(virus,en) then
    kill_virus(virus)
    hit = true
   end
  end
 end

 if hit then
  virus.hittimestamp = time()
 end
end

function solve_cells_coll()
 for c in all(cells) do
  if cccolide(virus,c) then
   for i=0,3 do
    make_virus_elem(virus)
    sfx(11)
   end
   del(cells,c)
  end
 end
end

function solve_bullets_coll()
 for b in all(bullets) do
  for e in all(enemies) do
   if cccolide(b,e) then
    e.health -= 1
    if e.health <= 0 then
     make_hole(e.x,e.y)
     kill_enemy(e)
     virus.score += 3
     sfx(9)
    end
    dmg_bullet(b,2)
   end
  end
 end

 for b in all(bullets) do
  for k in all(kzones) do
   if cccolide(b,k) then
    del(kzones,k)
    virus.score += 1
    dmg_bullet(b,1)
    sfx(9)
   end
  end
 end
end

function solve_holes_coll()
 virus.in_hole = false
 for h in all(holes) do
  if cccolide(virus,h) then
   virus.in_hole = true
  end
 end

 for e in all(virus.elems) do
  e.in_hole = false
  for h in all(holes) do
   if cccolide(h,e) then
    e.in_hole = true
   end
  end
 end
end
-- collisions end --
-- cells --
function make_cell(new)
 local c = {}
 c.r = 5
 c.make_ts = time()
 if #cells == 0 or new then
  c.x = rnd(128)
  c.y = rnd(128)
 else
  local cid = flr(rnd(#cells))+1
  local angle = rnd(360)/360.0
  c.x = cells[cid].x + sin(angle)*c.r*2
  c.y = cells[cid].y + cos(angle)*c.r*2
 end

 next_cell_eta = 2+rnd(2)
 add(cells,c)
 return c
end

function try_spawn_cell()
 if #cells == 0 then
  make_cell(true)
 end

 next_cell_eta -= 1/30
 if next_cell_eta < 0 then
  if rnd(100) > 50 then
   make_cell(true)
  else
   make_cell(false)
  end
 end

end

function draw_cells()
 fillp(0b0101101001011010)
 for c in all(cells) do
  local f = sin(time()*2)*0.2+0.8
  local dt = time() - c.make_ts
  if dt < 0.5 then
   f = backout(dt/0.5,1.4)
  end
  circfill(c.x,c.y,c.r*f,0x9a)
 end
 fillp()
end

function draw_glitch()
 if time() - virus.hittimestamp < virus.hittime or not virus.alive then
  local repeats = 3
  if not virus.alive then
   repeats = 40
  end
  for i=0,repeats do
   local dest  = flr(rnd(0x1f00)) + 0x6040
   local src = dest + flr(rnd(0x4)-0x2)
   len = flr(rnd(0x80)+0x40)
   memcpy(dest,src,len)
  end
 end
end

function set_pal1()
 pal(8,2,1)
 pal(6,13,1)
 pal(7,6,1)
 pal(15,6,1)
 pal(10,8,1)
 pal(14,2,1)
 pal(12,1,1)
 pal(9,4,1)
end

function set_pal2()
 pal(8,2,1)
 pal(6,13,1)
 pal(7,13,1)
 pal(15,13,1)
 pal(10,2,1)
 pal(14,2,1)
 pal(12,1,1)
 pal(9,2,1)
end

function set_pal3()
 pal(8,2,1)
 pal(6,2,1)
 pal(7,2,1)
 pal(15,2,1)
 pal(10,2,1)
 pal(14,2,1)
 pal(12,2,1)
 pal(9,2,1)
 pal(13,2,1)
 pal(1,2,1)
end

function set_pal4()
 pal(8,0,1)
 pal(6,0,1)
 pal(7,0,1)
 pal(15,0,1)
 pal(10,0,1)
 pal(14,0,1)
 pal(12,0,1)
 pal(9,0,1)
 pal(13,0,1)
 pal(2,0,1)
 pal(1,0,1)
end

function draw_blackin()
 local elapsed = time() - blackin_start;
 if elapsed < 0.1 then
  set_pal4()
 elseif elapsed < 0.15 then
  set_pal3()
 elseif elapsed < 0.2 then
  set_pal2()
 elseif elapsed < 0.25 then
  set_pal1()
 else
  draw_postproc = draw_blackout
  state_fun = start_if_any_but
 end
end

function draw_blackout()
 if not virus.alive then
  local elapsed = time() - virus.deathtimestamp - 0.5;
  if elapsed > 0.1 then
   if elapsed < 0.2 then
    set_pal1()
   elseif elapsed < 0.3 then
    set_pal2()
   elseif elapsed < 0.4 then
    set_pal3()
   else
    set_pal4()
   end

   if elapsed > 1.0 then
    if elapsed < 3.0 then
     pal()
     cls(0)
     draw_end_score(virus)
    else
     internal_init()
     state_update = nil
     draw_postproc = draw_blackin
     blackin_start = time()
    end
   end
  end
 end
end
-- cells end --
-- holes --
function make_hole(x,y)
 local h = {}
 h.x = x
 h.y = y
 h.r = 13
 h.ttd = 5.5
 add(holes,h)
 return h
end

function update_holes()
 for h in all(holes) do
  h.ttd -= 1/30
  if h.ttd < 0 then
   del(holes,h)
  end
 end
end

function draw_holes()
 for h in all(holes) do
  if h.ttd > 2 then
   local f = 0.8 + 0.2 * h.ttd/5
   circfill(h.x-1,h.y-1,(h.r+3)*f,2)
  end
 end

 for h in all(holes) do
  local pcolor = 1
  if h.ttd < 2 then 
   if h.ttd > 1 then
    pcolor = 2
   elseif h.ttd > 0.5 then
    fillp(0b0101101001011010)
    pcolor = 0x28
   else
    fillp(0b0101000001000000)
    pcolor = 0x28
   end
  end

  local f = 0.8 + 0.2 * h.ttd/5
  circfill(h.x,h.y,h.r*f,pcolor)
  fillp()
 end
end
-- holes end --


function _init()
 cartdata(0)
 hiscore = dget(0)
 music(0)

 internal_init()
 state_fun = start_if_any_but
end

function internal_init()
 enemies = {}
 kzones = {}
 cells = {}
 bullets = {}
 holes = {}

 virus = make_virus(0)
 draw_postproc = draw_blackout
 draw_interface = draw_controls

 any_but_timestamp = nil
 comming_e_pos = nil
end

function _update()
 if state_fun then
  state_fun()
 end
 if state_update then
  state_update()
 end
end

function _draw()
 cls(0x28)
 pal()
 draw_holes()
 draw_virus(virus)
 draw_cells()
 draw_kzones()
 draw_incomming_e()
 draw_enemies()
 draw_bullets()
 draw_interface(virus)
 draw_glitch()
 draw_postproc()
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700000777007700007700700070077700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000f999ff99f00f99ff9f0f9ff999f0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000007977979797797977977797977770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000f4ffff444ff4ff9f4fff4f44ff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000f222ff2ff2f2ff2f2fff2fff2ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000f11fff11f1f11f1f11ff1f1ff1f0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000f1111f1111f1111f111f1f111ff0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000ffff0fffffffff0fff0f0ffff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
010f0010050530003307005306150900505005054330443305053000530700530615050050900505005057000e403104030570005700047000340004700037000370003700037000370003700013000000000000
0104000218010245250000018000245051800024505180002450501c0301c0301c0301c0301c0301c0301c0324505000000000000000000000000000000000000000000000000000000000000000000000000000
01040004184551a4451c4551d4551a4051d401004001d4051d40524405244051d4051d4051d4051d4051c40500400004000040000400004000040000400004000040000400004000040000400004000040000400
0118002018a551aa5518a551aa5518a551aa5518a551aa5518a551aa5518a551aa5518a551aa5518a551aa5510a5513a5510a5513a5510a5513a5510a5513a5511a5513a5511a5513a5511a5513a5511a5513a55
010f0010004550040500455304050c455004050040500455004050045500405004550c4550b4050b4550b40500405004050040500405004050040500405004050040500405004050040500405004050000000000
010f00081c3231d3251d3211d3151d3121d3151d3151d315003050030500305003050030500305003050030500305003050030500305003050030500305003050030500305003050030500305003050030500305
0178000018d5018d5018d5018d5218d5018d5218d500cd5213d5013d5213d5013d521fd5613d5213d5624d5200d5000d5200d5000d521fd5600d521fd5600d5213d5013d5213d5013d521fd5613d521fd5624d52
010f002018955189550c9051090518900189001890018900189551895500000000000000000000000000000024955249550000000000000000000000000000001895518955000000000000000000000000000000
010800001813300133181031810300103001030010300103001030010300103001030010300103001030010300103001030010300103001030010300103001030010300103001030010300103001030010300103
010f00000c6530c613000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010800001865000730186400072018630007101862000610186121861200612006120061200612000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010800003015013131301121811230115301040010500100001000010000100001000010000100001000010000100001000010000100001000010000100001000010000100001000010000100001000010000100
__music__
02 04060507
00 41014344

