#ifndef f_VD2_DITA_ACCEL_H
#define f_VD2_DITA_ACCEL_H

#include <vd2/system/vdstl.h>

class VDRegistryKey;

struct VDUIAccelerator {
	enum {
		kModCtrl		= 0x01,
		kModShift		= 0x02,
		kModAlt			= 0x04,
		kModExtended	= 0x08
	};

	uint32		mVirtKey;
	uint32		mModifiers;
};

struct VDAccelToCommandEntry {
	uint32 mId;
	const char *mpName;
};

struct VDAccelTableEntry {
	const char *mpCommand;
	uint32 mCommandId;
	VDUIAccelerator mAccel;
};

class VDAccelTableDefinition {
public:
	VDAccelTableDefinition();
	VDAccelTableDefinition(const VDAccelTableDefinition&);
	~VDAccelTableDefinition();

	VDAccelTableDefinition& operator=(const VDAccelTableDefinition&);

	uint32 GetSize() const;

	const VDAccelTableEntry& operator[](uint32 index) const;

	void Clear();
	void Add(const VDAccelTableEntry& ent);
	void RemoveAt(uint32 index);

	void Swap(VDAccelTableDefinition& dst);

	void VDAccelTableDefinition::Save(VDRegistryKey& key) const;
	void VDAccelTableDefinition::Load(VDRegistryKey& key, const VDAccelToCommandEntry *pCommands, uint32 nCommands);

public:
	typedef vdfastvector<VDAccelTableEntry> Accelerators;
	Accelerators	mAccelerators;
};

inline bool operator==(const VDUIAccelerator& x, const VDUIAccelerator& y) {
	return x.mVirtKey == y.mVirtKey && x.mModifiers == y.mModifiers;
}

void VDUIGetAcceleratorString(const VDUIAccelerator& accel, VDStringW& s);

#endif
