//	Asuka - VirtualDub Build/Post-Mortem Utility
//	Copyright (C) 2005-2007 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma warning(disable: 4786)		// SHUT UP

#include "stdafx.h"
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>

#include <vd2/system/vdtypes.h>
#include <vd2/system/vdstl.h>
#include <vd2/system/error.h>

#include <vector>
#include <algorithm>

#include "utils.h"

using namespace std;

void tool_verinc(bool amd64);
void tool_lookup(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches, bool amd64);
void tool_mapconv(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches, bool amd64);
void tool_fxc(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches, bool amd64);
void tool_makearray(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches);
void tool_glc(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches);
void tool_fontextract(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches);
void tool_snapsetup();
void tool_filecreate(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches);
void tool_maketables(const vdfastvector<const char *>& args, const vdfastvector<const char *>& switches);

int main(int argc, char **argv) {
	--argc;
	++argv;

	vdfastvector<const char *> switches, args;
	bool amd64 = false;

	while(const char *s = *argv++) {
		if (s[0] == '/') {
			if (!_stricmp(s+1, "amd64"))
				amd64 = true;
			else
				switches.push_back(s+1);
		} else {
			args.push_back(s);
		}
	}

	// look for mode
	if (args.empty())
		help();

	const char *s = args[0];

	args.erase(args.begin());

	try {
		if (!_stricmp(s, "verinc")) {
			read_version();
			tool_verinc(amd64);
		} else if (!_stricmp(s, "lookup"))
			tool_lookup(args, switches, amd64);
		else if (!_stricmp(s, "mapconv")) {
			read_version();
			tool_mapconv(args, switches, amd64);
		} else if (!_stricmp(s, "fxc")) {
			tool_fxc(args, switches, amd64);
		} else if (!_stricmp(s, "makearray")) {
			tool_makearray(args, switches);
		} else if (!_stricmp(s, "glc")) {
			tool_glc(args, switches);
		} else if (!_stricmp(s, "fontextract")) {
			tool_fontextract(args, switches);
		} else if (!_stricmp(s, "snapsetup")) {
			tool_snapsetup();
		} else if (!_stricmp(s, "filecreate")) {
			tool_filecreate(args, switches);
		} else if (!_stricmp(s, "maketables")) {
			tool_maketables(args, switches);
		} else
			help();
	} catch(const char *s) {
		fail("%s", s);
	} catch(const MyError& e) {
		fail("%s", e.gets());
	}

	return 0;
}
