//	Altirra - Atari 800/800XL emulator
//	Copyright (C) 2008 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_AT_DEBUGGER_H
#define f_AT_DEBUGGER_H

#ifdef _MSC_VER
	#pragma once
#endif

#include <vd2/system/vdstl.h>

struct ATSymbol;
struct ATSourceLineInfo;
class IATDebuggerClient;

struct ATDebuggerSystemState {
	uint16	mPC;
	uint8	mA;
	uint8	mX;
	uint8	mY;
	uint8	mP;
	uint8	mS;

	uint32	mPCModuleId;
	uint16	mPCFileId;
	uint16	mPCLine;

	uint16	mFramePC;
};

struct ATCallStackFrame {
	uint16	mPC;
	uint8	mS;
	uint8	mP;
};

class IATDebugger {
public:
	virtual void Break() = 0;
	virtual void Run() = 0;
	virtual void ToggleBreakpoint(uint16 addr) = 0;
	virtual void StepInto() = 0;
	virtual void StepOver() = 0;
	virtual void StepOut() = 0;
	virtual void SetPC(uint16 pc) = 0;
	virtual void SetFramePC(uint16 pc) = 0;
	virtual uint32 GetCallStack(ATCallStackFrame *dst, uint32 maxCount) = 0;
	virtual void DumpCallStack() = 0;
	virtual void ListModules() = 0;

	virtual void AddClient(IATDebuggerClient *client, bool requestUpdate = false) = 0;
	virtual void RemoveClient(IATDebuggerClient *client) = 0;

	virtual uint32 LoadSymbols(const wchar_t *fileName) = 0;
	virtual void UnloadSymbols(uint32 moduleId) = 0;
};

class IATDebuggerSymbolLookup {
public:
	virtual bool LookupSymbol(uint32 addr, uint32 flags, ATSymbol& symbol) = 0;
	virtual bool LookupLine(uint32 addr, uint32& moduleId, ATSourceLineInfo& lineInfo) = 0;
	virtual bool LookupFile(const wchar_t *fileName, uint32& moduleId, uint16& fileId) = 0;
	virtual void GetLinesForFile(uint32 moduleId, uint16 fileId, vdfastvector<ATSourceLineInfo>& lines) = 0;
};

class IATDebuggerClient {
public:
	virtual void OnDebuggerSystemStateUpdate(const ATDebuggerSystemState& state) = 0;
};

IATDebugger *ATGetDebugger();
IATDebuggerSymbolLookup *ATGetDebuggerSymbolLookup();

#endif
