#ifndef _MONITOR_H_
#define _MONITOR_H_

#ifdef MONITOR_TRACE
extern int tron;
extern FILE *trace_file;
#endif

/*
 * The following array is used for 6502 instruction profiling
 */
#ifdef MONITOR_PROFILE
extern int instruction_count[256];
#endif

#ifdef MONITOR_BREAK
#define NONE        0
#define OR_BREAK    1

#define FLAG_CLR    0 
#define FLAG_SET    1 
#define NCLR_BREAK  2 
#define NSET_BREAK  3 
#define VCLR_BREAK  4 
#define VSET_BREAK  5 
#define BCLR_BREAK  6 
#define BSET_BREAK  7 
#define DCLR_BREAK  8 
#define DSET_BREAK  9 
#define ICLR_BREAK  10 
#define ISET_BREAK  11 
#define ZCLR_BREAK  12 
#define ZSET_BREAK  13 
#define CCLR_BREAK  14 
#define CSET_BREAK  15 
	
#define BREAK_LESS  1
#define BREAK_EQUAL 2
#define BREAK_GREAT 4

#define PC_BREAK	16
#define A_BREAK		24 
#define X_BREAK		32
#define Y_BREAK		40
#define S_BREAK		48

#define READ_BREAK 64
#define WRITE_BREAK 128

typedef struct break_struct {
	int condition;
	union {
		UWORD addr;
		UBYTE val;
	};
} break_struct;

#define BREAK_TABLE_SIZE 20
extern break_struct break_table[BREAK_TABLE_SIZE];
extern int break_table_pos;

typedef struct break_token {
	char string[7];
	int condition;
} break_token;
extern break_token break_token_table[];

#define REMEMBER_PC_STEPS 128
extern UWORD remember_PC[REMEMBER_PC_STEPS];
extern UBYTE remember_A[REMEMBER_PC_STEPS];
extern UBYTE remember_X[REMEMBER_PC_STEPS];
extern UBYTE remember_Y[REMEMBER_PC_STEPS];
extern UBYTE remember_S[REMEMBER_PC_STEPS];
extern UBYTE remember_P[REMEMBER_PC_STEPS];
extern int remember_PC_curpos;
#ifdef NEW_CYCLE_EXACT
extern int remember_xpos[REMEMBER_PC_STEPS];
#endif

#define REMEMBER_JMP_STEPS 32
extern UWORD remember_JMP[REMEMBER_JMP_STEPS];
extern int remember_jmp_curpos;

extern UWORD ypos_break_addr;
extern UWORD break_addr;
extern UBYTE break_active;
extern UBYTE break_step;
extern UBYTE break_ret;
extern UBYTE break_cim;
extern UBYTE break_here;
extern int break_fired;
extern int ret_nesting;
extern int brkhere;
#endif

int monitor(void);
unsigned int disassemble(UWORD addr1, UWORD addr2);
UWORD show_instruction(FILE *file,UWORD inad, int wid);
extern UBYTE optype6502[];

#endif /* _MONITOR_H_ */
