/****************************************************************************
File    : RomTypeDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CRomTypeDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 30.09.2002
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "RomTypeDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_ROMTYPE_FIRST		IDC_ROMTYPE_CARTRIDGE
#define IDC_ROMTYPE_LAST		IDC_ROMTYPE_CANCEL


/////////////////////////////////////////////////////////////////////////////
// Static objects

static CRomTypeDlg::CartTypeInfo_t s_aCartTypeInfo[] =
{
	{ "Standard 8 KB cartridge",          CART_STD_8,      8,    IDS_CART_STD_8      },
	{ "Standard 16 KB cartridge",         CART_STD_16,     16,   IDS_CART_STD_16     },
	{ "One chip 16 KB 5200 cartridge",    CART_5200_NS_16, 16,   IDS_CART_5200_NS_16 },
	{ "Two chip 16 KB 5200 cartridge",    CART_5200_EE_16, 16,   IDS_CART_5200_EE_16 },
	{ "Standard 32 KB 5200 cartridge",    CART_5200_32,    32,   IDS_CART_5200_32    },
	{ "Bounty Bob 40 KB 5200 cartridge",  CART_5200_40,    40,   IDS_CART_5200_40    },
	{ "DB 32 KB cartridge",               CART_DB_32,      32,   IDS_CART_DB_32      },
	{ "Williams 64 KB cartridge",         CART_WILL_64,    64,   IDS_CART_WILL_64    },
	{ "Express 64 KB cartridge",          CART_EXP_64,     64,   IDS_CART_EXP_64     },
	{ "Diamond 64 KB cartridge",          CART_DIAMOND_64, 64,   IDS_CART_DIAMOND_64 },
	{ "SpartaDOS X 64 KB cartridge",      CART_SDX_64,     64,   IDS_CART_SDX_64     },
	{ "XEGS 32 KB cartridge",             CART_XEGS_32,    32,   IDS_CART_XEGS_32    },
	{ "XEGS 64 KB cartridge",             CART_XEGS_64,    64,   IDS_CART_XEGS_64    },
	{ "XEGS 128 KB cartridge",            CART_XEGS_128,   128,  IDS_CART_XEGS_128   },
	{ "OSS '034M' 16 KB cartridge",       CART_OSS_16,     16,   IDS_CART_OSS_16     },
	{ "OSS 'M091' 16 KB cartridge",       CART_OSS2_16,    16,   IDS_CART_OSS2_16    },
	{ "Atrax 128 KB cartridge",           CART_ATRAX_128,  128,  IDS_CART_ATRAX_128  },
	{ "Bounty Bob 40 KB cartridge",       CART_BBSB_40,    40,   IDS_CART_BBSB_40    },
	{ "Standard 8 KB 5200 cartridge",     CART_5200_8,     8,    IDS_CART_5200_8     },
	{ "Standard 4 KB 5200 cartridge",     CART_5200_4,     4,    IDS_CART_5200_4     },
	{ "Right slot 8 KB cartridge",        CART_RIGHT_8,    8,    IDS_CART_RIGHT_8    },
	{ "Williams 32 KB cartridge",         CART_WILL_32,    32,   IDS_CART_WILL_32    },
	{ "XEGS 256 KB cartridge",            CART_XEGS_256,   256,  IDS_CART_XEGS_256   },
	{ "XEGS 512 KB cartridge",            CART_XEGS_512,   512,  IDS_CART_XEGS_512   },
	{ "XEGS 1 MB cartridge",              CART_XEGS_1024,  1024, IDS_CART_XEGS_1024  },
	{ "MegaCart 16 KB cartridge",         CART_MEGA_16,    16,   IDS_CART_MEGA_16    },
	{ "MegaCart 32 KB cartridge",         CART_MEGA_32,    32,   IDS_CART_MEGA_32    },
	{ "MegaCart 64 KB cartridge",         CART_MEGA_64,    64,   IDS_CART_MEGA_64    },
	{ "MegaCart 128 KB cartridge",        CART_MEGA_128,   128,  IDS_CART_MEGA_128   },
	{ "MegaCart 256 KB cartridge",        CART_MEGA_256,   256,  IDS_CART_MEGA_256   },
	{ "MegaCart 512 KB cartridge",        CART_MEGA_512,   512,  IDS_CART_MEGA_512   },
	{ "MegaCart 1 MB cartridge",          CART_MEGA_1024,  1024, IDS_CART_MEGA_1024  },
	{ "Switchable XEGS 32 KB cartridge",  CART_SWXEGS_32,  32,   IDS_CART_SWXEGS_32  },
	{ "Switchable XEGS 64 KB cartridge",  CART_SWXEGS_64,  64,   IDS_CART_SWXEGS_64  },
	{ "Switchable XEGS 128 KB cartridge", CART_SWXEGS_128, 128,  IDS_CART_SWXEGS_128 },
	{ "Switchable XEGS 256 KB cartridge", CART_SWXEGS_256, 256,  IDS_CART_SWXEGS_256 },
	{ "Switchable XEGS 512 KB cartridge", CART_SWXEGS_512, 512,  IDS_CART_SWXEGS_512 }
};

static const int s_nCartTypeInfoNo = sizeof(s_aCartTypeInfo)/sizeof(s_aCartTypeInfo[0]);


/////////////////////////////////////////////////////////////////////////////
// CRomTypeDlg dialog

BEGIN_MESSAGE_MAP(CRomTypeDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CRomTypeDlg)
	ON_CBN_SELCHANGE(IDC_ROMTYPE_CARTRIDGE, OnSelchangeCartridge)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_ROMTYPE_OK, CCommonDlg::OnOK)
	ON_BN_CLICKED(IDC_ROMTYPE_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CRomTypeDlg::CRomTypeDlg
=========================================================*/
/* #FN#
   Standard constructor */
CRomTypeDlg::
CRomTypeDlg(
	int   nCartSize,
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to the parent window */
)
	: m_nCartSize( nCartSize ), CCommonDlg( CRomTypeDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CRomTypeDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_pCartTypeInfo = s_aCartTypeInfo;
	m_nCartType     = CART_NONE;
	m_nFirstCtrl    = IDC_ROMTYPE_FIRST;
	m_nLastCtrl     = IDC_ROMTYPE_LAST;
} /* #OF# CRomTypeDlg::CRomTypeDlg */

/*========================================================
Method   : CRomTypeDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not used) */
void
/* #AS#
   Nothing */
CRomTypeDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CRomTypeDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CRomTypeDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CRomTypeDlg implementation

/*========================================================
Method   : CRomTypeDlg::CountTypes
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate combo box */
int
/* #AS#
   Number of known cartridge types of a given size */
CRomTypeDlg::
CountTypes(
	int nCartSize
)
{
	int nItems = 0;
	int nIndex = 0;

	ASSERT(CART_LAST_SUPPORTED == s_nCartTypeInfoNo);

	for( int i = 0; i < s_nCartTypeInfoNo; i++ )
	{
		if( m_pCartTypeInfo[ i ].nCartSize == nCartSize &&
			(CART_IsFor5200( m_pCartTypeInfo[ i ].nCartType ) && MACHINE_5200 == machine_type ||
			!CART_IsFor5200( m_pCartTypeInfo[ i ].nCartType ) && MACHINE_5200 != machine_type) )
		{
			nIndex = i;
			nItems++;
		}
	}
	if( 1 == nItems )
		m_nCartType = m_pCartTypeInfo[ nIndex ].nCartType;

	return nItems;
} /* #OF# CRomTypeDlg::CountTypes */

/*========================================================
Method   : CRomTypeDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CRomTypeDlg::
SetDlgState()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_ROMTYPE_CARTRIDGE );
	ASSERT(NULL != pCombo);

	if( !m_bStateInit )
	{
		int nIndex = 0;
		ASSERT(CART_LAST_SUPPORTED == s_nCartTypeInfoNo);

		pCombo->ResetContent();
		for( int i = 0; i < s_nCartTypeInfoNo; i++ )
		{
			if( m_pCartTypeInfo[ i ].nCartSize == m_nCartSize &&
				(CART_IsFor5200( m_pCartTypeInfo[ i ].nCartType ) && MACHINE_5200 == machine_type ||
				!CART_IsFor5200( m_pCartTypeInfo[ i ].nCartType ) && MACHINE_5200 != machine_type) )
			{
				nIndex = pCombo->AddString( m_pCartTypeInfo[ i ].pszCartName );
				pCombo->SetItemData( nIndex, m_pCartTypeInfo[ i ].nCartType );
			}
		}
		pCombo->SetCurSel( 0 );
	}
	/* Set cartridge description */
	for( int i = 0; i < s_nCartTypeInfoNo; i++ )
		if( m_pCartTypeInfo[ i ].nCartType == m_nCartType )
		{
			CWnd *pStatic = GetDlgItem( IDC_ROMTYPE_DESCRIPTION );
			ASSERT(NULL != pStatic);
			char szCartDesc[ 1024 ];

			pStatic->SetWindowText( LoadStringEx( m_pCartTypeInfo[ i ].nCartDesc, szCartDesc, 1024 ) );
			break;
		}
	m_bStateInit = TRUE;
} /* #OF# CRomTypeDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CRomTypeDlg message handlers

/*========================================================
Method   : CRomTypeDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CRomTypeDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	SetDlgState();
	OnSelchangeCartridge();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CRomTypeDlg::OnInitDialog */

/*========================================================
Method   : CRomTypeDlg::OnSelchangeCartridge
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate combo box */
void
/* #AS#
   Nothing */
CRomTypeDlg::
OnSelchangeCartridge()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_ROMTYPE_CARTRIDGE );
	int nIndex = 0;

	ASSERT(NULL != pCombo);

	if( CB_ERR == (nIndex = pCombo->GetCurSel()) )
	{
		pCombo->SetCurSel( 0 );
		nIndex = 0;
	}
	m_nCartType = pCombo->GetItemData( nIndex );

	SetDlgState();
} /* #OF# CRomTypeDlg::OnSelchangeCartridge */
