/****************************************************************************
File    : compress.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Compress interface methods and objects prototypes
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 21.08.2002
*/

#ifndef __COMPRESS_H__
#define __COMPRESS_H__

#include "zlib.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define ZL_ERROR_LOAD		1
#define ZL_ERROR_FUNC		2

#define zlib_capable		Compress_IsCapable	/* For use by kernel */

/* Exported methods */

int  Compress_LoadLibrary ( PHANDLE pHandle );
void Compress_FreeLibrary ( void );
int  Compress_IsCapable   ( void );

/* Wrappers for Zlib exports */

int         GZREAD ( gzFile fFile, voidp pBuf, unsigned nLen );
gzFile      GZOPEN ( const char *pszPath, const char *pszMode );
int         GZCLOSE( gzFile fFile );
int         GZWRITE( gzFile fFile, const voidp pBuf, unsigned nLen );
const char *GZERROR( gzFile fFile, int *pErrNum );

#ifdef __cplusplus
}
#endif

#endif /*__COMPRESS_H__*/
