/****************************************************************************
File    : MouseDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CMouseDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 17.03.2002
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "MouseDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_MOUSE_FIRST		IDC_MOUSE_EMULATEDDEVICE
#define IDC_MOUSE_LAST		IDC_MOUSE_CANCEL

#define MAX_MOUSE_SPEED		 99
#define MAX_MIN_POT			228
#define MAX_MAX_POT			228
#define MAX_JOY_INERTIA		 99
#define MAX_PEN_H_OFFSET	 44
#define MAX_PEN_V_OFFSET	 32


/////////////////////////////////////////////////////////////////////////////
// CMouseDlg dialog

BEGIN_MESSAGE_MAP(CMouseDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CMouseDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_PENHORZSPIN, OnDeltaposPenHorzSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_PENHORZOFFSET, OnKillfocusPenHorzOffset)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_PENVERTSPIN, OnDeltaposPenVertSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_PENVERTOFFSET, OnKillfocusPenVertOffset)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_MOUSESPIN, OnDeltaposMouseSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_MOUSESPEED, OnKillfocusMouseSpeed)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_MINSPIN, OnDeltaposMinSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_MINPOT, OnKillfocusMinPot)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_MAXSPIN, OnDeltaposMaxSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_MAXPOT, OnKillfocusMaxPot)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_JOYSPIN, OnDeltaposJoySpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_JOYINERTIA, OnKillfocusJoyInertia)
	ON_CBN_SELCHANGE(IDC_MOUSE_EMULATEDDEVICE, OnSelchangeEmulatedDevice)
	ON_CBN_SELCHANGE(IDC_MOUSE_STICKPORT, OnSelchangeStickPort)
	ON_BN_CLICKED(IDC_MOUSE_MOUSECAPTURE, OnMouseCapture)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_MOUSE_OK, OnOK)
	ON_BN_CLICKED(IDC_MOUSE_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CMouseDlg::CMouseDlg
=========================================================*/
/* #FN#
   Standard constructor */
CMouseDlg::
CMouseDlg(
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to the parent window */
)
	: CCommonDlg( CMouseDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CMouseDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nFirstCtrl = IDC_MOUSE_FIRST;
	m_nLastCtrl  = IDC_MOUSE_LAST;
} /* #OF# CMouseDlg::CMouseDlg */

/*========================================================
Method   : CMouseDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not used) */
void
/* #AS#
   Nothing */
CMouseDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CMouseDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CMouseDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CMouseDlg implementation

/*========================================================
Method   : CMouseDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CMouseDlg::
SetDlgState()
{
	CButton   *pButton = NULL;
	CComboBox *pCombo  = NULL;
	CWnd      *pWnd    = NULL;

	pCombo = (CComboBox *)GetDlgItem( IDC_MOUSE_EMULATEDDEVICE );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nMouseMode );

	/* Enable/Disable appriopriate controls */

	pWnd = GetDlgItem( IDC_MOUSE_MOUSESPEED );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MOUSESPEED_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MOUSESPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MINPOT );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode || MOUSE_TOUCH == m_nMouseMode || MOUSE_KOALA == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MINPOT_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode || MOUSE_TOUCH == m_nMouseMode || MOUSE_KOALA == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MINSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode || MOUSE_TOUCH == m_nMouseMode || MOUSE_KOALA == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MAXPOT );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode || MOUSE_TOUCH == m_nMouseMode || MOUSE_KOALA == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MAXPOT_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode || MOUSE_TOUCH == m_nMouseMode || MOUSE_KOALA == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MAXSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode || MOUSE_TOUCH == m_nMouseMode || MOUSE_KOALA == m_nMouseMode );
	
	pWnd = GetDlgItem( IDC_MOUSE_PENHORZOFFSET );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode || MOUSE_GUN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENHORZOFFSET_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode || MOUSE_GUN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENHORZSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode || MOUSE_GUN == m_nMouseMode );
	
	pWnd = GetDlgItem( IDC_MOUSE_PENVERTOFFSET );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode || MOUSE_GUN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENVERTOFFSET_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode || MOUSE_GUN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENVERTSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode || MOUSE_GUN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_JOYINERTIA );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_JOY == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_JOYINERTIA_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_JOY == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_JOYSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_JOY == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_STICKPORT );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_STICKPORT_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode );

	pCombo = (CComboBox *)GetDlgItem( IDC_MOUSE_STICKPORT );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nMousePort );

	/* Set up check buttons states */
	if( m_ulInputState & IS_CAPTURE_MOUSE )
	{
		pButton = (CButton *)GetDlgItem( IDC_MOUSE_MOUSECAPTURE );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	SetDlgItemInt( IDC_MOUSE_MOUSESPEED,    m_nMouseSpeed, FALSE );
	SetDlgItemInt( IDC_MOUSE_MINPOT,        m_nPotMin,     FALSE );
	SetDlgItemInt( IDC_MOUSE_MAXPOT,        m_nPotMax,     FALSE );
	SetDlgItemInt( IDC_MOUSE_JOYINERTIA,    m_nJoyInertia, FALSE );
	SetDlgItemInt( IDC_MOUSE_PENHORZOFFSET, m_nPenOffsetX, FALSE );
	SetDlgItemInt( IDC_MOUSE_PENVERTOFFSET, m_nPenOffsetY, FALSE );

} /* #OF# CMouseDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CMouseDlg message handlers

/*========================================================
Method   : CMouseDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CMouseDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	m_ulInputState = g_Input.ulState;
	m_nMouseMode   = mouse_mode;
	m_nMousePort   = mouse_port;
	m_nMouseSpeed  = mouse_speed;
	m_nPotMin      = mouse_pot_min;
	m_nPotMax      = mouse_pot_max;
	m_nJoyInertia  = mouse_joy_inertia;
	m_nPenOffsetX  = mouse_pen_ofs_h;
	m_nPenOffsetY  = mouse_pen_ofs_v;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CMouseDlg::OnInitDialog */

/*========================================================
Method   : CMouseDlg::OnMouseCapture
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CMouseDlg::
OnMouseCapture()
{
	_ClickButton( IDC_MOUSE_MOUSECAPTURE, m_ulInputState, IS_CAPTURE_MOUSE );
} /* #OF# CMouseDlg::OnMouseCapture */

/*========================================================
Method   : CMouseDlg::OnDeltaposMouseSpin
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate spin control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposMouseSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	_DeltaposSpin( pNMHDR, IDC_MOUSE_MOUSESPEED, m_nMouseSpeed, 1, MAX_MOUSE_SPEED );
	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposMouseSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusMouseSpeed
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate edit control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusMouseSpeed()
{
	_KillfocusSpin( IDC_MOUSE_MOUSESPEED, m_nMouseSpeed, 1, MAX_MOUSE_SPEED );
} /* #OF# CMouseDlg::OnKillfocusMouseSpeed */

/*========================================================
Method   : CMouseDlg::OnDeltaposJoySpin
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate spin control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposJoySpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	_DeltaposSpin( pNMHDR, IDC_MOUSE_JOYINERTIA, m_nJoyInertia, 1, MAX_JOY_INERTIA );
	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposJoySpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusJoyInertia
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate edit control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusJoyInertia()
{
	_KillfocusSpin( IDC_MOUSE_JOYINERTIA, m_nJoyInertia, 1, MAX_JOY_INERTIA );
} /* #OF# CMouseDlg::OnKillfocusJoyInertia */

/*========================================================
Method   : CMouseDlg::OnDeltaposMinSpin
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate spin control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposMinSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	_DeltaposSpin( pNMHDR, IDC_MOUSE_MINPOT, m_nPotMin, 0, MAX_MIN_POT );
	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposMinSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusMinPot
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate edit control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusMinPot()
{
	_KillfocusSpin( IDC_MOUSE_MINPOT, m_nPotMin, 0, MAX_MIN_POT );
} /* #OF# CMouseDlg::OnKillfocusMinPot */

/*========================================================
Method   : CMouseDlg::OnDeltaposMaxSpin
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate spin control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposMaxSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	_DeltaposSpin( pNMHDR, IDC_MOUSE_MAXPOT, m_nPotMax, 0, MAX_MAX_POT );
	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposMaxSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusMaxPot
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate edit control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusMaxPot()
{
	_KillfocusSpin( IDC_MOUSE_MAXPOT, m_nPotMax, 0, MAX_MAX_POT );
} /* #OF# CMouseDlg::OnKillfocusMaxPot */

/*========================================================
Method   : CMouseDlg::OnDeltaposPenHorzSpin
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate spin control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposPenHorzSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	_DeltaposSpin( pNMHDR, IDC_MOUSE_PENHORZOFFSET, m_nPenOffsetX, 0, MAX_PEN_H_OFFSET );
	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposPenHorzSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusPenHorzOffset
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate edit control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusPenHorzOffset()
{
	_KillfocusSpin( IDC_MOUSE_PENHORZOFFSET, m_nPenOffsetX, 0, MAX_PEN_H_OFFSET );
} /* #OF# CMouseDlg::OnKillfocusPenHorzOffset */

/*========================================================
Method   : CMouseDlg::OnDeltaposPenVertSpin
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate spin control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposPenVertSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	_DeltaposSpin( pNMHDR, IDC_MOUSE_PENVERTOFFSET, m_nPenOffsetY, 0, MAX_PEN_V_OFFSET );
	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposPenVertSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusPenVertOffset
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate edit control */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusPenVertOffset()
{
	_KillfocusSpin( IDC_MOUSE_PENVERTOFFSET, m_nPenOffsetY, 0, MAX_PEN_V_OFFSET );
} /* #OF# CMouseDlg::OnKillfocusPenVertOffset */

/*========================================================
Method   : CMouseDlg::OnSelchangeEmulatedDevice
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate combo box */
void
/* #AS#
   Nothing */
CMouseDlg::
OnSelchangeEmulatedDevice()
{
	CComboBox *pDevice = (CComboBox *)GetDlgItem( IDC_MOUSE_EMULATEDDEVICE );
	ASSERT(pDevice);
	m_nMouseMode = pDevice->GetCurSel();

	SetDlgState();
} /* #OF# CMouseDlg::OnSelchangeEmulatedDevice */

/*========================================================
Method   : CMouseDlg::OnSelchangeStickPort
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate combo box */
void
/* #AS#
   Nothing */
CMouseDlg::
OnSelchangeStickPort()
{
	CComboBox *pPort = (CComboBox *)GetDlgItem( IDC_MOUSE_STICKPORT );
	ASSERT(pPort);
	m_nMousePort = pPort->GetCurSel();
} /* #OF# CMouseDlg::OnSelchangeStickPort */

/*========================================================
Method   : CMouseDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CMouseDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	switch( nCtrlID )
	{
		case IDC_MOUSE_MINPOT:
			OnKillfocusMinPot();
			break;
		case IDC_MOUSE_MAXPOT:
			OnKillfocusMaxPot();
			break;
		case IDC_MOUSE_MOUSESPEED:
			OnKillfocusMouseSpeed();
			break;
		case IDC_MOUSE_JOYINERTIA:
			OnKillfocusJoyInertia();
			break;
		case IDC_MOUSE_PENHORZOFFSET:
			OnKillfocusPenHorzOffset();
			break;
		case IDC_MOUSE_PENVERTOFFSET:
			OnKillfocusPenVertOffset();
			break;
	}
} /* #OF# CMouseDlg::ReceiveFocused */

/*========================================================
Method   : CMouseDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CMouseDlg::
OnOK() 
{
	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_nMouseMode != mouse_mode )
	{
		mouse_mode = m_nMouseMode;
		WriteRegDWORD( NULL, REG_MOUSE_MODE, mouse_mode );

		/* Update main window's indicator */
		UpdateIndicator( ID_INDICATOR_MSE );
	}
	if( m_nMousePort != mouse_port )
	{
		mouse_port = m_nMousePort;
		WriteRegDWORD( NULL, REG_MOUSE_PORT, mouse_port );
	}
	if( m_nMouseSpeed != mouse_speed )
	{
		mouse_speed = m_nMouseSpeed;
		WriteRegDWORD( NULL, REG_MOUSE_SPEED, mouse_speed );
	}
	if( m_nPotMin != mouse_pot_min )
	{
		mouse_pot_min = m_nPotMin;
		WriteRegDWORD( NULL, REG_POT_MIN, mouse_pot_min );
	}
	if( m_nPotMax != mouse_pot_max )
	{
		mouse_pot_max = m_nPotMax;
		WriteRegDWORD( NULL, REG_POT_MAX, mouse_pot_max );
	}
	if( m_nJoyInertia != mouse_joy_inertia )
	{
		mouse_joy_inertia = m_nJoyInertia;
		WriteRegDWORD( NULL, REG_JOY_INERTIA, mouse_joy_inertia );
	}
	if( m_nPenOffsetX != mouse_pen_ofs_h )
	{
		mouse_pen_ofs_h = m_nPenOffsetX;
		WriteRegDWORD( NULL, REG_PEN_XOFFSET, mouse_pen_ofs_h );
	}
	if( m_nPenOffsetY != mouse_pen_ofs_v )
	{
		mouse_pen_ofs_v = m_nPenOffsetY;
		WriteRegDWORD( NULL, REG_PEN_YOFFSET, mouse_pen_ofs_v );
	}

	if( m_ulInputState != g_Input.ulState )
	{
		if( g_Input.ulState & IS_CAPTURE_MOUSE ^
			m_ulInputState & IS_CAPTURE_MOUSE )
		{
			Input_ToggleMouseCapture();

			/* Update main window's indicator */
			UpdateIndicator( ID_INDICATOR_MSE );
		}
		g_Input.ulState = m_ulInputState;
		WriteRegDWORD( NULL, REG_INPUT_STATE, g_Input.ulState );
	}
	CCommonDlg::OnOK();
} /* #OF# CMouseDlg::OnOK */
