/****************************************************************************
File    : JoystickAdvDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CJoystickAdvDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 17.03.2002
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "JoystickAdvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_JOYSTICKADV_FIRST		IDC_JOYSTICKADV_BUTTONSFIRE
#define IDC_JOYSTICKADV_LAST		IDC_JOYSTICKADV_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CJoystickAdvDlg dialog

BEGIN_MESSAGE_MAP(CJoystickAdvDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CJoystickAdvDlg)
	ON_BN_CLICKED(IDC_JOYSTICKADV_BUTTONSFIRE, OnButtonsFire)
	ON_BN_CLICKED(IDC_JOYSTICKADV_RECENTERSTICK, OnRecenterStick)
	ON_BN_CLICKED(IDC_JOYSTICKADV_BLOCKOPPOSITE, OnBlockOpposite)
	ON_BN_CLICKED(IDC_JOYSTICKADV_EXITPAUSE, OnExitPause)
	ON_BN_CLICKED(IDC_JOYSTICKADV_DONTEXCLUDE, OnDontExclude)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_JOYSTICKADV_OK, OnOK)
	ON_BN_CLICKED(IDC_JOYSTICKADV_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CJoystickAdvDlg::CJoystickAdvDlg
=========================================================*/
/* #FN#
   Standard constructor */
CJoystickAdvDlg::
CJoystickAdvDlg(
	ULONG *pInputState,    /* #IN# Pointer to input state flags   */
	int   *pBlockOpposite, /* #IN# Pointer to block opposite flag */
	CWnd  *pParent /*=NULL*/
)
	: CCommonDlg( CJoystickAdvDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CJoystickAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	ASSERT(pInputState);

	m_pInputState    = pInputState;
	m_pBlockOpposite = pBlockOpposite;
	m_nFirstCtrl     = IDC_JOYSTICKADV_FIRST;
	m_nLastCtrl      = IDC_JOYSTICKADV_LAST;
} /* #OF# CJoystickAdvDlg::CJoystickAdvDlg */

/*========================================================
Method   : CJoystickAdvDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not used) */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CJoystickAdvDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CJoystickAdvDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg implementation

/*========================================================
Method   : CJoystickAdvDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
SetDlgState()
{
	CButton	*pButton = NULL;

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICKADV_BUTTONSFIRE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulInputState & IS_JOY_FIRE_ONLY) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICKADV_RECENTERSTICK );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulInputState & IS_JOY_STICK_RELEASE) != 0 );

	if( m_nBlockOpposite )
	{
		pButton = (CButton *)GetDlgItem( IDC_JOYSTICKADV_BLOCKOPPOSITE );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	pButton = (CButton *)GetDlgItem( IDC_JOYSTICKADV_EXITPAUSE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulInputState & IS_JOY_EXIT_PAUSE) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICKADV_DONTEXCLUDE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulInputState & IS_JOY_DONT_EXCLUDE) != 0 );
} /* #OF# CJoystickAdvDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CJoystickAdvDlg message handlers

/*========================================================
Method   : CJoystickAdvDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CJoystickAdvDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	m_ulInputState   = *m_pInputState;
	m_nBlockOpposite = *m_pBlockOpposite;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CJoystickAdvDlg::OnInitDialog */

/*========================================================
Method   : CJoystickAdvDlg::OnRecenterStick
=========================================================*/
/* #FN#
	Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
OnRecenterStick()
{
   _ClickButton( IDC_JOYSTICKADV_RECENTERSTICK, m_ulInputState, IS_JOY_STICK_RELEASE );
} /* #OF# CJoystickAdvDlg::OnRecenterStick */

/*========================================================
Method   : CJoystickAdvDlg::OnButtonsFire
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
OnButtonsFire()
{
	_ClickButton( IDC_JOYSTICKADV_BUTTONSFIRE, m_ulInputState, IS_JOY_FIRE_ONLY );
} /* #OF# CJoystickAdvDlg::OnButtonsFire */

/*========================================================
Method   : CJoystickAdvDlg::OnBlockOpposite
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
OnBlockOpposite()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_JOYSTICKADV_BLOCKOPPOSITE );
	ASSERT(pButton);
	m_nBlockOpposite = pButton->GetCheck();
} /* #OF# CJoystickAdvDlg::OnBlockOpposite */

/*========================================================
Method   : CJoystickAdvDlg::OnExitPause
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
OnExitPause()
{
	_ClickButton( IDC_JOYSTICKADV_EXITPAUSE, m_ulInputState, IS_JOY_EXIT_PAUSE );
} /* #OF# CJoystickAdvDlg::OnExitPause */

/*========================================================
Method   : CJoystickAdvDlg::OnDontExclude
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
OnDontExclude()
{
	_ClickButton( IDC_JOYSTICKADV_DONTEXCLUDE, m_ulInputState, IS_JOY_DONT_EXCLUDE );
} /* #OF# CJoystickAdvDlg::OnDontExclude */

/*========================================================
Method   : CJoystickAdvDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CJoystickAdvDlg::
OnOK()
{
	if( m_ulInputState != *m_pInputState )
		*m_pInputState = m_ulInputState;

	if( m_nBlockOpposite != *m_pBlockOpposite )
		*m_pBlockOpposite = m_nBlockOpposite;

	CCommonDlg::OnOK();
} /* #OF# CJoystickAdvDlg::OnOK */
