/****************************************************************************
File    : GraphicsAdvDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CGraphicsAdvDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 11.03.2002
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "GraphicsAdvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_GRAPHICSADV_FIRST		IDC_GRAPHICSADV_PRIMARY
#define IDC_GRAPHICSADV_LAST		IDC_GRAPHICSADV_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsAdvDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CGraphicsAdvDlg)
	ON_BN_CLICKED(IDC_GRAPHICSADV_PRIMARY, OnPrimary)
	ON_BN_CLICKED(IDC_GRAPHICSADV_WAITVBL, OnWaitVbl)
	ON_BN_CLICKED(IDC_GRAPHICSADV_FLIP, OnFlip)
	ON_BN_CLICKED(IDC_GRAPHICSADV_SYNCBLIT, OnSyncBlit)
	ON_BN_CLICKED(IDC_GRAPHICSADV_SAFEMODE, OnSafeMode)
	ON_CBN_SELCHANGE(IDC_GRAPHICSADV_MEMORYTYPE, OnSelchangeMemoryType)
	ON_CBN_SELCHANGE(IDC_GRAPHICSADV_BLITEFFECTS, OnSelchangeBlitEffects)
	ON_BN_CLICKED(IDC_GRAPHICSADV_OPTIMIZEPRO, OnOptimizePro)
	ON_BN_CLICKED(IDC_GRAPHICSADV_USEMMX, OnUseMMX)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_GRAPHICSADV_OK, OnOK)
	ON_BN_CLICKED(IDC_GRAPHICSADV_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CGraphicsAdvDlg::CGraphicsAdvDlg
=========================================================*/
/* #FN#
   Standard constructor */
CGraphicsAdvDlg::
CGraphicsAdvDlg(
	ULONG *pScreenMode,      /* #IN# Pointer to screen mode flags  */
	int   *pMemoryType,      /* #IN# Pointer to memory type switch */
	CWnd  *pParent /*=NULL*/ /* #IN# Pointer to the parent window  */
)
	: CCommonDlg( CGraphicsAdvDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	ASSERT(pScreenMode && pMemoryType);

	m_pScreenMode = pScreenMode;
	m_pMemoryType = pMemoryType;
	m_nFirstCtrl  = IDC_GRAPHICSADV_FIRST;
	m_nLastCtrl   = IDC_GRAPHICSADV_LAST;
} /* #OF# CGraphicsAdvDlg::CGraphicsAdvDlg */

/*========================================================
Method   : CGraphicsAdvDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not used) */
void
CGraphicsAdvDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CGraphicsAdvDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg implementation

/*========================================================
Method   : CGraphicsAdvDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
SetDlgState()
{
	CComboBox *pCombo  = NULL;
	ULONG      ulIndex = (m_ulScreenMode >> 28) & 0x0f; 

	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDVBL_WAIT) != 0 );
//	pCombo->EnableWindow( !(m_ulScreenMode & SM_OPTN_FLIP_BUFFERS) );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDBLT_WAIT) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SAFEMODE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_SAFE_MODE) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_OPTIMIZEPRO );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_OPTIMIZE_PRO) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_USEMMX );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_MMX) != 0 );
	pButton->EnableWindow( g_Misc.unSystemInfo & SYS_PRC_MMX );

	/* Set the memory type combo */
	pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_MEMORYTYPE );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nMemoryType );

	CheckRadioButton( IDC_GRAPHICSADV_PRIMARY, IDC_GRAPHICSADV_FLIP,
		m_ulScreenMode & SM_OPTN_FLIP_BUFFERS ?
		IDC_GRAPHICSADV_FLIP : IDC_GRAPHICSADV_PRIMARY );
	
	pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_BLITEFFECTS );
	ASSERT(pCombo);
	for( int i = 0; i < BLIT_EFFECTS_NO; i++ )
		if( ulIndex & (1 << i) )
		{
			pCombo->SetCurSel( i + 1 );
			break;
		}
	if( i == BLIT_EFFECTS_NO )
		pCombo->SetCurSel( 0 );
} /* #OF# CGraphicsAdvDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg message handlers

/*========================================================
Method   : CGraphicsAdvDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CGraphicsAdvDlg::
OnInitDialog() 
{
	CCommonDlg::OnInitDialog();

	m_ulScreenMode = *m_pScreenMode;
	m_nMemoryType  = *m_pMemoryType;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CGraphicsAdvDlg::OnInitDialog */

/*========================================================
Method   : CGraphicsAdvDlg::OnPrimary
=========================================================*/
/* #FN#
   Turns off the flipping buffers method */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnPrimary()
{
//	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
//	ASSERT(pButton);
//	pButton->EnableWindow( TRUE );

	m_ulScreenMode &= ~SM_OPTN_FLIP_BUFFERS;
} /* #OF# CGraphicsAdvDlg::OnPrimary */

/*========================================================
Method   : CGraphicsAdvDlg::OnFlip
=========================================================*/
/* #FN#
   Turns on the flipping buffers method */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnFlip()
{
//	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
//	ASSERT(pButton);
//	pButton->EnableWindow( FALSE );

	m_ulScreenMode |= SM_OPTN_FLIP_BUFFERS;
} /* #OF# CGraphicsAdvDlg::OnFlip */

/*========================================================
Method   : CGraphicsAdvDlg::OnWaitVbl
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnWaitVbl()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);

	int nCheckState = pButton->GetCheck();
	if( nCheckState && !(g_Misc.ulDontShow & DONT_SHOW_VBLWAIT_WARN) )
	{
		CWarningDlg dlgWarning;
		dlgWarning.m_nWarningID   = IDS_WARN_VBLWAIT;
		dlgWarning.m_nWarningFlag = DONT_SHOW_VBLWAIT_WARN;
		dlgWarning.m_bCancel      = FALSE;

		dlgWarning.DoModal();
	}
	if( nCheckState )
		m_ulScreenMode |= SM_OPTN_DDVBL_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDVBL_WAIT;
} /* #OF# CGraphicsAdvDlg::OnWaitVbl */

/*========================================================
Method   : CGraphicsAdvDlg::OnSyncBlit
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSyncBlit()
{
	_ClickButton( IDC_GRAPHICSADV_SYNCBLIT, m_ulScreenMode, SM_OPTN_DDBLT_WAIT );
} /* #OF# CGraphicsAdvDlg::OnSyncBlit */

/*========================================================
Method   : CGraphicsAdvDlg::OnSafeMode
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSafeMode()
{
	_ClickButton( IDC_GRAPHICSADV_SAFEMODE, m_ulScreenMode, SM_OPTN_SAFE_MODE );
} /* #OF# CGraphicsAdvDlg::OnSafeMode */

/*========================================================
Method   : CGraphicsAdvDlg::OnOptimizePro
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnOptimizePro()
{
	_ClickButton( IDC_GRAPHICSADV_OPTIMIZEPRO, m_ulScreenMode, SM_OPTN_OPTIMIZE_PRO );
} /* #OF# CGraphicsAdvDlg::OnOptimizePro */

/*========================================================
Method   : CGraphicsAdvDlg::OnUseMMX
=========================================================*/
/* #FN#
   Sets a state of the object regarding to an appropriate check box */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnUseMMX()
{
	_ClickButton( IDC_GRAPHICSADV_USEMMX, m_ulScreenMode, SM_OPTN_USE_MMX );
} /* #OF# CGraphicsAdvDlg::OnUseMMX */

/*========================================================
Method   : CGraphicsAdvDlg::OnSelchangeMemoryType
=========================================================*/
/* #FN#
   Allows choosing system/AGP/video memory for Direct Draw offscreen surfaces */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSelchangeMemoryType()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_MEMORYTYPE );
	ASSERT(pCombo);
	m_nMemoryType = pCombo->GetCurSel();
} /* #OF# CGraphicsAdvDlg::OnSelchangeMemoryType */

/*========================================================
Method   : CGraphicsAdvDlg::OnSelchangeBlitEffects
=========================================================*/
/* #FN#
   Allows choosing a certain graphic FX effects */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSelchangeBlitEffects()
{
	DWORD dwSMFxFlags[ BLIT_EFFECTS_NO ] = {
		SM_DDFX_MIRRORLEFTRIGHT,
		SM_DDFX_MIRRORUPDOWN,
		SM_DDFX_NOTEARING };

	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_BLITEFFECTS );
	ASSERT(pCombo);
	int nSelection = pCombo->GetCurSel();

	if( CB_ERR == nSelection )
		return;

	m_ulScreenMode &= ~SM_DDFX_MASK;
	if( nSelection > 0 )
	{
		m_ulScreenMode |= dwSMFxFlags[ nSelection - 1 ];
	}
} /* #OF# CGraphicsAdvDlg::OnSelchangeBlitEffects */

/*========================================================
Method   : CGraphicsAdvDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnOK()
{
	if( m_ulScreenMode != *m_pScreenMode )
		*m_pScreenMode = m_ulScreenMode;

	if( m_nMemoryType != *m_pMemoryType )
		*m_pMemoryType = m_nMemoryType;

	CCommonDlg::OnOK();
} /* #OF# CGraphicsAdvDlg::OnOK */
