/****************************************************************************
File    : globals.c
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Shared C-core attributes definitions
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 15.12.2001
*/

#include <windows.h>
#include "WinConfig.h"
#include "platform.h"
#include "globals.h"


LPCSTR VERSION_INFO       = "Atari800Win PLus 3.0: ";

LPCSTR DEFAULT_A8S        = "atarisav.a8s";
LPCSTR DEFAULT_A8K        = "None";
LPCSTR DEFAULT_ACT        = "None";
LPCSTR DEFAULT_TAP        = "None";
LPCSTR DEFAULT_OSA        = "None";
LPCSTR DEFAULT_OSB        = "None";
LPCSTR DEFAULT_OXL        = "None";
LPCSTR DEFAULT_O52        = "None";
LPCSTR DEFAULT_BAS        = "None";
LPCSTR DEFAULT_HDD        = ".";

HWND      g_hMainWnd      = NULL;
HWND      g_hViewWnd      = NULL;
HINSTANCE g_hInstance     = NULL;

int       g_nStartX       = DEF_START_X;
int       g_nStartY       = DEF_START_Y;

int       g_nTestVal      = 0;
int       g_nDoubleRate   = DEF_DOUBLE_RATE;
int       g_nSpeedPercent = DEF_SPEED_PERCENT;

ULONG     g_ulAtariState  = ATARI_UNINITIALIZED;

int       g_argc          = 0;
char     *g_argv          [ 32 ];
char      g_szCmdLine     [ 2048 ];

int       g_anRamSize     [] = { DEF_RAMSIZE_OSA, DEF_RAMSIZE_OSB, DEF_RAMSIZE_XLXE };

char      g_szCurrentRom  [ MAX_PATH ];
char      g_szOtherRom    [ MAX_PATH ];
char      g_szTemplateFile[ MAX_PATH ];
char      g_szPaletteFile [ MAX_PATH ];
char      g_szTemplateDesc[ TEMPLATE_DESC_LENGTH ];
char      g_szAutobootFile[ MAX_PATH ];

/* ZLIB starters */
FARPROC	pgzread        = NULL;
FARPROC	pgzopen        = NULL;
FARPROC	pgzclose       = NULL;
FARPROC	pgzwrite       = NULL;
FARPROC	pgzerror       = NULL;

/* WS2_32 starters */
FARPROC	pclosesocket   = NULL;
FARPROC	pioctlsocket   = NULL;
FARPROC	pconnect       = NULL;
FARPROC	phtons         = NULL;
FARPROC	psocket        = NULL;
FARPROC	pgethostbyname = NULL;
FARPROC	pWSAStartup    = NULL;
FARPROC	psend          = NULL;
FARPROC	precv          = NULL;
FARPROC	pinet_ntoa     = NULL;
FARPROC	paccept        = NULL;
FARPROC	plisten        = NULL;
FARPROC	pbind          = NULL;
