/****************************************************************************
File    : rdevice.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# R: device public methods and objects prototypes
@(#) #BY# Daniel Noguerol, Piotr Fusik
@(#) #LM# 04.10.2001
*/

#ifndef __RDEVICE_H__
#define __RDEVICE_H__

#ifdef __cplusplus
extern "C" {
#endif

extern int enable_r_patch;

/* these codes shouldn't collide with other escape codes in atari.h */
enum {
	ESC_RHOPEN = 0xd0,
	ESC_RHCLOS = 0xd1,
	ESC_RHREAD = 0xd2,
	ESC_RHWRIT = 0xd3,
	ESC_RHSTAT = 0xd4,
	ESC_RHSPEC = 0xd5,
	ESC_RHINIT = 0xd6
};

#define R_DEVICE_BEGIN	0xd180
#define R_TABLE_ADDRESS	0xd180
#define R_PATCH_OPEN	0xd190
#define R_PATCH_CLOS	0xd193
#define R_PATCH_READ	0xd196
#define	R_PATCH_WRIT	0xd199
#define R_PATCH_STAT	0xd19c
#define R_PATCH_SPEC	0xd19f
#define R_DEVICE_END	0xd1a1

/* call before Atari800_Frame() */
void RDevice_Frame(void);

/* call before or after Atari800_UpdatePatches */
void RDevice_UpdatePatches(void);

/* call in Atari_Exit() */
void RDevice_Exit();

#ifdef __cplusplus
}
#endif

#endif /*__RDEVICE_H__*/
