/****************************************************************************
File    : globals.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Shared C-core attributes declarations
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 08.03.2002
*/

#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Shared C-core specific const definitions */

#define ATARI_UNINITIALIZED		0x0001	/* Various machine states the Atari can be in */
#define ATARI_RUNNING			0x0002
#define ATARI_PAUSED			0x0004
#define ATARI_NO_FOCUS			0x0008
#define ATARI_LOAD_FAILED		0x0010
#define ATARI_CRASHED			0x0020
#define ATARI_CLOSING			0x0040
#define ATARI_MONITOR			0x0080

#define DEF_START_X				0		/* Default values */
#define DEF_START_Y				0
#define DEF_DOUBLE_RATE			2
#define DEF_SPEED_PERCENT		100

#define DEF_RAMSIZE_OSA			48
#define DEF_RAMSIZE_OSB			48
#define DEF_RAMSIZE_XLXE		64

#define DEF_PRINT_COMMAND		"Notepad %s"
#define PRINT_CMD_LENGTH		256

#define CX_BORDER				2		/* Note: afxData.cxBorder and afxData.cyBorder aren't used anymore */
#define CY_BORDER				2

#define LOADSTRING_SIZE_S		128
#define LOADSTRING_SIZE_M		512
#define LOADSTRING_SIZE_L		1024

#define TEMPLATE_DESC_LENGTH	256

#define ID_INDICATOR_MSG		0
#define ID_INDICATOR_RUN		1
#define ID_INDICATOR_VID		2
#define ID_INDICATOR_SIO		3
#define ID_INDICATOR_MSE		4
#define ID_INDICATOR_JOY		5
#define ID_INDICATOR_AVI		6
#define ID_INDICATOR_WAV		7

/* AtariWin C modules shared objects */

extern LPCSTR VERSION_INFO;

extern LPCSTR DEFAULT_A8S;
extern LPCSTR DEFAULT_A8K;
extern LPCSTR DEFAULT_ACT;
extern LPCSTR DEFAULT_TAP;
extern LPCSTR DEFAULT_OSA;
extern LPCSTR DEFAULT_OSB;
extern LPCSTR DEFAULT_OXL;
extern LPCSTR DEFAULT_O52;
extern LPCSTR DEFAULT_BAS;
extern LPCSTR DEFAULT_HDD;

extern HWND      g_hMainWnd;
extern HWND      g_hViewWnd;
extern HINSTANCE g_hInstance;

extern int       g_nStartX;
extern int       g_nStartY;
extern int       g_nTestVal;
extern int       g_nDoubleRate;
extern int       g_nSpeedPercent;

extern ULONG     g_ulAtariState;

extern int       g_argc;
extern char     *g_argv          [];
extern char      g_szCmdLine     [];

extern int       g_anRamSize     [];

extern char      g_szCurrentRom  [];
extern char      g_szOtherRom    [];
extern char      g_szTemplateFile[];
extern char      g_szTemplateDesc[];
extern char      g_szPaletteFile [];
extern char      g_szAutobootFile[];

/* Procedure starters of dynamically loaded libraries */

extern FARPROC pclosesocket;
extern FARPROC pioctlsocket;
extern FARPROC pconnect;
extern FARPROC phtons;
extern FARPROC psocket;
extern FARPROC pgethostbyname;
extern FARPROC pWSAStartup;
extern FARPROC psend;
extern FARPROC precv;
extern FARPROC pinet_ntoa;
extern FARPROC paccept;
extern FARPROC plisten;
extern FARPROC pbind;

#define _CLOSESOCKET( X )		(int)pclosesocket( X )
#define _IOCTLSOCKET( X, Y, Z )	(int)pioctlsocket( X, Y, Z )
#define _CONNECT( X, Y, Z )		(int)pconnect( X, Y, Z )
#define _HTONS( X )				(u_short)phtons( X )
#define _SOCKET( X, Y, Z )		(SOCKET)psocket( X, Y, Z )
#define _GETHOSTBYNAME( X )		(struct hostent FAR *)pgethostbyname( X )
#define _WSASTARTUP( X, Y )		(int)pWSAStartup( X, Y )
#define _SEND( X, Y, Z, Q )		(int)psend( X, Y, Z, Q )
#define _RECV( X, Y, Z, Q )		(int)precv( X, Y, Z, Q )
#define _INET_NTOA( X )			(char FAR *)pinet_ntoa( X )
#define _ACCEPT( X, Y, Z )		(SOCKET)paccept( X, Y, Z )
#define _LISTEN( X, Y )			(int)plisten( X, Y )
#define _BIND( X, Y, Z )		(int)pbind( X, Y, Z )

extern FARPROC pgzread;
extern FARPROC pgzopen;
extern FARPROC pgzclose;
extern FARPROC pgzwrite;
extern FARPROC pgzerror;

#define GZOPEN( X, Y )			(gzFile)pgzopen( X, Y )
#define GZCLOSE( X )			(int)pgzclose( X )
#define GZREAD( X, Y, Z )		(int)pgzread( X, Y, Z )
#define GZWRITE( X, Y, Z )		(int)pgzwrite( X, Y, Z )
#define GZERROR( X, Y )			(const char *)pgzerror( X, Y )

#ifdef __cplusplus
}
#endif

#endif /*__GLOBALS_H__*/
