/****************************************************************************
File    : RomTypeDlg.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Interface of the CRomTypeDlg class
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 22.08.2001
*/

#ifndef __ROMTYPE_H__
#define __ROMTYPE_H__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


/////////////////////////////////////////////////////////////////////////////
// CRomTypeDlg dialog

class CRomTypeDlg : public CCommonDlg
{
// Type definitions
public:
	struct CartTypeInfo_t
	{
		LPCSTR pszCartName;
		int    nCartType;
		int    nCartSize;
		UINT   nCartDesc;
	};

// Construction
public:
	CRomTypeDlg( int nCartSize, CWnd *pParent = NULL );   // standard constructor

// Interface: operations
public:
	int GetRomType() { return m_nCartType; }
	int CountTypes( int nCartSize );

// Interface: attributes
public:

// Dialog Data
	//{{AFX_DATA(CRomTypeDlg)
	enum { IDD = IDD_ROMTYPE };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation: operations
private:
	void SetDlgState();

// Implementation: overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRomTypeDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

// Implementation: attributes
private:
	int m_nCartSize;
	int m_nCartType;

	CartTypeInfo_t *m_pCartTypeInfo;

// Generated message map functions
protected:
	//{{AFX_MSG(CRomTypeDlg)
	afx_msg void OnSelchangeCartridge();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif //__ROMTYPE_H__
