/****************************************************************************
File    : macros.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Usefull macros
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 14.03.2002
*/

#ifndef __MACROS_H__
#define __MACROS_H__

#include <process.h>

#ifdef __cplusplus
extern "C" {
#endif

/* State of the emulator */

#define ST_DOUBLE_REFRESH \
	(g_Misc.ulState & MS_USE_DOUBLE_REFRESH && \
	 g_Screen.ulState & SM_MODE_WIND && \
	 g_Screen.ulState & SM_WRES_DOUBLE)

#define ST_MENUBAR_HIDDEN \
	(g_Screen.ulState & SM_MODE_FULL && \
	(g_Screen.ulState & (SM_OPTN_FLIP_BUFFERS | SM_ATTR_NO_MENU)))

#define ST_DOUBLE_BUFFERS \
	(g_Screen.ulState & SM_MODE_FULL && \
	 g_Screen.ulState & SM_OPTN_FLIP_BUFFERS)

#define ST_ATARI_STOPPED \
	(g_ulAtariState & (ATARI_UNINITIALIZED | ATARI_CRASHED | ATARI_PAUSED))

#define ST_ATARI_FAILED \
	(g_ulAtariState & (ATARI_UNINITIALIZED | ATARI_CRASHED))

#define ST_MENU_VISIBLE \
	(g_Screen.bLocked || !ST_MENUBAR_HIDDEN || ST_ATARI_STOPPED)

#define ST_MOUSE_HIDDEN \
	(g_Screen.ulState & SM_MODE_FULL && \
	 g_Screen.ulState & SM_OPTN_HIDE_CURSOR || \
	 g_Input.ulState & IS_CAPTURE_MOUSE)

#define ST_CTRLESC_CAPTURED \
	(g_Input.ulState & IS_CAPTURE_CTRLESC || \
	(g_Screen.ulState & SM_MODE_FULL && g_Misc.unSystemInfo & SYS_WIN_9x))

/* Handling of dialog controls */

#define _DeltaposSpin(phdr, ctrl, var, min, max)	\
{													\
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)phdr;		\
	var -= pNMUpDown->iDelta;						\
	if(var < min) var = min;						\
	if(var > max) var = max;						\
	SetDlgItemInt(ctrl, var, FALSE);				\
}

#define _KillfocusSpin(ctrl, var, min, max)			\
{													\
	BOOL bTrans;									\
	int nVar = GetDlgItemInt(ctrl, &bTrans, FALSE);	\
	if(bTrans) {									\
		var = nVar;									\
		if(var < min) var = min;					\
		if(var > max) var = max;					\
	}												\
	if(!bTrans || nVar < min || nVar > max)			\
		SetDlgItemInt(ctrl, var, FALSE);			\
}

#define _ClickButton(ctrl, var, opt)				\
{													\
	CButton *pButton = (CButton*)GetDlgItem(ctrl);	\
	ASSERT(ctrl);									\
	if(pButton->GetCheck())							\
		var |= (opt);								\
	else											\
		var &= ~(opt);								\
}

/* Create thread wrapper */

typedef unsigned (__stdcall *PTHREAD_START)(void *);

#define _CreateThreadEx(psa, cbStack, pfnStartAddr,	\
	pvParam, fdwCreate, pdwThreadID)				\
		((HANDLE) _beginthreadex(					\
			(void *)(psa),							\
			(unsigned)(cbStack),					\
			(PTHREAD_START)(pfnStartAddr),			\
			(void *)(pvParam),						\
			(unsigned)(fdwCreate),					\
			(unsigned *)(pdwThreadID)))

/* Misc helpers */

#define _IsPathAvailable(sz) \
	(BOOL)(*(sz) != '\0' && _stricmp(sz, "None") != 0 )

#define _NullPathToNone(sz) \
	if(*(sz) == '\0') strcpy(sz, "None")

#define _IsKeyPressed(key) \
	(BOOL)(GetAsyncKeyState(key) >> ((sizeof(SHORT) * 8) - 1))

#define _LoadStringSx(nID, sz) \
	LoadStringEx(nID, sz, LOADSTRING_SIZE_S)

#define _LoadStringMx(nID, sz) \
	LoadStringEx(nID, sz, LOADSTRING_SIZE_M)

#define _LoadStringLx(nID, sz) \
	LoadStringEx(nID, sz, LOADSTRING_SIZE_L)

#define _CursorBusy() \
	AfxGetApp()->DoWaitCursor(1)

#define _CursorFree() \
	AfxGetApp()->DoWaitCursor(-1)

#ifdef __cplusplus
}
#endif

#endif /*__MACROS_H__*/
