/****************************************************************************
File    : Helpers.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Global declaration of usefull methods and objects
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 10.03.2002
*/

#ifndef __HELPERS_H__
#define __HELPERS_H__

#ifdef __cplusplus

/*
   C++ specific declarations
*/

/* File management */

#define PF_LOAD_FLAGS	(OFN_EXPLORER | OFN_HIDEREADONLY | OFN_FILEMUSTEXIST)
#define PF_SAVE_FLAGS	(OFN_EXPLORER | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT)

BOOL PickFileName( BOOL bOpenFileDialog, LPSTR pszFileName, LPCSTR pszPrompt, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, LPSTR pszFileName, LPCSTR pszPrompt, UINT nFilterID, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, LPSTR pszFileName, UINT nPromptID, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, LPSTR pszFileName, UINT nPromptID, UINT nFilterID, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, CString &strFileName, LPCSTR pszPrompt, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, CString &strFileName, LPCSTR pszPrompt, UINT nFilterID, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, CString &strFileName, UINT nPromptID, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, CString &strFileName, UINT nPromptID, UINT nFilterID, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );

/* Cartridge management */

BOOL PickCartridge  ( LPSTR pszCurrentCart, CWnd *pParentWnd = NULL );
int  AttachCartridge( LPSTR pszCartridge );

/* Hooks procedures */

UINT CALLBACK FileDialogHookProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );

/* Miscellanous */

void RestartEmulation( BOOL bForceWinInit = TRUE, BOOL bIgnoreParams = TRUE );

extern BOOL g_bLargeFonts;

#endif /*__cplusplus*/

#ifdef __cplusplus
extern "C" {
#endif

/*
   Common declarations
*/

void  UpdateIndicator  ( int nPane );
void  UpdateStatus     ( BOOL bForceShow, int nSpeed, int nPane, BOOL bWinMode );
void  ResetLoopCounter ( BOOL bSetSpeed );
int   SelectCartType   ( int nCartSize );
BOOL  InitialiseMachine( void );
void  ResetCheatServer ();
char* LoadStringEx     ( UINT nStringID, char *pszBuffer, int nBufLen );

#ifdef __cplusplus
}
#endif


#endif /*__HELPERS_H__*/
