/****************************************************************************
File    : Helpers.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Implementation of usefull methods and objects
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 26.06.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "MainFrame.h"
#include "FileSmallDlg.h"


/////////////////////////////////////////////////////////////////////////////
//
//   C++ stuff implementation
//

BOOL g_bLargeFonts = LOWORD(GetDialogBaseUnits()) >= 10;


/////////////////////////////////////////////////////////////////////////////
// File management

LPCSTR  PF_DSK_FILTER =	"Atari disk images (*.atr,*.xfd, etc)|*.atr;*.xfd;*.atr.gz;*.atz;*.xfd.gz;*.xfz;*.dcm|ATR Images only (*.atr,*.atr.gz,*.atz)|*.atr;*.atr.gz;*.atz|XFD Images only (*.xfd,*.xfd.gz,*.xfz)|*.xfd;*.xfd.gz;*.xfz|DCM Images only (*.dcm)|*.dcm|All Files (*.*)|*.*||";
LPCSTR  PF_BIN_FILTER =	"Atari executable files (*.com,*.exe,*.xex)|*.com;*.exe;*.xex|All Files (*.*)|*.*||";
LPCSTR  PF_A8S_FILTER =	"Atari state images (*.a8s)|*.a8s|All Files (*.*)|*.*||";
LPCSTR  PF_A8K_FILTER =	"Atari keyboard templates (*.a8k)|*.a8k|All Files (*.*)|*.*||";
LPCSTR  PF_ACT_FILTER =	"Atari palette files (*.act)|*.act|All Files (*.*)|*.*||";
LPCSTR  PF_PCX_FILTER =	"Atari screenshot files (*.pcx)|*.pcx|All Files (*.*)|*.*||";
LPCSTR  PF_WAV_FILTER =	"Waveform audio data files (*.wav)|*.wav|All Files (*.*)|*.*||";
LPCSTR  PF_CRT_FILTER =	"Atari cartridge images (*.rom,*.bin,*.crt)|*.rom;*.bin;*.crt|ROM Images only (*.rom,*.bin)|*.rom;*.bin|CART Images only (*.crt)|*.crt|All Files (*.*)|*.*||";
LPCSTR  PF_ROM_FILTER =	"ROM Images (*.rom,*.bin)|*.rom;*.bin|All Files (*.*)|*.*||";
LPCSTR  PF_CAR_FILTER =	"CART Images (*.crt)|*.crt|All Files (*.*)|*.*||";
LPCSTR  PF_TXT_FILTER =	"Text files (*.txt)|*.txt|All Files (*.*)|*.*||";
LPCSTR  PF_AVI_FILTER =	"Video files (*.avi)|*.avi|All Files (*.*)|*.*||";
LPCSTR  PF_DCM_FILTER =	"DCM disk images (*.dcm)|*.dcm|All Files (*.*)|*.*||";
LPCSTR  PF_XFD_FILTER =	"XFD disk images (*.xfd)|*.xfd|All Files (*.*)|*.*||";
LPCSTR  PF_ATR_FILTER =	"ATR disk images (*.atr)|*.atr|All Files (*.*)|*.*||";

/*========================================================
Function : PickFileName
=========================================================*/
/* #FN#
   Displays file dialog and ask user for a file name */
BOOL
/* #AS#
   TRUE if the file was picked, otherwise FALSE */
PickFileName(
	BOOL    bOpenFileDialog,		 /* #IN# */
	LPSTR   pszFileName,			 /* #IN/OUT# */
	LPCSTR  pszTitle,				 /* #IN# */
	LPCSTR  pszFilter,				 /* #IN# */
	LPCSTR  pszDefExt,				 /* #IN# */
	DWORD   dwFlags,				 /* #IN# */
	BOOL    bCheckPath  /*=TRUE*/,   /* #IN# */
	LPCSTR  pszNoneFile /*="None"*/, /* #IN# */
	CWnd   *pParentWnd  /*=NULL*/    /* #IN# */
)
{
	char szFilePath[ MAX_PATH ];
	int  nResult = IDOK;

	strncpy( szFilePath, pszFileName, MAX_PATH );
	szFilePath[ MAX_PATH - 1 ] = '\0';

	if( bCheckPath )
	{
		CFileStatus fsStatus;
		int i;

		/* Standard FileDialog wants that */
		do
		{
			/* Remove the ending backslash */
			for( i = strlen( szFilePath ) - 1; i >= 0 && szFilePath[ i ] == '\\'; i-- )
				szFilePath[ i ] = '\0';
			/* We have got a drive here, don't process */
			if( strlen( szFilePath ) == 2 && szFilePath[ 1 ] == ':' )
			{
				strcat( szFilePath, "\\" );
				strcat( szFilePath, pszNoneFile );
				break;
			}
			/* That's the static method, don't panic */
			if( CFile::GetStatus( szFilePath, fsStatus ) )
			{
				if( fsStatus.m_attribute & CFile::directory )
				{
					strcat( szFilePath, "\\" );
					strcat( szFilePath, pszNoneFile );
				}
				break;
			}
			else
			{
				for( i = strlen( szFilePath );
					 i >= 0 && szFilePath[ i ] != '\\'; i-- )
					szFilePath[ i ] = '\0';
			}
		}
		while( i > 0 );
	}
	if( *szFilePath == '\0' )
		strcpy( szFilePath, pszNoneFile );

	/* Open the file dialog */
	if( g_Screen.ulMode & SM_ATTR_SMALL_DLG )
	{
		CFileSmallDlg dlgFileSmall( bOpenFileDialog,
									pszDefExt,
									pszTitle,
									szFilePath,
									FALSE,
									(pParentWnd ? pParentWnd : AfxGetMainWnd()) );

		if( IDOK == (nResult = dlgFileSmall.DoModal()) )
			strncpy( pszFileName, dlgFileSmall.GetPathName(), MAX_PATH );
	}
	else
	{
		if( g_Screen.ulMode & SM_MODE_FULL )
			dwFlags |= OFN_ENABLEHOOK;

		CFileDialog	fdlgFile( bOpenFileDialog,
							  pszDefExt,
							  szFilePath,
							  dwFlags,
							  pszFilter,
							  (pParentWnd ? pParentWnd : AfxGetMainWnd()) );

		fdlgFile.m_ofn.lpstrTitle = pszTitle;
		if( g_Screen.ulMode & SM_MODE_FULL )
			fdlgFile.m_ofn.lpfnHook = FileDialogHookProc;

		if( IDOK == (nResult = fdlgFile.DoModal()) )
			strncpy( pszFileName, fdlgFile.GetPathName(), MAX_PATH );
	}
	return (nResult == IDOK ? TRUE : FALSE);
} /* #OF# PickFileName */

/*========================================================
Function : PickFileName
=========================================================*/
/* #FN#
   Displays file dialog and ask user for a file name */
BOOL
/* #AS#
   TRUE if the file was picked, otherwise FALSE */
PickFileName(
	BOOL     bOpenFileDialog,		  /* #IN# */
	CString &strFileName,			  /* #IN/OUT# */
	LPCSTR   pszTitle,				  /* #IN# */
	LPCSTR   pszFilter,				  /* #IN# */
	LPCSTR   pszDefExt,				  /* #IN# */
	DWORD    dwFlags,				  /* #IN# */
	BOOL     bCheckPath  /*=TRUE*/,   /* #IN# */
	LPCSTR   pszNoneFile /*="None"*/, /* #IN# */
	CWnd    *pParentWnd  /*=NULL*/    /* #IN# */
)
{
	BOOL bResult =
		PickFileName( bOpenFileDialog,
					  strFileName.GetBuffer( MAX_PATH ),
					  pszTitle,
					  pszFilter,
					  pszDefExt,
					  dwFlags,
					  bCheckPath,
					  pszNoneFile,
					  pParentWnd );

	strFileName.ReleaseBuffer();

	return bResult;
} /* #OF# PickFileName */


/////////////////////////////////////////////////////////////////////////////
// Cartridge management

/*========================================================
Function : PickCartridge
=========================================================*/
/* #FN#
   Displays file dialog and ask user for cartridge */
BOOL
/* #AS#
   TRUE if the cartridge was picked, otherwise FALSE */
PickCartridge(
	LPSTR pszCurrentCart,
	CWnd *pParentWnd /*=NULL*/
)
{
	BOOL bResult = FALSE;

	if( PickFileName( TRUE, pszCurrentCart, "Select ROM to use as inserted cart",
					  PF_CRT_FILTER, "rom", PF_LOAD_FLAGS, TRUE, "None", pParentWnd ) &&
		*pszCurrentCart != '\0' )
	{
		bResult = TRUE;
	}
	return bResult;
} /* #OF# PickCartridge */

/*========================================================
Function : AttachCartridge
=========================================================*/
/* #FN#
   Attaches cartridge */
BOOL
/* #AS#
   TRUE if the cartridge was attached, otherwise FALSE */
AttachCartridge(
	LPSTR pszCartridge,
	int   nCartType
)
{
	int nResult = 0;

	if( rom_inserted )
		Remove_ROM();

	if( NO_CART == nCartType )
		nCartType = Misc_FindCartType( pszCartridge, FALSE, TRUE );

	/* strcpy will be called within Insert_ROM functions */
	/* strcpy( g_szCurrentRom, pszCartridge ); */
	cart_type = NO_CART;

	if( NORMAL8_CART == nCartType &&
		(nResult = Insert_8K_ROM( pszCartridge )) )
	{
		cart_type = NORMAL8_CART;
	}
	else
	if( NORMAL16_CART == nCartType &&
		(nResult = Insert_16K_ROM( pszCartridge )) )
	{
		cart_type = NORMAL16_CART;
	}
	else
	if( OSS_SUPERCART == nCartType &&
		(nResult = Insert_OSS_ROM( pszCartridge )) )
	{
		cart_type = OSS_SUPERCART;
	}
	else
	if( AGS32_CART == nCartType &&
		(nResult = Insert_32K_5200ROM( pszCartridge )) )
	{
		cart_type = AGS32_CART;
	}
	else
	if( DB_SUPERCART == nCartType &&
		(nResult = Insert_DB_ROM( pszCartridge )) )
	{
		cart_type = DB_SUPERCART;
	}
	else
	if( CARTRIDGE == nCartType &&
		(nResult = Insert_Cartridge( pszCartridge )) )
	{
		cart_type = CARTRIDGE;
	}
	/* If there was an error... */
	if( !nResult )
	{
		DisplayMessage( NULL, IDS_ERROR_ROM_LOAD, 0, MB_ICONEXCLAMATION | MB_OK, pszCartridge );
		strcpy( g_szCurrentRom, "None" );
	}
	return (BOOL)nResult;
} /* #OF# AttachCartridge */


/////////////////////////////////////////////////////////////////////////////
// Miscellanous

/*========================================================
Function : RestartEmulation
=========================================================*/
/* #FN#
   Restarts the emulator (kernel and Windows stuff) */
void
/* #AS#
   Nothing */
RestartEmulation(
	BOOL bForceWinInit /*=TRUE*/,
	BOOL bIgnoreParams /*=TRUE*/
)
{
	ULONG ulAtariState = g_ulAtariState;

	Clear_Temp_Files();

	/* Reinitialise the kernel */
	main( bIgnoreParams ? 1    : g_argc,
		  bIgnoreParams ? NULL : g_argv );

	if( bForceWinInit ||
		/* Drag&Drop: don't worry about loosing the focus,
		   the emulated Atari won't start in this case */
		g_ulAtariState & ATARI_UNINITIALIZED )
	{
		ASSERT(g_hMainWnd);

		CMainFrame *pMainFrame = (CMainFrame *)AfxGetMainWnd();//::FromHandle( g_hMainWnd );
		ASSERT(pMainFrame);

		RECT rc;
		pMainFrame->GetClientRect( &rc );
		rc.left = rc.right / 2; rc.right = rc.left + 1;
		rc.top = rc.bottom / 2; rc.bottom = rc.top + 1;

		Sound_Clear( TRUE );
		/* Clear the screen content */
		pMainFrame->CleanScreen();

		g_hViewWnd = NULL;
		/* Reinitialise Windows stuff */
		pMainFrame->RedrawWindow( &rc, NULL, RDW_INVALIDATE /*RDW_NOFRAME | RDW_NOERASE | RDW_UPDATENOW*/ );
	}
	else
	{
		g_ulAtariState = ulAtariState;
		/* Restart sound if necessary */
		Sound_Restart();
	}

	/* This avoids some problems with sound reinitialization routines that
	   lead to serious troubles (especially under Windows 2000, e.g. when
	   the user tries to load binary files, change video system or machine
	   type; this "method" doesn't work in fullscreen modes anyway...).

	   This is a temporary solution I hope, the problem must be detected
	   and resolved in more elegant manner.

	   -------------------------------------------------------------------
	   After adding the Sound_Clear before invoking the sound initilisation
	   the problem has been temporary resolved. The sound routines must be
	   revised anyway.
	*/
//	Sleep( 100 );
} /* #OF# RestartEmulation */

/*========================================================
Function : FileDialogHookProc
=========================================================*/
/* #FN#
   Callback function used with the Explorer-style Open and Save As dialog boxes */
UINT CALLBACK
/* #AS#
   If zero, the default dialog box procedure processes the message */
FileDialogHookProc(
	HWND   hDlg,   /* #IN# Handle to child dialog window    */
	UINT   uMsg,   /* #IN# WM_NOTIFY                        */
	WPARAM wParam, /* #IN# Not used                         */
	LPARAM lParam  /* #IN# Message information (LPOFNOTIFY) */
)
{
	LPNMHDR lpNMHDR = (LPNMHDR)lParam;

	if( WM_NOTIFY == uMsg && lpNMHDR && CDN_INITDONE == lpNMHDR->code )
	{
		CWnd *pWnd = pWnd->FromHandle( lpNMHDR->hwndFrom );
		ASSERT(pWnd);

		SetWindowLong( lpNMHDR->hwndFrom, GWL_EXSTYLE, ~WS_EX_CONTEXTHELP & GetWindowLong( lpNMHDR->hwndFrom, GWL_EXSTYLE ) );
		pWnd->CenterWindow();

		return 1;
	}
	return 0;
} /* #OF# FileDialogHookProc */


/////////////////////////////////////////////////////////////////////////////
//
// Common stuff implementation
//

extern "C" { /* Do not decorate the function name, please */

/*========================================================
Function : UpdateIndicator
=========================================================*/
/* #FN#
   Redraws the pointed icon on the status bar */
void
/* #AS#
   Nothing */
UpdateIndicator(
	int nPane
)
{
	CMainFrame *pMainFrame = (CMainFrame *)AfxGetMainWnd();
	ASSERT(pMainFrame);

	/* Update the given indicator */
	pMainFrame->UpdateIndicator( nPane );
}

} //extern "C"
