// WizardStep2.cpp : implementation file
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WizardDlg.h"
#include "RomImagesBase.h"
#include "WizardStep2.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_WIZARD_STEP2_FIRST		IDC_WIZARD_STEP2_OSA
#define IDC_WIZARD_STEP2_LAST		IDC_WIZARD_STEP2_INFO


/////////////////////////////////////////////////////////////////////////////
// CWizardStep2 dialog

CWizardStep2::
CWizardStep2(
	CWnd* pParent /*=NULL*/
)
	: CWizardPage( CWizardStep2::IDD, pParent ),
	  CRomImagesBase()
{
	//{{AFX_DATA_INIT(CWizardStep2)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nFirstCtrl = IDC_WIZARD_STEP2_FIRST;
	m_nLastCtrl  = IDC_WIZARD_STEP2_LAST;
}

void
CWizardStep2::
DoDataExchange(
	CDataExchange *pDX
)
{
	CWizardPage::DoDataExchange( pDX );
	CRomImagesBase::DataExchange( pDX );

	//{{AFX_DATA_MAP(CWizardStep2)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWizardStep2, CWizardPage)
	//{{AFX_MSG_MAP(CWizardStep2)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_OSA, OnOsa)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_OSB, OnOsb)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_XLXE, OnXlxe)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_5200, On5200)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_BASIC, OnBasic)
	ON_EN_KILLFOCUS(IDC_WIZARD_STEP2_EDITOSA, OnKillfocusEditOsa)
	ON_EN_KILLFOCUS(IDC_WIZARD_STEP2_EDITOSB, OnKillfocusEditOsb)
	ON_EN_KILLFOCUS(IDC_WIZARD_STEP2_EDITXLXE, OnKillfocusEditXlxe)
	ON_EN_KILLFOCUS(IDC_WIZARD_STEP2_EDIT5200, OnKillfocusEdit5200)
	ON_EN_KILLFOCUS(IDC_WIZARD_STEP2_EDITBASIC, OnKillfocusEditBasic)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_SEARCH, OnSearch)
	ON_BN_CLICKED(IDC_WIZARD_STEP2_INFO, OnInfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWizardStep2 implementation

/*========================================================
Method   : CWizardStep2::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CWizardStep2::
SetDlgState()
{
	/* Set OS ROM and BASIC path edit windows */
	for( int i = 0; i < ROM_TYPES_NO; i++ )
		SetDlgItemText( m_pRomData[ i ].nCtrlID, m_pRomData[ i ].szNewName );
} /* #OF# CWizardStep2::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CWizardStep2 message handlers

/*========================================================
Method   : CWizardStep2::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CWizardStep2::
OnInitDialog()
{
	CWizardPage::OnInitDialog();
	CRomImagesBase::InitDialog();

	const UINT anCtrls[ ROM_TYPES_NO ] =
	{
		IDC_WIZARD_STEP2_EDITOSA,
		IDC_WIZARD_STEP2_EDITOSB,
		IDC_WIZARD_STEP2_EDITXLXE,
		IDC_WIZARD_STEP2_EDIT5200,
		IDC_WIZARD_STEP2_EDITBASIC
	};

	for( int i = 0; i < ROM_TYPES_NO; i++ )
	{
		/* Set the appropriate controls IDs */
		m_pRomData[ i ].nCtrlID = anCtrls[ i ];
		/* Backup ROM paths */
		strncpy( m_pRomData[ i ].szNewName, m_pRomData[ i ].pszName, MAX_PATH );
	}
	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CWizardStep2::OnInitDialog */

void
CWizardStep2::
OnOsa() 
{
	BrowseRomFile( RTI_OSA );
}

void
CWizardStep2::
OnOsb() 
{
	BrowseRomFile( RTI_OSB );
}

void
CWizardStep2::
OnXlxe() 
{
	BrowseRomFile( RTI_XLE );
}

void
CWizardStep2::
On5200()
{
	BrowseRomFile( RTI_A52 );
}

void
CWizardStep2::
OnBasic() 
{
	BrowseRomFile( RTI_BAS );
}

void
CWizardStep2::
OnKillfocusEditOsa() 
{
	KillfocusEditRom( RTI_OSA );
}

void
CWizardStep2::
OnKillfocusEditOsb()
{
	KillfocusEditRom( RTI_OSB );
}

void
CWizardStep2::
OnKillfocusEditXlxe()
{
	KillfocusEditRom( RTI_XLE );
}

void
CWizardStep2::
OnKillfocusEdit5200()
{
	KillfocusEditRom( RTI_A52 );
}

void
CWizardStep2::
OnKillfocusEditBasic()
{
	KillfocusEditRom( RTI_BAS );
}

void
CWizardStep2::
OnSearch()
{
	if( SearchRomImages() )
		SetDlgState();
}

void
CWizardStep2::
OnInfo()
{
	DisplayRomInfo();
}

void
CWizardStep2::
Commit()
{
	/* Check if OS ROMs were changed */
	for( int i = 0; i < ROM_TYPES_NO; i++ )
	{
		if( m_pRomData[ i ].szNewName == '\0' )
			strcpy( m_pRomData[ i ].szNewName, "None" );
		if( _stricmp( m_pRomData[ i ].pszName, m_pRomData[ i ].szNewName ) != 0 )
		{
			/* If the ROM was changed for an active system */
			if( i == "\0\1\2\2\2\3"[ default_system - 1 ] || i == RTI_BAS )
			{
				int nCFOut;
				if( CheckFile( m_pRomData[ i ].pszName, &nCFOut ) !=
					CheckFile( m_pRomData[ i ].szNewName, &nCFOut ) )
				{
					m_bReboot = TRUE;
				}
			}
			/* The function "strncpy" has given strange effects here */
			strcpy( m_pRomData[ i ].pszName, m_pRomData[ i ].szNewName );

			WriteRegString( NULL, m_pRomData[ i ].pszRegName, m_pRomData[ i ].pszName );
		}
	}
}
