// WizardStep1.cpp : implementation file
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WizardDlg.h"
#include "WizardStep1.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_WIZARD_STEP1_FIRST		IDC_WIZARD_STEP1_SHORTMENU
#define IDC_WIZARD_STEP1_LAST		IDC_WIZARD_STEP1_SHORTDESK


/* Private objects */

static CWizardStep1::ShortInfo_t s_aShortInfo[] =
{
	{ "exe", "Atari800Win PLus 2.8.lnk",      "Atari800Win PLus Emulator" },
	{ "hlp", "Atari800Win PLus 2.8 Help.lnk", "Atari800Win PLus Help"     }
};

const int s_nShortInfoNo = sizeof(s_aShortInfo)/sizeof(s_aShortInfo[0]);


/////////////////////////////////////////////////////////////////////////////
// CWizardStep1 dialog

CWizardStep1::
CWizardStep1(
	CWnd *pParent /*=NULL*/
)
	: CWizardPage( CWizardStep1::IDD, pParent )
{
	//{{AFX_DATA_INIT(CWizardStep1)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nFirstCtrl = IDC_WIZARD_STEP1_FIRST;
	m_nLastCtrl  = IDC_WIZARD_STEP1_LAST;

	m_pShortInfo = s_aShortInfo;
	m_bInitCOM   = FALSE;
	m_bShortMenu = FALSE;
	m_bShortDesk = FALSE;
}

void
CWizardStep1::
DoDataExchange(
	CDataExchange *pDX
)
{
	CWizardPage::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CWizardStep1)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWizardStep1, CWizardPage)
	//{{AFX_MSG_MAP(CWizardStep1)
	ON_BN_CLICKED(IDC_WIZARD_STEP1_SHORTMENU, OnShortMenu)
	ON_BN_CLICKED(IDC_WIZARD_STEP1_SHORTDESK, OnShortDesk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWizardStep2 implementation

/*========================================================
Method   : CWizardStep1::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CWizardStep1::
SetDlgState()
{
	CButton *pButton = NULL;

	pButton = (CButton*)GetDlgItem( IDC_WIZARD_STEP1_SHORTMENU );
	ASSERT(pButton != NULL);
	pButton->SetCheck( m_bShortMenu );

	pButton = (CButton*)GetDlgItem( IDC_WIZARD_STEP1_SHORTDESK );
	ASSERT(pButton != NULL);
	pButton->SetCheck( m_bShortDesk );
} /* #OF# CWizardStep1::SetDlgState */

/*========================================================
Method   : CWizardStep1::CreateLink
=========================================================*/
/* #FN#
   CreateLink - uses the shell's IShellLink and IPersistFile interfaces 
   to create and store a shortcut to the specified object. */
HRESULT
/* #AS#
   The result of calling the member functions of the interfaces. */
CWizardStep1::
CreateLink(
	LPCSTR lpszPathObj,  /* #IN# Address of a buffer containing the path of the object */
	LPCSTR lpszPathLink, /* #IN# Address of a buffer containing the path where the shell link is to be stored */
	LPCSTR lpszDesc      /* #IN# Address of a buffer containing the description of the shell link */
)
{
	HRESULT hResult;
	IShellLink* psl;

	// Get a pointer to the IShellLink interface. 
	hResult = CoCreateInstance( CLSID_ShellLink,
							 NULL, 
							 CLSCTX_INPROC_SERVER,
							 IID_IShellLink,
							 (LPVOID *)&psl );
	if( SUCCEEDED(hResult) )
	{
		IPersistFile *ppf;

		// Set the path to the shortcut target and add the description.
		psl->SetPath( lpszPathObj );
		psl->SetDescription( lpszDesc );

		// Query IShellLink for the IPersistFile interface for saving the
		// shortcut in persistent storage.
		hResult = psl->QueryInterface( IID_IPersistFile, (LPVOID *)&ppf );

		if( SUCCEEDED(hResult) )
		{
			WCHAR wsz[ MAX_PATH ];

			// Ensure that the string is Unicode. 
			MultiByteToWideChar( CP_ACP, 0, lpszPathLink, -1, wsz, MAX_PATH );

			// Save the link by calling IPersistFile::Save.
			hResult = ppf->Save( wsz, TRUE );
			ppf->Release();
		}
		psl->Release();
	}
	return hResult;
} /* #OF# CWizardStep1::CreateLink */

void
CWizardStep1::
GetSpecialFolder(
	int   nFolder,
	LPSTR szSpecialFolder
)
{
    LPITEMIDLIST pidl = NULL;
    LPMALLOC pMalloc = NULL;

    SHGetMalloc( &pMalloc );

	SHGetSpecialFolderLocation( GetSafeHwnd(), nFolder, &pidl );
	SHGetPathFromIDList( pidl, szSpecialFolder );
	if( pidl )
		pMalloc->Free( pidl );

    pMalloc->Release();
}

void
CWizardStep1::
GetMenuFolder(
	LPSTR szMenuPath
)
{
	GetSpecialFolder( CSIDL_PROGRAMS, szMenuPath );
	strcat( szMenuPath, "\\Atari800Win PLus" );
}

void
CWizardStep1::
GetDeskFolder(
	LPSTR szDeskPath
)
{
	GetSpecialFolder( CSIDL_DESKTOP, szDeskPath );
}

BOOL
CWizardStep1::
CreateShortcut(
	ShortInfo_t *pShortInfo,
	LPCSTR pszShortPath
)
{
	char szSource[ MAX_PATH ];
	char szTarget[ MAX_PATH ];
	BOOL bResult = TRUE;

	sprintf( szSource, "%s\\%s.%s", m_szHomeDir, g_szCmdLine, pShortInfo->pszFileExt );
	sprintf( szTarget, "%s\\%s", pszShortPath, pShortInfo->pszShortcut );

	if( FAILED(CreateLink( szSource, szTarget, pShortInfo->pszDesc )) )
		bResult = FALSE;

	return bResult;
}

BOOL
CWizardStep1::
DeleteShortcut(
	ShortInfo_t *pShortInfo,
	LPCSTR pszShortPath
)
{
	char szSource[ MAX_PATH ];
	CFileStatus fsStatus;
	BOOL bResult = TRUE;

	sprintf( szSource, "%s\\%s", pszShortPath, pShortInfo->pszShortcut );
	if( CFile::GetStatus( szSource, fsStatus ) )
	{
		bResult = DeleteFile( szSource );
	}
	return bResult;
}

void
CWizardStep1::
Commit()
{
	char szShortPath[ MAX_PATH ];
	CFileStatus fsStatus;

	GetMenuFolder( szShortPath );
	/* Create shortcuts in the Start Menu */
	if( m_bShortMenu )
	{
		if( CFile::GetStatus( szShortPath, fsStatus ) || CreateDirectory( szShortPath, NULL ) )
			for( int i = 0; i < s_nShortInfoNo; i++ )
			{
				CreateShortcut( &m_pShortInfo[ i ], szShortPath );
			}
	}
	/* Remove shortcuts from the Start Menu */
	else
	{
		if( CFile::GetStatus( szShortPath, fsStatus ) )
			for( int i = 0; i < s_nShortInfoNo; i++ )
			{
				DeleteShortcut( &m_pShortInfo[ i ], szShortPath );
			}
		RemoveDirectory( szShortPath );
	}

	GetDeskFolder( szShortPath );
	/* Create shortcuts at the Desktop */
	if( m_bShortDesk )
	{
		for( int i = 0; i < s_nShortInfoNo; i++ )
			if( strcmp( m_pShortInfo[ i ].pszFileExt, "exe" ) == 0 )
			{
				CreateShortcut( &m_pShortInfo[ i ], szShortPath );
				break;
			}
	}
	/* Remove shortcuts from the Desktop */
	else
	{
		for( int i = 0; i < s_nShortInfoNo; i++ )
			if( strcmp( m_pShortInfo[ i ].pszFileExt, "exe" ) == 0 )
			{
				DeleteShortcut( &m_pShortInfo[ i ], szShortPath );
				break;
			}
	}
}


/////////////////////////////////////////////////////////////////////////////
// CWizardStep1 message handlers

/*========================================================
Method   : CWizardStep1::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CWizardStep1::
OnInitDialog()
{
	CWizardPage::OnInitDialog();

	char szShortPath[ MAX_PATH ];
	CFileStatus fsStatus;

	/* Init the COM library */
	if( !m_bInitCOM )
	{
		CoInitialize( NULL );
		m_bInitCOM = TRUE;
	}
	/* Prepare the shortcuts */
	if( !Misc_GetHomeDirectory( m_szHomeDir ) )
		GetCurrentDirectory( MAX_PATH, m_szHomeDir );

	/* We are satisfied if there is a folder for shortcuts in the Start Menu */
	GetMenuFolder( szShortPath );
	m_bShortMenu = CFile::GetStatus( szShortPath, fsStatus );

	GetDeskFolder( szShortPath );
	for( int i = 0; i < s_nShortInfoNo; i++ )
		if( strcmp( m_pShortInfo[ i ].pszFileExt, "exe" ) == 0 )
		{
			sprintf( szShortPath, "%s\\%s", szShortPath, m_pShortInfo[ i ].pszShortcut );
			m_bShortDesk = CFile::GetStatus( szShortPath, fsStatus );
			break;
		}

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CWizardStep1::OnInitDialog */

void
CWizardStep1::
OnShortMenu()
{
	CButton *pButton = (CButton*)GetDlgItem( IDC_WIZARD_STEP1_SHORTMENU );
	ASSERT(pButton != NULL);
	m_bShortMenu = pButton->GetCheck();
}

void
CWizardStep1::
OnShortDesk()
{
	CButton *pButton = (CButton*)GetDlgItem( IDC_WIZARD_STEP1_SHORTDESK );
	ASSERT(pButton != NULL);
	m_bShortDesk = pButton->GetCheck();
}
