/****************************************************************************
File    : WizardDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CWizardDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 01.07.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WizardDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define IDC_WIZARD_FIRST		IDC_WIZARD_BACK

/* For handling context help request invoked by Shift+F1 there
   is necessary to include all the wizard pages' controls here.
   Unfortunately, the context help request invoked by question-
   pointer is handled in the standard way by the CCommonDlg.
*/
#define IDC_WIZARD_LAST			IDC_WIZARD_STEP3_REMOVEALL /*IDC_WIZARD_CANCEL*/


CWizardPage::
CWizardPage(
	UINT  nIDTemplate,
	CWnd *pParent /*=NULL*/
)
	: CCommonDlg( nIDTemplate, pParent ),
	  m_bReboot( FALSE )
{
	//{{AFX_DATA_INIT(CWizardPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
// CWizardDlg dialog

CWizardDlg::
CWizardDlg(
	CWnd *pParent /*=NULL*/
)
	: CCommonDlg( CWizardDlg::IDD, pParent ),
	  m_nCurrentIndex( -1 ),
	  m_strTitle( "" )
{
	//{{AFX_DATA_INIT(CWizardDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nFirstCtrl = IDC_WIZARD_FIRST;
	m_nLastCtrl  = IDC_WIZARD_LAST;
}


void
CWizardDlg::
DoDataExchange(
	CDataExchange *pDX
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CWizardDlg)
	DDX_Control(pDX, IDC_WIZARD_FRAME, m_wndPanel);
	//}}AFX_DATA_MAP
}

CWizardDlg::
~CWizardDlg()
{
	m_arrPages.RemoveAll();
}

BEGIN_MESSAGE_MAP(CWizardDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CWizardDlg)
	ON_BN_CLICKED(IDC_WIZARD_NEXT, OnNext)
	ON_BN_CLICKED(IDC_WIZARD_BACK, OnBack)
	ON_BN_CLICKED(IDC_WIZARD_FINISH, OnFinish)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_WIZARD_CANCEL, CWizardDlg::OnCancel)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWizardDlg message handlers

BOOL
CWizardDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	if( m_arrPages.GetUpperBound() != -1 )
	{
		CWizardPage *pPage = NULL;
		CRect rc;

		m_wndPanel.GetWindowRect( rc );
		ScreenToClient( rc );

		for( int i = 0; i < m_arrPages.GetUpperBound() + 1; i++ )
		{
			pPage = GetPage( i );
			if( pPage )
			{
				pPage->Create( pPage->GetIDTemplate(), this );
				pPage->SetWindowPos( NULL, rc.left, rc.top, rc.Width(), rc.Height(), SWP_NOZORDER );
			}			
		}
		SetPage( 0 );
		SetWizardState();
	}
	return FALSE;  // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

void
CWizardDlg::
OnCancel()
{
	ClosePages();
	CCommonDlg::OnCancel();
}

void
CWizardDlg::
OnNext() 
{
	if( m_nCurrentIndex < m_arrPages.GetUpperBound() )
		SetPage( m_nCurrentIndex + 1 );

	SetWizardState();
}

void
CWizardDlg::
OnBack()
{
	if( m_nCurrentIndex > 0 )
		SetPage( m_nCurrentIndex - 1 );

	SetWizardState();
}

void
CWizardDlg::
OnFinish() 
{
	CWizardPage *pPage = NULL;
	for( int i = 0; i < m_arrPages.GetUpperBound() + 1; i++ )
	{
		pPage = GetPage( i );
		if( pPage )
			pPage->UpdateData();
	}
	ClosePages();

	CCommonDlg::OnOK();
}

void
CWizardDlg::
SetWizardState()
{
	CButton *pBack   = (CButton *)GetDlgItem( IDC_WIZARD_BACK );
	CButton *pNext   = (CButton *)GetDlgItem( IDC_WIZARD_NEXT );
	CButton *pFinish = (CButton *)GetDlgItem( IDC_WIZARD_FINISH );

	BOOL bFirst = (BOOL)(!m_nCurrentIndex);
	BOOL bLast  = (BOOL)(m_nCurrentIndex == m_arrPages.GetUpperBound());

	ASSERT(pBack && pNext && pFinish);

	pBack->EnableWindow( !bFirst );
	pNext->EnableWindow( !bLast );

	if( bLast )
	{
		SetDefID( IDC_WIZARD_FINISH );
		GotoDlgCtrl( pFinish );
	}
	else
	{
		SetDefID( IDC_WIZARD_NEXT );
		if( bFirst )
			GotoDlgCtrl( pNext );
	}
	/* Set wizard dialog title */
	m_strTitle.Format( IDS_WIZARD_TITLE, m_nCurrentIndex + 1, m_arrPages.GetUpperBound() != -1 ? m_arrPages.GetUpperBound() + 1 : 1 );
	SetWindowText( m_strTitle );
}

void
CWizardDlg::
AddPage(
	CWizardPage *pPage
)
{
	m_arrPages.Add( (void *)pPage );
}

void
CWizardDlg::
SetPage(
	const int nIndex
)
{
	CWizardPage *pPage = NULL;

	if( m_nCurrentIndex >= 0 )
	{
		pPage = GetPage( m_nCurrentIndex );
		if( pPage )
		{
			if( !pPage->UpdateData() )
				return;
			pPage->ShowWindow( SW_HIDE );
		}
	}
	m_nCurrentIndex = nIndex;

	pPage = GetPage( m_nCurrentIndex );
	if( pPage )
		pPage->ShowWindow( SW_SHOW );
}

CWizardPage*
CWizardDlg::
GetPage(
	const int nIndex
)
{
	ASSERT(nIndex <= m_arrPages.GetUpperBound());
	ASSERT(nIndex >= 0);

	return (CWizardPage *)m_arrPages.GetAt( nIndex );
}

void
CWizardDlg::
ClosePages()
{
	CWizardPage *pPage = NULL;
	for( int i = 0; i < m_arrPages.GetUpperBound() + 1; i++ )
	{
		pPage = GetPage( i );
		if( pPage )
			pPage->DestroyWindow();
	}
}

BOOL
CWizardDlg::
Reboot()
{
	BOOL bResult = FALSE;

	CWizardPage *pPage = NULL;
	for( int i = 0; i < m_arrPages.GetUpperBound() + 1; i++ )
	{
		pPage = GetPage( i );
		if( pPage && pPage->GetReboot() )
		{
			bResult = TRUE;
			break;
		}
	}
	return bResult;
}

void
CWizardDlg::
Commit()
{
	CWizardPage *pPage = NULL;
	for( int i = 0; i < m_arrPages.GetUpperBound() + 1; i++ )
	{
		pPage = GetPage( i );
		if( pPage )
			pPage->Commit();
	}
}
