/****************************************************************************
File    : SoundDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CSoundDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 17.09.2000
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "Helpers.h"
#include "SoundDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_SOUND_FIRST		IDC_SOUND_NOSOUND
#define IDC_SOUND_LAST		IDC_SOUND_CANCEL


/////////////////////////////////////////////////////////////////////////////
// Static objects

static int s_anSoundRates[ 7 ] =
{
	8000, 11025, 21280, 22050, 31920, 44100, 48000
};

static int s_anLowLimits[ 7 ] =
{
	6, 4, 2, 2, 2, 1, 1
};


/////////////////////////////////////////////////////////////////////////////
// CSoundDlg dialog

BEGIN_MESSAGE_MAP(CSoundDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CSoundDlg)
	ON_BN_CLICKED(IDC_SOUND_MMSOUND, OnSoundMmsound)
	ON_BN_CLICKED(IDC_SOUND_DIRECTSOUND, OnSoundDirectsound)
	ON_BN_CLICKED(IDC_SOUND_NOSOUND, OnSoundNosound)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SOUND_POKEYSPIN, OnDeltaposPokeyDivisorSpin)
	ON_CBN_SELCHANGE(IDC_SOUND_PLAYBACK, OnSelchangeSoundPlayback)
	ON_BN_CLICKED(IDC_SOUND_VOLUMEONLY, OnSoundVolumeOnly)
	ON_BN_CLICKED(IDC_SOUND_STEREO, OnSoundStereo)
	ON_EN_KILLFOCUS(IDC_SOUND_POKEYDIVISOR, OnKillfocusPokeyDivisor)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_SOUND_OK, OnOK)
	ON_BN_CLICKED(IDC_SOUND_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CSoundDlg::CSoundDlg
=========================================================*/
/* #FN#
   Standard constructor */
CSoundDlg::
CSoundDlg(
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to the parent window */
)
	: CCommonDlg( CSoundDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CSoundDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nFirstCtrl = IDC_SOUND_FIRST;
	m_nLastCtrl  = IDC_SOUND_LAST;
} /* #OF# CSoundDlg::CSoundDlg */

/*========================================================
Method   : CSoundDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CSoundDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CSoundDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CSoundDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CSoundDlg implementation

/*========================================================
Method   : CSoundDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CSoundDlg::
SetDlgState()
{
	CButton     *pButton = NULL;
	CSliderCtrl *pSlider = NULL;
	CComboBox   *pCombo  = NULL;

	pSlider = (CSliderCtrl *)GetDlgItem( IDC_SOUND_VOLUMESLIDER );
	ASSERT(pSlider != NULL);

	pSlider->EnableWindow( Sound_VolumeCapable() );
	pSlider->SetRange( 0, 100, FALSE );
	pSlider->SetTicFreq( 10 );
	pSlider->SetPageSize( 10 );
	pSlider->SetPos( 100 + m_nSoundVol );

	/* Set up Output Type buttons */
	CheckRadioButton( IDC_SOUND_NOSOUND, IDC_SOUND_DIRECTSOUND,
		 m_ulSoundState & SOUND_NOSOUND ? IDC_SOUND_NOSOUND :
		(m_ulSoundState & SOUND_MMSOUND ? IDC_SOUND_MMSOUND : IDC_SOUND_DIRECTSOUND) );

	pButton = (CButton *)GetDlgItem( IDC_SOUND_VOLUMEONLY );
	ASSERT(pButton != NULL);
	pButton->SetCheck( m_bVolumeOnly );
#ifdef NO_VOL_ONLY
	pButton->EnableWindow( FALSE );
#endif

	pButton = (CButton *)GetDlgItem( IDC_SOUND_STEREO );
	ASSERT(pButton != NULL);
	pButton->SetCheck( m_bEnableStereo );
#ifndef STEREO
	pButton->EnableWindow( FALSE );
#endif

#ifndef WIN_USE_DSOUND
	GetDlgItem( IDC_SOUND_DIRECTSOUND )->EnableWindow( FALSE );
#endif

	pCombo = (CComboBox *)GetDlgItem( IDC_SOUND_PLAYBACK );
	ASSERT(pCombo != NULL);

	switch( m_nSoundRate )
	{
		case 8000:
			pCombo->SetCurSel( 0 );
			m_nLowSkipLimit = 6;
			break;

		case 11025:
			pCombo->SetCurSel( 1 );
			m_nLowSkipLimit = 4;
			break;

		case 21280:
			pCombo->SetCurSel( 2 );
			m_nLowSkipLimit = 2;
			break;

		case 22050:
			pCombo->SetCurSel( 3 );
			m_nLowSkipLimit = 2;
			break;

		case 31920:
			pCombo->SetCurSel( 4 );
			m_nLowSkipLimit = 2;
			break;

		case 44100:
			pCombo->SetCurSel( 5 );
			m_nLowSkipLimit = 1;
			break;

		case 48000:
			pCombo->SetCurSel( 6 );
			m_nLowSkipLimit = 1;
			break;

		default:
			pCombo->SetCurSel( 5 );
			m_nSoundRate = 44100;
			m_nLowSkipLimit = 1;
	}
	SetPokeyDivisor();
} /* #OF# CSoundDlg::SetDlgState */

/*========================================================
Method   : CSoundDlg::SetPokeyDivisor
=========================================================*/
/* #FN#
   Sets the proper Pokey update divisor value */
void
/* #AS#
   Nothing */
CSoundDlg::
SetPokeyDivisor()
{
	if( m_nSkipUpdate < m_nLowSkipLimit )
		m_nSkipUpdate = m_nLowSkipLimit;
	if( m_nSkipUpdate > m_nHighSkipLimit )
		m_nSkipUpdate = m_nHighSkipLimit;

	SetDlgItemInt( IDC_SOUND_POKEYDIVISOR, m_nSkipUpdate, FALSE );
} /* #OF# CSoundDlg::SetPokeyDivisor */


/////////////////////////////////////////////////////////////////////////////
// CSoundDlg message handlers

/*========================================================
Method   : CSoundDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CSoundDlg::
OnInitDialog() 
{
	CCommonDlg::OnInitDialog();
	
	m_nLowSkipLimit  = 1;
	m_nHighSkipLimit = (default_tv_mode == 1 ? TV_NTSC : TV_PAL);
	m_ulSoundState   = g_Sound.ulMode;
	m_nSoundRate     = g_Sound.nRate;
	m_nSoundVol      = g_Sound.nVolume;
	m_nSkipUpdate    = g_Sound.nSkipUpdate;
	m_bVolumeOnly    = (BOOL)g_Sound.nVolumeOnly;
	m_bEnableStereo  = (BOOL)stereo_enabled;

	SetDlgState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CSoundDlg::OnInitDialog */

void
CSoundDlg::
OnSelchangeSoundPlayback() 
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_SOUND_PLAYBACK );
	ASSERT(pCombo != NULL);

	m_nLowSkipLimit = s_anLowLimits [ pCombo->GetCurSel() ];
	m_nSoundRate    = s_anSoundRates[ pCombo->GetCurSel() ];
	SetPokeyDivisor();

	if( m_nSoundRate == 22050 )
		m_ulSoundState &= ~SOUND_CUSTOM_RATE;
	else
		m_ulSoundState |= SOUND_CUSTOM_RATE;
}

void
CSoundDlg::
OnSoundNosound() 
{
	m_ulSoundState |= SOUND_NOSOUND;
//	m_ulSoundState &= ~(SOUND_DIRECTSOUND | SOUND_MMSOUND); /* Sound/Mute wants this */
}

void
CSoundDlg::
OnSoundMmsound() 
{
	m_ulSoundState |= SOUND_MMSOUND;
	m_ulSoundState &= ~(SOUND_DIRECTSOUND | SOUND_NOSOUND);
}


void
CSoundDlg::
OnSoundDirectsound() 
{
	m_ulSoundState |= SOUND_DIRECTSOUND;
	m_ulSoundState &= ~(SOUND_MMSOUND | SOUND_NOSOUND);
}

void
CSoundDlg::
OnKillfocusPokeyDivisor() 
{
	BOOL bResult;

	ASSERT(GetDlgItem( IDC_SOUND_POKEYDIVISOR ));
	m_nSkipUpdate = GetDlgItemInt( IDC_SOUND_POKEYDIVISOR, &bResult, FALSE );

	SetPokeyDivisor();
}

void
CSoundDlg::
OnDeltaposPokeyDivisorSpin(
	NMHDR   *pNMHDR,
	LRESULT *pResult
)
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN *)pNMHDR;
	m_nSkipUpdate -= pNMUpDown->iDelta;

	SetPokeyDivisor();

	*pResult = m_nSkipUpdate;
}

void
CSoundDlg::
OnSoundVolumeOnly() 
{
	CButton *pButton = (CButton*)GetDlgItem( IDC_SOUND_VOLUMEONLY );
	ASSERT(pButton != NULL);
	m_bVolumeOnly = pButton->GetCheck();
}

void
CSoundDlg::
OnSoundStereo() 
{
	CButton *pButton = (CButton*)GetDlgItem( IDC_SOUND_STEREO );
	ASSERT(pButton != NULL);
	m_bEnableStereo = pButton->GetCheck();
}

/*========================================================
Method   : CSoundDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CSoundDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	if( IDC_SOUND_POKEYDIVISOR == nCtrlID )
	{
		OnKillfocusPokeyDivisor();
	}
} /* #OF# CSoundDlg::ReceiveFocused */

void
CSoundDlg::
OnOK() 
{
	CSliderCtrl	*pSlider  = (CSliderCtrl *)GetDlgItem( IDC_SOUND_VOLUMESLIDER );
	BOOL         bChanged = FALSE;

	ASSERT(pSlider != NULL);

	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_ulSoundState != g_Sound.ulMode )
	{
		g_Sound.ulMode = m_ulSoundState;
		WriteRegDWORD( NULL, REG_SOUND_STATE, g_Sound.ulMode );
		bChanged = TRUE;
	}
	if( m_nSoundRate != g_Sound.nRate )
	{
		g_Sound.nRate = m_nSoundRate;
		WriteRegDWORD( NULL, REG_SOUND_RATE, g_Sound.nRate );
		bChanged = TRUE;
	}
	if( m_nSkipUpdate != g_Sound.nSkipUpdate )
	{
		g_Sound.nSkipUpdate = m_nSkipUpdate;
		WriteRegDWORD( NULL, REG_SOUND_UPDATE, g_Sound.nSkipUpdate );
		bChanged = TRUE;
	}
	if( m_bVolumeOnly != (BOOL)g_Sound.nVolumeOnly )
	{
		g_Sound.nVolumeOnly = m_bVolumeOnly;
		WriteRegDWORD( NULL, REG_USE_VOLUME_ONLY, g_Sound.nVolumeOnly );
		bChanged = TRUE;
	}
	if( m_bEnableStereo != (BOOL)stereo_enabled )
	{
		stereo_enabled = (int)m_bEnableStereo;
		WriteRegDWORD( NULL, REG_ENABLE_STEREO, stereo_enabled );
		bChanged = TRUE;
	}

	if( bChanged )
	{
		Sound_Clear( TRUE );
		Sound_Initialise( FALSE );
	}

	/* We have to get slider's position here because it could be changed by keyboard */
	m_nSoundVol = pSlider->GetPos() - 100;
	/* Set new sound volume */
	if( m_nSoundVol != g_Sound.nVolume )
	{
		g_Sound.nVolume = m_nSoundVol;
		WriteRegDWORD( NULL, REG_SOUND_VOLUME, g_Sound.nVolume );

		Sound_SetVolume();
	}
	CCommonDlg::OnOK();
}
