/****************************************************************************
File    : SettingsDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CSettingsDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 08.10.2000
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "SettingsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_SETTINGS_FIRST		IDC_SETTINGS_C000RAM
#define IDC_SETTINGS_LAST		IDC_SETTINGS_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg dialog

BEGIN_MESSAGE_MAP(CSettingsDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CSettingsDlg)
	ON_BN_CLICKED(IDC_SETTINGS_C000RAM, OnC000Ram)
	ON_BN_CLICKED(IDC_SETTINGS_ENABLEROM, OnEnableRom)
	ON_BN_CLICKED(IDC_SETTINGS_ENABLESIO, OnEnableSio)
	ON_BN_CLICKED(IDC_SETTINGS_HOLDOPTION, OnHoldOption)
	ON_BN_CLICKED(IDC_SETTINGS_PRINTCHECK, OnPrintCheck)
	ON_EN_KILLFOCUS(IDC_SETTINGS_PRINTCMD, OnKillfocusPrintCmd)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_SETTINGS_OK, OnOK)
	ON_BN_CLICKED(IDC_SETTINGS_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CSettingsDlg::CSettingsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CSettingsDlg::
CSettingsDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CCommonDlg( CSettingsDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CSettingsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nFirstCtrl = IDC_SETTINGS_FIRST;
	m_nLastCtrl  = IDC_SETTINGS_LAST;
	m_bReboot    = FALSE;
} /* #OF# CSettingsDlg::CSettingsDlg */

/*========================================================
Method   : CSettingsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CSettingsDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CSettingsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CSettingsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg implementation

/*========================================================
Method   : CSettingsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CSettingsDlg::
SetDlgState()
{
	CButton	*pButton = NULL;
	CWnd	*pWnd    = NULL;

	pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLEROM );
	ASSERT(pButton);
	if( m_nEnableRomPatches )
	{
		pButton->SetCheck( 1 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
		ASSERT(pButton);
		pButton->EnableWindow( TRUE );

		if( m_nEnableSIOPatch )
			pButton->SetCheck( 1 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_PRINTCHECK );
		ASSERT(pButton);
		pButton->EnableWindow( TRUE );

		if( m_ulMiscState & MS_USE_PRINT_COMMAND )
			pButton->SetCheck( 1 );
	}
	else /* ROM patch == FALSE automatically disables SIO_PATCH */
	{
		pButton->SetCheck( 0 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
		pButton->EnableWindow( FALSE );
		m_nEnableSIOPatch = 0; /* turn the SIO patch off */

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_PRINTCHECK );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
		pButton->EnableWindow( FALSE );
		m_ulMiscState &= ~MS_USE_PRINT_COMMAND;
	}
	/* Set up check buttons states */
	if( m_nHoldOption )
	{
		pButton = (CButton*)GetDlgItem( IDC_SETTINGS_HOLDOPTION );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	if( m_nEnableC000Ram )
	{
		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_C000RAM );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	/* An alternative print command */
	SetDlgItemText( IDC_SETTINGS_PRINTCMD, m_szPrintCommand );

	pWnd = GetDlgItem( IDC_SETTINGS_PRINTCMD );
	ASSERT(pWnd);
	pWnd->EnableWindow( m_ulMiscState & MS_USE_PRINT_COMMAND );
} /* #OF# CSettingsDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg message handlers

/*========================================================
Method   : CSettingsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CSettingsDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	m_ulMiscState       = g_Misc.ulState;
	m_nEnableRomPatches = enable_rom_patches;
	m_nEnableSIOPatch   = enable_sio_patch;
	m_nEnableC000Ram    = enable_c000_ram;
	m_nHoldOption       = hold_option;

	strncpy( m_szPrintCommand, print_command, PRINT_CMD_LENGTH );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CSettingsDlg::OnInitDialog */

/*========================================================
Method   : CSettingsDlg::OnHoldOption
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Hold Option check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnHoldOption()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_HOLDOPTION );
	ASSERT(pButton);
	m_nHoldOption = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnHoldOption */

/*========================================================
Method   : CSettingsDlg::OnEnableRom
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Enable ROM Patches check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnEnableRom() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLEROM );
	ASSERT(pButton);
	m_nEnableRomPatches = pButton->GetCheck();

	SetDlgState();
} /* #OF# CSettingsDlg::OnEnableRom */

/*========================================================
Method   : CSettingsDlg::OnEnableSio
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Enable SIO Patch check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnEnableSio() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
	ASSERT(pButton);
	m_nEnableSIOPatch = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnEnableSio */

/*========================================================
Method   : CSettingsDlg::OnC000Ram
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Enable C000 RAM check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnC000Ram() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_C000RAM );
	ASSERT(pButton);
	m_nEnableC000Ram = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnC000Ram */

void
CSettingsDlg::
OnPrintCheck()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_PRINTCHECK );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscState |= MS_USE_PRINT_COMMAND;
	else
		m_ulMiscState &= ~MS_USE_PRINT_COMMAND;

	SetDlgState();
}

void
CSettingsDlg::
OnKillfocusPrintCmd()
{
	GetDlgItemText( IDC_SETTINGS_PRINTCMD, m_szPrintCommand, PRINT_CMD_LENGTH );
}

/*========================================================
Method   : CSettingsDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CSettingsDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	if( IDC_SETTINGS_PRINTCMD == nCtrlID )
	{
		OnKillfocusPrintCmd();
	}
} /* #OF# CSettingsDlg::ReceiveFocused */

/*========================================================
Method   : CSettingsDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnOK() 
{
	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_nHoldOption != hold_option )
	{
		hold_option = m_nHoldOption;
		WriteRegDWORD( NULL, REG_HOLD_OPTION, hold_option );
//		m_bReboot = TRUE; /* I think we don't really need this */
	}
	if( m_nEnableC000Ram != enable_c000_ram )
	{
		enable_c000_ram = m_nEnableC000Ram;
		WriteRegDWORD( NULL, REG_ENABLE_C000_RAM, enable_c000_ram );
		m_bReboot = TRUE;
	}
	if( m_nEnableRomPatches != enable_rom_patches )
	{
		enable_rom_patches = m_nEnableRomPatches;
		WriteRegDWORD( NULL, REG_ENABLE_ROM_PATCH, enable_rom_patches );
		m_bReboot = TRUE;
	}
	if( m_nEnableSIOPatch != enable_sio_patch )
	{
		enable_sio_patch = (m_nEnableSIOPatch && enable_rom_patches ? 1 : 0);
		if( enable_sio_patch )
			SetSIOEsc();
		else
			RestoreSIO();
		WriteRegDWORD( NULL, REG_ENABLE_SIO_PATCH, enable_sio_patch );
	}
	if( m_ulMiscState != g_Misc.ulState )
	{
		g_Misc.ulState = m_ulMiscState;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_Misc.ulState );
	}

	if( *m_szPrintCommand == '\0' )
		strcpy( m_szPrintCommand, "Notepad %s" );
	if( _stricmp( m_szPrintCommand, print_command ) != 0 )
	{
		strncpy( print_command, m_szPrintCommand, PRINT_CMD_LENGTH );
		WriteRegString( NULL, REG_PRINT_COMMAND, print_command );
	}
	CCommonDlg::OnOK();
} /* #OF# CSettingsDlg::OnOK */
