/****************************************************************************
File    : RomImagesDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CRomImagesDlg implementation file
@(#) #BY# Tomasz Szymankowski, Richard Lawrence
@(#) #LM# 17.10.2000
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "RomImagesBase.h"
#include "RomImagesDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_ROMIMAGES_FIRST		IDC_ROMIMAGES_OSA
#define IDC_ROMIMAGES_LAST		IDC_ROMIMAGES_CANCEL

#define CS_DETACHED			0
#define CS_ATTACHED			1
#define CS_USE_BASIC		2


/////////////////////////////////////////////////////////////////////////////
// Static objects

static char s_szNewCartName[ MAX_PATH ];


/////////////////////////////////////////////////////////////////////////////
// CRomImagesDlg dialog

BEGIN_MESSAGE_MAP(CRomImagesDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CRomImagesDlg)
	ON_BN_CLICKED(IDC_ROMIMAGES_OSA, OnOsa)
	ON_BN_CLICKED(IDC_ROMIMAGES_OSB, OnOsb)
	ON_BN_CLICKED(IDC_ROMIMAGES_XLXE, OnXlxe)
	ON_BN_CLICKED(IDC_ROMIMAGES_5200, On5200)
	ON_BN_CLICKED(IDC_ROMIMAGES_BASIC, OnBasic)
	ON_BN_CLICKED(IDC_ROMIMAGES_CARTRIDGE, OnCartridge)
	ON_BN_CLICKED(IDC_ROMIMAGES_OSROM, OnOsRom)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITOSA, OnKillfocusEditOsa)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITOSB, OnKillfocusEditOsb)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITXLXE, OnKillfocusEditXlxe)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDIT5200, OnKillfocusEdit5200)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITBASIC, OnKillfocusEditBasic)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITOSROM, OnKillfocusEditOsRom)
	ON_CBN_SELCHANGE(IDC_ROMIMAGES_MACHINETYPE, OnSelchangeMachineType)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITCARTRIDGE, OnKillfocusEditCartridge)
	ON_BN_CLICKED(IDC_ROMIMAGES_SEARCH, OnSearch)
	ON_BN_CLICKED(IDC_ROMIMAGES_INFO, OnInfo)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_ROMIMAGES_OK, OnOK)
	ON_BN_CLICKED(IDC_ROMIMAGES_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CRomImagesDlg::CRomImagesDlg
=========================================================*/
/* #FN#
   Standard constructor */
CRomImagesDlg::
CRomImagesDlg(
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to the parent window */
)
	: CCommonDlg( (g_Screen.ulMode & SM_ATTR_SMALL_DLG ? IDD_ROMIMAGES_SMALL : CRomImagesDlg::IDD), pParent ),
	  CRomImagesBase()
{
	//{{AFX_DATA_INIT(CRomImagesDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_bExitPass  = FALSE;
	m_nFirstCtrl = IDC_ROMIMAGES_FIRST;
	m_nLastCtrl  = IDC_ROMIMAGES_LAST;
	m_bReboot    = FALSE;
} /* #OF# CRomImagesDlg::CRomImagesDlg */

/*========================================================
Method   : CRomImagesDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CRomImagesDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CCommonDlg::DoDataExchange( pDX );
	CRomImagesBase::DataExchange( pDX );

	//{{AFX_DATA_MAP(CRomImagesDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CRomImagesDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CRomImagesDlg implementation

/*========================================================
Method   : CRomImagesDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CRomImagesDlg::
SetDlgState()
{
	CComboBox *pCartState = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_CARTRIDGESTATE );

	BOOL bBasicExists = strcmp( atari_basic_filename, "None" ) != 0;
	BOOL bBasicActive = _stricmp( g_szCurrentRom, atari_basic_filename ) == 0;

	ASSERT(pCartState);

	m_nCartState = CS_DETACHED;
	pCartState->ResetContent();

	pCartState->AddString( "Detached" );
	pCartState->AddString( "Attached" );

	if( m_bSmallMode )
	{
		CComboBox *pOsRomType = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
		RomType    rtType     = RTI_OSA;
		ASSERT(pOsRomType);

		/* Get default system OS type */
		switch( default_system )
		{
			case 1:
				rtType = RTI_OSA;
				break;
			case 2:
				rtType = RTI_OSB;
				break;
			case 3:
			case 4:
			case 5:
				rtType = RTI_XLE;
				break;
			case 6:
				rtType = RTI_A52;
				break;
		}
		pOsRomType->SetCurSel( rtType );
		SetDlgItemText( m_pRomData[ rtType ].nCtrlID, m_pRomData[ rtType ].szNewName );
		SetDlgItemText( m_pRomData[ RTI_BAS ].nCtrlID, m_pRomData[ RTI_BAS ].szNewName );
	}
	else
		/* Set OS ROM and BASIC path edit windows */
		for( int i = 0; i < ROM_TYPES_NO; i++ )
		{
			SetDlgItemText( m_pRomData[ i ].nCtrlID, m_pRomData[ i ].szNewName );
		}

	/* Set cartridge path edit window */
	SetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, s_szNewCartName );

	/* The BASIC cartridge is used (800 OS-A/B) */
	if( default_system == 1/*800 OS-A*/ || default_system == 2/*800 OS-B*/ )
	{
		pCartState->AddString( "Use BASIC" );
		if( cart_type != NO_CART &&
			/* There is other ROM or BASIC is the current ROM */
			(strcmp( s_szNewCartName, "None" ) != 0 ||
			(bBasicExists && bBasicActive )) )
		{
			m_nCartState = (bBasicExists && bBasicActive) ? CS_USE_BASIC : CS_ATTACHED;
		}
	}
	else /* (XL/XE/5200) */
	{
		if( cart_type != NO_CART &&
			/* There is other ROM and BASIC is not the current ROM */
			strcmp( s_szNewCartName, "None" ) != 0 &&
			bBasicExists && !bBasicActive )
		{
			m_nCartState = CS_ATTACHED;
		}
	}
	/* Set appropriate combo item */
	pCartState->SetCurSel( m_nCartState );
} /* #OF# CRomImagesDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CRomImagesDlg message handlers

/*========================================================
Method   : CRomImagesDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CRomImagesDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();
	CRomImagesBase::InitDialog();

	const UINT anCtrlsLarge[ ROM_TYPES_NO ] =
	{
		IDC_ROMIMAGES_EDITOSA,
		IDC_ROMIMAGES_EDITOSB,
		IDC_ROMIMAGES_EDITXLXE,
		IDC_ROMIMAGES_EDIT5200,
		IDC_ROMIMAGES_EDITBASIC
	};

	const UINT anCtrlsSmall[ ROM_TYPES_NO ] =
	{
		IDC_ROMIMAGES_EDITOSROM,
		IDC_ROMIMAGES_EDITOSROM,
		IDC_ROMIMAGES_EDITOSROM,
		IDC_ROMIMAGES_EDITOSROM,
		IDC_ROMIMAGES_EDITBASIC
	};

	m_bSmallMode = g_Screen.ulMode & SM_ATTR_SMALL_DLG;
	m_nCartType  = NO_CART;

	for( int i = 0; i < ROM_TYPES_NO; i++ )
	{
		/* Set the appropriate controls IDs */
		m_pRomData[ i ].nCtrlID = (m_bSmallMode ? anCtrlsSmall[ i ] : anCtrlsLarge[ i ]);
		/* Backup ROM paths */
		strncpy( m_pRomData[ i ].szNewName, m_pRomData[ i ].pszName, MAX_PATH );
	}
	/* Backup cart path */
	strncpy( s_szNewCartName, g_szOtherRom, MAX_PATH );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CRomImagesDlg::OnInitDialog */

/*========================================================
Method   : CRomImagesDlg::OnSelchangeMachineType
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Machine Type combo */
void
/* #AS#
   Nothing */
CRomImagesDlg::
OnSelchangeMachineType()
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
	ASSERT(pCombo);
	int nType = pCombo->GetCurSel();

	SetDlgItemText( m_pRomData[ nType ].nCtrlID, m_pRomData[ nType ].szNewName );
} /* #OF# CHardwareDlg::OnSelchangeMachineType */

void
CRomImagesDlg::
OnOsa() 
{
	BrowseRomFile( RTI_OSA );
}

void
CRomImagesDlg::
OnOsb() 
{
	BrowseRomFile( RTI_OSB );
}

void
CRomImagesDlg::
OnXlxe() 
{
	BrowseRomFile( RTI_XLE );
}

void
CRomImagesDlg::
On5200()
{
	BrowseRomFile( RTI_A52 );
}

void
CRomImagesDlg::
OnBasic() 
{
	BrowseRomFile( RTI_BAS );
}

void
CRomImagesDlg::
OnCartridge()
{
	char szNewCart[ MAX_PATH ];

	GetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, szNewCart, MAX_PATH );

	if( PickCartridge( szNewCart, this ) )
	{
		int nCartType;

		if( *szNewCart == '\0' )
			strcpy( szNewCart, "None" );
		/* If the names and cart types are equal then don't process */
		if( m_nCartType != (nCartType = Misc_FindCartType( szNewCart, FALSE, FALSE )) ||
			_stricmp( s_szNewCartName, szNewCart ) != 0 )
		{
			strcpy( s_szNewCartName, szNewCart );
			m_nCartType = nCartType;
			/* Apply changes to dialog window */
			SetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, szNewCart );
		}
	}
}

void
CRomImagesDlg::
OnOsRom() 
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
	ASSERT(pCombo);
	BrowseRomFile( (RomType)pCombo->GetCurSel() );
}

void
CRomImagesDlg::
OnKillfocusEditOsa() 
{
	if( !m_bExitPass )
		KillfocusEditRom( RTI_OSA );
}

void
CRomImagesDlg::
OnKillfocusEditOsb()
{
	if( !m_bExitPass )
		KillfocusEditRom( RTI_OSB );
}

void
CRomImagesDlg::
OnKillfocusEditXlxe()
{
	if( !m_bExitPass )
		KillfocusEditRom( RTI_XLE );
}

void
CRomImagesDlg::
OnKillfocusEdit5200()
{
	if( !m_bExitPass )
		KillfocusEditRom( RTI_A52 );
}

void
CRomImagesDlg::
OnKillfocusEditBasic()
{
	if( !m_bExitPass )
		KillfocusEditRom( RTI_BAS );
}

void
CRomImagesDlg::
OnKillfocusEditCartridge()
{
	char szNewCart[ MAX_PATH ];

	GetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, szNewCart, MAX_PATH );
	if( *szNewCart == '\0' )
		strcpy( szNewCart, "None" );
	/* If the names are equal then don't process */
	if( _stricmp( s_szNewCartName, szNewCart ) != 0 )
	{
		/* Don't bother the user asking him for cart type
           anytime the edit window loses its focus */
		m_nCartType = Misc_FindCartType( szNewCart, FALSE, FALSE );
		strcpy( s_szNewCartName, szNewCart );
	}
}

void
CRomImagesDlg::
OnKillfocusEditOsRom()
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
	ASSERT(pCombo);
	if( !m_bExitPass )
		KillfocusEditRom( (RomType)pCombo->GetCurSel() );
}

void
CRomImagesDlg::
OnSearch()
{
	if( SearchRomImages() )
		SetDlgState();
}

void
CRomImagesDlg::
OnInfo()
{
	DisplayRomInfo();
}

/*========================================================
Method   : CRomImagesDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CRomImagesDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	if( m_bSmallMode )
	{
		if( IDC_ROMIMAGES_EDITOSROM == nCtrlID )
			OnKillfocusEditOsRom();
		else
		if( IDC_ROMIMAGES_EDITBASIC == nCtrlID )
			KillfocusEditRom( RTI_BAS );
	}
	else
	for( int i = 0; i < ROM_TYPES_NO; i++ )
	{
		if( m_pRomData[ i ].nCtrlID == nCtrlID )
		{
			KillfocusEditRom( (RomType)i );
			break;
		}
	}
} /* #OF# CRomImagesDlg::ReceiveFocused */

/*========================================================
Method   : CRomImagesDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CRomImagesDlg::
OnOK()
{
	CComboBox *pCombo = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_CARTRIDGESTATE );
	int        nNewCartState;

	ASSERT(pCombo);

	/* There is a problem with messages routing when the dialog is
	   closed with Enter/Alt-O key. KILLFOCUS message arrives
       to late and we have to invoke KillFocus handlers in OnOK
       method by ourselves. That's why we use this member. */
	m_bExitPass = TRUE;

	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	/* Get cartridge state the user was set */
	if( CB_ERR == (nNewCartState = pCombo->GetCurSel()) )
	{
		pCombo->SetCurSel( CS_DETACHED );
		nNewCartState = CS_DETACHED;
	}
	/* Check if OS ROMs were changed */
	for( int i = 0; i < ROM_TYPES_NO; i++ )
	{
		if( m_pRomData[ i ].szNewName == '\0' )
			strcpy( m_pRomData[ i ].szNewName, "None" );
		if( _stricmp( m_pRomData[ i ].pszName, m_pRomData[ i ].szNewName ) != 0 )
		{
			/* If the ROM was changed for an active system */
			if( i == "\0\1\2\2\2\3"[ default_system - 1 ] ||
			   (i == RTI_BAS && CS_USE_BASIC == nNewCartState) )
			{
				int nCFOut;
				if( CheckFile( m_pRomData[ i ].pszName, &nCFOut ) !=
					CheckFile( m_pRomData[ i ].szNewName, &nCFOut ) )
				{
					m_bReboot = TRUE;
				}
			}
			/* The function "strncpy" has given strange effects here */
			strcpy( m_pRomData[ i ].pszName, m_pRomData[ i ].szNewName );

			WriteRegString( NULL, m_pRomData[ i ].pszRegName, m_pRomData[ i ].pszName );
		}
	}
	/* Check if cartridge ROM was changed */
	/* This is the simplest way to resolve the KillFocus handling problems :) */
	GetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, s_szNewCartName, MAX_PATH );

	if( *s_szNewCartName == '\0' )
		strcpy( s_szNewCartName, "None" );
	if( _stricmp( s_szNewCartName, g_szOtherRom ) != 0 )
	{
		if( CS_ATTACHED == nNewCartState )
		{
			strcpy( g_szCurrentRom, s_szNewCartName );
			m_bReboot = TRUE;
		}
		strcpy( g_szOtherRom, s_szNewCartName );
		WriteRegString( NULL, REG_OTHER_ROM, g_szOtherRom );
	}

	if( nNewCartState != m_nCartState || m_bReboot )
	{
		m_bReboot = TRUE;
		if( CS_USE_BASIC == nNewCartState )
		{
			if( rom_inserted )
				Remove_ROM();
			/* strcpy will be called within Insert_ROM function */
			/* strcpy( g_szCurrentRom, atari_basic_filename ); */
			if( !Insert_8K_ROM( atari_basic_filename ) )
			{
				DisplayMessage( GetSafeHwnd(), IDS_ERROR_ROM_LOAD, 0, MB_ICONSTOP | MB_OK, atari_basic_filename );

				strcpy( g_szCurrentRom, "None" );
				cart_type = NO_CART;
			}
		}
		if( CS_ATTACHED == nNewCartState )
		{
			AttachCartridge( g_szOtherRom, m_nCartType );
		}
		if( CS_DETACHED == nNewCartState )
		{
			strcpy( g_szCurrentRom, "None" );
			cart_type = NO_CART;
		}
		WriteRegString( NULL, REG_CURRENT_ROM, g_szCurrentRom );
		WriteRegDWORD ( NULL, REG_CART_TYPE, cart_type );
	}
	CCommonDlg::OnOK();
} /* #OF# CRomImagesDlg::OnOK */
