/****************************************************************************
File    : RomImagesBase.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CRomImagesBase implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 09.03.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "FileSmallDlg.h"
#include "WarningDlg.h"
#include "RomImagesBase.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static objects

static CRomImagesBase::RomData_t s_aRomData[ ROM_TYPES_NO ] =
{
	{ atari_osa_filename,   "None", 0, "Select the ROM for Atari 800 OS-A", REG_OSA_ROM,   DONT_SHOW_OSA_WARN   },
	{ atari_osb_filename,   "None", 0, "Select the ROM for Atari 800 OS-B", REG_OSB_ROM,   DONT_SHOW_OSB_WARN   },
	{ atari_xlxe_filename,  "None", 0, "Select the ROM for Atari XL/XE",    REG_XLXE_ROM,  DONT_SHOW_XLXE_WARN  },
	{ atari_5200_filename,  "None", 0, "Select the ROM for Atari 5200",     REG_5200_ROM,  DONT_SHOW_5200_WARN  },
	{ atari_basic_filename, "None", 0, "Select the ROM for BASIC cart",     REG_BASIC_ROM, DONT_SHOW_BASIC_WARN }
};


/////////////////////////////////////////////////////////////////////////////
// CRomImagesBase class

/*========================================================
Method   : CRomImagesBase::CRomImagesBase
=========================================================*/
CRomImagesBase::
CRomImagesBase()
{
	m_pRomData = s_aRomData;
}

/*========================================================
Method   : CRomImagesBase::~CRomImagesBase
=========================================================*/
CRomImagesBase::
~CRomImagesBase()
{
}

/*========================================================
Method   : RomImagesBase::KillfocusEditRom
=========================================================*/
/* #FN#
	Sets the specific ROM image */
void
/* #AS#
   Nothing */
CRomImagesBase::
KillfocusEditRom( RomType rtType )
{
	char szNewRom[ MAX_PATH ];

	GetWnd()->GetDlgItemText( m_pRomData[ rtType ].nCtrlID, szNewRom, MAX_PATH );
	if( *szNewRom == '\0' )
		strcpy( szNewRom, "None" );
	/* If the names are equal then don't go */
	if( _stricmp( m_pRomData[ rtType ].szNewName, szNewRom ) != 0 )
	{
		int   nCFOut;
		ULONG ulCRC   = CheckFile( szNewRom, &nCFOut );
		int   nResult = IDOK;

		if( ulCRC && !nCFOut )
		{
			BOOL bFound = FALSE;
			for( int i = 0; i < g_nRomTypeInfoNo; i++ )
			{
				if( g_aRomTypeInfo[ i ].rtType == rtType &&
					g_aRomTypeInfo[ i ].ulCRC  == ulCRC )
				{
					bFound = TRUE;
					break;
				}
			}
			if( !bFound &&
				!(g_Misc.ulDontShow & m_pRomData[ rtType ].nWarnBit) )
			{
				char szMessage[ LOADSTRING_STRING_SIZE ];
				CWarningDlg	dlgWarning;

				LoadString( NULL, IDS_WARN_ROM_CORRUPT, szMessage, LOADSTRING_STRING_SIZE );
				dlgWarning.m_strWarnText = szMessage;
				dlgWarning.m_ulWarnBit   = m_pRomData[ rtType ].nWarnBit;
				nResult = dlgWarning.DoModal();
			}
		}
		if( IDOK == nResult )
			strcpy( m_pRomData[ rtType ].szNewName, szNewRom );

		/* Apply changes to dialog window */
		GetWnd()->SetDlgItemText( m_pRomData[ rtType ].nCtrlID, m_pRomData[ rtType ].szNewName );
	}
} /* #OF# RomImagesBase::OnKillfocusEditRom */

/*========================================================
Method   : RomImagesBase::BrowseRomFile
=========================================================*/
/* #FN#
   Allows to select ROM image using FileDialog window */
void
/* #AS#
   Nothing */
CRomImagesBase::
BrowseRomFile( RomType rtType )
{
	char szNewRom[ MAX_PATH ];

	GetWnd()->GetDlgItemText( m_pRomData[ rtType ].nCtrlID, szNewRom, MAX_PATH );

	if( PickFileName( TRUE, szNewRom, m_pRomData[ rtType ].pszOpenPrompt,
					  PF_ROM_FILTER, "rom", PF_LOAD_FLAGS, TRUE, "None", GetWnd() ) &&
		*szNewRom != '\0' )
	{
		GetWnd()->SetDlgItemText( m_pRomData[ rtType ].nCtrlID, szNewRom );
		KillfocusEditRom( rtType );
	}
} /* #OF# RomImagesBase::BrowseRomFile */

BOOL
CRomImagesBase::
SearchRomImages()
{
	CString	strPath = "";
	int	nResult;

	CFileSmallDlg dlgFileSmall( TRUE, NULL, NULL, strPath, TRUE, GetWnd() );
	if( IDOK == (nResult = dlgFileSmall.DoModal()) )
	{
		char acRomNamesBackup[ ROM_TYPES_NO ][ MAX_PATH ];

		for( int i = 0; i < ROM_TYPES_NO; i++ )
			strncpy( &acRomNamesBackup[ i ][ 0 ], m_pRomData[ i ].pszName, MAX_PATH );

		strPath = dlgFileSmall.GetPathName();	
		if( Misc_TestRomPaths( (LPSTR)(LPCSTR)strPath, GetWnd()->GetSafeHwnd() ) )
		{
			/* The Cancel button must work after using Search */
			for( int i = 0; i < ROM_TYPES_NO; i++ )
			{
				strncpy( m_pRomData[ i ].szNewName, m_pRomData[ i ].pszName, MAX_PATH );
				strcpy( m_pRomData[ i ].pszName, &acRomNamesBackup[ i ][ 0 ] );
			}
			return TRUE;
		}
		else
			DisplayMessage( GetWnd()->GetSafeHwnd(), IDS_ERROR_ROM_SEARCH, 0, MB_ICONINFORMATION | MB_OK );
	}
	return FALSE;
}

void
CRomImagesBase::
DisplayRomInfo()
{
	LPCSTR pszLabel[ ROM_TYPES_NO ] = { "OS-A", "OS-B", "XL/XE", "5200", "BASIC" };
	char   szBuffer[ 1024 ];
	LPCSTR pszInfo = NULL;
	LPSTR  pszPtr  = szBuffer;

	for( int i = 0; i < ROM_TYPES_NO; i++ )
	{
		if( *(m_pRomData[ i ].szNewName) != '\0' && strcmp( m_pRomData[ i ].szNewName, "None" ) != 0 )
		{
			pszInfo = GetRomInfo( m_pRomData[ i ].szNewName, (RomType)i );
			if( pszInfo )
				sprintf( pszPtr, "%s\t| %s\n", pszLabel[ i ], pszInfo );
			else
				sprintf( pszPtr, "%s\t| Unknown type\n", pszLabel[ i ] );
		}
		else
			sprintf( pszPtr, "%s\t| Not available\n", pszLabel[ i ], pszInfo );

		pszPtr = szBuffer + strlen( szBuffer );
	}
	GetWnd()->MessageBox( szBuffer, "ROM Information", MB_ICONINFORMATION | MB_OK );
}

/*========================================================
Method   : CRomImagesBase::GetRomInfo
=========================================================*/
/* #FN#
   Returns a description of the ROM image */
LPCSTR
/* #AS#
   Description of the ROM image if was found, otherwise NULL */
CRomImagesBase::
GetRomInfo(
	LPSTR pszFileName,
	enum RomType rtType
)
{
	ULONG ulCRC;
	int   nResult;

	if( NULL != pszFileName )
	{
		ulCRC = CheckFile( pszFileName, &nResult );

		if( ulCRC != 0 )
		{
			int i;
			for( i = 0; i < g_nRomTypeInfoNo; i++ )
			{
				if( g_aRomTypeInfo[ i ].rtType == rtType &&
					g_aRomTypeInfo[ i ].ulCRC  == ulCRC )
				{
					return g_aRomTypeInfo[ i ].pszDesc;
				}
			}
		}
	}
	return NULL;
} /* #OF# CRomImagesBase::GetRomInfo */
