/****************************************************************************
File    : MouseDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CMouseDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 02.12.2000
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "MainFrame.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "MouseDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_MOUSE_FIRST		IDC_MOUSE_EMULATEDDEVICE
#define IDC_MOUSE_LAST		IDC_MOUSE_CANCEL

#define MAX_MOUSE_SPEED		 10
#define MAX_PAD_RANGE		228
#define MAX_JOY_INERTIA		 20
#define MAX_PEN_H_OFFSET	 44
#define MAX_PEN_V_OFFSET	 32


/////////////////////////////////////////////////////////////////////////////
// CMouseDlg dialog

BEGIN_MESSAGE_MAP(CMouseDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CMouseDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_PENHORZSPIN, OnDeltaposPenHorzSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_PENHORZOFFSET, OnKillfocusPenHorzOffset)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_PENVERTSPIN, OnDeltaposPenVertSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_PENVERTOFFSET, OnKillfocusPenVertOffset)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_MOUSESPIN, OnDeltaposMouseSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_MOUSESPEED, OnKillfocusMouseSpeed)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_PADDLESPIN, OnDeltaposPaddleSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_PADDLERANGE, OnKillfocusPaddleRange)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MOUSE_JOYSTICKSPIN, OnDeltaposJoystickSpin)
	ON_EN_KILLFOCUS(IDC_MOUSE_JOYSTICKINERTIA, OnKillfocusJoystickInertia)
	ON_CBN_SELCHANGE(IDC_MOUSE_EMULATEDDEVICE, OnSelchangeEmulatedDevice)
	ON_CBN_SELCHANGE(IDC_MOUSE_STICKPORT, OnSelchangeStickPort)
	ON_BN_CLICKED(IDC_MOUSE_MOUSECAPTURE, OnMouseCapture)
	ON_BN_CLICKED(IDC_MOUSE_SHOWPEN, OnShowPen)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_MOUSE_OK, OnOK)
	ON_BN_CLICKED(IDC_MOUSE_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CMouseDlg::CMouseDlg
=========================================================*/
/* #FN#
   Standard constructor */
CMouseDlg::
CMouseDlg(
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */
)
	: CCommonDlg( CMouseDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CMouseDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_pFrameWindow = (CMainFrame *)pParent;
	m_nFirstCtrl   = IDC_MOUSE_FIRST;
	m_nLastCtrl    = IDC_MOUSE_LAST;
} /* #OF# CMouseDlg::CMouseDlg */

/*========================================================
Method   : CMouseDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CMouseDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CMouseDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CMouseDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CMouseDlg implementation

/*========================================================
Method   : CMouseDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CMouseDlg::
SetDlgState()
{
	CButton   *pButton = NULL;
	CComboBox *pCombo  = NULL;
	CWnd      *pWnd    = NULL;

	pCombo = (CComboBox *)GetDlgItem( IDC_MOUSE_EMULATEDDEVICE );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nMouseMode );

	/* Enable/Disable appriopriate controls */

	pWnd = GetDlgItem( IDC_MOUSE_MOUSESPEED );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_AMIGA == m_nMouseMode || MOUSE_ST == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MOUSESPEED_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_AMIGA == m_nMouseMode || MOUSE_ST == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_MOUSESPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_AMIGA == m_nMouseMode || MOUSE_ST == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PADDLERANGE );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PADDLERANGE_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PADDLESPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PAD == m_nMouseMode );
	
	pWnd = GetDlgItem( IDC_MOUSE_SHOWPEN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENHORZOFFSET );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENHORZOFFSET_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENHORZSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );
	
	pWnd = GetDlgItem( IDC_MOUSE_PENVERTOFFSET );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENVERTOFFSET_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_PENVERTSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_PEN == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_JOYSTICKINERTIA );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_JOY == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_JOYSTICKINERTIA_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_JOY == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_JOYSTICKSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_JOY == m_nMouseMode );

	pWnd = GetDlgItem( IDC_MOUSE_STICKPORT );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode /*&& MOUSE_PEN != m_nMouseMode*/ );

	pWnd = GetDlgItem( IDC_MOUSE_STICKPORT_LABEL );
	ASSERT(pWnd);
	pWnd->EnableWindow( MOUSE_OFF != m_nMouseMode /*&& MOUSE_PEN != m_nMouseMode*/ );

	/* The light pen is assigned to port #0 in ANTIC.c */
//	if( MOUSE_PEN == m_nMouseMode )
//		m_nMousePort = 0;

	pCombo = (CComboBox *)GetDlgItem( IDC_MOUSE_STICKPORT );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nMousePort );

	/* Set up check buttons states */
	if( m_ulMiscState & MS_MOUSE_CAPTURED )
	{
		pButton = (CButton *)GetDlgItem( IDC_MOUSE_MOUSECAPTURE );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	if( m_ulMiscState & MS_SHOW_PEN_POINTER )
	{
		pButton = (CButton *)GetDlgItem( IDC_MOUSE_SHOWPEN );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	SetDlgItemInt( IDC_MOUSE_MOUSESPEED, MAX_MOUSE_SPEED + 1 - m_nMouseSpeed, FALSE );
	SetDlgItemInt( IDC_MOUSE_PADDLERANGE, m_nPaddleRange, FALSE );
	SetDlgItemInt( IDC_MOUSE_JOYSTICKINERTIA, m_nJoyInertia, FALSE );
	SetDlgItemInt( IDC_MOUSE_PENHORZOFFSET, m_nPenOffsetX, FALSE );
	SetDlgItemInt( IDC_MOUSE_PENVERTOFFSET, m_nPenOffsetY, FALSE );

} /* #OF# CMouseDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CMouseDlg message handlers

/*========================================================
Method   : CMouseDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CMouseDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	m_nMouseMode   = g_Input.Mouse.nMode;
	m_nMousePort   = g_Input.Mouse.nPort;
	m_nMouseSpeed  = g_Input.Mouse.nMouseSpeed;
	m_nPaddleRange = g_Input.Mouse.nPaddleRange;
	m_nJoyInertia  = g_Input.Mouse.nJoyInertia;
	m_nPenOffsetX  = g_Input.Mouse.nPenOffsetX;
	m_nPenOffsetY  = g_Input.Mouse.nPenOffsetY;
	m_ulMiscState = g_Misc.ulState;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CMouseDlg::OnInitDialog */

/*========================================================
Method   : CMouseDlg::OnMouseCapture
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Full Speed check box */
void
/* #AS#
   Nothing */
CMouseDlg::
OnMouseCapture()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MOUSE_MOUSECAPTURE );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscState |= MS_MOUSE_CAPTURED;
	else
		m_ulMiscState &= ~MS_MOUSE_CAPTURED;
} /* #OF# CMouseDlg::OnMouseCapture */

/*========================================================
Method   : CMouseDlg::OnShowPen
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Show Pen Pointer check box */
void
/* #AS#
   Nothing */
CMouseDlg::
OnShowPen()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MOUSE_SHOWPEN );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscState |= MS_SHOW_PEN_POINTER;
	else
		m_ulMiscState &= ~MS_SHOW_PEN_POINTER;
} /* #OF# CMouseDlg::OnShowPen */

/*========================================================
Method   : CMouseDlg::OnDeltaposMouseSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Mouse Speed spin */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposMouseSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;
	int nMouseInvert = MAX_MOUSE_SPEED + 1 - m_nMouseSpeed;

	nMouseInvert -= pNMUpDown->iDelta;
	if( nMouseInvert < 1 )
		nMouseInvert = 1;
	if( nMouseInvert > MAX_MOUSE_SPEED )
		nMouseInvert = MAX_MOUSE_SPEED;

	SetDlgItemInt( IDC_MOUSE_MOUSESPEED, nMouseInvert, FALSE );
	m_nMouseSpeed = MAX_MOUSE_SPEED + 1 - nMouseInvert;

	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposMouseSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusMouseSpeed
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Joystick Inertia edit */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusMouseSpeed()
{
	BOOL bTrans;
	int  nMouseInvert = GetDlgItemInt( IDC_MOUSE_MOUSESPEED, &bTrans, FALSE );

	if( bTrans )
	{
		if( nMouseInvert < 1 )
			nMouseInvert = 1;
		if( nMouseInvert > MAX_MOUSE_SPEED )
			nMouseInvert = MAX_MOUSE_SPEED;

		m_nMouseSpeed = MAX_MOUSE_SPEED + 1 - nMouseInvert;
	}
	if( !bTrans || nMouseInvert < 1 || nMouseInvert > MAX_MOUSE_SPEED )
		SetDlgItemInt( IDC_MOUSE_MOUSESPEED, MAX_MOUSE_SPEED + 1 - m_nMouseSpeed, FALSE );
} /* #OF# CMouseDlg::OnKillfocusMouseSpeed */

/*========================================================
Method   : CMouseDlg::OnDeltaposJoystickSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Joystick Inertia spin */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposJoystickSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nJoyInertia -= pNMUpDown->iDelta;
	if( m_nJoyInertia < 1 )
		m_nJoyInertia = 1;
	if( m_nJoyInertia > MAX_JOY_INERTIA )
		m_nJoyInertia = MAX_JOY_INERTIA;

	SetDlgItemInt( IDC_MOUSE_JOYSTICKINERTIA, m_nJoyInertia, FALSE );

	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposJoystickSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusJoystickInertia
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Joystick Inertia edit */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusJoystickInertia()
{
	BOOL bTrans;
	int  nJoystickInertia = GetDlgItemInt( IDC_MOUSE_JOYSTICKINERTIA, &bTrans, FALSE );

	if( bTrans )
	{
		m_nJoyInertia = nJoystickInertia;
		if( m_nJoyInertia < 1 )
			m_nJoyInertia = 1;
		if( m_nJoyInertia > MAX_JOY_INERTIA )
			m_nJoyInertia = MAX_JOY_INERTIA;
	}
	if( !bTrans || nJoystickInertia < 1 || nJoystickInertia > MAX_JOY_INERTIA )
		SetDlgItemInt( IDC_MOUSE_JOYSTICKINERTIA, m_nJoyInertia, FALSE );
} /* #OF# CMouseDlg::OnKillfocusJoystickInertia */

/*========================================================
Method   : CMouseDlg::OnDeltaposPaddleSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Paddle Range spin */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposPaddleSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nPaddleRange -= pNMUpDown->iDelta;
	if( m_nPaddleRange < 1 )
		m_nPaddleRange = 1;
	if( m_nPaddleRange > MAX_PAD_RANGE )
		m_nPaddleRange = MAX_PAD_RANGE;

	SetDlgItemInt( IDC_MOUSE_PADDLERANGE, m_nPaddleRange, FALSE );

	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposPaddleSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusPaddleRange
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Paddle Range edit */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusPaddleRange()
{
	BOOL bTrans;
	int  nPaddleRange = GetDlgItemInt( IDC_MOUSE_PADDLERANGE, &bTrans, FALSE );

	if( bTrans )
	{
		m_nPaddleRange = nPaddleRange;
		if( m_nPaddleRange < 1 )
			m_nPaddleRange = 1;
		if( m_nPaddleRange > MAX_PAD_RANGE )
			m_nPaddleRange = MAX_PAD_RANGE;
	}
	if( !bTrans || nPaddleRange < 1 || nPaddleRange > MAX_PAD_RANGE )
		SetDlgItemInt( IDC_MOUSE_PADDLERANGE, m_nPaddleRange, FALSE );
} /* #OF# CMouseDlg::OnKillfocusPaddleRange */

/*========================================================
Method   : CMouseDlg::OnDeltaposPenHorzSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Pen Horz Offset spin */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposPenHorzSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nPenOffsetX -= pNMUpDown->iDelta;
	if( m_nPenOffsetX < 0 )
		m_nPenOffsetX = 0;
	if( m_nPenOffsetX > MAX_PEN_H_OFFSET )
		m_nPenOffsetX = MAX_PEN_H_OFFSET;

	SetDlgItemInt( IDC_MOUSE_PENHORZOFFSET, m_nPenOffsetX, FALSE );

	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposPenHorzSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusPenHorzOffset
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Pen Horz Offset edit */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusPenHorzOffset()
{
	BOOL bTrans;
	int  nPenOffsetX = GetDlgItemInt( IDC_MOUSE_PENHORZOFFSET, &bTrans, FALSE );

	if( bTrans )
	{
		m_nPenOffsetX = nPenOffsetX;
		if( m_nPenOffsetX < 0 )
			m_nPenOffsetX = 0;
		if( m_nPenOffsetX > MAX_PEN_H_OFFSET )
			m_nPenOffsetX = MAX_PEN_H_OFFSET;
	}
	if( !bTrans || nPenOffsetX < 0 || nPenOffsetX > MAX_PEN_H_OFFSET )
		SetDlgItemInt( IDC_MOUSE_PENHORZOFFSET, m_nPenOffsetX, FALSE );
} /* #OF# CMouseDlg::OnKillfocusPenHorzOffset */

/*========================================================
Method   : CMouseDlg::OnDeltaposPenVertSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Pen Vert Offset spin */
void
/* #AS#
   Nothing */
CMouseDlg::
OnDeltaposPenVertSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */
)
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nPenOffsetY -= pNMUpDown->iDelta;
	if( m_nPenOffsetY < 0 )
		m_nPenOffsetY = 0;
	if( m_nPenOffsetY > MAX_PEN_V_OFFSET )
		m_nPenOffsetY = MAX_PEN_V_OFFSET;

	SetDlgItemInt( IDC_MOUSE_PENVERTOFFSET, m_nPenOffsetY, FALSE );

	*pResult = 0;
} /* #OF# CMouseDlg::OnDeltaposPenVertSpin */

/*========================================================
Method   : CMouseDlg::OnKillfocusPenVertOffset
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Pen Vert Offset edit */
void
/* #AS#
   Nothing */
CMouseDlg::
OnKillfocusPenVertOffset()
{
	BOOL bTrans;
	int  nPenOffsetY = GetDlgItemInt( IDC_MOUSE_PENVERTOFFSET, &bTrans, FALSE );

	if( bTrans )
	{
		m_nPenOffsetY = nPenOffsetY;
		if( m_nPenOffsetY < 0 )
			m_nPenOffsetY = 0;
		if( m_nPenOffsetY > MAX_PEN_V_OFFSET )
			m_nPenOffsetY = MAX_PEN_V_OFFSET;
	}
	if( !bTrans || nPenOffsetY < 0 || nPenOffsetY > MAX_PEN_V_OFFSET )
		SetDlgItemInt( IDC_MOUSE_PENVERTOFFSET, m_nPenOffsetY, FALSE );
} /* #OF# CMouseDlg::OnKillfocusPenVertOffset */

/*========================================================
Method   : CMouseDlg::OnSelchangeEmulatedDevice
=========================================================*/
/* #FN#
   */
void
/* #AS#
   Nothing */
CMouseDlg::
OnSelchangeEmulatedDevice()
{
	CComboBox *pDevice = (CComboBox *)GetDlgItem( IDC_MOUSE_EMULATEDDEVICE );
	ASSERT(pDevice);
	m_nMouseMode = pDevice->GetCurSel();

	SetDlgState();
} /* #OF# CMouseDlg::OnSelchangeEmulatedDevice */

/*========================================================
Method   : CMouseDlg::OnSelchangeStickPort
=========================================================*/
/* #FN#
   */
void
/* #AS#
   Nothing */
CMouseDlg::
OnSelchangeStickPort()
{
	CComboBox *pPort = (CComboBox *)GetDlgItem( IDC_MOUSE_STICKPORT );
	ASSERT(pPort);
	m_nMousePort = pPort->GetCurSel();
} /* #OF# CMouseDlg::OnSelchangeStickPort */

/*========================================================
Method   : CMouseDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CMouseDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	switch( nCtrlID )
	{
		case IDC_MOUSE_PADDLERANGE:
			OnKillfocusPaddleRange();
			break;
		case IDC_MOUSE_MOUSESPEED:
			OnKillfocusMouseSpeed();
			break;
		case IDC_MOUSE_JOYSTICKINERTIA:
			OnKillfocusJoystickInertia();
			break;
		case IDC_MOUSE_PENHORZOFFSET:
			OnKillfocusPenHorzOffset();
			break;
		case IDC_MOUSE_PENVERTOFFSET:
			OnKillfocusPenVertOffset();
			break;
	}
} /* #OF# CMouseDlg::ReceiveFocused */

/*========================================================
Method   : CMouseDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CMouseDlg::
OnOK() 
{
	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_nMouseMode != g_Input.Mouse.nMode )
	{
		g_Input.Mouse.nMode = m_nMouseMode;
		WriteRegDWORD( NULL, REG_MOUSE_MODE, g_Input.Mouse.nMode );

		/* Enable/disable pen emulation in antic.c */
		light_pen_enabled = (BOOL)(MOUSE_PEN == g_Input.Mouse.nMode);

		/* Update main window's indicator */
		m_pFrameWindow->UpdateIndicator( ID_INDICATOR_MSE );
	}
	if( m_nMousePort != g_Input.Mouse.nPort )
	{
		g_Input.Mouse.nPort = m_nMousePort;
		WriteRegDWORD( NULL, REG_MOUSE_PORT, g_Input.Mouse.nPort );
	}
	if( m_nMouseSpeed != g_Input.Mouse.nMouseSpeed )
	{
		g_Input.Mouse.nMouseSpeed = m_nMouseSpeed;
		WriteRegDWORD( NULL, REG_MOUSE_SPEED, g_Input.Mouse.nMouseSpeed );
	}
	if( m_nPaddleRange != g_Input.Mouse.nPaddleRange )
	{
		g_Input.Mouse.nPaddleRange = m_nPaddleRange;
		WriteRegDWORD( NULL, REG_PADDLE_RANGE, g_Input.Mouse.nPaddleRange );
	}
	if( m_nJoyInertia != g_Input.Mouse.nJoyInertia )
	{
		g_Input.Mouse.nJoyInertia = m_nJoyInertia;
		WriteRegDWORD( NULL, REG_JOY_INERTIA, g_Input.Mouse.nJoyInertia );
	}
	if( m_nPenOffsetX != g_Input.Mouse.nPenOffsetX )
	{
		g_Input.Mouse.nPenOffsetX = m_nPenOffsetX;
		WriteRegDWORD( NULL, REG_PEN_XOFFSET, g_Input.Mouse.nPenOffsetX );
	}
	if( m_nPenOffsetY != g_Input.Mouse.nPenOffsetY )
	{
		g_Input.Mouse.nPenOffsetY = m_nPenOffsetY;
		WriteRegDWORD( NULL, REG_PEN_YOFFSET, g_Input.Mouse.nPenOffsetY );
	}

	if( m_ulMiscState != g_Misc.ulState )
	{
		if( g_Misc.ulState & MS_MOUSE_CAPTURED ^
			m_ulMiscState & MS_MOUSE_CAPTURED )
		{
			Input_ToggleMouseCapture();

			/* Update main window's indicator */
			m_pFrameWindow->UpdateIndicator( ID_INDICATOR_MSE );
		}
		g_Misc.ulState = m_ulMiscState;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_Misc.ulState );
	}
	CCommonDlg::OnOK();
} /* #OF# CMouseDlg::OnOK */
