/****************************************************************************
File    : KeysetGKDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CKeysetGKDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 01.10.2000
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "KeysetGKDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static objects

static char *s_apszGetkeyTexts[ NUM_KBJOY_KEYS ] =
{
	"NorthWest",
	"North",
	"NorthEast",
	"East",
	"SouthEast",
	"South",
	"SouthWest",
	"West",
	"Centre",
	"Fire"
};

BYTE s_anRegKeys[ 256 ] = /* Regular keys table */
{
/*000*/ 0, 0, 0, 0, 0, 0, 0, 0, VK_BACK, VK_TAB, 0, 0, 0, VK_RETURN, 0, 0,
/*016*/ VK_SHIFT, VK_CONTROL, VK_MENU, VK_PAUSE, VK_CAPITAL, 0, 0, 0, 0, 0, 0, VK_ESCAPE, 0, 0, 0, 0,
/*032*/ VK_SPACE, 0, 0, 0, 0, 0, 0, 0, 0, 0, VK_PRINT, 0, 0, 0, 0, VK_HELP,
/*048*/ 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0,		// 0 1 2 3 4 5 6 7 8 9
/*064*/ 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,	// A B C D E F G H I J K L M N O
/*080*/ 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0,		// P Q R S T U V W X Y Z
/*096*/ VK_NUMPAD0, VK_NUMPAD1, VK_NUMPAD2, VK_NUMPAD3, VK_NUMPAD4, VK_NUMPAD5, VK_NUMPAD6, VK_NUMPAD7, VK_NUMPAD8, VK_NUMPAD9, VK_MULTIPLY, VK_ADD, 0, VK_SUBTRACT, VK_DECIMAL, 0,
/*112*/ VK_F1, VK_F2, VK_F3, VK_F4, VK_F5, VK_F6, VK_F7, VK_F8, VK_F9, VK_F10, VK_F11, VK_F12, VK_F13, VK_F14, VK_F15, VK_F16,
/*128*/ VK_F17, VK_F18, VK_F19, VK_F20, VK_F21, VK_F22, VK_F23, VK_F24, 0, 0, 0, 0, 0, 0, 0, 0,
/*144*/ 0, VK_SCROLL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/*160*/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/*176*/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 186, 187, 188, 189, 190, 191,		// ; = , - . /
/*192*/ 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,				// `
/*208*/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 220, 221, 222, 0,			// [ \ ] '
/*224*/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/*240*/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


/////////////////////////////////////////////////////////////////////////////
// CKeysetGKDlg dialog

BEGIN_MESSAGE_MAP(CKeysetGKDlg, CDialog)
	//{{AFX_MSG_MAP(CKeysetGKDlg)
	ON_WM_KEYDOWN()
	ON_WM_GETDLGCODE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CKeysetGKDlg::
CKeysetGKDlg( WORD *pwKeyset,
			  int   nKeyIndex,
			  CWnd *pParent /*=NULL*/ )
	: CDialog( CKeysetGKDlg::IDD, pParent ),
	  m_pwKeyset( pwKeyset ),
	  m_nKeyIndex( nKeyIndex )
{
	//{{AFX_DATA_INIT(CKeysetGKDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void
CKeysetGKDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CKeysetGKDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CKeysetGKDlg message handlers

BOOL
CKeysetGKDlg::
OnInitDialog() 
{
	CString strLabel( "Press key for " );

	CDialog::OnInitDialog();

	SetWindowText( strLabel + s_apszGetkeyTexts[ m_nKeyIndex ] );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CKeysetGKDlg::
OnKeyDown( UINT nChar,
		   UINT nRepCnt,
		   UINT nFlags )
{
	BOOL bUsedKey = FALSE;

    /* Translate extended or filtrate regular codes */
	nChar = (nFlags & 0x100 ? g_Input.Key.anExtKeys[ nChar ] : s_anRegKeys[ nChar ]);

	if( nChar == VK_SHIFT && nFlags & 0x10 )
		nChar = VK_RSHIFT;

	if( nChar == VK_ESCAPE )
		nChar = 0;

	for( int i = 0; i < NUM_KBJOY_KEYS; i++ )
		if( nChar && m_nKeyIndex != i &&
			nChar == m_pwKeyset[ i ] )
		{
			bUsedKey = TRUE;
			break;
		}

	if( bUsedKey )
	{
		DisplayMessage( GetSafeHwnd(), IDS_WARN_KEY_CONFLICT, 0, MB_ICONWARNING | MB_OK, s_apszGetkeyTexts[ i ] );
	}
	else
		m_pwKeyset[ m_nKeyIndex ] = nChar;

	EndDialog( IDOK );
}

UINT
CKeysetGKDlg::
OnGetDlgCode()
{
	return DLGC_WANTALLKEYS;
}
