/****************************************************************************
File    : JoystickDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CJoystickDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 29.01.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "MainFrame.h"
#include "KeysetDlg.h"
#include "WarningDlg.h"
#include "Helpers.h"
#include "JoystickDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_JOYSTICK_FIRST		IDC_JOYSTICK_PORT
#define IDC_JOYSTICK_LAST		IDC_JOYSTICK_CANCEL

static DWORD s_dwStickIds[ MAX_ATARI_JOYPORTS ] =
{
	IDC_JOYSTICK_STICK1,
	IDC_JOYSTICK_STICK2,
	IDC_JOYSTICK_STICK3,
	IDC_JOYSTICK_STICK4
};

static DWORD s_dwAfireIds[ MAX_ATARI_JOYPORTS ] =
{
	IDC_JOYSTICK_AUTOFIRE1,
	IDC_JOYSTICK_AUTOFIRE2,
	IDC_JOYSTICK_AUTOFIRE3,
	IDC_JOYSTICK_AUTOFIRE4
};


/////////////////////////////////////////////////////////////////////////////
// CJoystickDlg dialog

BEGIN_MESSAGE_MAP(CJoystickDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CJoystickDlg)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_STICK1, OnSelchangeStick1)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_STICK2, OnSelchangeStick2)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_STICK3, OnSelchangeStick3)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_STICK4, OnSelchangeStick4)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_STICK, OnSelchangeStick)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_PORT, OnSelchangePort)
	ON_BN_CLICKED(IDC_JOYSTICK_AUTOFIRE1, OnAutofire1)
	ON_BN_CLICKED(IDC_JOYSTICK_AUTOFIRE2, OnAutofire2)
	ON_BN_CLICKED(IDC_JOYSTICK_AUTOFIRE3, OnAutofire3)
	ON_BN_CLICKED(IDC_JOYSTICK_AUTOFIRE4, OnAutofire4)
	ON_BN_CLICKED(IDC_JOYSTICK_AUTOFIRE, OnAutofire)
	ON_BN_CLICKED(IDC_JOYSTICK_KEYSET_A, OnKeysetA)
	ON_BN_CLICKED(IDC_JOYSTICK_KEYSET_B, OnKeysetB)
	ON_BN_CLICKED(IDC_JOYSTICK_BUTTONSFIRE, OnButtonsFire)
	ON_BN_CLICKED(IDC_JOYSTICK_RECENTERSTICK, OnRecenterStick)
	ON_BN_CLICKED(IDC_JOYSTICK_ALLOWOPPOSITEKEYS, OnAllowOppositeKeys)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_AUTOFIREMODE, OnSelchangeAutofireMode)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_JOYSTICK_OK, OnOK)
	ON_BN_CLICKED(IDC_JOYSTICK_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()


CJoystickDlg::
CJoystickDlg(
	CWnd *pParent /*=NULL*/
)
	: CCommonDlg( (g_Screen.ulMode & SM_ATTR_SMALL_DLG ? IDD_JOYSTICK_SMALL : CJoystickDlg::IDD), pParent )
{
	//{{AFX_DATA_INIT(CJoystickDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_pFrameWindow = (CMainFrame *)pParent;
	m_nFirstCtrl   = IDC_JOYSTICK_FIRST;
	m_nLastCtrl    = IDC_JOYSTICK_LAST;
}


void
CJoystickDlg::
DoDataExchange(
	CDataExchange *pDX
)
{
	CCommonDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CJoystickDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg implementation

/*========================================================
Method   : CJoystickDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CJoystickDlg::
SetDlgState()
{
	CComboBox *pCombo  = NULL;
	CButton	  *pButton = NULL;
	int i, j;

	for( i = 0; i < MAX_ATARI_JOYPORTS; i++ )
	{
		pCombo = (CComboBox *)GetDlgItem( m_bSmallMode ? IDC_JOYSTICK_STICK : s_dwStickIds[ i ] );
		ASSERT(pCombo);
		pCombo->ResetContent();

		/* Keyboard input */
		pCombo->AddString( "Numpad" );
		pCombo->AddString( "Arrows + RCtrl as fire" );
		pCombo->AddString( "Keyset A" );
		pCombo->AddString( "Keyset B" );

		/* Available input devices */
		for( j = 0; j < g_Input.nDevFoundNum; j++ )
			pCombo->AddString( g_Input.acDevNames[ j ] );

		/* No input device */
		pCombo->AddString( "None" );

		if(	m_anDevSelected[ i ] != NO_JOYSTICK )
		{
			pCombo->SetCurSel( m_anDevSelected[ i ] + NUM_KBJOY_DEVICES );
		}
		else
			pCombo->SetCurSel( g_Input.nDevFoundNum + NUM_KBJOY_DEVICES );

		if( m_ulAutoSticks & (1 << i) )
		{
			pButton = (CButton *)GetDlgItem( m_bSmallMode ? IDC_JOYSTICK_AUTOFIRE : s_dwAfireIds[ i ] );
			ASSERT(pButton);
			pButton->SetCheck( TRUE );
		}
		if( m_bSmallMode )
		{
			pCombo = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORT );
			ASSERT(pCombo);
			pCombo->SetCurSel( 0 );

			/* There is one combo only in a small version of the window */
			break;
		}
	}
	pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_RECENTERSTICK );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulMiscState & MS_STICK_RELEASE) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_BUTTONSFIRE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulMiscState & MS_JOY_FIRE_ONLY) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_ALLOWOPPOSITEKEYS );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulMiscState & MS_ALLOW_OPPOSITE_KEYS) != 0 );

	pCombo = (CComboBox *)GetDlgItem( IDC_JOYSTICK_AUTOFIREMODE );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nAutoMode );
}


/////////////////////////////////////////////////////////////////////////////
// CJoystickDlg message handlers

/*========================================================
Method   : CJoystickDlg::OnInitDialog
=========================================================*/
BOOL
CJoystickDlg::
OnInitDialog()
{
	CCommonDlg::OnInitDialog();

	m_ulMiscState  = g_Misc.ulState;
	m_ulAutoSticks = g_Input.Joy.ulAutoSticks;
	m_nAutoMode    = g_Input.Joy.nAutoMode;

	m_bSmallMode = g_Screen.ulMode & SM_ATTR_SMALL_DLG;

	for( int i = 0; i < MAX_ATARI_JOYPORTS; i++ )
		m_anDevSelected[ i ] = g_Input.anDevSelected[ i ];

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

/*========================================================
Method   : CJoystickDlg::OnSelchangePort
=========================================================*/
void
CJoystickDlg::
OnSelchangePort()
{
	CComboBox *pStick  = NULL;
	CComboBox *pPort   = NULL;
	CButton   *pButton = NULL;
	int	nStickNum = 0;

	pStick = (CComboBox *)GetDlgItem( IDC_JOYSTICK_STICK );
	ASSERT(pStick);
	pPort = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORT );
	ASSERT(pPort);

	if( (nStickNum = pPort->GetCurSel()) == CB_ERR )
		pPort->SetCurSel( 0 );

	if(	m_anDevSelected[ nStickNum ] != NO_JOYSTICK )
	{
		/* Set an appropriate device if any has been selected */
		pStick->SetCurSel( m_anDevSelected[ nStickNum ] + NUM_KBJOY_DEVICES );
	}
	else
		pStick->SetCurSel( g_Input.nDevFoundNum + NUM_KBJOY_DEVICES );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_AUTOFIRE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulAutoSticks & (1 << nStickNum)) != 0 );
}

/*========================================================
Method   : CJoystickDlg::OnSelchangeStick
=========================================================*/
void
CJoystickDlg::
OnSelchangeStick()
{
	CComboBox *pPort = NULL;
	int	nStickNum = 0;

	pPort = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORT );
	ASSERT(pPort);

	if( (nStickNum = pPort->GetCurSel()) == CB_ERR )
		pPort->SetCurSel( 0 );

	SelchangeStick( nStickNum );
}

/*========================================================
Method   : CJoystickDlg::OnSelchangeStick1
=========================================================*/
void
CJoystickDlg::
OnSelchangeStick1()
{
	SelchangeStick( 0 );
}

/*========================================================
Method   : CJoystickDlg::OnSelchangeStick2
=========================================================*/
void
CJoystickDlg::
OnSelchangeStick2()
{
	SelchangeStick( 1 );
}

/*========================================================
Method   : CJoystickDlg::OnSelchangeStick3
=========================================================*/
void
CJoystickDlg::
OnSelchangeStick3()
{
	SelchangeStick( 2 );
}

/*========================================================
Method   : CJoystickDlg::OnSelchangeStick4
=========================================================*/
void
CJoystickDlg::
OnSelchangeStick4()
{
	SelchangeStick( 3 );
}

/*========================================================
Method   : CJoystickDlg::SelchangeStick
=========================================================*/
void
CJoystickDlg::
SelchangeStick(
	int nStickNum
)
{
	CComboBox *pStick1 = (CComboBox *)GetDlgItem( m_bSmallMode ? IDC_JOYSTICK_STICK : s_dwStickIds[ nStickNum ] );
	CComboBox *pStick2 = NULL;
	int	       nJoy;

	ASSERT(pStick1);

	/* Get the joystick selection */
	if( CB_ERR == (nJoy = pStick1->GetCurSel()) )
		return;

	if( nJoy <= g_Input.nDevFoundNum + NUM_KBJOY_DEVICES - 1  /* Zero based index */ )
	{
		nJoy -= NUM_KBJOY_DEVICES;

		for( int i = 0; i < MAX_ATARI_JOYPORTS; i++ )
		{
			if( (nJoy == m_anDevSelected[ i ]) && i != nStickNum )
			{
				if( IDYES == DisplayMessage( GetSafeHwnd(), IDS_WARN_STICK_CONFLICT, 0, MB_ICONQUESTION | MB_YESNO, i + 1, nStickNum + 1 ) )
				{
					if( !m_bSmallMode )
					{
						pStick2 = (CComboBox *)GetDlgItem( s_dwStickIds[ i ] );
						ASSERT(pStick2);
						pStick2->SetCurSel( g_Input.nDevFoundNum + NUM_KBJOY_DEVICES );
					}
					m_anDevSelected[ i ] = NO_JOYSTICK;
				}
				else
					nJoy = m_anDevSelected[ nStickNum ];

				/* There may be only one the same device associated
				   to a port, break */
				break;
			}
		}
	}
	else
		nJoy = NO_JOYSTICK;

	/* Set the selected device to use */
	m_anDevSelected[ nStickNum ] = nJoy;
	/* Synchronize a device combo box */
	pStick1->SetCurSel( (NO_JOYSTICK == nJoy ? g_Input.nDevFoundNum : nJoy) + NUM_KBJOY_DEVICES );
}

void
CJoystickDlg::
OnAutofire()
{
	CComboBox *pPort = NULL;
	int	nStickNum = 0;

	pPort = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORT );
	ASSERT(pPort);

	if( (nStickNum = pPort->GetCurSel()) == CB_ERR )
		pPort->SetCurSel( 0 );

	Autofire( nStickNum );
}

void
CJoystickDlg::
OnAutofire1()
{
	Autofire( 0 );
}

void
CJoystickDlg::
OnAutofire2()
{
	Autofire( 1 );
}

void
CJoystickDlg::
OnAutofire3()
{
	Autofire( 2 );
}

void
CJoystickDlg::
OnAutofire4()
{
	Autofire( 3 );
}

void
CJoystickDlg::
Autofire(
	int nStickNum
)
{
	CButton *pButton = (CButton *)GetDlgItem( m_bSmallMode ? IDC_JOYSTICK_AUTOFIRE : s_dwAfireIds[ nStickNum ] );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulAutoSticks |=  (1 << nStickNum);
	else
		m_ulAutoSticks &= ~(1 << nStickNum);
}

void
CJoystickDlg::
OnSelchangeAutofireMode()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_JOYSTICK_AUTOFIREMODE );
	ASSERT(pCombo != NULL);
	m_nAutoMode = pCombo->GetCurSel();
}

/*========================================================
Method   : CJoystickDlg::OnKeysetA
=========================================================*/
void
CJoystickDlg::
OnKeysetA()
{
	CKeysetDlg dlgKeyset;

	int nResult = IDOK;
	if( !(g_Misc.ulDontShow & DONT_SHOW_KBJOY_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARN_KBJOY, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_KBJOY_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		dlgKeyset.SetTitlePostfix( " A" );
		dlgKeyset.SetCurrentKeyset( KEYS_A_JOYSTICK + NUM_KBJOY_DEVICES );
		dlgKeyset.DoModal();
	}
}

/*========================================================
Method   : CJoystickDlg::OnKeysetB
=========================================================*/
void
CJoystickDlg::
OnKeysetB()
{
	CKeysetDlg dlgKeyset;

	int nResult = IDOK;
	if( !(g_Misc.ulDontShow & DONT_SHOW_KBJOY_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARN_KBJOY, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_KBJOY_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		dlgKeyset.SetTitlePostfix( " B" );
		dlgKeyset.SetCurrentKeyset( KEYS_B_JOYSTICK + NUM_KBJOY_DEVICES );
		dlgKeyset.DoModal();
	}
}

/*========================================================
Method   : CJoystickDlg::OnRecenterStick
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Recenter check box */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnRecenterStick()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_RECENTERSTICK );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulMiscState |= MS_STICK_RELEASE;
	else
		m_ulMiscState &= ~MS_STICK_RELEASE;
} /* #OF# CJoystickDlg::OnRecenterStick */

/*========================================================
Method   : CJoystickDlg::OnButtonsFire
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Don't Assign Buttons check box */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnButtonsFire()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_BUTTONSFIRE );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulMiscState |= MS_JOY_FIRE_ONLY;
	else
		m_ulMiscState &= ~MS_JOY_FIRE_ONLY;
} /* #OF# CJoystickDlg::OnButtonsFire */

/*========================================================
Method   : CJoystickDlg::OnAllowOppositeKeys
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Don't Assign Buttons check box */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnAllowOppositeKeys()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_ALLOWOPPOSITEKEYS );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulMiscState |= MS_ALLOW_OPPOSITE_KEYS;
	else
		m_ulMiscState &= ~MS_ALLOW_OPPOSITE_KEYS;
} /* #OF# CJoystickDlg::OnAllowOppositeKeys */


/*========================================================
Method   : CJoystickDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnOK()
{
	BOOL bChanged = FALSE;

	if( m_ulMiscState != g_Misc.ulState )
	{
		g_Misc.ulState = m_ulMiscState;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_Misc.ulState );
	}
	if( m_nAutoMode != g_Input.Joy.nAutoMode )
	{
		g_Input.Joy.nAutoMode = m_nAutoMode;
		WriteRegDWORD( NULL, REG_AUTOFIRE_MODE, g_Input.Joy.nAutoMode );

		/* Update main window's indicator */
		m_pFrameWindow->UpdateIndicator( ID_INDICATOR_JOY );
	}
	if( m_ulAutoSticks != g_Input.Joy.ulAutoSticks )
	{
		g_Input.Joy.ulAutoSticks = m_ulAutoSticks;
		WriteRegDWORD( NULL, REG_AUTOFIRE_STICKS, g_Input.Joy.ulAutoSticks );
	}

	for( int i = 0; i < MAX_ATARI_JOYPORTS; i++ )
	{
		if( m_anDevSelected[ i ] != g_Input.anDevSelected[ i ] )
			bChanged = TRUE;
	}
	if( bChanged )
	{
		g_Input.Joy.ulSelected  = (ULONG)((UBYTE)m_anDevSelected[ 3 ]) << 24;
		g_Input.Joy.ulSelected |= (ULONG)((UBYTE)m_anDevSelected[ 2 ]) << 16;
		g_Input.Joy.ulSelected |= (ULONG)((UBYTE)m_anDevSelected[ 1 ]) << 8;
		g_Input.Joy.ulSelected |= (ULONG)((UBYTE)m_anDevSelected[ 0 ]);

		WriteRegDWORD( NULL, REG_JOYSTICKS, g_Input.Joy.ulSelected );
	}
	Input_Initialise( bChanged );

	CCommonDlg::OnOK();
} /* #OF# CJoystickDlg::OnOK */
