/****************************************************************************
File    : GraphicsAdvDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CGraphicsAdvDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 31.03.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "Helpers.h"
#include "GraphicsAdvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_GRAPHICSADV_FIRST		IDC_GRAPHICSADV_PRIMARY
#define IDC_GRAPHICSADV_LAST		IDC_GRAPHICSADV_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsAdvDlg, CCommonDlg)
	//{{AFX_MSG_MAP(CGraphicsAdvDlg)
	ON_BN_CLICKED(IDC_GRAPHICSADV_PRIMARY, OnPrimary)
	ON_BN_CLICKED(IDC_GRAPHICSADV_WAITVBL, OnWaitVbl)
	ON_BN_CLICKED(IDC_GRAPHICSADV_FLIP, OnFlip)
	ON_BN_CLICKED(IDC_GRAPHICSADV_SYNCBLIT, OnSyncBlit)
	ON_BN_CLICKED(IDC_GRAPHICSADV_SAFEMODE, OnSafeMode)
	ON_CBN_SELCHANGE(IDC_GRAPHICSADV_MEMORYTYPE, OnSelchangeMemoryType)
	ON_CBN_SELCHANGE(IDC_GRAPHICSADV_BLITEFFECTS, OnSelchangeBlitEffects)
	ON_BN_CLICKED(IDC_GRAPHICSADV_OPTIMIZEPRO, OnOptimizePro)
	ON_BN_CLICKED(IDC_GRAPHICSADV_USEMMX, OnUseMMX)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_GRAPHICSADV_OK, OnOK)
	ON_BN_CLICKED(IDC_GRAPHICSADV_CANCEL, CCommonDlg::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CGraphicsAdvDlg::CGraphicsAdvDlg
=========================================================*/
/* #FN#
   Standard constructor */
CGraphicsAdvDlg::
CGraphicsAdvDlg(
	ULONG *pScreenMode,      /* #IN# Pointer to screen mode flags  */
	int   *pMemoryType,      /* #IN# Pointer to memory type switch */
	CWnd  *pParent /*=NULL*/ /* #IN# Pointer to the parent window  */
)
	: CCommonDlg( CGraphicsAdvDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	ASSERT(pScreenMode);

	m_pScreenMode = pScreenMode;
	m_pMemoryType = pMemoryType;
	m_nFirstCtrl  = IDC_GRAPHICSADV_FIRST;
	m_nLastCtrl   = IDC_GRAPHICSADV_LAST;
} /* #OF# CGraphicsAdvDlg::CGraphicsAdvDlg */

/*========================================================
Method   : CGraphicsAdvDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
CGraphicsAdvDlg::
DoDataExchange(
	CDataExchange *pDX
)
{
	CCommonDlg::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CGraphicsAdvDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg implementation

/*========================================================
Method   : CGraphicsAdvDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
SetDlgState()
{
	CComboBox *pCombo  = NULL;
	ULONG      ulIndex = (m_ulScreenMode >> 28) & 0x0f; 

	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDVBL_WAIT) != 0 );
//	pCombo->EnableWindow( !(m_ulScreenMode & SM_OPTN_FLIP_BUFFERS) );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDBLT_WAIT) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SAFEMODE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_SAFE_MODE) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_OPTIMIZEPRO );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_OPTIMIZE_PRO) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_USEMMX );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_MMX) != 0 );
	pButton->EnableWindow( g_Misc.unSystemInfo & SYS_PRC_MMX );

	/* Set the memory type combo */
	pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_MEMORYTYPE );
	ASSERT(pCombo);
	pCombo->SetCurSel( m_nMemoryType );

	CheckRadioButton( IDC_GRAPHICSADV_PRIMARY, IDC_GRAPHICSADV_FLIP,
		m_ulScreenMode & SM_OPTN_FLIP_BUFFERS ?
		IDC_GRAPHICSADV_FLIP : IDC_GRAPHICSADV_PRIMARY );
	
	pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_BLITEFFECTS );
	ASSERT(pCombo);
	for( int i = 0; i < BLIT_EFFECTS_NO; i++ )
		if( ulIndex & (1 << i) )
		{
			pCombo->SetCurSel( i + 1 );
			break;
		}
	if( i == BLIT_EFFECTS_NO )
		pCombo->SetCurSel( 0 );
} /* #OF# CGraphicsAdvDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg message handlers

/*========================================================
Method   : CGraphicsAdvDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CGraphicsAdvDlg::
OnInitDialog() 
{
	CCommonDlg::OnInitDialog();

	m_ulScreenMode = *m_pScreenMode;
	m_nMemoryType  = *m_pMemoryType;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CGraphicsAdvDlg::OnInitDialog */

/*========================================================
Method   : CGraphicsAdvDlg::OnPrimary
=========================================================*/
/* #FN#
   Turns the Flipped Buffers off */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnPrimary()
{
//	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
//	ASSERT(pButton);
//	pButton->EnableWindow( TRUE );

	m_ulScreenMode &= ~SM_OPTN_FLIP_BUFFERS;
} /* #OF# CGraphicsAdvDlg::OnPrimary */

/*========================================================
Method   : CGraphicsAdvDlg::OnFlip
=========================================================*/
/* #FN#
   Turns the Flipped Buffers on */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnFlip()
{
//	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
//	ASSERT(pButton);
//	pButton->EnableWindow( FALSE );

	m_ulScreenMode |= SM_OPTN_FLIP_BUFFERS;
} /* #OF# CGraphicsAdvDlg::OnFlip */

/*========================================================
Method   : CGraphicsAdvDlg::OnWaitVbl
=========================================================*/
/* #FN#
   Turns on/off the Wait for VBI flag */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnWaitVbl()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);

	int nCheckState = pButton->GetCheck();
	if( nCheckState && !(g_Misc.ulDontShow & DONT_SHOW_VBLWAIT_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg dlgWarning;

		LoadString( NULL, IDS_WARN_VBL_WAIT, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_VBLWAIT_WARN;
		dlgWarning.m_bCancel     = FALSE;
		dlgWarning.DoModal();
	}
	if( nCheckState )
		m_ulScreenMode |= SM_OPTN_DDVBL_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDVBL_WAIT;
} /* #OF# CGraphicsAdvDlg::OnWaitVbl */

/*========================================================
Method   : CGraphicsAdvDlg::OnSyncBlit
=========================================================*/
/* #FN#
   Turns on/off the Synchronous Blits flag */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSyncBlit()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_DDBLT_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDBLT_WAIT;
} /* #OF# CGraphicsAdvDlg::OnSyncBlit */

/*========================================================
Method   : CGraphicsAdvDlg::OnSafeMode
=========================================================*/
/* #FN#
   Turns on/off the Synchronous Blits flag */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSafeMode()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SAFEMODE );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_SAFE_MODE;
	else
		m_ulScreenMode &= ~SM_OPTN_SAFE_MODE;
} /* #OF# CGraphicsAdvDlg::OnSafeMode */

/*========================================================
Method   : CGraphicsAdvDlg::OnOptimizePro
=========================================================*/
/* #FN#
   Turns on/off the Pentium Pro support */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnOptimizePro()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_OPTIMIZEPRO );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_OPTIMIZE_PRO;
	else
		m_ulScreenMode &= ~SM_OPTN_OPTIMIZE_PRO;
} /* #OF# CGraphicsAdvDlg::OnOptimizePro */

/*========================================================
Method   : CGraphicsAdvDlg::OnUseMMX
=========================================================*/
/* #FN#
   Turns on/off the MMX support */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnUseMMX()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_USEMMX );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_USE_MMX;
	else
		m_ulScreenMode &= ~SM_OPTN_USE_MMX;
} /* #OF# CGraphicsAdvDlg::OnUseMMX */

/*========================================================
Method   : CGraphicsAdvDlg::OnSelchangeMemoryType
=========================================================*/
/* #FN#
   Allows to choose System/AGP/video memory for DDraw offscreen surfaces */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSelchangeMemoryType()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_MEMORYTYPE );
	ASSERT(pCombo);

	m_nMemoryType = pCombo->GetCurSel();
} /* #OF# CGraphicsAdvDlg::OnSelchangeMemoryType */

void
CGraphicsAdvDlg::
OnSelchangeBlitEffects()
{
	DWORD dwSMFxFlags[ BLIT_EFFECTS_NO ] = {
		SM_DDFX_MIRRORLEFTRIGHT,
		SM_DDFX_MIRRORUPDOWN,
		SM_DDFX_NOTEARING };

	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_BLITEFFECTS );
	ASSERT(pCombo);
	int nSelection = pCombo->GetCurSel();

	if( CB_ERR == nSelection )
		return;

	m_ulScreenMode &= ~SM_DDFX_MASK;
	if( nSelection > 0 )
	{
		m_ulScreenMode |= dwSMFxFlags[ nSelection - 1 ];
	}
}

/*========================================================
Method   : CGraphicsAdvDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnOK()
{
	if( m_ulScreenMode != *m_pScreenMode )
		*m_pScreenMode = m_ulScreenMode;

	if( m_nMemoryType != *m_pMemoryType )
		*m_pMemoryType = m_nMemoryType;

	CCommonDlg::OnOK();
} /* #OF# CGraphicsAdvDlg::OnOK */
