/****************************************************************************
File    : BootTypeDlg.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# CBootTypeDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 08.05.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "BootTypeDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CBootTypeDlg dialog

BEGIN_MESSAGE_MAP(CBootTypeDlg, CDialog)
	//{{AFX_MSG_MAP(CBootTypeDlg)
	ON_BN_CLICKED(IDC_BOOTTYPE_LOGICAL, OnLogical)
	ON_BN_CLICKED(IDC_BOOTTYPE_PHYSICAL, OnPhysical)
	ON_BN_CLICKED(IDC_BOOTTYPE_SIO2PC, OnSio2Pc)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BOOTTYPE_OK, OnOK)
	ON_BN_CLICKED(IDC_BOOTTYPE_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CBootTypeDlg::CBootTypeDlg
=========================================================*/
/* #FN#
   Standard constructor */
CBootTypeDlg::
CBootTypeDlg(
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to the parent window */
)
	: CDialog( CBootTypeDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CBootTypeDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CBootTypeDlg::CBootTypeDlg */

/*========================================================
Method   : CBootTypeDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CBootTypeDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CBootTypeDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CBootTypeDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CBootTypeDlg implementation

/*========================================================
Method   : CBootTypeDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CBootTypeDlg::
SetDlgState()
{
	char  szBuffer[ LOADSTRING_STRING_SIZE ];
	int   nCtrlID = 0;
	CWnd *pWnd    = NULL;

	switch( m_btSelOpt )
	{
		case Logical:
			LoadString( NULL, IDS_BOOT_DESC_LOGICAL, szBuffer, LOADSTRING_STRING_SIZE );
			nCtrlID = IDC_BOOTTYPE_LOGICAL;
			break;

		case Physical:
			LoadString( NULL, IDS_BOOT_DESC_PHYSICAL, szBuffer, LOADSTRING_STRING_SIZE );
			nCtrlID = IDC_BOOTTYPE_PHYSICAL;
			break;

		case Sio2Pc:
			LoadString( NULL, IDS_BOOT_DESC_SIO2PC, szBuffer, LOADSTRING_STRING_SIZE );
			nCtrlID = IDC_BOOTTYPE_SIO2PC;
			break;
	}
	/* Set appropriate radio button */
	CheckRadioButton( IDC_BOOTTYPE_LOGICAL, IDC_BOOTTYPE_SIO2PC, nCtrlID );

	/* Set option description */
	pWnd = GetDlgItem( IDC_BOOTTYPE_DESCRIPTION );
	ASSERT(pWnd);
	pWnd->SetWindowText( szBuffer );
} /* #OF# CBootTypeDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CBootTypeDlg message handlers

/*========================================================
Method   : CBootTypeDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CBootTypeDlg::
OnInitDialog() 
{
	CWnd *pWnd = NULL;

	CDialog::OnInitDialog();

	m_btSelOpt = Logical;

	SetDlgState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CBootTypeDlg::OnInitDialog */

void
CBootTypeDlg::
OnLogical()
{
	m_btSelOpt = Logical;
	SetDlgState();
}

void
CBootTypeDlg::
OnPhysical()
{
	m_btSelOpt = Physical;
	SetDlgState();
}

void
CBootTypeDlg::
OnSio2Pc()
{
	m_btSelOpt = Sio2Pc;
	SetDlgState();
}

void
CBootTypeDlg::
OnOK() 
{
	CDialog::OnOK();
}
