/****************************************************************************
File    : Atari800Win.cpp
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Defines the class behaviors for the application.
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 24.01.2001
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Atari800WinDoc.h"
#include "Atari800WinView.h"
#include "MainFrame.h"
#include "Helpers.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static objects

static int s_nCmdIndex;


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinCommandLineInfo

/*========================================================
Method   : CAtari800WinCommandLineInfo::ParseParam
=========================================================*/
/* #FN#
   The framework calls this function to parse/interpret individual
   parameters from the command line */
void
/* #AS#
   Nothing */
CAtari800WinCommandLineInfo::
ParseParam(
	LPCSTR pszParam,
	BOOL   bFlag,
	BOOL   bLast
)
{
	LPSTR pszTmpParam = (LPSTR)pszParam;

	/* It would be nice to remember the long form of the file name... */
	if( strchr( pszTmpParam, '\\' ) )
	{
		WIN32_FIND_DATA fileData;
		HANDLE hFile = ::FindFirstFile( pszTmpParam, &fileData );

		if( INVALID_HANDLE_VALUE != hFile )
		{
			char szLongPath[ MAX_PATH ];

			::FindClose( hFile );
			::GetCurrentDirectory( MAX_PATH, szLongPath );
			strcat( szLongPath, "\\" );
			strcat( szLongPath, fileData.cFileName );
			/* Test what we have got, please */
			if( INVALID_HANDLE_VALUE != (hFile = ::FindFirstFile( szLongPath, &fileData )) )
			{
				::FindClose( hFile );
				/* OK, it seems to be correct */
				pszTmpParam = szLongPath;
			}
		}
	}
	g_argv[ g_argc ] = &g_szCmdLine[ s_nCmdIndex ];
	g_argc++;
	if( bFlag )
		g_szCmdLine[ s_nCmdIndex++ ] = '-';
	strcpy( &g_szCmdLine[ s_nCmdIndex ], pszTmpParam );
	s_nCmdIndex += strlen( &g_szCmdLine[ s_nCmdIndex ] ) + 1;

//	CCommandLineInfo::ParseParam( pszParam, bFlag, bLast );
} /* #OF# CAtari800WinCommandLineInfo::ParseParam */


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp

BEGIN_MESSAGE_MAP(CAtari800WinApp, CWinApp)
	//{{AFX_MSG_MAP(CAtari800WinApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard print setup command
//	ON_COMMAND(ID_FILE_PRINT_SETUP, OnFilePrintSetup)
END_MESSAGE_MAP()


/*========================================================
Method   : CAtari800WinApp::CAtari800WinApp
=========================================================*/
/* #FN#
   Standard constructor */
CAtari800WinApp::
CAtari800WinApp()
{
	m_nHWLoopCounter = 127;
	m_ulStartMeasure = timeGetTime();
	m_ulSpeed        = 0;
	m_bSPIPrevState  = FALSE;
} /* #OF# CAtari800WinApp::CAtari800WinApp */


/////////////////////////////////////////////////////////////////////////////
// The one and only CAtari800WinApp object

CAtari800WinApp theApp;


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp message handlers

/*========================================================
Method   : CAtari800WinApp::InitInstance
=========================================================*/
/* #FN#
   Instance initialization that runs each time a copy of the
   program runs */
BOOL
/* #AS#
   Nonzero if initialization is successful; otherwise 0 */
CAtari800WinApp::
InitInstance()
{
	char szHomeDir[ MAX_PATH ];
	HWND hAppWnd = NULL;

	g_hInstance = AfxGetInstanceHandle();

	/* We must prepare a DOS-style command line */
	g_argc = 1;
	g_argv[ 0 ] = g_szCmdLine;
	strcpy( g_szCmdLine, this->m_pszAppName );
	s_nCmdIndex = strlen( g_szCmdLine ) + 1;

	/* Parse command line for shell commands, DDE, file open */
	CAtari800WinCommandLineInfo cmdInfo;
	ParseCommandLine( cmdInfo );

	/* Needed for ROM searching when the Registry are not initialized */
	BuildCRCTable();
	/* Read the Registry stored values */
	if( HandleRegistry() )
	{
		BOOL bReboot = FALSE;
		/* This is the first time start-up, launch the Setup Wizard */
		if( !CMainFrame::LaunchWizard( NULL, bReboot ) )
		{
			DisplayMessage( NULL, IDS_WIZARD_TIP, 0, MB_ICONINFORMATION | MB_OK );
		}
	}
	/* Disable multiple instances? */
	if( g_Misc.ulState & MS_REUSE_WINDOW && (hAppWnd = Misc_FindAppWindow()) )
	{
		HANDLE hFileMap  = NULL;
		HWND   hPopupWnd = GetLastActivePopup( hAppWnd );

		BringWindowToTop( hAppWnd );
		if( IsIconic( hPopupWnd ) )
		{
			ShowWindow( hPopupWnd, SW_RESTORE );
		}
		else
			SetForegroundWindow( hPopupWnd );

		/* The current command line has to be sent to an active
		   instance of the emulator */
		if( NULL != (hFileMap = CreateFileMapping( INVALID_HANDLE_VALUE, NULL,
			PAGE_READWRITE, 0, s_nCmdIndex, "Atari800CmdLine" )) )
		{
			LPSTR pszMsg = (LPSTR)MapViewOfFile( hFileMap, FILE_MAP_WRITE, 0, 0, 0 );
			if( pszMsg )
			{
				CopyMemory( pszMsg, g_szCmdLine, s_nCmdIndex );
				UnmapViewOfFile( (LPCVOID)pszMsg );
				SendMessage( hAppWnd, WM_PLUS_CMDLINE, g_argc, s_nCmdIndex );
			}
			CloseHandle( hFileMap );
		}
		return FALSE;
	}
	/* Check Hight Performance Timer resolution */
	if( !Timer_Examine() )
	{
		DisplayMessage( NULL, IDS_ERROR_NO_HITIMER, 0, MB_ICONSTOP | MB_OK );
		return FALSE;
	}
	/* Get information about the system the emulator is running on */
	Misc_GetSystemInfo( &g_Misc.unSystemInfo );

	/* Install Low Level Keyboard Hook when running on NT */
	if( g_Misc.unSystemInfo & SYS_WIN_NT )
		Input_InstallKeyboardHook( TRUE );

	/* Enable menu underlines when mouse is used for accessing the options */
#if WINVER >= 0x0500
	if( g_Misc.unSystemInfo & SYS_WIN_NT5 )
	{
		BOOL bEnable = TRUE;
		SystemParametersInfo( SPI_GETMENUUNDERLINES, 0, &m_bSPIPrevState, 0 );
		SystemParametersInfo( SPI_SETMENUUNDERLINES, 0, (LPVOID)bEnable, 0 );
	}
#endif

	/* Standard initialization
	   If you are not using these features and wish to reduce the
	   size of your final executable, you should remove from the
	   following the specific initialization routines you do not need.
	*/

#ifdef _AFXDLL
	Enable3dControls();			/* Call this when using MFC in a shared DLL */
#else
	Enable3dControlsStatic();	/* Call this when linking to MFC statically */
#endif

	/* Register the application's document templates. Document templates
	   serve as the connection between documents, frame windows and views. */

	CSingleDocTemplate *pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CAtari800WinDoc),
		RUNTIME_CLASS(CMainFrame),       /* main SDI frame window */
		RUNTIME_CLASS(CAtari800WinView));
	AddDocTemplate(pDocTemplate);

	/* Dispatch commands specified on the command line */
	if( !ProcessShellCommand( cmdInfo ) )
		return FALSE;

	m_pMainWindow = (CMainFrame *)m_pMainWnd;
	/* Describe a current state of the emulator */
	m_pMainWindow->UpdateStatus( TRUE, -1, ID_INDICATOR_RUN, TRUE );

	/* The one and only window has been initialized, so show and update it */
	m_pMainWnd->ShowWindow( SW_SHOW );
	m_pMainWnd->UpdateWindow();

	/* For a variety of reasons it's better to set the current working
	   directory to where Atari800Win (the executable) is located */
	if( Misc_GetHomeDirectory( szHomeDir ) )
		SetCurrentDirectory( szHomeDir );

	/* Reset Loop Counter */
	ResetLoopCounter();

	return TRUE;
} /* #OF# CAtari800WinApp::InitInstance */

/*========================================================
Method   : CAtari800WinApp::InitInstance
=========================================================*/
/* #FN#
   Called by the framework from within the Run member function
   to exit this instance of the application */
int
/* #AS#
   The applications exit code; 0 indicates no errors, and
   values greater than 0 indicate an error */
CAtari800WinApp::
ExitInstance() 
{
#if WINVER >= 0x0500
	/* Disable menu underlines */
	if( g_Misc.unSystemInfo & SYS_WIN_NT5 )
		SystemParametersInfo( SPI_SETMENUUNDERLINES, 0, (LPVOID)m_bSPIPrevState, 0 );
#endif

	/* Uninstall Low Level Keyboard Hook */
	if( g_Misc.unSystemInfo & SYS_WIN_NT )
		Input_InstallKeyboardHook( FALSE );

	return CWinApp::ExitInstance();
} /* #OF# CAtari800WinApp::ExitInstance */

/*========================================================
Method   : CAtari800WinApp::OnFilePrintSetup
=========================================================*/
/* #FN#
   Handles execution of the File Print command */
void
/* #AS#
   Nothing */
CAtari800WinApp::
OnFilePrintSetup()
{
	CWinApp::OnFilePrintSetup();
	m_pMainWindow->CleanScreen();
} /* #OF# CAtari800WinApp::OnFilePrintSetup */


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp commands

/*========================================================
Method   : CAtari800WinApp::OnIdle
=========================================================*/
/* #FN#
   OnIdle is called in the default message loop when the
   applications message queue is empty */
BOOL
/* #AS#
   0 to indicate that no idle processing time is required */
CAtari800WinApp::
OnIdle(
	LONG lCount /* #IN# A counter incremented each time OnIdle is called
						when the applications message queue is empty */
)
{
	if( (g_Misc.ulState & MS_STOP_WHEN_NO_FOCUS &&
		g_ulAtariState & ATARI_NO_FOCUS) || ST_ATARI_STOPPED )
	{
		/* Give to the MFC chance to clean up the framework stuff */
		CWinApp::OnIdle( lCount );

		m_ulSpeed = 0L;
		/* Nothing to do at the moment */
		return FALSE;
	}
	else
	/* Calculate the emulation speed */
	if( 128 == ++m_nHWLoopCounter )
	{
		/* Full time for PAL would be 1280ms, for NTSC 1067ms */
		static const ULONG ulTimes[] = { 2560, 2134 };

		ULONG ulTotalTime = timeGetTime() - m_ulStartMeasure;

		m_ulSpeed = MulDiv( ulTimes[ default_tv_mode - 1 ], 100, ulTotalTime ? ulTotalTime : 1 );
		/* Display the emulation speed */
		m_pMainWindow->UpdateSpeed();

		m_ulStartMeasure = timeGetTime();
		m_nHWLoopCounter = 0;
	}

	/* Do the emulation work */
	if( g_ulAtariState & ATARI_RUNNING )
	{
		int nRefreshRate = (ST_DOUBLE_REFRESH ? g_nDoubleRate : refresh_rate);

		/* The "Hide pointer..." option and the mouse emulation need this */
		Input_UpdateMouseState();

		Atari_Keyboard();
		Input_GetJoystick();

		draw_display = 1;
		if( g_Misc.ulState & MS_NO_COLLISIONS && g_nTestVal != nRefreshRate - 1 )
			draw_display = 0;

		ANTIC_RunDisplayList(); /* Generate screen */
		
		Atari_PlaySound();

		if( ++g_nTestVal == nRefreshRate )
		{
			Atari_DisplayScreen( (UBYTE *)atari_screen );
			nframes++; /* For autofire */

			g_nTestVal = 0;
		}
		Timer_WaitForVBI();
	}
	return TRUE;
} /* #OF# CAtari800WinApp::OnIdle */
