/****************************************************************************
File    : sound_win.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# SoundWin public methods and objects prototypes
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 02.02.2001
*/

#ifndef __SOUND_WIN_H__
#define __SOUND_WIN_H__

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define DEFAULT_SOUND_BUFFER_SIZE		8192
#define NUM_SOUND_BUFS					8
#define SOUND_LATENCY_IN_FRAMES			2
#define POKEY_SLOP_BYTES				64

#define SOUND_MMSOUND					0x0001	/* Sound states and registry stuff */
#define SOUND_DIRECTSOUND				0x0002
#define SOUND_CUSTOM_RATE				0x0004
#define SOUND_NOSOUND					0x0008

#define DEF_SOUND_STATE					(SOUND_MMSOUND | SOUND_CUSTOM_RATE)
#define DEF_SOUND_RATE					44100
#define DEF_SOUND_VOL					0
#define DEF_SKIP_UPDATE					2
#define DEF_USE_VOLUME_ONLY				0

/* Exported methods */

int  Sound_Initialise   ( BOOL bCleanRegs );
void Sound_Restart      ( void );
BOOL Sound_VolumeCapable( void );
void Sound_SetVolume    ( void );
void Sound_Clear        ( BOOL bPermanent );
int  Sound_Disable      ( BOOL bClearSound );
void Sound_OpenOutput   ( char *pszOutFileName );
void Sound_CloseOutput  ( void );

/* Exported globals */

struct SoundCtrl_t
{
	ULONG ulMode;		/* Sound flags            */
	int   nRate;		/* Sound rate             */
	int   nVolume;		/* Sound volume           */
	int   nSkipUpdate;	/* Pokey update frequency */
	int   nVolumeOnly;	/* Digital effects        */
	FILE *pfOutput;		/* Audio stream           */
};
extern struct SoundCtrl_t g_Sound;

extern void (*Atari_PlaySound)(void);

#ifdef __cplusplus
}
#endif

#endif /*__SOUND_WIN_H__*/
